/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHView;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableViewProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHViewOracle
extends MOHView {
    private static final Logger LOGGER = new Logger(MOHViewOracle.class);
    private List postProc;
    protected boolean dbaUser;

    public MOHViewOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHViewOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Views begin");
        this.postProc = new ArrayList();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("a.").append("COLUMN_NAME").append(',');
        buffer.append("DATA_TYPE").append(',');
        buffer.append("DATA_LENGTH").append(',');
        buffer.append("DATA_PRECISION").append(',');
        buffer.append("DATA_SCALE").append(',');
        buffer.append("COMMENTS").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_tab_columns" : "all_tab_columns").append(' ').append("a").append(',');
        buffer.append(this.dbaUser ? "dba_col_comments" : "all_col_comments").append(' ').append("b").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("OWNER").append('=');
        buffer.append("b.").append("OWNER").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("TABLE_NAME").append('=');
        buffer.append("b.").append("TABLE_NAME").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("COLUMN_NAME").append('=');
        buffer.append("b.").append("COLUMN_NAME").append(' ');
        buffer.append("ORDER BY").append(' ').append("COLUMN_ID");
        String colsql = buffer.toString();
        PreparedStatement col_statement = sqlConnection.prepareStatement(colsql);
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("OWNER").append(',');
        buffer.append("TRIGGER_NAME").append(',');
        buffer.append("TRIGGERING_EVENT").append(',');
        buffer.append("REFERENCING_NAMES").append(',');
        buffer.append("WHEN_CLAUSE").append(',');
        buffer.append("TRIGGER_BODY").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_triggers" : "all_triggers").append(' ');
        buffer.append("WHERE").append(' ').append("TABLE_OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?');
        String trigsql = buffer.toString();
        PreparedStatement trig_statement = sqlConnection.prepareStatement(trigsql);
        boolean oracle11g = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        if (oracle11g) {
            buffer.append("EDITIONING_VIEW").append(',');
        }
        buffer.append("TEXT").append(',');
        buffer.append("OID_TEXT").append(',');
        buffer.append("SUPERVIEW_NAME").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_views" : "all_views").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("VIEW_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("OWNER").append('=').append('?');
        String sql = buffer.toString();
        PreparedStatement statement = sqlConnection.prepareStatement(sql);
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!"VIEW".equalsIgnoreCase(dbo.getType())) continue;
            String viewName = dbo.getName();
            String schemaName = dbo.getSchema();
            ResultSet rs = null;
            try {
                statement.setString(1, viewName);
                statement.setString(2, schemaName);
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                LOGGER.error("MOHViewOracle.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    String editioning;
                    SchemaObjectSet schemaSet;
                    SchemaObject so;
                    TableView tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                    tableView.setCommentInRDBMS(dbo.getComments());
                    tableView.setSchema(schemaName);
                    String userName = schemaName;
                    UserOracle user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(userName);
                    TableViewProxyOracle vp = (TableViewProxyOracle)this.getStorageDesign().getTableViewProxySet().getProxy(tableView.getObjectID());
                    if (user == null) {
                        user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().createElement(null);
                        user.setName(userName);
                        this.stampModelObject((ModelObject)user, "", userName);
                    }
                    if ((so = (SchemaObject)(schemaSet = ((RelationalDesign)tableView.getDesignPart()).getSchemaObjectSet()).getByName(userName)) == null) {
                        so = schemaSet.createSchemaObject(null);
                        so.setName(userName);
                        this.stampModelObject((ModelObject)so, "", userName);
                    }
                    if (user != null) {
                        if (user.getSchemaObject() == null) {
                            user.setSchemaObject(so);
                        }
                        if (user.getSchemaObject() != so) {
                            vp.setUser(user);
                        }
                    }
                    tableView.setSchemaObject(so);
                    tableView.setName(viewName);
                    if (!viewName.equals(viewName.toUpperCase())) {
                        tableView.setNameHasQuotes(true);
                    }
                    if (oracle11g && (editioning = rs.getString("EDITIONING_VIEW")).equals("Y")) {
                        ((TableViewProxyOraclev10g)vp).setEditioning("YES");
                    }
                    if (dbo.getTypeName() != null) {
                        StructuredTypeProxyOracle stp = ((StructuredTypeProxySetOracle)this.getStorageDesign().getStructuredTypeProxySet()).getByLongName(dbo.getTypeName(), dbo.getTypeOwner());
                        if (stp != null && stp.getStructuredType() != null) {
                            tableView.setUserDefined(true);
                            tableView.setBasedOnStructuredType(stp.getStructuredType());
                            String view_def = rs.getString("TEXT");
                            String definition = "CREATE OR REPLACE VIEW " + viewName;
                            String superViewName = rs.getString("SUPERVIEW_NAME");
                            String oidText = rs.getString("OID_TEXT");
                            if (superViewName != null) {
                                Temp temp = new Temp();
                                temp.superViewName = superViewName;
                                temp.tview = tableView;
                                this.postProc.add(temp);
                            }
                            if (oidText != null) {
                                tableView.setOidText(oidText);
                                if (vp != null) {
                                    vp.setOidAttributes(oidText);
                                }
                            }
                            tableView.setUserDefinedSQL(definition + "\nAS \n" + view_def);
                        }
                    } else {
                        tableView.setUserDefined(true);
                        String vdef = rs.getString("TEXT").trim();
                        String vdef_up = vdef.toUpperCase();
                        int ind = vdef_up.indexOf("WITH READ ONLY");
                        String vend = "";
                        if (ind > -1) {
                            vend = vdef.substring(ind);
                            vdef = vdef.substring(0, ind);
                            vp.setViewReadOnly("YES");
                        } else {
                            ind = vdef_up.indexOf("WITH CHECK OPTION");
                            if (ind > -1) {
                                vend = vdef.substring(ind);
                                vdef = vdef.substring(0, ind);
                                vp.setCheckOption(true);
                            }
                        }
                        if (!"".equals(vend)) {
                            // empty if block
                        }
                        String definition = "CREATE OR REPLACE VIEW " + viewName + "\nAS \n" + vdef;
                        tableView.setUserDefinedSQL(definition);
                        ResultSet rs_col = null;
                        try {
                            col_statement.setString(1, viewName);
                            col_statement.setString(2, schemaName);
                            rs_col = col_statement.executeQuery();
                            if (rs_col != null) {
                                while (rs_col.next()) {
                                    String col_name = rs_col.getString(1);
                                    String col_type = rs_col.getString(2);
                                    String dt_length = rs_col.getString(3);
                                    String dt_precision = rs_col.getString(4);
                                    String dt_scale = rs_col.getString(5);
                                    String col_comments = rs_col.getString(6);
                                    AbstractViewElement cvExp = tableView.createViewElement(tableView.getDesignPart());
                                    cvExp.setName(col_name);
                                    cvExp.setHeaderAlias(col_name);
                                    cvExp.setDataType(this.createDataTypeString(col_type, dt_length, dt_precision, dt_scale));
                                    cvExp.setDesign(tableView.getDesign());
                                    cvExp.setAlias(col_name);
                                    cvExp.setContainer(tableView);
                                    if (col_comments != null) {
                                        cvExp.setCommentInRDBMS(col_comments);
                                    }
                                    tableView.add(cvExp);
                                    if (!col_name.equals(col_name.toUpperCase())) {
                                        cvExp.setNameHasQuotes(true);
                                    }
                                    this.stampModelObject((ModelObject)cvExp, tableView.getName(), col_name);
                                }
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                            LOGGER.error("MOHViewOracle.generate() column names:", e);
                        }
                        if (rs_col != null) {
                            rs_col.close();
                        }
                    }
                    if (this.getDbmeHandler().isTriggers()) {
                        this.initViewTriggers(trig_statement, tableView, schemaName);
                    }
                    this.stampModelObject(tableView, dbo);
                }
                rs.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        trig_statement.close();
        col_statement.close();
        statement.close();
        TimeLog.log("End Views");
    }

    private boolean isNotEmpty(String param) {
        return param != null && !"".equalsIgnoreCase(param) && !"0".equalsIgnoreCase(param);
    }

    private String createDataTypeString(String datatype, String length, String precision, String scale) {
        if (!(datatype.startsWith("TIMESTAMP") || datatype.startsWith("INTERVAL") || length == null && precision == null && scale == null)) {
            StringBuffer buffer = new StringBuffer();
            boolean needComma = false;
            if (!"NUMBER".equalsIgnoreCase(datatype) && this.isNotEmpty(length)) {
                buffer.append(length);
                needComma = true;
            }
            if (this.isNotEmpty(precision)) {
                if (needComma) {
                    buffer.append(',').append(' ');
                }
                buffer.append(precision);
                needComma = true;
            }
            if (this.isNotEmpty(scale)) {
                if (needComma) {
                    buffer.append(',').append(' ');
                }
                buffer.append(scale);
            }
            if (buffer.length() > 0) {
                buffer.append(')');
                return datatype + " (" + buffer.toString();
            }
        }
        return datatype;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract View begin");
        Statement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            String schemaName = dboNext.getName();
            if (statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("VIEW_NAME").append(',');
                buffer.append("VIEW_TYPE").append(',');
                buffer.append("a.").append("VIEW_TYPE_OWNER").append(',');
                buffer.append("c.").append("COMMENTS").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_views" : "all_views").append(' ').append("a").append(',');
                buffer.append(this.dbaUser ? "dba_tab_comments" : "all_tab_comments").append(' ').append("c").append(' ');
                buffer.append("WHERE").append(' ').append("a.").append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("a.").append("OWNER").append('=').append("c.").append("OWNER").append(' ');
                buffer.append("AND").append(' ').append("a.").append("VIEW_NAME").append('=').append("c.").append("TABLE_NAME").append(' ');
                buffer.append("ORDER BY").append(' ').append("VIEW_NAME");
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHViewOracle.extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String dimName = rs.getString(1);
                String tableTypeOwner = rs.getString(3);
                String tableType = rs.getString(2);
                String comments = rs.getString("COMMENTS");
                DBObject dboView = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dimName, "VIEW", schemaName);
                dboView.setTypeName(tableType);
                dboView.setTypeOwner(tableTypeOwner);
                dboView.setComments(comments);
                list.add(dboView);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        TimeLog.log("Extract View end");
        return list;
    }

    private void initViewTriggers(PreparedStatement trig_statement, TableView table, String ownerName) throws Exception {
        ResultSet rs = null;
        try {
            trig_statement.setString(1, ownerName);
            trig_statement.setString(2, table.getName());
            rs = trig_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.initTableConstraints():", e);
        }
        if (rs != null) {
            StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
            TableViewProxyOracle tableProxy = (TableViewProxyOracle)storage.getTableViewProxySet().getProxy(table.getObjectID());
            while (rs.next()) {
                String trigOwner = rs.getString("OWNER");
                String trigName = rs.getString("TRIGGER_NAME");
                String event = rs.getString("TRIGGERING_EVENT");
                String refNames = rs.getString("REFERENCING_NAMES");
                String whenClause = rs.getString("WHEN_CLAUSE");
                String trBody = rs.getString("TRIGGER_BODY");
                TriggerOracle trigger = storage.getTriggerSet().createTrigger();
                UserOracle user = (UserOracle)storage.getUserSet().getByName(trigOwner);
                trigger.setOwner(user);
                trigger.setName(trigName);
                if (!trigName.equals(trigName.toUpperCase())) {
                    trigger.setNameHasQuotes(true);
                }
                trigger.setView(tableProxy);
                this.stampModelObject((ModelObject)trigger, tableProxy, trigName);
                trigger.setTriggerTime("INSTEAD OF");
                if (event.indexOf("INSERT") > -1) {
                    trigger.setActions(Trigger.ACTION_TYPES[0]);
                }
                if (event.indexOf("UPDATE") > -1) {
                    trigger.setActions(Trigger.ACTION_TYPES[1]);
                }
                if (event.indexOf("DELETE") > -1) {
                    trigger.setActions(Trigger.ACTION_TYPES[2]);
                }
                String newref = "NEW";
                String oldref = "OLD";
                String parentref = "PARENT";
                if (refNames.indexOf("NEW AS") > -1 && !"NEW".equalsIgnoreCase(newref = Token.getFirstToken(Token.getStringAfter(refNames, "NEW AS")))) {
                    trigger.setRef_NEW_AS(newref);
                }
                if (refNames.indexOf("OLD AS") > -1 && !"OLD".equalsIgnoreCase(oldref = Token.getFirstToken(Token.getStringAfter(refNames, "OLD AS")))) {
                    trigger.setRef_OLD_AS(oldref);
                }
                if (refNames.indexOf("PARENT AS") > -1 && !"PARENT".equalsIgnoreCase(parentref = Token.getFirstToken(Token.getStringAfter(refNames, "PARENT AS")))) {
                    trigger.setRef_PARENT_AS(parentref);
                }
                if (whenClause != null) {
                    trigger.setCondition(whenClause);
                }
                trigger.setBody(trBody);
            }
            rs.close();
        }
    }

    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        if (this.postProc != null) {
            TableViewSet vs = this.getDesign().getRelationalDesign().getTableViewSet();
            for (Temp temp : this.postProc) {
                TableView tview = (TableView)vs.getByName(temp.superViewName);
                if (tview == null || tview == temp.tview) continue;
                TypeSubstitution ts = this.getDesign().getRelationalDesign().createTypeSubstitution();
                ContainerView childTV = (ContainerView)temp.tview.getFirstViewForDPV(this.getDesign().getRelationalDesign().getMainView());
                ContainerView parentTV = (ContainerView)tview.getFirstViewForDPV(this.getDesign().getRelationalDesign().getMainView());
                ts.setChildCV(childTV);
                ts.setParentCV(parentTV);
                ts.addToAllDPVs();
            }
            this.postProc.clear();
        }
    }

    class Temp {
        TableView tview;
        String superViewName;

        Temp() {
        }
    }
}

