/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHBitmapIndexesv9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "BITMAP JOIN";
    private static final Logger LOGGER = new Logger(MOHBitmapIndexesv9i.class);
    protected boolean dbaUser;
    PreparedStatement col_statement = null;
    PreparedStatement jcol_statement = null;

    public MOHBitmapIndexesv9i(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHBitmapIndexesv9i(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        this.col_statement = null;
        this.jcol_statement = null;
        Statement statement = null;
        ResultSet rs = null;
        Iterator it = this.getStorageDesign().getTableProxySet().iterator();
        TableProxyOraclev9i table = null;
        while (it.hasNext()) {
            table = (TableProxyOraclev9i)it.next();
            try {
                if (statement == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("OWNER").append(',');
                    buffer.append("INDEX_NAME").append(',');
                    buffer.append("INDEX_TYPE").append(',');
                    buffer.append("TABLE_OWNER").append(',');
                    buffer.append("TABLE_NAME").append(',');
                    buffer.append("TABLE_TYPE").append(',');
                    buffer.append("UNIQUENESS").append(',');
                    buffer.append("COMPRESSION").append(',');
                    buffer.append("TABLESPACE_NAME").append(',');
                    buffer.append("INI_TRANS").append(',');
                    buffer.append("MAX_TRANS").append(',');
                    buffer.append("INITIAL_EXTENT").append(',');
                    buffer.append("NEXT_EXTENT").append(',');
                    buffer.append("MIN_EXTENTS").append(',');
                    buffer.append("MAX_EXTENTS").append(',');
                    buffer.append("PCT_INCREASE").append(',');
                    buffer.append("INCLUDE_COLUMN").append(',');
                    buffer.append("FREELISTS").append(',');
                    buffer.append("FREELIST_GROUPS").append(',');
                    buffer.append("PCT_FREE").append(',');
                    buffer.append("LOGGING").append(',');
                    buffer.append("DEGREE").append(',');
                    buffer.append("PARTITIONED").append(',');
                    buffer.append("TEMPORARY").append(',');
                    buffer.append("GENERATED").append(',');
                    buffer.append("SECONDARY").append(',');
                    buffer.append("BUFFER_POOL").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? "dba_indexes" : "all_indexes").append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
                    buffer.append("AND").append(' ');
                    buffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
                    buffer.append("AND").append(' ');
                    buffer.append("JOIN_INDEX").append('=').append('\'');
                    buffer.append("YES").append('\'');
                    statement = sqlConnection.prepareStatement(buffer.toString());
                }
                statement.setString(1, ((Table)table.getObject()).getSchema());
                statement.setString(2, table.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println("MOHBitmapIndexesv9i.generate(): " + e.getMessage());
                LOGGER.error("MOHBitmapIndexesv9i.generate(): ", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                String owner = rs.getString("TABLE_OWNER");
                String localPartitioning = rs.getString("PARTITIONED");
                String tablespace = rs.getString("TABLESPACE_NAME");
                String logging = rs.getString("LOGGING");
                BitmapJoinIndexOraclev9i bitmapIndex = (BitmapJoinIndexOraclev9i)((StorageDesignOraclev9i)this.getStorageDesign()).getBitmapJoinIndexSet().createBitmapJoinIndex();
                UserOraclev9i user = (UserOraclev9i)((StorageDesignOraclev9i)this.getStorageDesign()).getUserSet().getByName(owner);
                bitmapIndex.setName(indexName);
                bitmapIndex.setUser(user);
                bitmapIndex.setTable(table);
                bitmapIndex.setLocalPartitioning(localPartitioning);
                bitmapIndex.setTablespace(tablespace);
                bitmapIndex.setLogging(logging);
                this.stampModelObject((ModelObject)bitmapIndex, owner, indexName);
                this.initIndexColumns(sqlConnection, bitmapIndex, owner, importLog);
                this.initJoinColumns(sqlConnection, bitmapIndex, owner, importLog);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.jcol_statement != null) {
            this.jcol_statement.close();
        }
    }

    private void initJoinColumns(Connection sqlConnection, BitmapJoinIndexOracle bitmapIndex, String owner, ImportLogger importLog) {
        ResultSet rs = null;
        try {
            if (this.jcol_statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("INNER_TABLE_OWNER").append(',');
                buffer.append("INNER_TABLE_NAME").append(',');
                buffer.append("INNER_TABLE_COLUMN").append(',');
                buffer.append("OUTER_TABLE_OWNER").append(',');
                buffer.append("OUTER_TABLE_NAME").append(',');
                buffer.append("OUTER_TABLE_COLUMN").append(',');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_join_ind_columns" : "all_join_ind_columns").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("INDEX_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("INDEX_NAME").append(' ').append('=').append(' ').append('?');
                this.jcol_statement = sqlConnection.prepareStatement(buffer.toString());
            }
            this.jcol_statement.setString(1, owner);
            this.jcol_statement.setString(2, bitmapIndex.getName());
            rs = this.jcol_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String innerTable = rs.getString("INNER_TABLE_NAME");
                    String innerColumn = rs.getString("INNER_TABLE_COLUMN");
                    String outerTable = rs.getString("OUTER_TABLE_NAME");
                    String outerColumn = rs.getString("OUTER_TABLE_COLUMN");
                    Table iTable = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(innerTable);
                    Table oTable = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(outerTable);
                    if (iTable == null || oTable == null) continue;
                    Column iColumn = (Column)iTable.getElementByName(innerColumn);
                    Column oColumn = (Column)oTable.getElementByName(outerColumn);
                    if (iColumn == null || oColumn == null) continue;
                    bitmapIndex.setJoinColumns(oColumn.getObjectID());
                    bitmapIndex.setJoinColumns(iColumn.getObjectID());
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(oColumn.getName());
                    Index index = this.getUniqueIndexForColumnNames(oTable, list);
                    bitmapIndex.setDimensionKeys(oTable.getObjectID());
                    bitmapIndex.setDimensionKeys(index.getObjectID());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("MOHBitmapIndexesv9i.initJoinColumns():", e);
        }
    }

    private void initIndexColumns(Connection sqlConnection, BitmapJoinIndexOracle bitmapIndex, String owner, ImportLogger importLog) {
        ResultSet rs = null;
        try {
            if (this.col_statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("TABLE_OWNER").append(',');
                buffer.append("TABLE_NAME").append(',');
                buffer.append("COLUMN_NAME").append(',');
                buffer.append("COLUMN_POSITION").append(',');
                buffer.append("DESCEND").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_ind_columns" : "all_ind_columns").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("INDEX_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("INDEX_NAME").append(' ').append('=').append(' ').append('?').append(' ');
                buffer.append("ORDER BY").append(' ');
                buffer.append("COLUMN_POSITION");
                this.col_statement = sqlConnection.prepareStatement(buffer.toString());
            }
            this.col_statement.setString(1, owner);
            this.col_statement.setString(2, bitmapIndex.getName());
            rs = this.col_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    String tableName = rs.getString("TABLE_NAME");
                    Table table = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(tableName);
                    if (table != null) {
                        Column column = (Column)table.getElementByName(columnName);
                        String descend = rs.getString("DESCEND");
                        if (column != null) {
                            bitmapIndex.setIndexColumns(column.getObjectID());
                            bitmapIndex.setIndexColumns(descend);
                            continue;
                        }
                        importLog.addWarning("Column " + columnName + " was not imported");
                        continue;
                    }
                    importLog.addWarning("Table " + tableName + " was not imported");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("MOHBitmapIndexesv9i.initIndexColumns():", e);
        }
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        ArrayList copy = new ArrayList();
        copy.addAll(names);
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            for (int j = 0; j < names.size(); ++j) {
                if (!columns[i].getName().equalsIgnoreCase((String)names.get(j))) continue;
                copy.remove(names.get(j));
            }
        }
        return copy.size() == 0;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }
}

