/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHExternalTableOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "EXTERNAL TABLE";
    private static final Logger LOGGER = new Logger(MOHExternalTableOraclev9i.class);
    protected boolean dbaUser;
    PreparedStatement columnsStmt = null;
    PreparedStatement parallelStmt = null;

    public MOHExternalTableOraclev9i(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        Statement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            if (statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("TABLE_NAME").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_external_tables" : "all_external_tables").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("OWNER").append('=').append('?').append(' ');
                buffer.append("ORDER BY").append(' ');
                buffer.append("TABLE_NAME");
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println("MOHExternalTableOraclev9i.extract(): " + e.getMessage());
                LOGGER.error("MOHExternalTableOraclev9i.extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String objName = rs.getString("TABLE_NAME");
                DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), objName, OBJECT_TYPE, dboNext.getName());
                list.add(dboTable);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String ownerName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            ResultSet rs = null;
            try {
                if (statement == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("b.").append("LOCATION").append(',');
                    buffer.append("DEFAULT_DIRECTORY_NAME").append(',');
                    buffer.append("REJECT_LIMIT").append(',');
                    buffer.append("TYPE_NAME").append(',');
                    buffer.append("ACCESS_PARAMETERS").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? "dba_external_tables" : "all_external_tables").append(' ').append("a").append(',');
                    buffer.append(this.dbaUser ? "dba_external_locations" : "all_external_locations").append(' ').append("b").append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
                    buffer.append("AND").append(' ');
                    buffer.append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
                    buffer.append("AND").append(' ');
                    buffer.append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ');
                    buffer.append("AND").append(' ');
                    buffer.append("a.").append("TABLE_NAME").append('=').append("b.").append("TABLE_NAME");
                    statement = sqlConnection.prepareStatement(buffer.toString());
                }
                statement.setString(1, ownerName);
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHExternalTableOraclev9i.extract():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    StorageDesign stoDes = this.getStorageDesign();
                    if (stoDes instanceof StorageDesignOracle) {
                        StorageDesignOracle storageDesign = (StorageDesignOracle)stoDes;
                        String name = dbo.getName();
                        String location = rs.getString("LOCATION");
                        String defDirName = rs.getString("DEFAULT_DIRECTORY_NAME");
                        String rejectLimit = rs.getString("REJECT_LIMIT");
                        String driverType = rs.getString("TYPE_NAME");
                        String accessParams = rs.getString("ACCESS_PARAMETERS");
                        accessParams = accessParams == null ? "" : accessParams.trim();
                        ExternalTableOracle externalTable = storageDesign.getExternalTableSet().createExternalTable();
                        if (externalTable != null) {
                            externalTable.setName(name);
                            if (!name.equals(name.toUpperCase())) {
                                externalTable.setNameHasQuotes(true);
                            }
                            UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(ownerName);
                            externalTable.setOwner(user);
                            externalTable.setLocation(location);
                            DirectoryOracle directory = (DirectoryOracle)storageDesign.getDirectorySet().getByName(defDirName);
                            externalTable.setDefaultDir(directory);
                            externalTable.setRejectLimit(rejectLimit);
                            externalTable.setAccessDriverType(driverType);
                            if (driverType != null && driverType.toUpperCase().startsWith("ORACLE_")) {
                                externalTable.setAccessParametersType("Opaque Format Spec");
                                externalTable.setOpaqueFormatSpec(accessParams);
                            } else {
                                externalTable.setAccessParametersType("CLOB Subquery");
                                externalTable.setClobSubquery(accessParams);
                            }
                            this.initParallel(sqlConnection, externalTable, ownerName);
                            this.initColumns(sqlConnection, externalTable, ownerName);
                            this.stampModelObject(externalTable, dbo);
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (this.parallelStmt != null) {
            this.parallelStmt.close();
            this.parallelStmt = null;
        }
        if (this.columnsStmt != null) {
            this.columnsStmt.close();
            this.columnsStmt = null;
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initColumns(Connection sqlConnection, ExternalTableOracle externalTable, String owner) throws Exception {
        ResultSet rs = null;
        try {
            if (this.columnsStmt == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("a.").append("COLUMN_NAME").append(',');
                buffer.append("DATA_TYPE").append(',');
                buffer.append("DATA_LENGTH").append(',');
                buffer.append("DATA_PRECISION").append(',');
                buffer.append("DATA_SCALE").append(',');
                buffer.append("CHAR_USED").append(',');
                buffer.append("CHAR_LENGTH").append(',');
                buffer.append("COMMENTS").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_tab_columns" : "all_tab_columns").append(' ').append("a").append(',');
                buffer.append(this.dbaUser ? "dba_col_comments" : "all_col_comments").append(' ').append("b").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("a.").append("OWNER").append('=');
                buffer.append("b.").append("OWNER").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("a.").append("TABLE_NAME").append('=');
                buffer.append("b.").append("TABLE_NAME").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("a.").append("COLUMN_NAME").append('=');
                buffer.append("b.").append("COLUMN_NAME").append(' ');
                buffer.append("ORDER BY").append(' ');
                buffer.append("COLUMN_ID");
                this.columnsStmt = sqlConnection.prepareStatement(buffer.toString());
            }
            this.columnsStmt.setString(1, owner);
            this.columnsStmt.setString(2, externalTable.getName());
            rs = this.columnsStmt.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHExternalTableOraclev9i.initColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                String colDatatype = rs.getString("DATA_TYPE");
                int colSize = rs.getInt("DATA_LENGTH");
                int colPrecision = rs.getInt("DATA_PRECISION");
                int colScale = rs.getInt("DATA_SCALE");
                int charLength = rs.getInt("CHAR_LENGTH");
                String charUsed = rs.getString("CHAR_USED");
                String comments = rs.getString("COMMENTS");
                ExternalTableColumnOracle column = null;
                if (externalTable instanceof ExternalTableOraclev9i) {
                    column = ((StorageDesignOraclev9i)externalTable.getStorageDesign()).getExternalColumnSet().createExternalColumn();
                } else if (externalTable instanceof ExternalTableOraclev10g) {
                    column = ((StorageDesignOraclev10g)externalTable.getStorageDesign()).getExternalColumnSet().createExternalColumn();
                }
                if (column == null) continue;
                column.setName(colName);
                if (!colName.equals(colName.toUpperCase())) {
                    column.setNameHasQuotes(true);
                }
                column.setExternalTable(externalTable);
                colDatatype = this.removeBrackets(colDatatype);
                column.setDatatype(colDatatype);
                if (colDatatype.indexOf("CHAR") > -1) {
                    int relevantLength = charLength;
                    String charUnits = "";
                    if (charUsed != null) {
                        if (charUsed.equalsIgnoreCase("C")) {
                            charUnits = "CHAR";
                        } else if (charUsed.equalsIgnoreCase("B")) {
                            charUnits = "BYTE";
                            relevantLength = colSize;
                        }
                    }
                    column.setSize(relevantLength);
                    column.setUnits(charUnits);
                } else if (colDatatype.equals("RAW") || colDatatype.equals("UROWID")) {
                    column.setSize(colSize);
                } else if (colDatatype.startsWith("TIMESTAMP")) {
                    column.setPrecision(colScale);
                } else {
                    column.setPrecision(colPrecision);
                    column.setScale(colScale);
                }
                if (comments != null) {
                    column.setCommentInRDBMS(comments);
                }
                this.stampModelObject((ModelObject)column, externalTable.getName(), colName);
            }
            rs.close();
        }
    }

    private void initParallel(Connection sqlConnection, ExternalTableOracle externalTable, String owner) throws Exception {
        ResultSet rs = null;
        try {
            if (this.parallelStmt == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("DEGREE").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_all_tables" : "all_all_tables").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("TABLE_NAME").append('=').append('?');
                this.parallelStmt = sqlConnection.prepareStatement(buffer.toString());
            }
            this.parallelStmt.setString(1, owner);
            this.parallelStmt.setString(2, externalTable.getName());
            rs = this.parallelStmt.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHExternalTableOraclev9i.initParallel():", e);
        }
        if (rs != null) {
            if (rs.next()) {
                String parallel = rs.getString("DEGREE");
                if ("1".equalsIgnoreCase(parallel.trim())) {
                    externalTable.setParallel("NOPARALLEL");
                } else {
                    externalTable.setParallel("PARALLEL");
                }
            }
            rs.close();
        }
    }

    protected String removeBrackets(String input) {
        String result;
        int length = input.length();
        int ind = input.indexOf(40);
        if (ind > 0) {
            result = input.substring(0, ind);
            int close_ind = input.indexOf(41);
            if (close_ind > 0 && close_ind < length - 1) {
                String rest = input.substring(close_ind + 1, length);
                result = result.trim() + ' ' + this.removeBrackets(rest).trim();
            }
        } else {
            result = input;
        }
        return result;
    }
}

