/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHCommentsSqlServer
extends AbstractMOHandler {
    protected static final String OBJECT_TYPE = "COMMENTS";
    private static final Logger LOGGER = new Logger(MOHCommentsSqlServer.class);

    public MOHCommentsSqlServer(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        String schema;
        String user;
        String db;
        StorageDesignSqlServer storage = (StorageDesignSqlServer)this.getDesign().getRelationalDesign().getStorageDesign();
        Iterator it = storage.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxySqlServer table = (TableProxySqlServer)it.next();
            if (table == null || table.getDatabase() == null || table.getUser() == null && table.getSchema() == null) continue;
            db = table.getDatabase().getName();
            user = table.getUser() != null ? table.getUser().getName() : "";
            schema = table.getSchema() != null ? table.getSchema().getName() : "";
            this.initExtendedProps(table, db, user, schema, sqlConnection);
            this.initComments(table, db, user, schema, sqlConnection);
            ColumnProxy[] cols = table.getColumnProxies();
            for (int i = 0; i < cols.length; ++i) {
                this.initExtendedProps(table, (ColumnProxySqlServer)cols[i], db, user, schema, sqlConnection);
                this.initComments(table, (ColumnProxySqlServer)cols[i], db, user, schema, sqlConnection);
            }
            IndexProxy[] indexes = table.getIndexProxies();
            for (int i = 0; i < indexes.length; ++i) {
                this.initExtendedProps(table, (IndexProxySqlServer)indexes[i], db, user, schema, sqlConnection);
                this.initComments(table, (IndexProxySqlServer)indexes[i], db, user, schema, sqlConnection);
            }
        }
        it = storage.getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableViewProxySqlServer view = (TableViewProxySqlServer)it.next();
            if (view == null) continue;
            db = view.getDataBase().getName();
            user = view.getUser() != null ? view.getUser().getName() : "";
            schema = view.getSchema() != null ? view.getSchema().getName() : "";
            this.initExtendedProps(view, db, user, schema, sqlConnection);
            this.initComments(view, db, user, schema, sqlConnection);
        }
    }

    private void initExtendedProps(TableProxySqlServer table, String db, String user, String schema, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(" CONVERT(VARCHAR(30), [name]) AS [Property Name], CONVERT(VARCHAR(256), [value]) AS [Property vCharValue]").append(' ');
            buffer.append("FROM").append(' ');
            if (!"".equals(schema)) {
                buffer.append("::fn_listextendedproperty(NULL,'schema',").append(' ');
                buffer.append('\'').append(schema).append('\'').append(' ');
            } else {
                buffer.append("::fn_listextendedproperty(NULL,'user',").append(' ');
                buffer.append('\'').append(user).append('\'').append(' ');
            }
            buffer.append(',').append(' ');
            buffer.append("'table',").append(' ');
            buffer.append('\'').append(table.getName()).append('\'').append(' ');
            buffer.append(",null,null)").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("name <> 'MS_Description'").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHCommentsSqlServer.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String value = rs.getString(2);
                table.setProps(name);
                table.setProps(value);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initComments(TableProxySqlServer table, String db, String user, String schema, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(" CONVERT(VARCHAR(2000), [value]) AS [Property vCharValue]").append(' ');
            buffer.append("FROM").append(' ');
            if (!"".equals(schema)) {
                buffer.append("::fn_listextendedproperty('MS_Description','schema',").append(' ');
                buffer.append('\'').append(schema).append('\'').append(' ');
            } else {
                buffer.append("::fn_listextendedproperty('MS_Description','user',").append(' ');
                buffer.append('\'').append(user).append('\'').append(' ');
            }
            buffer.append(',').append(' ');
            buffer.append("'table',").append(' ');
            buffer.append('\'').append(table.getName()).append('\'').append(' ');
            buffer.append(",null,null)").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHCommentsSqlServer.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String value = rs.getString(1);
                ((Table)table.getObject()).setCommentInRDBMS(value);
                table.setCommentInRDBMS(value);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initExtendedProps(TableViewProxySqlServer view, String db, String user, String schema, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(" CONVERT(VARCHAR(30), [name]) AS [Property Name], CONVERT(VARCHAR(256), [value]) AS [Property vCharValue]").append(' ');
            buffer.append("FROM").append(' ');
            if (!"".equals(schema)) {
                buffer.append("::fn_listextendedproperty(NULL,'schema',").append(' ');
                buffer.append('\'').append(schema).append('\'').append(' ');
            } else {
                buffer.append("::fn_listextendedproperty(NULL,'user',").append(' ');
                buffer.append('\'').append(user).append('\'').append(' ');
            }
            buffer.append(',').append(' ');
            buffer.append("'view',").append(' ');
            buffer.append('\'').append(view.getName()).append('\'').append(' ');
            buffer.append(",null,null)").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("name <> 'MS_Description'").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHCommentsSqlServer.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String value = rs.getString(2);
                view.setProps(name);
                view.setProps(value);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initComments(TableViewProxySqlServer view, String db, String user, String schema, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(" CONVERT(VARCHAR(2000), [value]) AS [Property vCharValue]").append(' ');
            buffer.append("FROM").append(' ');
            if (!"".equals(schema)) {
                buffer.append("::fn_listextendedproperty('MS_Description','schema',").append(' ');
                buffer.append('\'').append(schema).append('\'').append(' ');
            } else {
                buffer.append("::fn_listextendedproperty('MS_Description','user',").append(' ');
                buffer.append('\'').append(user).append('\'').append(' ');
            }
            buffer.append(',').append(' ');
            buffer.append("'view',").append(' ');
            buffer.append('\'').append(view.getName()).append('\'').append(' ');
            buffer.append(",null,null)").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHCommentsSqlServer.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String value = rs.getString(1);
                ((TableView)view.getObject()).setCommentInRDBMS(value);
                view.setCommentInRDBMS(value);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initExtendedProps(TableProxySqlServer table, ColumnProxySqlServer column, String db, String user, String schema, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(" CONVERT(VARCHAR(30), [name]) AS [Property Name], CONVERT(VARCHAR(256), [value]) AS [Property vCharValue]").append(' ');
            buffer.append("FROM").append(' ');
            if (!"".equals(schema)) {
                buffer.append("::fn_listextendedproperty(NULL,'schema',").append(' ');
                buffer.append('\'').append(schema).append('\'').append(' ');
            } else {
                buffer.append("::fn_listextendedproperty(NULL,'user',").append(' ');
                buffer.append('\'').append(user).append('\'').append(' ');
            }
            buffer.append(',').append(' ');
            buffer.append("'table',").append(' ');
            buffer.append('\'').append(table.getName()).append('\'').append(' ');
            buffer.append(",'column', ").append(' ');
            buffer.append('\'').append(column.getName()).append('\'').append(' ');
            buffer.append(")").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("name <> 'MS_Description'").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHCommentsSqlServer.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String value = rs.getString(2);
                column.setProps(name);
                column.setProps(value);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initComments(TableProxySqlServer table, ColumnProxySqlServer column, String db, String user, String schema, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(" CONVERT(VARCHAR(2000), [value]) AS [Property vCharValue]").append(' ');
            buffer.append("FROM").append(' ');
            if (!"".equals(schema)) {
                buffer.append("::fn_listextendedproperty('MS_Description','schema',").append(' ');
                buffer.append('\'').append(schema).append('\'').append(' ');
            } else {
                buffer.append("::fn_listextendedproperty('MS_Description','user',").append(' ');
                buffer.append('\'').append(user).append('\'').append(' ');
            }
            buffer.append(',').append(' ');
            buffer.append("'table',").append(' ');
            buffer.append('\'').append(table.getName()).append('\'').append(' ');
            buffer.append(",'column', ").append(' ');
            buffer.append('\'').append(column.getName()).append('\'').append(' ');
            buffer.append(")").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHCommentsSqlServer.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String value = rs.getString(1);
                ((Column)column.getObject()).setCommentInRDBMS(value);
                column.setCommentInRDBMS(value);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initExtendedProps(TableProxySqlServer table, IndexProxySqlServer index, String db, String user, String schema, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(" CONVERT(VARCHAR(30), [name]) AS [Property Name], CONVERT(VARCHAR(256), [value]) AS [Property vCharValue]").append(' ');
            buffer.append("FROM").append(' ');
            if (!"".equals(schema)) {
                buffer.append("::fn_listextendedproperty(NULL,'schema',").append(' ');
                buffer.append('\'').append(schema).append('\'').append(' ');
            } else {
                buffer.append("::fn_listextendedproperty(NULL,'user',").append(' ');
                buffer.append('\'').append(user).append('\'').append(' ');
            }
            buffer.append(',').append(' ');
            buffer.append("'table',").append(' ');
            buffer.append('\'').append(table.getName()).append('\'').append(' ');
            buffer.append(",'index', ").append(' ');
            buffer.append('\'').append(index.getName()).append('\'').append(' ');
            buffer.append(")").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("name <> 'MS_Description'").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHCommentsSqlServer.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String value = rs.getString(2);
                index.setProps(name);
                index.setProps(value);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initComments(TableProxySqlServer table, IndexProxySqlServer index, String db, String user, String schema, Connection sqlConnection) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(" CONVERT(VARCHAR(2000), [value]) AS [Property vCharValue]").append(' ');
            buffer.append("FROM").append(' ');
            if (!"".equals(schema)) {
                buffer.append("::fn_listextendedproperty('MS_Description','schema',").append(' ');
                buffer.append('\'').append(schema).append('\'').append(' ');
            } else {
                buffer.append("::fn_listextendedproperty('MS_Description','user',").append(' ');
                buffer.append('\'').append(user).append('\'').append(' ');
            }
            buffer.append(',').append(' ');
            buffer.append("'table',").append(' ');
            buffer.append('\'').append(table.getName()).append('\'').append(' ');
            buffer.append(",'index', ").append(' ');
            buffer.append('\'').append(index.getName()).append('\'').append(' ');
            buffer.append(")").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHCommentsSqlServer.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String value = rs.getString(1);
                ((Index)index.getObject()).setCommentInRDBMS(value);
                index.setCommentInRDBMS(value);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }
}

