/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;

public abstract class MOHandlerSqlServer
extends AbstractMOHandler {
    public MOHandlerSqlServer(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    protected boolean containsDboForDb(List list, DBUserSqlServer dbo) {
        int position = list.lastIndexOf(dbo);
        for (int i = 0; i < position; ++i) {
            DBObject dboNext = (DBObject)list.get(i);
            if (!(dboNext instanceof DBUserSqlServer) || !dboNext.isSelected() || !((DBUserSqlServer)dboNext).getDb().equalsIgnoreCase(dbo.getDb()) || !((DBUserSqlServer)dboNext).getName().equalsIgnoreCase(dbo.getName())) continue;
            return true;
        }
        return false;
    }

    protected SchemaObject getSchemaSqlServer(String schema, String db) {
        RelationalDesign rd = this.getDesign().getRelationalDesign();
        SchemaObject so = (SchemaObject)rd.getSchemaObjectSet().getByName(db + "_" + schema);
        if (so == null) {
            so = rd.getSchemaObjectSet().createSchemaObject(null);
            so.setName(db + "_" + schema);
            this.stampModelObject((ModelObject)so, db, schema);
        }
        return so;
    }

    public static String getFormattedName(DataBaseSqlServer db) {
        return MOHandlerSqlServer.getFormattedName(db.getName());
    }

    public static String getFormattedName(String name) {
        if (MOHandlerSqlServer.startsWithNumber(name)) {
            return '\"' + name + '\"';
        }
        return name;
    }

    private static boolean startsWithNumber(String name) {
        String[] NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        for (int i = 0; i < NUMBERS.length; ++i) {
            if (!name.startsWith(NUMBERS[i])) continue;
            return true;
        }
        return false;
    }
}

