/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPartitionColumnSqlServerv2k5
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "Partition";
    private static final Logger LOGGER = new Logger(MOHPartitionColumnSqlServerv2k5.class);
    private StorageDesignSqlServerv2k5 storage;
    private DataBaseSqlServerv2k5 database;

    public MOHPartitionColumnSqlServerv2k5(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        if (this.getStorageDesign() instanceof StorageDesignSqlServerv2k5) {
            this.storage = (StorageDesignSqlServerv2k5)this.getStorageDesign();
            Iterator iterator = this.storage.getDataBaseSet().iterator();
            while (iterator.hasNext()) {
                this.database = (DataBaseSqlServerv2k5)iterator.next();
                if (this.database.isNullInstance()) continue;
                this.initPartitionColumnsForTables(sqlConnection, importLog);
                this.initPartitionColumnsForIndexes(sqlConnection, importLog);
            }
        }
    }

    private void initPartitionColumnsForTables(Connection sqlConnection, ImportLogger importLog) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        String db = this.database.getName();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ').append(MOHPartitionColumnSqlServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("tab.name table_name, sch.name [schema], ");
            buffer.append("cols.name [column], cols.column_id,partition_ordinal ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.index_columns icols, sys.columns cols, ");
            buffer.append("sys.tables tab, sys.schemas sch ");
            buffer.append("WHERE").append(' ');
            buffer.append("partition_ordinal>0 ");
            buffer.append("AND").append(' ');
            buffer.append("icols.index_id < 2 ");
            buffer.append("AND").append(' ');
            buffer.append("icols.object_id = cols.object_id ");
            buffer.append("AND").append(' ');
            buffer.append("icols.column_id = cols.column_id ");
            buffer.append("AND").append(' ');
            buffer.append("tab.object_id = icols.object_id ");
            buffer.append("AND").append(' ');
            buffer.append("tab.schema_id = sch.schema_id ");
            buffer.append("ORDER BY").append(' ');
            buffer.append("table_name,partition_ordinal");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPartitionColumnSqlServerv2k5.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String tableName = rs.getString(1);
                String schemaName = rs.getString(2);
                String columnName = rs.getString(3);
                TableProxySqlServerv2k5 tableProxy = this.getTableByNameAndSchemaName(tableName, schemaName);
                if (tableProxy == null) continue;
                ColumnProxySqlServerv2k5 columnProxy = (ColumnProxySqlServerv2k5)tableProxy.getColumnProxyByName(columnName);
                tableProxy.setPartitioningColumn(columnProxy);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initPartitionColumnsForIndexes(Connection sqlConnection, ImportLogger importLog) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        String db = this.database.getName();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ').append(MOHPartitionColumnSqlServerv2k5.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("tab.name table_name, sch.name [schema], ");
            buffer.append("ind.name index_name, cols.name [column], ");
            buffer.append("cols.column_id,partition_ordinal, is_primary_key ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.index_columns icols, sys.columns cols, ");
            buffer.append("sys.tables tab, sys.schemas sch, sys.indexes ind ");
            buffer.append("WHERE").append(' ');
            buffer.append("partition_ordinal>0 ");
            buffer.append("AND").append(' ');
            buffer.append("icols.index_id > 0 ");
            buffer.append("AND").append(' ');
            buffer.append("icols.object_id = cols.object_id ");
            buffer.append("AND").append(' ');
            buffer.append("icols.column_id = cols.column_id ");
            buffer.append("AND").append(' ');
            buffer.append("tab.object_id = icols.object_id ");
            buffer.append("AND").append(' ');
            buffer.append("tab.schema_id = sch.schema_id ");
            buffer.append("AND").append(' ');
            buffer.append("ind.index_id = icols.index_id ");
            buffer.append("AND").append(' ');
            buffer.append("ind.object_id = icols.object_id ");
            buffer.append("ORDER BY").append(' ');
            buffer.append("table_name,partition_ordinal");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPartitionColumnSqlServerv2k5.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                IndexProxy proxy;
                String tableName = rs.getString(1);
                String schemaName = rs.getString(2);
                String indexName = rs.getString(3);
                String columnName = rs.getString(4);
                String is_primary_key = rs.getString(7);
                TableProxySqlServerv2k5 tableProxy = this.getTableByNameAndSchemaName(tableName, schemaName);
                if (tableProxy == null) continue;
                IndexProxySqlServerv2k5 indexProxy = (IndexProxySqlServerv2k5)tableProxy.getIndexes().getByName(indexName);
                ColumnProxySqlServerv2k5 columnProxy = (ColumnProxySqlServerv2k5)tableProxy.getColumnProxyByName(columnName);
                if (indexProxy != null) {
                    indexProxy.setPartitioningColumn(columnProxy);
                    continue;
                }
                if ("1".equals(is_primary_key)) {
                    proxy = (PKProxySqlServerv2k5)tableProxy.getPkeys().getByName(indexName);
                    if (proxy == null) continue;
                    ((PKProxySqlServerv2k5)proxy).setPartitioningColumn(columnProxy);
                    continue;
                }
                proxy = (UniqueProxySqlServerv2k5)tableProxy.getUkeys().getByName(indexName);
                if (proxy == null) continue;
                ((UniqueProxySqlServerv2k5)proxy).setPartitioningColumn(columnProxy);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    public TableProxySqlServerv2k5 getTableByNameAndSchemaName(String tableName, String schemaName) {
        TableProxySqlServerv2k5 tableProxy = null;
        Iterator iterator = this.database.getTables().iterator();
        while (iterator.hasNext()) {
            StorageObjectPlaceHolder object = (StorageObjectPlaceHolder)iterator.next();
            tableProxy = (TableProxySqlServerv2k5)object.getObject();
            if (!tableProxy.getName().equals(tableName) || tableProxy.getSchema() == null || !tableProxy.getSchema().getName().equals(schemaName)) continue;
            return tableProxy;
        }
        return null;
    }
}

