/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHProcedureSqlServerv2k5
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "PROCEDURE";
    private static final Logger LOGGER = new Logger(MOHProcedureSqlServerv2k5.class);

    public MOHProcedureSqlServerv2k5(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            String username = dbo.getSchema();
            String id = dbo.getId();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            if ("".equalsIgnoreCase(id)) {
                id = this.getID(sqlConnection, name, username, db);
            }
            if (id == null) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("s").append('.').append("TEXT").append(' ');
                buffer.append("DEFINITION").append(' ');
                buffer.append("FROM").append(' ');
                if (!"".equalsIgnoreCase(db)) {
                    buffer.append(MOHProcedureSqlServerv2k5.getFormattedName(db)).append('.');
                }
                buffer.append("dbo.syscomments s").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("s").append('.').append("ID").append(' ');
                buffer.append('=').append(' ');
                buffer.append(id);
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHProcedureSqlServerv2k5.generate():", e);
            }
            if (rs != null && rs.next()) {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                    DataBaseSqlServer database = null;
                    if (!"".equalsIgnoreCase(db)) {
                        database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                        if (database == null) {
                            database = storage.getDataBaseSet().createDataBase();
                            database.setName(db);
                            this.stampModelObject((ModelObject)database, "", db);
                        }
                    } else {
                        database = (DataBaseSqlServer)storage.getDataBaseSet().getNullInstance();
                    }
                    StoredProcedureSqlServer proc = ((StorageDesignSqlServer)storageDesign).getStoredProcedureSet().createStoredProcedure();
                    proc.setName(name);
                    this.stampModelObject((ModelObject)proc, username, name);
                    proc.setDatabase(database);
                    this.setSchema(proc, username);
                    this.setProperties(proc, rs);
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void setSchema(StoredProcedureSqlServer proc, String username) {
        SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)proc.getDatabase().getSchemas().getByName(username);
        proc.setSchema(schema);
    }

    private void setProperties(StoredProcedureSqlServer proc, ResultSet rs) throws Exception {
        String definition = rs.getString("DEFINITION");
        if (definition != null) {
            String name;
            if (definition.startsWith("CREATE PROCEDURE") && (name = Token.getStringAfter(definition, "CREATE PROCEDURE")).startsWith(proc.getName())) {
                definition = name.substring(proc.getName().length());
            }
            proc.setBody(definition.trim());
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList list = new ArrayList();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dbo = (DBUserSqlServer)dboNext;
            list.addAll(this.extractByUser(sqlConnection, dbo));
        }
        return list;
    }

    private String getID(Connection sqlConnection, String procName, String userName, String dbName) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        String result = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("o").append('.').append("NAME").append(' ');
            buffer.append("PROCNAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("o").append('.').append("ID").append(' ');
            buffer.append("PROCID").append(' ');
            buffer.append("FROM").append(' ');
            if (!"".equalsIgnoreCase(dbName)) {
                buffer.append(MOHProcedureSqlServerv2k5.getFormattedName(dbName)).append('.');
            }
            buffer.append("dbo.sysobjects o").append(' ');
            buffer.append(',').append(' ');
            if (!"".equalsIgnoreCase(dbName)) {
                buffer.append(MOHProcedureSqlServerv2k5.getFormattedName(dbName)).append('.');
            }
            buffer.append("dbo.sysusers u").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("XTYPE").append(' ');
            buffer.append('=').append(' ');
            buffer.append('\'').append("P").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("u").append('.').append("NAME").append(' ');
            buffer.append('=').append(' ');
            buffer.append('\'').append(userName).append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("o").append('.').append("NAME").append(' ');
            buffer.append('=').append(' ');
            buffer.append('\'').append(procName).append('\'');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHProcedureSqlServerv2k5.extract():", e);
        }
        if (rs != null && rs.next()) {
            result = rs.getString(2);
        }
        if (statement != null) {
            statement.close();
        }
        return result;
    }

    private List extractByUser(Connection sqlConnection, DBUserSqlServer dbo) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        String dbName = dbo.getDb();
        String uid = dbo.getId();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("o").append('.').append("NAME").append(' ');
            buffer.append("PROCNAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("o").append('.').append("ID").append(' ');
            buffer.append("PROCID").append(' ');
            buffer.append(',').append(' ');
            buffer.append("u").append('.').append("NAME").append(' ');
            buffer.append("USERNAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHProcedureSqlServerv2k5.getFormattedName(dbName)).append('.').append("dbo.sysobjects o").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHProcedureSqlServerv2k5.getFormattedName(dbName)).append('.').append("dbo.sysusers u").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("XTYPE").append(' ');
            buffer.append('=').append(' ');
            buffer.append('\'').append("P").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("o").append('.').append("UID").append(' ');
            buffer.append('=').append(' ').append(uid).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("-- user id").append("\n");
            buffer.append("o").append('.').append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append("u").append('.').append("UID").append(' ');
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHProcedureSqlServerv2k5.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String procName = rs.getString(1);
                String procId = rs.getString(2);
                String username = rs.getString(3);
                DBObjectSqlServer dboProc = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), procName, OBJECT_TYPE, "");
                dboProc.setSchema(username);
                dboProc.setDb(dbName);
                dboProc.setId(procId);
                list.add(dboProc);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }
}

