/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHPartitionColumnSqlServerv2k5;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.XMLSchemaCollectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHXMLSchemaCollection
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "XMLSchemaCollection";
    private static final Logger LOGGER = new Logger(MOHPartitionColumnSqlServerv2k5.class);
    private StorageDesignSqlServerv2k5 storage;
    private DataBaseSqlServerv2k5 database;

    public MOHXMLSchemaCollection(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        if (this.getStorageDesign() instanceof StorageDesignSqlServerv2k5) {
            this.storage = (StorageDesignSqlServerv2k5)this.getStorageDesign();
            Iterator iterator = this.storage.getDataBaseSet().iterator();
            while (iterator.hasNext()) {
                this.database = (DataBaseSqlServerv2k5)iterator.next();
                if (this.database.isNullInstance()) continue;
                this.initXMLSchemaCollection(sqlConnection, importLog);
            }
        }
    }

    private void initXMLSchemaCollection(Connection sqlConnection, ImportLogger importLog) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        String db = this.database.getName();
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ').append(MOHXMLSchemaCollection.getFormattedName(db)).append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("xsc.name AS [Name],xsc.xml_collection_id AS [ID], ");
            buffer.append("sch.name AS [Schema],XML_SCHEMA_NAMESPACE(sch.Name, xsc.name) AS [Definition] ");
            buffer.append("FROM").append(' ');
            buffer.append("sys.xml_schema_collections AS xsc ");
            buffer.append("INNER JOIN sys.schemas AS sch ON xsc.schema_id = sch.schema_id ");
            buffer.append("WHERE").append(' ');
            buffer.append("(xsc.schema_id   <>4) ");
            buffer.append("ORDER BY").append(' ');
            buffer.append("sch.name,xsc.name ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPartitionColumnSqlServerv2k5.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String schemaName = rs.getString(3);
                String definition = rs.getString(4);
                SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)this.database.getSchemas().getByName(schemaName);
                XMLSchemaCollectionSqlServerv2k5 xmlCollection = (XMLSchemaCollectionSqlServerv2k5)this.storage.getXmlSchemaCollectionSet().createType();
                if (xmlCollection == null) continue;
                xmlCollection.setName(name);
                xmlCollection.setDatabase(this.database);
                if (schema != null) {
                    xmlCollection.setSchema(schema);
                    this.stampModelObject((ModelObject)xmlCollection, schema, name);
                }
                xmlCollection.setSchemaDefinition(definition);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }
}

