/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.oracle.MOHViewOracle;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPrivilegesUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "PRIVILIGES";
    private static final Logger LOGGER = new Logger(MOHViewOracle.class);

    public MOHPrivilegesUDB(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        this.initObject(sqlConnection, this.getDesign().getRelationalDesign().getTableSet());
        this.initObject(sqlConnection, this.getDesign().getRelationalDesign().getTableViewSet());
    }

    private void initObject(Connection sqlConnection, DesignObjectSet set) throws SQLException {
        Iterator it = set.iterator();
        DesignObject object = null;
        RelationalObjectProxy proxy = null;
        StorageDesignUDB storage = (StorageDesignUDB)this.getStorageDesign();
        while (it.hasNext()) {
            object = (DesignObject)it.next();
            if (object instanceof Table) {
                proxy = storage.getTableProxySet().getProxy(object.getObjectID());
                if (((TableProxyUDB)proxy).getSchema() == null) continue;
                this.setPermission(sqlConnection, proxy, ((TableProxyUDB)proxy).getSchema().getName());
                this.initColumns(sqlConnection, proxy, ((TableProxyUDB)proxy).getSchema().getName());
                continue;
            }
            proxy = storage.getTableViewProxySet().getProxy(object.getObjectID());
            if (((TableViewProxyUDB)proxy).getSchema() == null) continue;
            this.setPermission(sqlConnection, proxy, ((TableViewProxyUDB)proxy).getSchema().getName());
            this.initColumns(sqlConnection, proxy, ((TableViewProxyUDB)proxy).getSchema().getName());
        }
    }

    private void setPermission(Connection sqlConnection, RelationalObjectProxy proxy, String schemaName) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        PermissionsUDB perm = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT GRANTEE,GRANTEETYPE,CONTROLAUTH,ALTERAUTH, ");
            buffer.append("DELETEAUTH,INDEXAUTH,INSERTAUTH,SELECTAUTH, ");
            buffer.append("REFAUTH,UPDATEAUTH ");
            buffer.append("from syscat.TABAUTH  ");
            buffer.append("WHERE  TABNAME   =  '");
            buffer.append(proxy.getName()).append("'");
            buffer.append(" AND TABSCHEMA   = '");
            buffer.append(schemaName).append("'");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPrivilegesUDB.setPermission():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String owner = rs.getString(1);
                String type = rs.getString(2);
                String control = rs.getString(3);
                String alter = rs.getString(4);
                String delete = rs.getString(5);
                String index = rs.getString(6);
                String insert = rs.getString(7);
                String select = rs.getString(8);
                String references = rs.getString(9);
                String update = rs.getString(10);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB)) continue;
                StorageDesignUDB storage = (StorageDesignUDB)storageDesign;
                StorageObject userOrGroup = this.getUserOrGroup(storage, owner, type);
                if (userOrGroup != null) {
                    perm = this.getPermissionForUser(proxy, userOrGroup);
                }
                if (perm == null) {
                    perm = storage.getPermissionsSet().createPermissions();
                    this.initUserOrGroup(storage, perm, userOrGroup, type);
                }
                this.initPrivileges(perm, "CONTROL", control);
                this.initPrivileges(perm, "ALTER", alter);
                this.initPrivileges(perm, "DELETE", delete);
                this.initPrivileges(perm, "INDEX", index);
                this.initPrivileges(perm, "INSERT", insert);
                this.initPrivileges(perm, "SELECT", select);
                this.initPrivileges(perm, "REFERENCES", references);
                this.initPrivileges(perm, "UPDATE", update);
                if (proxy instanceof TableProxyUDB) {
                    perm.setTable((TableProxyUDB)proxy);
                    continue;
                }
                perm.setView((TableViewProxyUDB)proxy);
            }
            rs.close();
        }
        statement.close();
    }

    private void initColumns(Connection sqlConnection, RelationalObjectProxy proxy, String schemaName) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        PermissionsUDB perm = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT grantee,granteetype,tabschema,tabname, ");
            buffer.append("colname,privtype,grantable ");
            buffer.append("from syscat.colauth  ");
            buffer.append("WHERE  TABNAME   =  '");
            buffer.append(proxy.getName()).append("'");
            buffer.append(" AND TABSCHEMA   = '");
            buffer.append(schemaName).append("'");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPrivilegesUDB.initColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String owner = rs.getString(1);
                String type = rs.getString(2);
                String colName = rs.getString(5);
                String privType = rs.getString(6);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB)) continue;
                StorageDesignUDB storage = (StorageDesignUDB)storageDesign;
                StorageObject userOrGroup = this.getUserOrGroup(storage, owner, type);
                if (userOrGroup != null) {
                    perm = this.getPermissionForUser(proxy, userOrGroup);
                }
                if (perm == null) {
                    perm = storage.getPermissionsSet().createPermissions();
                    this.initUserOrGroup(storage, perm, userOrGroup, type);
                }
                if ("U".equalsIgnoreCase(privType)) {
                    perm.setColumnList(colName + "," + "UPDATE");
                    continue;
                }
                if (!"R".equalsIgnoreCase(privType)) continue;
                perm.setColumnList(colName + "," + "REFERENCES");
            }
            rs.close();
        }
        statement.close();
    }

    private StorageObject getUserOrGroup(StorageDesignUDB storage, String userOrGroup, String type) {
        if ("U".equalsIgnoreCase(type) && storage.getOwnerSet().getByName(userOrGroup) != null) {
            return (StorageObject)storage.getOwnerSet().getByName(userOrGroup);
        }
        if ("G".equalsIgnoreCase(type) && storage.getUserGroupSet().getByName(userOrGroup) != null) {
            return (StorageObject)storage.getUserGroupSet().getByName(userOrGroup);
        }
        return null;
    }

    private void initPrivileges(PermissionsUDB perm, String privName, String privType) {
        if ("Y".equalsIgnoreCase(privType)) {
            perm.setPrivileges(privName);
        } else if ("G".equalsIgnoreCase(privType)) {
            perm.setPrivilegesWithGrantOption(privName);
        }
    }

    private void initUserOrGroup(StorageDesignUDB storage, PermissionsUDB perm, StorageObject userOrGroup, String type) {
        if ("U".equalsIgnoreCase(type) && userOrGroup instanceof OwnerUDB) {
            perm.setUser((OwnerUDB)userOrGroup);
        } else if ("G".equalsIgnoreCase(type) && userOrGroup instanceof UserGroupUDB) {
            perm.setGroup((UserGroupUDB)userOrGroup);
        }
    }

    private PermissionsUDB getPermissionForUser(RelationalObjectProxy proxy, StorageObject user) {
        StorageDesign storageDesign = this.getStorageDesign();
        if (storageDesign != null && storageDesign instanceof StorageDesignUDB) {
            StorageDesignUDB storage = (StorageDesignUDB)storageDesign;
            Iterator it = storage.getPermissionsSet().iterator();
            PermissionsUDB perm = null;
            while (it.hasNext()) {
                perm = (PermissionsUDB)it.next();
                if (perm.getUser() != user && perm.getGroup() != user || perm.getTable() != proxy && perm.getView() != proxy) continue;
                return perm;
            }
        }
        return null;
    }
}

