/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.udb.MOHPartitionGroupUDB;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPartitionGroupUDBv81
extends MOHPartitionGroupUDB {
    public static final String OBJECT_TYPE = "PARTITION GROUP";
    private static final Logger LOGGER = new Logger(MOHPartitionGroupUDBv81.class);

    public MOHPartitionGroupUDBv81(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select  dbpgname,remarks ");
            buffer.append("from syscat.DBPARTITIONGROUPS");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPartitionGroupUDBv81.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String dbpgname = rs.getString(1);
                String comment = rs.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81)) continue;
                StorageDesignUDBv81 storage = (StorageDesignUDBv81)storageDesign;
                DBPartitionGroupUDBv81 group = (DBPartitionGroupUDBv81)storage.getNodeGroupSet().getByName(dbpgname);
                if (group == null) {
                    group = (DBPartitionGroupUDBv81)storage.getNodeGroupSet().createNodeGroup();
                    group.setName(dbpgname);
                    this.stampModelObject((ModelObject)group, "", dbpgname);
                }
                group.setCommentInRDBMS(comment);
            }
            rs.close();
        }
        statement.close();
    }
}

