/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODConstants;
import oracle.dbtools.crest.imports.oracledesigner.ODDataTypeDiagram;
import oracle.dbtools.crest.imports.oracledesigner.ODODomain;
import oracle.dbtools.crest.imports.oracledesigner.ODOType;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.imports.oracledesigner.logical.ODLogicalDiagram;
import oracle.dbtools.crest.imports.oracledesigner.logical.ODOEntity;
import oracle.dbtools.crest.imports.oracledesigner.logical.ODORelation;
import oracle.dbtools.crest.imports.oracledesigner.physical.ODOCluster;
import oracle.dbtools.crest.imports.oracledesigner.physical.ODOSequence;
import oracle.dbtools.crest.imports.oracledesigner.physical.ODOSnapshot;
import oracle.dbtools.crest.imports.oracledesigner.relational.ODOForeignKey;
import oracle.dbtools.crest.imports.oracledesigner.relational.ODOTable;
import oracle.dbtools.crest.imports.oracledesigner.relational.ODOView;
import oracle.dbtools.crest.imports.oracledesigner.relational.ODRelationalDiagram;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODExtractionHandler
implements ODConstants {
    public static final String WORKAREA_OBJECT_TYPE = "WORKAREA";
    public static final String APP_SYSTEM_OBJECT_TYPE = "APP_SYSTEM";
    private static ODExtractionHandler odExtractionHandler;
    protected String dbProductName = "";
    protected String dbProductVersion = "";
    protected int dbMajorVersion = -1;
    private List mohObjectsv8i = null;
    private List mohObjectsv9i = null;
    private List mohObjectsv10g = null;
    private ApplicationView view;
    private Map importedObjects = new TreeMap();
    private List appSystems;
    private static final Logger LOGGER;
    private Map relationsToKeys = new TreeMap();

    protected ODExtractionHandler(ApplicationView view) {
        this.view = view;
    }

    public static ODExtractionHandler getInstance(ApplicationView view) {
        if (odExtractionHandler == null) {
            odExtractionHandler = new ODExtractionHandler(view);
        }
        return odExtractionHandler;
    }

    public static void clearInstance() {
        odExtractionHandler = null;
    }

    public List getOHObjects() {
        switch (this.dbMajorVersion) {
            case 8: {
                return this.getOHObjectsv8i();
            }
            case 9: {
                return this.getOHObjectsv9i();
            }
            case 10: 
            case 11: 
            case 12: {
                return this.getOHObjectsv10g();
            }
        }
        return this.getOHObjectsv8i();
    }

    public List getOHObjectsv8i() {
        if (this.mohObjectsv8i == null) {
            this.mohObjectsv8i = new ArrayList();
            this.mohObjectsv8i.add(new ODODomain(this, this.view));
            this.mohObjectsv8i.add(new ODOType(this, this.view));
            this.mohObjectsv8i.add(new ODOCluster(this, this.view));
            this.mohObjectsv8i.add(new ODOEntity(this, this.view));
            this.mohObjectsv8i.add(new ODORelation(this, this.view));
            this.mohObjectsv8i.add(new ODOSequence(this, this.view));
            this.mohObjectsv8i.add(new ODOTable(this, this.view));
            this.mohObjectsv8i.add(new ODOView(this, this.view));
            this.mohObjectsv8i.add(new ODOSnapshot(this, this.view));
            this.mohObjectsv8i.add(new ODOForeignKey(this, this.view));
            this.mohObjectsv8i.add(new ODDataTypeDiagram(this, this.view));
            this.mohObjectsv8i.add(new ODLogicalDiagram(this, this.view));
            this.mohObjectsv8i.add(new ODRelationalDiagram(this, this.view));
        }
        return this.mohObjectsv8i;
    }

    public List getOHObjectsv9i() {
        if (this.mohObjectsv9i == null) {
            this.mohObjectsv9i = new ArrayList();
            this.mohObjectsv9i.add(new ODODomain(this, this.view));
            this.mohObjectsv9i.add(new ODOType(this, this.view));
            this.mohObjectsv9i.add(new ODOCluster(this, this.view));
            this.mohObjectsv9i.add(new ODOEntity(this, this.view));
            this.mohObjectsv9i.add(new ODORelation(this, this.view));
            this.mohObjectsv9i.add(new ODOSequence(this, this.view));
            this.mohObjectsv9i.add(new ODOTable(this, this.view));
            this.mohObjectsv9i.add(new ODOView(this, this.view));
            this.mohObjectsv9i.add(new ODOSnapshot(this, this.view));
            this.mohObjectsv9i.add(new ODOForeignKey(this, this.view));
            this.mohObjectsv9i.add(new ODDataTypeDiagram(this, this.view));
            this.mohObjectsv9i.add(new ODLogicalDiagram(this, this.view));
            this.mohObjectsv9i.add(new ODRelationalDiagram(this, this.view));
        }
        return this.mohObjectsv9i;
    }

    public List getOHObjectsv10g() {
        if (this.mohObjectsv10g == null) {
            this.mohObjectsv10g = new ArrayList();
            this.mohObjectsv10g.add(new ODODomain(this, this.view));
            this.mohObjectsv10g.add(new ODOType(this, this.view));
            this.mohObjectsv10g.add(new ODOCluster(this, this.view));
            this.mohObjectsv10g.add(new ODOSequence(this, this.view));
            this.mohObjectsv10g.add(new ODOEntity(this, this.view));
            this.mohObjectsv10g.add(new ODORelation(this, this.view));
            this.mohObjectsv10g.add(new ODOTable(this, this.view));
            this.mohObjectsv10g.add(new ODOView(this, this.view));
            this.mohObjectsv10g.add(new ODOSnapshot(this, this.view));
            this.mohObjectsv10g.add(new ODOForeignKey(this, this.view));
            this.mohObjectsv10g.add(new ODDataTypeDiagram(this, this.view));
            this.mohObjectsv10g.add(new ODLogicalDiagram(this, this.view));
            this.mohObjectsv10g.add(new ODRelationalDiagram(this, this.view));
        }
        return this.mohObjectsv10g;
    }

    public RDBMSSite getRDBMSSite() {
        RDBMSSiteSet rdbmsSiteSet = this.view.getCurrentDesign().getRDBMSSiteSet();
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return rdbmsSiteSet.get(StorageDesignOraclev9i.RDBMS_TYPE);
            }
            case 10: {
                return rdbmsSiteSet.get(StorageDesignOraclev10g.RDBMS_TYPE);
            }
            case 11: {
                return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
            }
            case 12: {
                return rdbmsSiteSet.get(StorageDesignOraclev12c.RDBMS_TYPE);
            }
        }
        return rdbmsSiteSet.get(StorageDesignOraclev9i.RDBMS_TYPE);
    }

    public String getDBProductVersion() {
        return this.dbProductVersion;
    }

    public String getDBProductName() {
        return this.dbProductName;
    }

    public int getDBMajorVersion() {
        return this.dbMajorVersion;
    }

    public List getWorkAreas(Connection connection) throws Exception {
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        if (connection != null) {
            DatabaseMetaData dbmd = connection.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
            Statement statement = connection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("NAME").append(',');
                buffer.append("OWNER").append(',');
                buffer.append("IRID").append(',');
                buffer.append("DESCRIPTION").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("i$sdd_workareas");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("ODExtractionHandler.getWorkAreas():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString("NAME");
                    String irid = rs.getString("IRID");
                    String description = rs.getString("DESCRIPTION");
                    ODObject odObject = new ODObject(false, name, WORKAREA_OBJECT_TYPE, irid, description);
                    list.add(odObject);
                }
                rs.close();
            }
            statement.close();
        }
        return list;
    }

    public List getApplicationSystems(Connection connection, List workAreas) throws Exception {
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        if (workAreas.size() > 0 && connection != null) {
            HashMap<String, Branch> map = new HashMap<String, Branch>();
            Statement brstatement = connection.createStatement();
            ResultSet rs = null;
            try {
                rs = brstatement.executeQuery("select branch_id, name from I$SDD_BRANCHES order by name ");
            }
            catch (SQLException e) {
                LOGGER.error("ODExtractionHandler.getApplicationSystems() - branches extract:", e);
            }
            Branch defaultBranch = null;
            Branch temp = null;
            ArrayList<Branch> branches = new ArrayList<Branch>();
            int c = 0;
            if (rs != null) {
                while (rs.next()) {
                    String id = rs.getString(1);
                    String name = rs.getString(2);
                    Branch br = new Branch(name, id);
                    map.put(id, br);
                    branches.add(br);
                    if (++c == 1) {
                        temp = br;
                    }
                    if (!"MAIN".equalsIgnoreCase(name)) continue;
                    defaultBranch = br;
                }
                rs.close();
            }
            if (defaultBranch == null && temp != null) {
                defaultBranch = temp;
            }
            brstatement.close();
            boolean versioned = false;
            for (ODObject odObject : workAreas) {
                if (!odObject.isSelected()) continue;
                String irid = odObject.getIrid();
                Statement statement = connection.createStatement();
                rs = null;
                try {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT distinct A.Name, \n");
                    buffer.append("  A.Ivid, \n");
                    buffer.append("  A.Irid, \n");
                    buffer.append("  A.Container_Subtype , \n");
                    buffer.append("  NULL AS Branch_Id, \n");
                    buffer.append("  c.Folder_Reference, \n");
                    buffer.append("  'N' as state \n");
                    buffer.append("FROM I$sdd_Folders A, \n");
                    buffer.append("  I$sdd_Wa_Context B , \n");
                    buffer.append("  I$sdd_Folder_Members c, sdd_object_versions V \n");
                    buffer.append("WHERE A.Container_Subtype IN ('APP','FOL') \n");
                    buffer.append("AND b.workarea_irid        = " + irid + " \n");
                    buffer.append("AND B.Wastebasket          = 'N' \n");
                    buffer.append("And A.Irid                 = V.Irid \n");
                    buffer.append("AND V.state                = 'N' \n");
                    buffer.append("AND A.Ivid                 = B.Object_Ivid \n");
                    buffer.append("AND A.Irid                 = C.Member_Object(+) \n");
                    buffer.append("union all ");
                    buffer.append("SELECT distinct Ss.Name, \n");
                    buffer.append("  Ss.Ivid, \n");
                    buffer.append("  Ss.Irid, \n");
                    buffer.append("  Ss.Container_Subtype, \n");
                    buffer.append("  Ss.Branch_Id, \n");
                    buffer.append("  B.Folder_Reference, \n");
                    buffer.append("  'I' as state \n");
                    buffer.append("FROM \n");
                    buffer.append("  ( SELECT DISTINCT A.Name, \n");
                    buffer.append("    A.Irid, \n");
                    buffer.append("    A.Ivid, \n");
                    buffer.append("    V0.Branch_Id, \n");
                    buffer.append("    Container_Subtype \n");
                    buffer.append("  FROM I$sdd_Folders A, \n");
                    buffer.append("    I$sdd_Object_Versions V0 \n");
                    buffer.append("  WHERE A.Container_Subtype IN ('APP','FOL') \n");
                    buffer.append("  AND A.Irid                 = V0.Irid \n");
                    buffer.append("  AND Branch_Id             IS NOT NULL \n");
                    buffer.append("  AND A.Ivid                 = \n");
                    buffer.append("    (SELECT Ivid \n");
                    buffer.append("    FROM I$sdd_Object_Versions V \n");
                    buffer.append("    WHERE A.Irid            = V.Irid \n");
                    buffer.append("    AND V.Branch_Id         = V0.Branch_Id \n");
                    buffer.append("    AND Sequence_In_Branch IS NOT NULL \n");
                    buffer.append("    AND Wastebasket         ='N' \n");
                    buffer.append("    AND Sequence_In_Branch  = \n");
                    buffer.append("      (SELECT MAX(Sequence_In_Branch) \n");
                    buffer.append("      FROM I$sdd_Object_Versions V2 \n");
                    buffer.append("      WHERE A.Irid            = V2.Irid \n");
                    buffer.append("      AND V2.Branch_Id        = V0.Branch_Id \n");
                    buffer.append("      AND Sequence_In_Branch IS NOT NULL \n");
                    buffer.append("      AND Wastebasket         ='N' \n");
                    buffer.append("      ) \n");
                    buffer.append("    ) \n");
                    buffer.append("  )Ss, \n");
                    buffer.append("  I$sdd_Folder_Members B \n");
                    buffer.append("WHERE EXISTS \n");
                    buffer.append("  (SELECT 1 \n");
                    buffer.append("  FROM I$sdd_Folders F, \n");
                    buffer.append("    I$sdd_Wa_Context C \n");
                    buffer.append("  WHERE Ss.Irid       = F.Irid \n");
                    buffer.append("  AND F.Ivid          = C.Object_Ivid \n");
                    buffer.append("  AND C.Workarea_Irid = " + irid + " \n");
                    buffer.append("  ) \n");
                    buffer.append("AND ss.Irid = B.MEMBER_OBJECT(+) \n");
                    buffer.append("ORDER BY Name");
                    rs = statement.executeQuery(buffer.toString());
                }
                catch (SQLException e) {
                    LOGGER.error("ODExtractionHandler.getApplicationSystems():", e);
                }
                if (rs != null) {
                    while (rs.next()) {
                        int ind;
                        String name = rs.getString(1);
                        String ap_ivid = rs.getString(2);
                        String appSys_irid = rs.getString(3);
                        String contType = rs.getString(4);
                        String branchID = rs.getString(5);
                        String parentAPP = rs.getString(6);
                        String ver_state = rs.getString(7);
                        versioned = !"N".equals(ver_state);
                        ODObject appSys = new ODObject(false, name, APP_SYSTEM_OBJECT_TYPE, appSys_irid);
                        appSys.setParentName(odObject.getName());
                        appSys.ivid = ap_ivid;
                        appSys.wa_irid = irid;
                        appSys.containerType = contType;
                        appSys.parentAPP = parentAPP;
                        appSys.branchID = branchID;
                        if (branchID != null) {
                            Branch br;
                            appSys.branch = br = (Branch)map.get(branchID);
                            appSys.sourceBranch = br;
                            appSys.branchID = branchID;
                        }
                        list.add(appSys);
                        if (!versioned) continue;
                        for (Branch br : branches) {
                            Branch nbr = new Branch(br.getName(), br.getId());
                            nbr.ivid = ap_ivid;
                            appSys.branches.add(nbr);
                        }
                        if (appSys.branch != null || (ind = appSys.branches.indexOf(defaultBranch)) <= -1) continue;
                        appSys.branch = (Branch)appSys.branches.get(ind);
                    }
                    rs.close();
                }
                statement.close();
            }
        }
        return list;
    }

    public List getODObjects(Connection connection, List appSystems) throws Exception {
        ArrayList list = new ArrayList();
        List mhoList = this.getOHObjects();
        this.appSystems = appSystems;
        if (mhoList.size() > 0 && connection != null) {
            for (AbstractObjectHandler objectHandler : mhoList) {
                List extracted = objectHandler.extract(connection, appSystems);
                list.addAll(extracted);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDesign(Connection connection, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        this.clearImportedObjects();
        List mhoList = this.getOHObjects();
        boolean error = false;
        AbstractObjectHandler.clearStatements();
        if (selectedObjects.size() > 0 && mhoList.size() > 0 && connection != null) {
            TimeLog.log("Begin");
            try {
                int counter = 0;
                double step = 10.0;
                int size = mhoList.size();
                for (AbstractObjectHandler objectHandler : mhoList) {
                    try {
                        objectHandler.generate(connection, selectedObjects, importLog);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error during import from Designer Repository \n", e);
                        error = true;
                    }
                    ++counter;
                    monitor.setProgress((int)(step += 75.0 / (double)size));
                }
            }
            catch (Exception e) {
                LOGGER.error("TCP/IP connection is closed! \n", e);
                error = true;
            }
            finally {
                AbstractObjectHandler.closeStatements();
                connection.close();
                TimeLog.log("End");
                if (error) {
                    MessageDialogs.showErrorMessage(Messages.getString("ODExtractionHandler.ErrorsInImport"), true);
                }
            }
            this.synchronizeTableAbbreviations();
        }
    }

    public void addToImportedObjects(String id, ModelIDObject object) {
        this.importedObjects.put(id, object);
    }

    public void clearImportedObjects() {
        this.importedObjects.clear();
    }

    public Object getImportedObject(String id) {
        return this.importedObjects.get(id);
    }

    public Relation getRelationByEndID(String endID) {
        Object[] keys = this.importedObjects.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            int pos = key.indexOf(64);
            if (pos > -1) {
                String id1 = key.substring(0, pos);
                String id2 = key.substring(pos + 1);
                if (!endID.equalsIgnoreCase(id1) && !endID.equalsIgnoreCase(id2)) continue;
                return (Relation)this.importedObjects.get(keys[i]);
            }
            if (!key.equalsIgnoreCase(endID)) continue;
            System.out.println("ODExtractionHandler.getRelationByEndID: NEW ID TEST");
            return (Relation)this.importedObjects.get(keys[i]);
        }
        return null;
    }

    public String getImportedObjectID(DesignObject object) {
        Object[] keys = this.importedObjects.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            Object obj = this.importedObjects.get(keys[i]);
            if (obj != object) continue;
            return (String)keys[i];
        }
        return null;
    }

    public List getSelectedAppSystems() {
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        if (this.appSystems != null) {
            for (ODObject odNext : this.appSystems) {
                if (!odNext.isSelected()) continue;
                list.add(odNext);
            }
        }
        return list;
    }

    public List getBranches(Connection connection) throws Exception {
        ArrayList<Branch> list = new ArrayList<Branch>();
        Statement statement = connection.createStatement();
        ResultSet rs = null;
        try {
            rs = statement.executeQuery("select branch_id, name from I$SDD_BRANCHES order by name ");
        }
        catch (SQLException e) {
            LOGGER.error("ODExtractionHandler.getApplicationSystems():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String id = rs.getString(1);
                String name = rs.getString(2);
                Branch br = new Branch(name, id);
                list.add(br);
            }
            rs.close();
        }
        statement.close();
        return list;
    }

    public Map getRelationsToKeys() {
        return this.relationsToKeys;
    }

    private void synchronizeTableAbbreviations() {
        Iterator it = this.view.getCurrentDesign().getLogicalDesign().getEntitySet().iterator();
        while (it.hasNext()) {
            Entity ent = (Entity)it.next();
            String shortName = ent.getShortName();
            if (shortName == null) continue;
            for (Table table : ent.getAllMappedtables()) {
                table.setAbbreviation(shortName);
            }
        }
    }

    static {
        LOGGER = new Logger(ODExtractionHandler.class);
    }

    public class Branch {
        private String name;
        private String id;
        public String ivid;

        public Branch(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Branch) {
                return this.id.equals(((Branch)obj).getId());
            }
            return false;
        }
    }
}

