/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.logical;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODODomain;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOEntity
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "ENTITY";
    private static final Logger LOGGER = new Logger(ODOEntity.class);
    PreparedStatement attr_statement;
    PreparedStatement key_statement;
    PreparedStatement val_statement;
    PreparedStatement keyat_statement;
    PreparedStatement syn_statement;

    public ODOEntity(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List appSystems) throws Exception {
        Statement nvstatement = null;
        Statement statement = null;
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        for (ODObject odNext : appSystems) {
            ODObject odTable;
            String ivid;
            String id;
            String tableName;
            StringBuffer buffer;
            ResultSet rs;
            if (!odNext.isSelected()) continue;
            if (odNext.branches.size() == 0) {
                rs = null;
                try {
                    if (nvstatement == null) {
                        buffer = new StringBuffer();
                        buffer.append("select  a.NAME,a.ID,a.ivid    ");
                        buffer.append("from ci_entities a,sdd_folder_members b, i$sdd_wa_context cc ");
                        buffer.append("where ");
                        buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                        buffer.append(" and b.PARENT_IVID = ? ");
                        buffer.append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                        buffer.append(" order by name ");
                        nvstatement = sqlConnection.prepareStatement(buffer.toString());
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("ODOEntity.extract(): " + e.getMessage());
                }
                try {
                    nvstatement.setString(1, odNext.getIrid());
                    nvstatement.setString(2, odNext.ivid);
                    nvstatement.setString(3, odNext.wa_irid);
                    rs = nvstatement.executeQuery();
                }
                catch (SQLException e) {
                    LOGGER.error("ODOEntity.extract(): " + e.getMessage());
                }
                if (rs == null) continue;
                while (rs.next()) {
                    tableName = rs.getString(1);
                    id = rs.getString(2);
                    ivid = rs.getString(3);
                    odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                    odTable.ivid = ivid;
                    odTable.parent_ivid = odNext.ivid;
                    odTable.setParentName(odNext.getName());
                    odTable.setParentID(odNext.getIrid());
                    odTable.containerType = odNext.containerType;
                    list.add(odTable);
                }
                rs.close();
                continue;
            }
            if (odNext.branch == null) continue;
            rs = null;
            try {
                if (statement == null) {
                    buffer = new StringBuffer();
                    buffer.append("select  a.NAME,a.ID,a.ivid    ");
                    buffer.append("from ci_entities a,sdd_folder_members b ");
                    buffer.append("where ");
                    buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                    buffer.append(" and b.PARENT_IVID = ? ");
                    buffer.append("AND EXISTS \n");
                    buffer.append("(SELECT 1 \n");
                    buffer.append("FROM ci_entities F, \n");
                    buffer.append("  I$sdd_Wa_Context C \n");
                    buffer.append("WHERE a.Irid        = F.Irid \n");
                    buffer.append("AND F.Ivid          = C.Object_Ivid \n");
                    buffer.append("AND C.Workarea_Irid = ? \n");
                    buffer.append(")");
                    buffer.append(" and a.ivid = ");
                    buffer.append(" (select ivid from i$sdd_object_versions v ");
                    buffer.append("  where ");
                    buffer.append("  a.id = v.irid and ");
                    buffer.append("  branch_id = ? ");
                    buffer.append("  and sequence_in_branch  is not null");
                    buffer.append("  and wastebasket='N' ");
                    buffer.append("  and sequence_in_branch = ");
                    buffer.append("   ( ");
                    buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                    buffer.append("     where ");
                    buffer.append("     v2.irid = a.id");
                    buffer.append("     and branch_id = ? ");
                    buffer.append("     and sequence_in_branch  is not null ");
                    buffer.append("     and wastebasket='N' ");
                    buffer.append("   ) ");
                    buffer.append("  )");
                    buffer.append(" order by name ");
                    statement = sqlConnection.prepareStatement(buffer.toString());
                }
            }
            catch (SQLException e) {
                LOGGER.error("ODOTable.extract(): " + e.getMessage());
            }
            try {
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
                statement.setString(4, odNext.branch.getId());
                statement.setString(5, odNext.branch.getId());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOEntity.extract(): " + e.getMessage());
            }
            if (rs == null) continue;
            while (rs.next()) {
                tableName = rs.getString(1);
                id = rs.getString(2);
                ivid = rs.getString(3);
                odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                odTable.ivid = ivid;
                odTable.parent_ivid = odNext.ivid;
                odTable.branch = odNext.branch;
                odTable.setParentName(odNext.getName());
                odTable.setParentID(odNext.getIrid());
                odTable.containerType = odNext.containerType;
                list.add(odTable);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (nvstatement != null) {
            nvstatement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Entities begin");
        this.attr_statement = null;
        this.key_statement = null;
        this.val_statement = null;
        this.keyat_statement = null;
        this.syn_statement = null;
        ArrayList<Temp> inher = new ArrayList<Temp>();
        Iterator it = selectedObjects.iterator();
        this.getExtractionHandler().getRelationsToKeys().clear();
        Statement statement = null;
        while (it.hasNext()) {
            ODObject odObject = (ODObject)it.next();
            if (!OBJECT_TYPE.equalsIgnoreCase(odObject.getType())) continue;
            String id = odObject.getIrid();
            String ivid = odObject.ivid;
            if (statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT NAME,SUPERTYPE_REFERENCE,DATAWAREHOUSE_TYPE,ANNUAL_GROWTH_RATE,INITIAL_VOLUME,VOLUME avg_volume,MAXIMUM_VOLUME,SHORT_NAME,PLURAL ");
                buffer.append("FROM ci_entities ");
                buffer.append("WHERE IVID = ?");
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, ivid);
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOEntity.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    String datawarehouseType = rs.getString("DATAWAREHOUSE_TYPE");
                    int annualGrowthRate = rs.getInt("ANNUAL_GROWTH_RATE");
                    String initialVolume = rs.getString("INITIAL_VOLUME");
                    String avgVolume = rs.getString("avg_volume");
                    String maxVolume = rs.getString("MAXIMUM_VOLUME");
                    String superEntity = rs.getString("SUPERTYPE_REFERENCE");
                    String short_name = rs.getString(8);
                    String plural = rs.getString(9);
                    Entity entity = null;
                    DesignObject obj = this.getDesign().getDesignObject(id);
                    if (obj instanceof Entity) {
                        entity = (Entity)obj;
                    }
                    if (entity == null) {
                        entity = this.getDesign().getLogicalDesign().createEntity();
                        if (obj == null) {
                            entity.setObjectID(id);
                        }
                    }
                    entity.setName(odObject.getName());
                    this.getExtractionHandler().addToImportedObjects(id, entity);
                    if (initialVolume != null) {
                        entity.setMinVolumes(initialVolume);
                    }
                    if (avgVolume != null) {
                        entity.setExpectedVolumes(avgVolume);
                    }
                    if (maxVolume != null) {
                        entity.setMaxVolumes(maxVolume);
                    }
                    entity.setGrowthPercent(String.valueOf(annualGrowthRate));
                    if (entity.getDesign().getDesignLevelSettings().getClassificationTypeByID(entity.getTypeID()) != null) {
                        entity.getDesign().getDesignLevelSettings().getClassificationTypeByID(entity.getTypeID()).setTypeName(datawarehouseType);
                    }
                    if (short_name != null) {
                        entity.setShortName(short_name);
                    }
                    if (plural != null) {
                        entity.setPreferredAbbreviation(plural);
                    }
                    this.initAttributes(sqlConnection, entity, id, ivid);
                    this.initKeys(sqlConnection, entity, id, ivid);
                    this.setNotesAndComments(sqlConnection, entity, id, ivid);
                    this.createSynonyms(sqlConnection, entity, id, odObject.parent_ivid);
                    if (superEntity != null) {
                        Temp temp = new Temp();
                        temp.entity = entity;
                        temp.superEntityID = superEntity;
                        inher.add(temp);
                    }
                }
                rs.close();
            }
            importLog.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.attr_statement != null) {
            this.attr_statement.close();
        }
        if (this.key_statement != null) {
            this.key_statement.close();
        }
        if (this.val_statement != null) {
            this.val_statement.close();
        }
        if (this.keyat_statement != null) {
            this.keyat_statement.close();
        }
        if (this.syn_statement != null) {
            this.syn_statement.close();
        }
        for (Temp temp : inher) {
            Object ent = this.getExtractionHandler().getImportedObject(temp.superEntityID);
            if (ent == null || !(ent instanceof Entity)) continue;
            temp.entity.setHierarchicalParent((Entity)ent);
        }
        TimeLog.log("Entities end");
    }

    private void initAttributes(Connection sqlConnection, Entity entity, String id, String ivid) throws Exception {
        if (this.attr_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(',');
            buffer.append("ID").append(',');
            buffer.append("FORMAT").append(',');
            buffer.append("MAXIMUM_LENGTH").append(',');
            buffer.append("OPTIONAL_FLAG").append(',');
            buffer.append("domain_reference").append(',');
            buffer.append("PRECISION").append(',');
            buffer.append("NOTES").append(',').append("DEFAULT_VALUE").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("ci_attributes").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("parent_ivid").append('=').append(" ? ");
            buffer.append("ORDER BY").append(' ').append("SEQUENCE_NUMBER");
            String sql = buffer.toString();
            this.attr_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.attr_statement.setString(1, ivid);
            rs = this.attr_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOEntity.initAttributes():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                String format = rs.getString("FORMAT");
                String maxLength = rs.getString("MAXIMUM_LENGTH");
                String scale = rs.getString("PRECISION");
                String allowNull = rs.getString("OPTIONAL_FLAG");
                String attrID = rs.getString("ID");
                String domainRef = rs.getString("domain_reference");
                String notes = rs.getString("NOTES");
                String default_value = rs.getString("DEFAULT_VALUE");
                DesignObject obj = this.getDesign().getDesignObject(attrID);
                Attribute attribute = null;
                if (obj instanceof Attribute) {
                    attribute = (Attribute)obj;
                }
                if (attribute == null || attribute.getEntity() != entity) {
                    attribute = entity.createAttribute();
                    if (obj == null) {
                        attribute.setObjectID(attrID);
                    }
                }
                attribute.setName(name);
                if (default_value != null && !"".equals(default_value)) {
                    attribute.setDefaultValue(default_value);
                }
                this.getExtractionHandler().addToImportedObjects(attrID, attribute);
                if (domainRef != null) {
                    Object domain = this.getExtractionHandler().getImportedObject(domainRef);
                    if (domain == null) {
                        domain = ODODomain.getDomain(this.getDesign().getDomainSet(), domainRef);
                    }
                    if (domain == null) {
                        Domain dom = this.getDesign().getDomainSet().createDomain(domainRef);
                        LogicalDatatype dt = this.getDesign().getLogicalDatatypeSet().getLogTypeByName("unknown");
                        dom.setLogicalDatatype(dt);
                        domain = dom;
                    }
                    if (domain != null && domain instanceof Domain) {
                        attribute.setUse((short)0);
                        attribute.setDomain((Domain)domain);
                    }
                } else {
                    String datatype;
                    LogicalDatatype logDatatype;
                    String datatype2;
                    String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(format);
                    if ("UNKNOWN".equalsIgnoreCase(nameDatatype) && (datatype2 = MappingDatatypeNameLogicalDataType.getDesignerMappedName(format)) != null) {
                        nameDatatype = datatype2;
                    }
                    if ((logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype)) == null && (datatype = MappingDatatypeNameLogicalDataType.getDesignerMappedName(nameDatatype)) != null) {
                        nameDatatype = datatype;
                        logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype.toUpperCase());
                    }
                    if (logDatatype != null) {
                        attribute.setUse((short)1);
                        attribute.setLogicalDatatype(logDatatype);
                        if (format.toUpperCase().indexOf("CHAR") <= -1) {
                            if (format.toUpperCase().indexOf("TIMESTAMP") > -1) {
                                if (scale != null) {
                                    attribute.setDataTypeParameter("precision", scale);
                                }
                            } else {
                                if (maxLength != null) {
                                    attribute.setDataTypeParameter("precision", maxLength);
                                }
                                if (scale != null) {
                                    attribute.setDataTypeParameter("scale", scale);
                                }
                            }
                        } else if (maxLength != null) {
                            attribute.setDataTypeParameter("size", maxLength);
                        }
                    } else {
                        LOGGER.warn("ODOEntity.initAttributes() - Unable to find Logical DataType for: " + format);
                    }
                }
                if ("Y".equalsIgnoreCase(allowNull)) {
                    attribute.setNullsAllowed(true);
                } else {
                    attribute.setNullsAllowed(false);
                }
                this.setValues(sqlConnection, attribute, attrID, ivid);
                this.setNotesAndComments(sqlConnection, attribute, attrID, ivid);
                attribute.setCommentInRDBMS(notes);
            }
            rs.close();
        }
    }

    private void setValues(Connection sqlConnection, Attribute attribute, String id, String ivid) throws Exception {
        if (this.val_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("low_value").append(',');
            buffer.append("HIGH_VALUE").append(",meaning ");
            buffer.append("FROM").append(' ');
            buffer.append("ci_attribute_values").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("ATTRIBUTE_REFERENCE").append('=').append(" ? ");
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            buffer.append("ORDER BY").append(' ').append("radio_sequence");
            String sql = buffer.toString();
            this.val_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.val_statement.setString(1, id);
            this.val_statement.setString(2, ivid);
            rs = this.val_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOEntity.setValues():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                ConstraintEnumeration valueList;
                attribute.setUseDomainConstraints(false);
                String beginValue = rs.getString("low_value");
                String endValue = rs.getString("HIGH_VALUE");
                String description = rs.getString(3);
                if (endValue != null) {
                    AVT avt = new AVT(beginValue, endValue, description);
                    attribute.addAVT(avt);
                    continue;
                }
                if (attribute.getValueList() == null) {
                    valueList = new ConstraintEnumeration();
                    attribute.setValueList(valueList);
                } else {
                    valueList = attribute.getValueList();
                }
                valueList.add(beginValue, description);
            }
            rs.close();
        }
    }

    private void initKeys(Connection sqlConnection, Entity entity, String id, String ivid) throws Exception {
        if (this.key_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT NAME uid_name,PRIMARY_UID_FLAG,ID  ");
            buffer.append("FROM CI_UNIQUE_IDENTIFIERS ");
            buffer.append("WHERE parent_ivid = ?");
            String sql = buffer.toString();
            this.key_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.key_statement.setString(1, ivid);
            rs = this.key_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOEntity.initKeys():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("uid_name");
                String pk_flag = rs.getString("PRIMARY_UID_FLAG");
                String keyID = rs.getString("ID");
                CandidateKey key = null;
                DesignObject obj = this.getDesign().getDesignObject(keyID);
                if (obj instanceof CandidateKey) {
                    key = (CandidateKey)obj;
                }
                if (key == null || key.getEntity() != entity) {
                    key = obj == null ? entity.createCandidateKey(keyID) : entity.createCandidateKey();
                }
                key.setName(name);
                this.initKeyAttributes(sqlConnection, key, keyID, ivid);
                this.getExtractionHandler().addToImportedObjects(keyID, key);
                if ("Y".equalsIgnoreCase(pk_flag)) {
                    key.makePK();
                }
                this.setNotesAndComments(sqlConnection, key, keyID, ivid);
            }
            rs.close();
        }
    }

    private void initKeyAttributes(Connection sqlConnection, CandidateKey key, String id, String ivid) throws Exception {
        if (this.keyat_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("ATTRIBUTE_REFERENCE").append(',').append("RELATIONSHIP_END_REFERENCE").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("CI_UNIQUE_IDENTIFIER_ENTRIES").append(' ');
            buffer.append("WHERE ATTRIBUTE_OR_RELATION in ('A','R') ");
            buffer.append("AND").append(' ');
            buffer.append("UNIQUE_IDENTIFIER_REFERENCE").append('=').append(" ? ");
            buffer.append(" and parent_ivid ").append('=').append(" ? ");
            buffer.append("ORDER BY").append(' ').append("SEQUENCE_WITHIN_UID");
            String sql = buffer.toString();
            this.keyat_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.keyat_statement.setString(1, id);
            this.keyat_statement.setString(2, ivid);
            rs = this.keyat_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOEntity.initKeyAttributes():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String attributeID = rs.getString("ATTRIBUTE_REFERENCE");
                String relationID = rs.getString("RELATIONSHIP_END_REFERENCE");
                if (relationID != null) {
                    this.getExtractionHandler().getRelationsToKeys().put(relationID, key);
                    continue;
                }
                Object attribute = this.getExtractionHandler().getImportedObject(attributeID);
                if (attribute != null && attribute instanceof Attribute) {
                    key.add((ContainedObject)attribute);
                    continue;
                }
                System.out.println("Unable to find Attribute for Key: " + key.getLongName());
            }
            rs.close();
        }
    }

    private void createSynonyms(Connection sqlConnection, Entity entity, String id, String app_ivid) throws SQLException {
        if (this.syn_statement == null) {
            String query = "select a.name from ci_synonyms a, sdd_folder_members b where a.ENTITY_REFERENCE = ?  and a.ID = b.member_object and b.parent_ivid = ?  order by name";
            this.syn_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.syn_statement.setString(1, id);
            this.syn_statement.setString(2, app_ivid);
            rs = this.syn_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOEntity.createSynonyms():", e);
        }
        String synonyms = null;
        boolean first = true;
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                if (first) {
                    synonyms = name;
                    first = false;
                    continue;
                }
                synonyms = synonyms + ", " + name;
            }
            rs.close();
        }
        if (synonyms != null) {
            entity.setSynonym(synonyms);
        }
    }

    class Temp {
        Entity entity;
        String superEntityID;

        Temp() {
        }
    }
}

