/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.physical;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODODomain;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOSnapshot
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "SNAPSHOT";
    PreparedStatement pk_statement;
    PreparedStatement pkcol_statement;
    PreparedStatement ind_statement;
    PreparedStatement indcol_statement;
    private static final Logger LOGGER = new Logger(ODOSnapshot.class);
    PreparedStatement col_statement;
    PreparedStatement sel_statement;
    PreparedStatement wh_statement;

    public ODOSnapshot(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List appSystems) throws Exception {
        Statement nvstatement = null;
        Statement statement = null;
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        for (ODObject odNext : appSystems) {
            ODObject odTable;
            String ivid;
            String id;
            String tableName;
            StringBuffer buffer;
            ResultSet rs;
            if (!odNext.isSelected()) continue;
            if (odNext.branches.size() == 0) {
                rs = null;
                if (nvstatement == null) {
                    buffer = new StringBuffer();
                    buffer.append("select  a.NAME,a.ID,a.ivid    ");
                    buffer.append("from CI_SNAPSHOT_DEFINITIONS a,sdd_folder_members b , i$sdd_wa_context cc ");
                    buffer.append("where ");
                    buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                    buffer.append(" and b.PARENT_IVID = ? ");
                    buffer.append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    buffer.append(" order by name ");
                    nvstatement = sqlConnection.prepareStatement(buffer.toString());
                }
                try {
                    nvstatement.setString(1, odNext.getIrid());
                    nvstatement.setString(2, odNext.ivid);
                    nvstatement.setString(3, odNext.wa_irid);
                    rs = nvstatement.executeQuery();
                }
                catch (SQLException e) {
                    LOGGER.error("ODOSnapshot.extract(): " + e.getMessage());
                }
                if (rs == null) continue;
                while (rs.next()) {
                    tableName = rs.getString(1);
                    id = rs.getString(2);
                    ivid = rs.getString(3);
                    odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                    odTable.ivid = ivid;
                    odTable.setParentName(odNext.getName());
                    odTable.setParentID(odNext.getIrid());
                    list.add(odTable);
                }
                rs.close();
                continue;
            }
            if (odNext.branch == null) continue;
            rs = null;
            if (statement == null) {
                buffer = new StringBuffer();
                buffer.append("select  a.NAME,a.ID,a.ivid    ");
                buffer.append("from CI_SNAPSHOT_DEFINITIONS a,sdd_folder_members b ");
                buffer.append("where ");
                buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                buffer.append(" and b.PARENT_IVID = ? ");
                buffer.append("AND EXISTS \n");
                buffer.append("(SELECT 1 \n");
                buffer.append("FROM CI_SNAPSHOT_DEFINITIONS F, \n");
                buffer.append("  I$sdd_Wa_Context C \n");
                buffer.append("WHERE a.Irid        = F.Irid \n");
                buffer.append("AND F.Ivid          = C.Object_Ivid \n");
                buffer.append("AND C.Workarea_Irid = ? \n");
                buffer.append(")");
                buffer.append(" and a.ivid = ");
                buffer.append(" (select ivid from i$sdd_object_versions v ");
                buffer.append("  where ");
                buffer.append("  a.id = v.irid and ");
                buffer.append("  branch_id = ? ");
                buffer.append("  and sequence_in_branch  is not null");
                buffer.append("  and wastebasket='N' ");
                buffer.append("  and sequence_in_branch = ");
                buffer.append("   ( ");
                buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                buffer.append("     where ");
                buffer.append("     v2.irid = a.id");
                buffer.append("     and branch_id = ? ");
                buffer.append("     and sequence_in_branch  is not null ");
                buffer.append("     and wastebasket='N' ");
                buffer.append("   ) ");
                buffer.append("  )");
                buffer.append(" order by name ");
                statement = sqlConnection.prepareStatement(buffer.toString());
            }
            try {
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
                statement.setString(4, odNext.branch.getId());
                statement.setString(5, odNext.branch.getId());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOSnapshot.extract(): " + e.getMessage());
            }
            if (rs == null) continue;
            while (rs.next()) {
                tableName = rs.getString(1);
                id = rs.getString(2);
                ivid = rs.getString(3);
                odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                odTable.ivid = ivid;
                odTable.branch = odNext.branch;
                odTable.setParentName(odNext.getName());
                odTable.setParentID(odNext.getIrid());
                odTable.branch = odNext.branch;
                list.add(odTable);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (nvstatement != null) {
            nvstatement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        this.col_statement = null;
        this.sel_statement = null;
        this.wh_statement = null;
        for (ODObject odObject : selectedObjects) {
            if (!OBJECT_TYPE.equalsIgnoreCase(odObject.getType())) continue;
            String id = odObject.getIrid();
            String tableID = id + "T";
            String ids = id + "S";
            if (statement == null) {
                String query = "SELECT CLUSTER_REFERENCE,OVERRIDE_SELECT_TEXT_FLAG,UPDATABLE_FLAG, REMARK, ALIAS FROM CI_SNAPSHOT_DEFINITIONS WHERE ivid = ? ";
                statement = sqlConnection.prepareStatement(query);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, odObject.ivid);
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOSnapshot.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    ClusterOracle cluster;
                    String clusterRef = rs.getString("CLUSTER_REFERENCE");
                    String overrideTextFlag = rs.getString("OVERRIDE_SELECT_TEXT_FLAG");
                    String updatable = rs.getString("UPDATABLE_FLAG");
                    String remark = rs.getString("REMARK");
                    String alias = rs.getString("ALIAS");
                    Table table = null;
                    boolean idUsed = false;
                    DesignObject obj = this.getDesign().getDesignObject(id);
                    if (obj instanceof Table) {
                        table = (Table)obj;
                    }
                    if (obj != null) {
                        idUsed = true;
                    }
                    if (table == null) {
                        if (obj == null) {
                            obj = this.getDesign().getDesignObject(tableID);
                        }
                        if (obj != null && obj instanceof Table) {
                            table = (Table)obj;
                        } else {
                            table = this.getDesign().getRelationalDesign().createTable();
                            if (obj == null) {
                                table.setObjectID(tableID);
                            }
                        }
                    }
                    table.setName(odObject.getName());
                    table.setTypeID("4");
                    SnapshotOracle snapshot = null;
                    if (idUsed) {
                        snapshot = ((StorageDesignOracle)this.getStorageDesign()).getSnapshotSet().createSnapshot(ids);
                    } else {
                        snapshot = (SnapshotOracle)this.getStorageDesign().getStorageObject(id);
                        if (snapshot == null) {
                            snapshot = ((StorageDesignOracle)this.getStorageDesign()).getSnapshotSet().createSnapshot(id);
                        }
                    }
                    snapshot.setName(odObject.getName());
                    this.getExtractionHandler().addToImportedObjects(id, snapshot);
                    this.setNotesAndComments(sqlConnection, snapshot, id);
                    snapshot.setCommentInRDBMS(remark);
                    snapshot.setAlias(alias);
                    table.setAbbreviation(alias);
                    table.setComment(snapshot.getComment());
                    table.setCommentInRDBMS(snapshot.getCommentInRDBMS());
                    table.setNotes(snapshot.getNotes());
                    if ("Y".equalsIgnoreCase(updatable)) {
                        snapshot.setForUpdate("YES");
                    } else {
                        snapshot.setForUpdate("NO");
                    }
                    TableProxyOracle tbProxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
                    if (tbProxy != null) {
                        tbProxy.setSnapshot(snapshot);
                    }
                    this.initColumns(sqlConnection, table, id, tbProxy, odObject.ivid, snapshot);
                    this.createDBSynonyms(sqlConnection, odObject.getName(), odObject.ivid);
                    if ("Y".equalsIgnoreCase(overrideTextFlag)) {
                        String body = this.getSelectStatement(sqlConnection, id, odObject.ivid) + "\n" + this.getWhereStatement(sqlConnection, id, odObject.ivid);
                        snapshot.setSubquery(body);
                    }
                    this.initPK_UK(sqlConnection, table, id, odObject.ivid);
                    this.initIndexes(sqlConnection, table, id, odObject.ivid);
                    if (clusterRef != null && (cluster = (ClusterOracle)this.getExtractionHandler().getImportedObject(clusterRef)) != null) {
                        snapshot.setCluster(cluster);
                        tbProxy.setCluster(cluster);
                    }
                }
                rs.close();
            }
            importLog.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.sel_statement != null) {
            this.sel_statement.close();
        }
        if (this.wh_statement != null) {
            this.wh_statement.close();
        }
    }

    private void initColumns(Connection sqlConnection, Table table, String id, TableProxyOracle tbProxy, String ivid, SnapshotOracle snapshot) throws Exception {
        if (this.col_statement == null) {
            String query = "SELECT c.name,c.id,  c.DATATYPE, DECIMAL_PLACES,CLUSTER_COLUMN_REFERENCE,c.DOMAIN_REFERENCE,NULL_INDICATOR,c.DEFAULT_VALUE,c.MAXIMUM_LENGTH, OBJECT_TYPE_INCLUSION,ORACLE_TYPE_REFERENCE from ci_columns c where parent_ivid = ? order by c.SEQUENCE_NUMBER";
            this.col_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.col_statement.setString(1, ivid);
            rs = this.col_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOSnapshot.initColumns():", e);
        }
        if (rs != null) {
            String clustColumns = null;
            boolean first = true;
            while (rs.next()) {
                String name = rs.getString("NAME");
                String colID = rs.getString("ID");
                String dataType = rs.getString("DATATYPE");
                int decimalPlaces = rs.getInt("DECIMAL_PLACES");
                String clustColumnID = rs.getString("CLUSTER_COLUMN_REFERENCE");
                String domainRef = rs.getString("domain_reference");
                String nullIndicator = rs.getString("NULL_INDICATOR");
                String defaultValue = rs.getString("DEFAULT_VALUE");
                int maxLength = rs.getInt("MAXIMUM_LENGTH");
                String objectTypeInclusion = rs.getString("OBJECT_TYPE_INCLUSION");
                String typeRef = rs.getString("ORACLE_TYPE_REFERENCE");
                DesignObject objc = this.getDesign().getDesignObject(colID);
                Column column = null;
                if (objc instanceof Column) {
                    column = (Column)objc;
                }
                if (column == null || column.getTable() != table) {
                    column = table.createColumn();
                    if (objc == null) {
                        column.setObjectID(colID);
                    }
                }
                column.setDefaultValue(defaultValue);
                column.setName(name);
                this.getExtractionHandler().addToImportedObjects(colID, column);
                if ("NOT NULL".equalsIgnoreCase(nullIndicator)) {
                    column.setNullsAllowed(false);
                } else {
                    column.setNullsAllowed(true);
                }
                if (tbProxy != null && clustColumnID != null) {
                    if (first) {
                        clustColumns = column.getName();
                        first = false;
                    } else {
                        clustColumns = clustColumns + " , " + column.getName();
                    }
                    ColumnProxy cp = (ColumnProxy)this.getStorageDesign().getColumnProxySet().getProxy(column.getObjectID());
                    if (cp != null) {
                        tbProxy.setClusterColumns(cp.getObjectID());
                    }
                }
                if (domainRef != null) {
                    Object domain = this.getExtractionHandler().getImportedObject(domainRef);
                    if (domain == null) {
                        domain = ODODomain.getDomain(this.getDesign().getDomainSet(), domainRef);
                    }
                    if (domain != null && domain instanceof Domain) {
                        column.setUse((short)0);
                        column.setDomain((Domain)domain);
                    }
                } else if (typeRef != null) {
                    DesignObject objectType = (DesignObject)this.getExtractionHandler().getImportedObject(typeRef);
                    if (objectType != null) {
                        if ("REF".equalsIgnoreCase(objectTypeInclusion)) {
                            column.setReference(true);
                        }
                        if (objectType instanceof StructuredType) {
                            column.setUse((short)3);
                            column.setStructuredType((StructuredType)objectType);
                        } else if (objectType instanceof CollectionType) {
                            column.setUse((short)4);
                            column.setCollectionType((CollectionType)objectType);
                        }
                    }
                } else {
                    String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(dataType);
                    LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype);
                    if (logDatatype != null) {
                        column.setUse((short)1);
                        column.setLogicalDatatype(logDatatype);
                        if (decimalPlaces > 0) {
                            column.setDataTypeParameter("precision", String.valueOf(maxLength));
                            column.setDataTypeParameter("scale", String.valueOf(decimalPlaces));
                        } else {
                            column.setDataTypeParameter("size", String.valueOf(maxLength));
                        }
                    } else {
                        LOGGER.warn("ODOSnapshot.initColumns() - Unable to find Logical DataType for: " + dataType);
                    }
                }
                this.setNotesAndComments(sqlConnection, column, colID, ivid);
            }
            rs.close();
            if (clustColumns != null) {
                snapshot.setClusterColumns(clustColumns);
            }
        }
    }

    private void initPK_UK(Connection sqlConnection, Table table, String id, String ivid) throws Exception {
        if (this.pk_statement == null) {
            String query = "SELECT a.NAME, CONSTRAINT_TYPE,DEFER_STATUS, ENABLED_FLAG,EXCEPTION_TABLE, a.ID,UNIQUE_IDENTIFIER_REFERENCE mapped_uid, COMPLETE_FLAG from CI_UNIQUE_KEY_CONSTRAINTS a where a.parent_ivid = ?  and TABLE_REFERENCE = ?  union SELECT a.NAME, CONSTRAINT_TYPE,DEFER_STATUS, ENABLED_FLAG,EXCEPTION_TABLE, a.ID,UNIQUE_IDENTIFIER_REFERENCE mapped_uid, COMPLETE_FLAG from CI_PRIMARY_KEY_CONSTRAINTS a where a.parent_ivid = ?  and TABLE_REFERENCE = ?  order by CONSTRAINT_TYPE";
            this.pk_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.pk_statement.setString(1, ivid);
            this.pk_statement.setString(2, id);
            this.pk_statement.setString(3, ivid);
            this.pk_statement.setString(4, id);
            rs = this.pk_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOSnapshot.initPK_UK():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                CandidateKey key;
                TableProxyOracle proxy;
                Table exTable;
                String name = rs.getString("NAME");
                String indexID = rs.getString("ID");
                String constraintType = rs.getString("CONSTRAINT_TYPE");
                String deferStatus = rs.getString("DEFER_STATUS");
                String enabledFlag = rs.getString("ENABLED_FLAG");
                String exceptionTable = rs.getString("EXCEPTION_TABLE");
                String mapped_uid = rs.getString("mapped_uid");
                DesignObject obj = this.getDesign().getDesignObject(indexID);
                Index index = null;
                if (obj instanceof Index) {
                    index = (Index)obj;
                }
                if (index == null || index.getTable() != table) {
                    index = table.createIndex();
                    if (obj == null) {
                        index.setObjectID(indexID);
                    }
                }
                index.setName(name);
                String complete = rs.getString("COMPLETE_FLAG");
                if (complete != null && "Y".equalsIgnoreCase(complete)) {
                    index.setMarkedGenerate(true);
                } else {
                    index.setMarkedGenerate(false);
                }
                this.initPK_UKColumns(sqlConnection, index, indexID, ivid);
                this.getExtractionHandler().addToImportedObjects(indexID, index);
                if ("PRIMARY".equalsIgnoreCase(constraintType)) {
                    index.makePK();
                    PKProxyOracle pkProxy = (PKProxyOracle)((StorageDesignOracle)this.getStorageDesign()).getPKProxySet().getProxy(index.getObjectID());
                    if (pkProxy != null) {
                        if ("INIT DEFERRED".equalsIgnoreCase(deferStatus)) {
                            pkProxy.setInitially(FKProxyOracle.getInitiallyChoices()[1]);
                        } else if ("INIT IMMEDIATE".equalsIgnoreCase(deferStatus)) {
                            pkProxy.setInitially(FKProxyOracle.getInitiallyChoices()[0]);
                        } else if ("NOT DEFERRED".equalsIgnoreCase(deferStatus)) {
                            pkProxy.setDeferrable("NO");
                        }
                        if ("Y".equalsIgnoreCase(enabledFlag)) {
                            pkProxy.setEnable("YES");
                        } else {
                            pkProxy.setEnable("NO");
                        }
                        if (exceptionTable != null && (exTable = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(exceptionTable)) != null) {
                            proxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(exTable.getObjectID());
                            pkProxy.setExceptionsTable(proxy);
                        }
                    }
                } else {
                    index.setIndexState("Unique Constraint");
                    UniqueOracle unique = (UniqueOracle)((StorageDesignOracle)this.getStorageDesign()).getUniqueSet().getProxy(index.getObjectID());
                    if (unique != null) {
                        if ("INIT DEFERRED".equalsIgnoreCase(deferStatus)) {
                            unique.setInitially(FKProxyOracle.getInitiallyChoices()[1]);
                        } else if ("INIT IMMEDIATE".equalsIgnoreCase(deferStatus)) {
                            unique.setInitially(FKProxyOracle.getInitiallyChoices()[0]);
                        } else if ("NOT DEFERRED".equalsIgnoreCase(deferStatus)) {
                            unique.setDeferrable("NO");
                        }
                        if ("Y".equalsIgnoreCase(enabledFlag)) {
                            unique.setEnable("YES");
                        } else {
                            unique.setEnable("NO");
                        }
                        if (exceptionTable != null && (exTable = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(exceptionTable)) != null) {
                            proxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(exTable.getObjectID());
                            unique.setExceptionsTable(proxy);
                        }
                    }
                }
                if (mapped_uid != null && (key = (CandidateKey)this.getExtractionHandler().getImportedObject(mapped_uid)) != null) {
                    this.getDesign().getExtendedMap().createMapping(key, index);
                    index.setGeneratorID(key.getObjectID());
                }
                this.setNotesAndComments(sqlConnection, index, indexID, ivid);
            }
            rs.close();
        }
    }

    private void initPK_UKColumns(Connection sqlConnection, Index index, String id, String ivid) throws Exception {
        if (this.pkcol_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_REFERENCE").append(',');
            buffer.append("SEQUENCE_NUMBER").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("ci_key_components").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("CONSTRAINT_REFERENCE").append('=').append(" ? ");
            buffer.append("AND").append(' ').append("parent_ivid").append('=').append(" ? ");
            buffer.append("ORDER BY").append(' ').append("SEQUENCE_NUMBER");
            this.pkcol_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.pkcol_statement.setString(1, id);
            this.pkcol_statement.setString(2, ivid);
            rs = this.pkcol_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOSnapshot.initPK_UKColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String columnID = rs.getString("COLUMN_REFERENCE");
                Column column = (Column)this.getExtractionHandler().getImportedObject(columnID);
                if (column == null) continue;
                index.add(column);
            }
            rs.close();
        }
    }

    private void initIndexes(Connection sqlConnection, Table table, String id, String ivid) throws Exception {
        if (this.ind_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(',');
            buffer.append("CLUSTER_REFERENCE").append(',');
            buffer.append("COMPUTE_STATISTICS_FLAG").append(',');
            buffer.append("ID").append(',');
            buffer.append("INDEX_TYPE").append(',');
            buffer.append("RELATION_INDEX_TYPE").append(' ').append(',');
            buffer.append("ivid").append(',');
            buffer.append("COMPLETE_FLAG").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("ci_indexes").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("SNAPSHOT_DEFINITION_REFERENCE").append('=').append(" ? ");
            buffer.append("AND").append(' ').append("parent_ivid").append('=').append(" ? ");
            this.ind_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.ind_statement.setString(1, id);
            this.ind_statement.setString(2, ivid);
            rs = this.ind_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOSnapshot.initIndexes():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                String indexID = rs.getString("ID");
                String computeStats = rs.getString("COMPUTE_STATISTICS_FLAG");
                String relationalIndexType = rs.getString("RELATION_INDEX_TYPE");
                DesignObject obj = this.getDesign().getDesignObject(indexID);
                Index index = null;
                if (obj instanceof Index) {
                    index = (Index)obj;
                }
                if (index == null || index.getTable() != table) {
                    index = table.createIndex();
                    if (obj == null) {
                        index.setObjectID(indexID);
                    }
                }
                index.setName(name);
                this.getExtractionHandler().addToImportedObjects(indexID, index);
                String complete = rs.getString("COMPLETE_FLAG");
                if (complete != null && "Y".equalsIgnoreCase(complete)) {
                    index.setMarkedGenerate(true);
                } else {
                    index.setMarkedGenerate(false);
                }
                this.initIndexColumns(sqlConnection, index, indexID, ivid);
                if ("UNIQUE".equalsIgnoreCase(relationalIndexType)) {
                    index.setIndexState("Unique Plain Index");
                }
                this.setNotesAndComments(sqlConnection, index, indexID, ivid);
                IndexProxyOracle proxy = (IndexProxyOracle)this.getStorageDesign().getIndexProxySet().getProxy(index.getObjectID());
                if (proxy == null) continue;
                if ("Y".equalsIgnoreCase(computeStats)) {
                    proxy.setComputeStatistics("YES");
                } else {
                    proxy.setComputeStatistics("NO");
                }
                if (complete != null && "Y".equalsIgnoreCase(complete)) {
                    proxy.setMarkedGenerate(true);
                    continue;
                }
                proxy.setMarkedGenerate(false);
            }
            rs.close();
        }
    }

    private void initIndexColumns(Connection sqlConnection, Index index, String id, String ivid) throws Exception {
        ArrayList<String> columns = new ArrayList<String>();
        boolean isFunctional = false;
        if (this.indcol_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_REFERENCE").append(',');
            buffer.append("INDEX_ENTRY_TYPE").append(',');
            buffer.append("INDEX_FUNCTION").append(',');
            buffer.append("SEQUENCE_NUMBER").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("ci_index_entries").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("RELATION_INDEX_REFERENCE").append('=').append(" ? ");
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            buffer.append("ORDER BY").append(' ').append("SEQUENCE_NUMBER");
            this.indcol_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.indcol_statement.setString(1, id);
            this.indcol_statement.setString(2, ivid);
            rs = this.indcol_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOSnapshot.initIndexColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String columnID = rs.getString("COLUMN_REFERENCE");
                String indexEntryType = rs.getString("INDEX_ENTRY_TYPE");
                String function = rs.getString("INDEX_FUNCTION");
                if ("FUNCTIONBASED".equalsIgnoreCase(indexEntryType) && function != null) {
                    isFunctional = true;
                    columns.add("FUNCTIONBASED@" + function);
                    continue;
                }
                if (columnID == null) continue;
                columns.add(columnID);
            }
            rs.close();
        }
        Iterator it = columns.iterator();
        String functionStatement = null;
        while (it.hasNext()) {
            String columnID = (String)it.next();
            if (isFunctional) {
                String text = "";
                if (columnID.startsWith("FUNCTIONBASED")) {
                    text = columnID.substring(columnID.indexOf(64) + 1);
                } else {
                    Column column = (Column)this.getExtractionHandler().getImportedObject(columnID);
                    if (column != null) {
                        text = column.getName();
                    }
                }
                if (functionStatement == null) {
                    functionStatement = text;
                    continue;
                }
                functionStatement = functionStatement + ", " + text;
                continue;
            }
            Column column = (Column)this.getExtractionHandler().getImportedObject(columnID);
            if (column == null) continue;
            index.add(column);
        }
        if (functionStatement != null) {
            index.setIndexExpression(functionStatement);
        }
    }

    private String getSelectStatement(Connection sqlConnection, String id, String ivid) throws Exception {
        String result = "";
        if (this.sel_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("parent_ivid = ? ");
            buffer.append("AND").append(' ');
            buffer.append("txt_type").append('=').append("'LGEXPR'").append(' ');
            buffer.append("ORDER BY").append(' ').append("TXT_SEQ");
            this.sel_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.sel_statement.setString(1, ivid);
            rs = this.sel_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOSnapshot.getSelectStatement(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String text = rs.getString("txt_text");
                if ("".equalsIgnoreCase(result)) {
                    result = text;
                    continue;
                }
                result = result + text;
            }
            rs.close();
        }
        if (!"".equalsIgnoreCase(result) && !result.trim().toUpperCase().startsWith("SELECT")) {
            result = "SELECT " + result.trim();
        }
        return result;
    }

    private String getWhereStatement(Connection sqlConnection, String id, String ivid) throws Exception {
        String result = "";
        if (this.wh_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("parent_ivid = ? ");
            buffer.append("AND").append(' ');
            buffer.append("txt_type").append('=').append("'CDWHCL'").append(' ');
            buffer.append("ORDER BY").append(' ').append("TXT_SEQ");
            this.wh_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.wh_statement.setString(1, ivid);
            rs = this.wh_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOSnapshot.getWhereStatement(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String text = rs.getString("txt_text");
                if ("".equalsIgnoreCase(result)) {
                    result = text;
                    continue;
                }
                result = result + text;
            }
            rs.close();
        }
        if (!"".equalsIgnoreCase(result) && !result.trim().toUpperCase().startsWith("WHERE")) {
            result = "WHERE " + result.trim();
        }
        return result;
    }
}

