/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.relational;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOForeignKey
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "FOREIGN KEY";
    private static final Logger LOGGER = new Logger(ODOForeignKey.class);
    PreparedStatement fk_statement;
    private Map arcMap = new TreeMap();

    public ODOForeignKey(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        this.fk_statement = null;
        for (ODObject odObject : selectedObjects) {
            if (!"TABLE".equalsIgnoreCase(odObject.getType()) && !"SNAPSHOT".equalsIgnoreCase(odObject.getType())) continue;
            String tableID = odObject.getIrid();
            if (statement == null) {
                String query = "SELECT a.NAME,FOREIGN_TABLE_REFERENCE,a.DEFER_STATUS, a.ENABLED_FLAG, a.ERROR_MESSAGE, a.EXCEPTION_TABLE, FK_CASCADE_DELETE, FK_TRANSFERABLE, FOR_JOINING_TO,  a.ID,RELATIONSHIP_END_REFERENCE,UNIQUE_KEY_REFERENCE,ARC_NUMBER,ARC_MANDATORY, MANDATORY_FLAG, COMPLETE_FLAG, PRIMARY_KEY_REFERENCE from CI_FOREIGN_KEY_CONSTRAINTS a where a.TABLE_REFERENCE = ?  and a.PARENT_IVID = ? ";
                statement = sqlConnection.prepareStatement(query);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, tableID);
                statement.setString(2, odObject.ivid);
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOForeignKey.generate():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                TableProxyOracle refProxy;
                TableProxyOracle tabProxy;
                String fkName = rs.getString("NAME");
                String fkID = rs.getString("ID");
                String fkTableRef = rs.getString("FOREIGN_TABLE_REFERENCE");
                String defer = rs.getString("DEFER_STATUS");
                String enabled = rs.getString("ENABLED_FLAG");
                String exceptionTable = rs.getString("EXCEPTION_TABLE");
                String fkCascadeDelete = rs.getString("FK_CASCADE_DELETE");
                String fkTransferable = rs.getString("FK_TRANSFERABLE");
                String relationRef = rs.getString("RELATIONSHIP_END_REFERENCE");
                String ukRef = rs.getString("UNIQUE_KEY_REFERENCE");
                String arcNumber = rs.getString("ARC_NUMBER");
                String arcMandatory = rs.getString("ARC_MANDATORY");
                String fkMandatory = rs.getString("MANDATORY_FLAG");
                String complete = rs.getString("COMPLETE_FLAG");
                String pkRef = rs.getString("PRIMARY_KEY_REFERENCE");
                Table table = null;
                Object tabObj = this.getExtractionHandler().getImportedObject(tableID);
                if (tabObj instanceof Table) {
                    table = (Table)tabObj;
                } else if (tabObj instanceof SnapshotOracle && (tabProxy = ((SnapshotOracle)tabObj).getImplementedTable()) != null) {
                    table = (Table)tabProxy.getObject();
                }
                Table refTable = null;
                Object refObj = this.getExtractionHandler().getImportedObject(fkTableRef);
                if (refObj instanceof Table) {
                    refTable = (Table)refObj;
                } else if (refObj instanceof SnapshotOracle && (refProxy = ((SnapshotOracle)refObj).getImplementedTable()) != null) {
                    refTable = (Table)refProxy.getObject();
                }
                if (table == null || refTable == null) continue;
                KeyObject index = null;
                if (ukRef != null) {
                    index = (KeyObject)this.getExtractionHandler().getImportedObject(ukRef);
                } else if (pkRef != null) {
                    index = (KeyObject)this.getExtractionHandler().getImportedObject(pkRef);
                }
                if (index == null) {
                    index = refTable.getPK();
                }
                if (index != null) {
                    Relation relation;
                    FKIndexAssociation fk = null;
                    DesignObject obj = this.getDesign().getDesignObject(fkID);
                    if (obj instanceof FKIndexAssociation) {
                        fk = (FKIndexAssociation)obj;
                    }
                    if (fk == null) {
                        fk = table.addFK(index);
                        if (obj == null) {
                            fk.setObjectID(fkID);
                        }
                    }
                    this.getExtractionHandler().addToImportedObjects(fkID, fk);
                    if (fkName != null) {
                        fk.setName(fkName);
                        fk.getLocalFKIndex().setName(fkName);
                    }
                    this.initFKColumns(sqlConnection, fk, fkID, odObject.ivid);
                    this.setNotesAndComments(sqlConnection, fk, fkID, odObject.ivid);
                    if ("C".equalsIgnoreCase(fkCascadeDelete)) {
                        fk.setDeleteRule("CASCADE");
                    } else if ("N".equalsIgnoreCase(fkCascadeDelete)) {
                        fk.setDeleteRule("SET NULL");
                    } else {
                        fk.setDeleteRule("RESTRICT");
                    }
                    if (arcNumber != null) {
                        ArcHolder arch = (ArcHolder)this.arcMap.get(table.getObjectID() + arcNumber);
                        if (arch == null) {
                            arch = new ArcHolder();
                            this.arcMap.put(table.getObjectID() + arcNumber, arch);
                        }
                        boolean mandatory = false;
                        if (arcMandatory != null && arcMandatory.equalsIgnoreCase("Y")) {
                            mandatory = true;
                        }
                        arch.mandatory = mandatory || arch.mandatory;
                        arch.fkeys.add(fk);
                    }
                    if (fkTransferable != null && "Y".equalsIgnoreCase(fkTransferable)) {
                        fk.setTransferable(true);
                    } else {
                        fk.setTransferable(false);
                    }
                    if (fkMandatory != null && "Y".equalsIgnoreCase(fkMandatory)) {
                        fk.setMandatory(true);
                    } else {
                        fk.setMandatory(false);
                    }
                    if (complete != null && "Y".equalsIgnoreCase(complete)) {
                        fk.setMarkedGenerate(true);
                    } else {
                        fk.setMarkedGenerate(false);
                    }
                    FKProxyOracle fkProxy = (FKProxyOracle)((StorageDesignOracle)this.getStorageDesign()).getFKProxySet().getProxy(fk.getLocalFKIndex().getObjectID());
                    if (fkProxy != null) {
                        Table exTable;
                        fkProxy.setComment(fk.getComment());
                        if ("INIT DEFERRED".equalsIgnoreCase(defer)) {
                            fkProxy.setInitially(FKProxyOracle.getInitiallyChoices()[1]);
                        } else if ("INIT IMMEDIATE".equalsIgnoreCase(defer)) {
                            fkProxy.setInitially(FKProxyOracle.getInitiallyChoices()[0]);
                        } else if ("NOT DEFERRED".equalsIgnoreCase(defer)) {
                            fkProxy.setDeferrable("NO");
                        }
                        if ("Y".equalsIgnoreCase(enabled)) {
                            fkProxy.setEnable("YES");
                        } else {
                            fkProxy.setEnable("NO");
                        }
                        if (exceptionTable != null && (exTable = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(exceptionTable)) != null) {
                            TableProxyOracle proxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(exTable.getObjectID());
                            fkProxy.setExceptionsTable(proxy);
                        }
                    }
                    if (relationRef == null || (relation = this.getExtractionHandler().getRelationByEndID(relationRef)) == null) continue;
                    this.getDesign().getExtendedMap().createMapping(relation, fk);
                    fk.setGeneratorID(relation.getObjectID());
                    continue;
                }
                LOGGER.warn("ODOForeignKey.generate() - Unable to get Index from Table: " + refTable.getName());
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.fk_statement != null) {
            this.fk_statement.close();
        }
        this.createArcs();
    }

    private void initFKColumns(Connection sqlConnection, FKIndexAssociation fk, String fkID, String ivid) throws Exception {
        if (this.fk_statement == null) {
            String query = "SELECT COLUMN_REFERENCE,FOREIGN_COLUMN_REFERENCE,a.SEQUENCE_NUMBER from ci_key_components a where CONSTRAINT_REFERENCE = ?  and parent_ivid = ? order by SEQUENCE_NUMBER";
            this.fk_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.fk_statement.setString(1, fkID);
            this.fk_statement.setString(2, ivid);
            rs = this.fk_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOForeignKey.initFKColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colRef = rs.getString("COLUMN_REFERENCE");
                String fkColRef = rs.getString("FOREIGN_COLUMN_REFERENCE");
                Column column = (Column)this.getExtractionHandler().getImportedObject(colRef);
                Column fkColumn = (Column)this.getExtractionHandler().getImportedObject(fkColRef);
                if (column != null && fkColumn != null) {
                    if (column.getContainerWithKeyObject() != fk.getTable()) continue;
                    column.addFKAssociation(fkColumn, fk);
                    fk.getLocalFKIndex().add(column);
                    continue;
                }
                LOGGER.warn("ODOForeignKey.initFKColumns() - Unable to find Column!");
            }
            rs.close();
        }
    }

    private void createArcs() {
        for (String key : this.arcMap.keySet()) {
            ArcHolder arch = (ArcHolder)this.arcMap.get(key);
            List fkeys = arch.fkeys;
            if (fkeys.size() <= 1) continue;
            FKIndexAssociation fk = (FKIndexAssociation)fkeys.get(0);
            Table table = (Table)fk.getContainerWithKeyObject();
            fkeys.add(0, table);
            FKArc arc = ((RelationalDesign)table.getDesignPart()).createArc(fkeys.toArray());
            arc.setMandatory(arch.mandatory);
        }
    }

    private class ArcHolder {
        boolean mandatory = false;
        List fkeys = new ArrayList();

        private ArcHolder() {
        }
    }
}

