/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.relational;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODODomain;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOTable
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "TABLE";
    private static final Logger LOGGER = new Logger(ODOTable.class);
    PreparedStatement col_statement;
    PreparedStatement indcol_statement;
    PreparedStatement val_statement;
    PreparedStatement ind_statement;
    PreparedStatement pk_statement;
    PreparedStatement pkcol_statement;
    PreparedStatement tlc_statement;
    PreparedStatement cnd_statement;
    PreparedStatement tr_statement;
    PreparedStatement tr_col_statement;
    PreparedStatement vstatement;

    public ODOTable(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List appSystems) throws Exception {
        Statement nvstatement = null;
        Statement statement = null;
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        for (ODObject odNext : appSystems) {
            ODObject odTable;
            String ivid;
            String id;
            String tableName;
            ResultSet rs;
            StringBuffer buffer;
            if (!odNext.isSelected()) continue;
            if (odNext.branches.size() == 0) {
                if (nvstatement == null) {
                    buffer = new StringBuffer();
                    buffer.append("select  a.NAME,a.ID,a.ivid    ");
                    buffer.append("from CI_TABLE_DEFINITIONS a,sdd_folder_members b, i$sdd_wa_context cc ");
                    buffer.append("where ");
                    buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                    buffer.append(" and b.PARENT_IVID = ? ");
                    buffer.append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    buffer.append(" order by name ");
                    nvstatement = sqlConnection.prepareStatement(buffer.toString());
                }
                rs = null;
                try {
                    nvstatement.setString(1, odNext.getIrid());
                    nvstatement.setString(2, odNext.ivid);
                    nvstatement.setString(3, odNext.wa_irid);
                    rs = nvstatement.executeQuery();
                }
                catch (SQLException e) {
                    LOGGER.error("ODOTable.extract(): " + e.getMessage());
                }
                if (rs == null) continue;
                while (rs.next()) {
                    tableName = rs.getString(1);
                    id = rs.getString(2);
                    ivid = rs.getString(3);
                    odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                    odTable.ivid = ivid;
                    odTable.setParentName(odNext.getName());
                    odTable.setParentID(odNext.getIrid());
                    odTable.containerType = odNext.containerType;
                    list.add(odTable);
                }
                rs.close();
                continue;
            }
            if (odNext.branch == null) continue;
            if (statement == null) {
                buffer = new StringBuffer();
                buffer.append("select  a.NAME,a.ID,a.ivid    ");
                buffer.append("from CI_TABLE_DEFINITIONS a,sdd_folder_members b ");
                buffer.append("where ");
                buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                buffer.append(" and b.PARENT_IVID = ? ");
                buffer.append("AND EXISTS \n");
                buffer.append("(SELECT 1 \n");
                buffer.append("FROM CI_TABLE_DEFINITIONS F, \n");
                buffer.append("  I$sdd_Wa_Context C \n");
                buffer.append("WHERE a.Irid        = F.Irid \n");
                buffer.append("AND F.Ivid          = C.Object_Ivid \n");
                buffer.append("AND C.Workarea_Irid = ? \n");
                buffer.append(")");
                buffer.append(" and a.ivid = ");
                buffer.append(" (select ivid from i$sdd_object_versions v ");
                buffer.append("  where ");
                buffer.append("  a.id = v.irid and ");
                buffer.append("  branch_id = ? ");
                buffer.append("  and sequence_in_branch  is not null");
                buffer.append("  and wastebasket='N' ");
                buffer.append("  and sequence_in_branch = ");
                buffer.append("   ( ");
                buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                buffer.append("     where ");
                buffer.append("     v2.irid = a.id");
                buffer.append("     and branch_id = ? ");
                buffer.append("     and sequence_in_branch  is not null ");
                buffer.append("     and wastebasket='N' ");
                buffer.append("   ) ");
                buffer.append("  )");
                buffer.append(" order by name ");
                statement = sqlConnection.prepareStatement(buffer.toString());
            }
            rs = null;
            try {
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
                statement.setString(4, odNext.branch.getId());
                statement.setString(5, odNext.branch.getId());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOTable.extract(): " + e.getMessage());
            }
            if (rs == null) continue;
            while (rs.next()) {
                tableName = rs.getString(1);
                id = rs.getString(2);
                ivid = rs.getString(3);
                odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                odTable.ivid = ivid;
                odTable.branch = odNext.branch;
                odTable.setParentName(odNext.getName());
                odTable.setParentID(odNext.getIrid());
                odTable.branch = odNext.branch;
                odTable.containerType = odNext.containerType;
                list.add(odTable);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (nvstatement != null) {
            nvstatement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Tables begin");
        Statement statement = null;
        this.col_statement = null;
        this.indcol_statement = null;
        this.ind_statement = null;
        this.val_statement = null;
        this.pk_statement = null;
        this.pkcol_statement = null;
        this.tlc_statement = null;
        this.cnd_statement = null;
        this.tr_statement = null;
        this.tr_col_statement = null;
        this.vstatement = null;
        for (ODObject odObject : selectedObjects) {
            if (!OBJECT_TYPE.equalsIgnoreCase(odObject.getType())) continue;
            String id = odObject.getIrid();
            if (statement == null) {
                String query = "SELECT a.ALIAS,a.NAME,a.ID,CLUSTER_REFERENCE,INDEX_ONLY_FLAG index_organized,ORACLE_OBJECT_TYPE_REFERENCE,INITIAL_NUMBER_OF_ROWS, MAXIMUM_NUMBER_OF_ROWS,COLUMN_PREFIX,a.DATAWAREHOUSE_TYPE,c.ENTITY_REFERENCE, a.REMARK from CI_TABLE_DEFINITIONS a,CI_TABLES_ENTITIES c where a.IVID = ?  and a.ID = c.table_REFERENCE(+) ";
                statement = sqlConnection.prepareStatement(query);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, odObject.ivid);
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOTable.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    Entity entity;
                    ClusterOracle cluster;
                    String abbr = rs.getString("ALIAS");
                    String tableName = rs.getString("NAME");
                    String clusterID = rs.getString("CLUSTER_REFERENCE");
                    String typeRef = rs.getString("ORACLE_OBJECT_TYPE_REFERENCE");
                    int initialNumberOfRows = rs.getInt("INITIAL_NUMBER_OF_ROWS");
                    int maxNumberOfRows = rs.getInt("MAXIMUM_NUMBER_OF_ROWS");
                    String entityRef = rs.getString("ENTITY_REFERENCE");
                    String remark = rs.getString("REMARK");
                    Table table = null;
                    DesignObject obj = this.getDesign().getDesignObject(id);
                    if (obj instanceof Table) {
                        table = (Table)obj;
                    }
                    if (table == null) {
                        table = this.getDesign().getRelationalDesign().createTable();
                        if (obj == null) {
                            table.setObjectID(id);
                        }
                    }
                    table.setName(tableName);
                    table.setAbbreviation(abbr);
                    this.getExtractionHandler().addToImportedObjects(id, table);
                    table.setMinVolumes(String.valueOf(initialNumberOfRows));
                    table.setMaxVolumes(String.valueOf(maxNumberOfRows));
                    TableProxyOracle tbProxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
                    if (typeRef != null) {
                        StructuredType st = (StructuredType)this.getExtractionHandler().getImportedObject(typeRef);
                        if (st != null) {
                            table.setBasedOnStructuredType(st);
                        }
                    } else {
                        this.initColumns(sqlConnection, table, id, odObject.ivid, tbProxy);
                    }
                    this.initPK_UK(sqlConnection, table, id, odObject.ivid);
                    this.initIndexes(sqlConnection, table, id, odObject.ivid);
                    this.initTableLevelConstraints(sqlConnection, table, id, odObject.ivid);
                    try {
                        this.initTableTriggers(sqlConnection, table, id, odObject.ivid, odObject.branch);
                    }
                    catch (Exception e) {
                        LOGGER.error("ODOTable.generate(): problem in triggers for table " + tableName + ":\n" + e.getMessage());
                    }
                    if (tbProxy != null && clusterID != null && (cluster = (ClusterOracle)this.getExtractionHandler().getImportedObject(clusterID)) != null) {
                        tbProxy.setCluster(cluster);
                    }
                    this.setNotesAndComments(sqlConnection, table, id, odObject.ivid);
                    table.setCommentInRDBMS(remark);
                    this.createDBSynonyms(sqlConnection, table.getName(), odObject.ivid);
                    if (entityRef != null && (entity = (Entity)this.getExtractionHandler().getImportedObject(entityRef)) != null) {
                        this.getDesign().getExtendedMap().createMapping(entity, table);
                        table.setGeneratorID(entity.getObjectID());
                        table.setTypeID(entity.getTypeID());
                    }
                }
                rs.close();
            }
            importLog.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.indcol_statement != null) {
            this.indcol_statement.close();
        }
        if (this.val_statement != null) {
            this.val_statement.close();
        }
        if (this.ind_statement != null) {
            this.ind_statement.close();
        }
        if (this.pk_statement != null) {
            this.pk_statement.close();
        }
        if (this.pkcol_statement != null) {
            this.pkcol_statement.close();
        }
        if (this.tlc_statement != null) {
            this.tlc_statement.close();
        }
        if (this.cnd_statement != null) {
            this.cnd_statement.close();
        }
        if (this.tr_statement != null) {
            this.tr_statement.close();
        }
        if (this.tr_col_statement != null) {
            this.tr_col_statement.close();
        }
        if (this.vstatement != null) {
            this.vstatement.close();
        }
        TimeLog.log("Tables end");
    }

    private void initColumns(Connection sqlConnection, Table table, String id, String ivid, TableProxyOracle tbProxy) throws Exception {
        if (this.col_statement == null) {
            String query = "SELECT c.name,c.id,NULL_INDICATOR, c.AVERAGE_LENGTH,CLUSTER_COLUMN_REFERENCE,c.DATATYPE, DECIMAL_PLACES,DEFAULT_IMPLEMENTATION_ITEM, c.DEFAULT_VALUE,DESCRIPTOR_COLUMN,c.DOMAIN_REFERENCE,EXPRESSION_TEXT,FIELD_INITIAL_VALUE, FIELD_LEVEL,FIELD_NULL_VALUE, FINAL_VOLUME,INITIAL_VOLUME, JUSTIFICATION,c.MAXIMUM_LENGTH, OBJECT_TYPE_INCLUSION,ORACLE_TYPE_REFERENCE, REDEFINES, RELATION_SELECTION_REFERENCE,c.REMARK, SCOPE_TABLE_REFERENCE, c.SEQUENCE_NUMBER, SEQUENCE_REFERENCE,c.SOFT_LOV, SOURCE_ATTRIBUTE_REFERENCE,c.SOURCE_ENTITY_DERIVED_FROM, SOURCE_REL_ENTITY, SOURCE_REL_ENTITY_ATTRIBUTE,SOURCE_RELATIONSHIP_END,STORE_REF_WITH_ROWID_FLAG, c.REMARK, c.DEFAULT_DISPLAY_TYPE,c.DISPLAY_FLAG,c.DISPLAY_HEIGHT,c.DISPLAY_LENGTH,c.FORMAT_MODIFIER,c.HELP_TEXT,c.PROMPT,c.SERVER_DERIVED_FLAG from ci_columns c where c.PARENT_IVID = ?  order by  c.SEQUENCE_NUMBER";
            this.col_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.col_statement.setString(1, ivid);
            rs = this.col_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOTable.initColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                Attribute attribute;
                ColumnProxy cp;
                Object obj;
                String name = rs.getString("NAME");
                String colID = rs.getString("ID");
                String dataType = rs.getString("DATATYPE");
                String nullIndicator = rs.getString("NULL_INDICATOR");
                String clustColumnID = rs.getString("CLUSTER_COLUMN_REFERENCE");
                String decimalPlaces = rs.getString("DECIMAL_PLACES");
                String defaultValue = rs.getString("DEFAULT_VALUE");
                String domainRef = rs.getString("domain_reference");
                String maxLength = rs.getString("MAXIMUM_LENGTH");
                String objectTypeInclusion = rs.getString("OBJECT_TYPE_INCLUSION");
                String typeRef = rs.getString("ORACLE_TYPE_REFERENCE");
                String sourceAttributeRef = rs.getString("SOURCE_ATTRIBUTE_REFERENCE");
                String remark = rs.getString("REMARK");
                String sequenceID = rs.getString("SEQUENCE_REFERENCE");
                String displayAs = rs.getString("DEFAULT_DISPLAY_TYPE");
                String viewOnForm = rs.getString("DISPLAY_FLAG");
                String formHeight = rs.getString("DISPLAY_HEIGHT");
                String formDisplayWidth = rs.getString("DISPLAY_LENGTH");
                String formatMask = rs.getString("FORMAT_MODIFIER");
                String helptext = rs.getString("HELP_TEXT");
                String label = rs.getString("PROMPT");
                String serverGen = rs.getString("SERVER_DERIVED_FLAG");
                DesignObject objc = this.getDesign().getDesignObject(colID);
                Column column = null;
                if (objc instanceof Column) {
                    column = (Column)objc;
                }
                if (column == null || column.getTable() != table) {
                    column = table.createColumn();
                    if (objc == null) {
                        column.setObjectID(colID);
                    }
                }
                column.setDefaultValue(defaultValue);
                column.setName(name);
                this.getExtractionHandler().addToImportedObjects(colID, column);
                if (viewOnForm != null && "N".equalsIgnoreCase(viewOnForm)) {
                    column.setDefaultDisplayedOnForms(false);
                }
                if (label != null) {
                    column.setDefaultLabel(label);
                }
                if (formatMask != null) {
                    column.setDefaultFormatMask(formatMask);
                }
                if (helptext != null) {
                    column.setDefaultHelpText(helptext);
                }
                if (sequenceID != null && (obj = this.getExtractionHandler().getImportedObject(sequenceID)) != null && obj instanceof SequenceOracle) {
                    SequenceOracle seq = (SequenceOracle)obj;
                    column.setAutoIncrementColumn(true);
                    try {
                        column.setAutoIncrementStartWith(seq.getStartWith());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        column.setAutoIncrementIncrementBy(new Integer(seq.getIncrementBy()));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    column.setAutoIncrementSequenceName(seq.getName());
                    if ("Y".equals(serverGen)) {
                        column.setAutoIncrementGenerateTrigger(true);
                    } else {
                        column.setAutoIncrementGenerateTrigger(false);
                    }
                }
                this.setDisplaAs(column, displayAs);
                Integer value = null;
                if (formHeight != null) {
                    try {
                        value = new Integer(formHeight);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    column.setDefaultFormHeight(value);
                }
                if (formDisplayWidth != null) {
                    try {
                        value = new Integer(formDisplayWidth);
                    }
                    catch (Exception e) {
                        value = null;
                    }
                    column.setDefaultFormDisplayWidth(value);
                }
                if (tbProxy != null && clustColumnID != null && (cp = (ColumnProxy)this.getStorageDesign().getColumnProxySet().getProxy(column.getObjectID())) != null) {
                    tbProxy.setClusterColumns(cp.getObjectID());
                }
                if ("NOT NULL".equalsIgnoreCase(nullIndicator)) {
                    column.setNullsAllowed(false);
                } else {
                    column.setNullsAllowed(true);
                }
                if (domainRef != null) {
                    Object domain = this.getExtractionHandler().getImportedObject(domainRef);
                    if (domain == null) {
                        domain = ODODomain.getDomain(this.getDesign().getDomainSet(), domainRef);
                    }
                    if (domain == null) {
                        Domain dom = this.getDesign().getDomainSet().createDomain(domainRef);
                        LogicalDatatype dt = this.getDesign().getLogicalDatatypeSet().getLogTypeByName("unknown");
                        dom.setLogicalDatatype(dt);
                        domain = dom;
                    }
                    if (domain != null && domain instanceof Domain) {
                        column.setUse((short)0);
                        column.setDomain((Domain)domain);
                    }
                } else if (typeRef != null) {
                    DesignObject objectType = (DesignObject)this.getExtractionHandler().getImportedObject(typeRef);
                    if (objectType != null) {
                        if ("REF".equalsIgnoreCase(objectTypeInclusion)) {
                            column.setReference(true);
                        }
                        if (objectType instanceof StructuredType) {
                            column.setUse((short)3);
                            column.setStructuredType((StructuredType)objectType);
                        } else if (objectType instanceof CollectionType) {
                            column.setUse((short)4);
                            column.setCollectionType((CollectionType)objectType);
                        }
                    }
                } else {
                    String datatype;
                    LogicalDatatype logDatatype;
                    String datatype2;
                    String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(dataType);
                    if ("UNKNOWN".equalsIgnoreCase(nameDatatype) && (datatype2 = MappingDatatypeNameLogicalDataType.getDesignerMappedName(dataType)) != null) {
                        nameDatatype = datatype2;
                        dataType = datatype2;
                    }
                    if ((logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype)) == null && (datatype = MappingDatatypeNameLogicalDataType.getDesignerMappedName(nameDatatype)) != null) {
                        nameDatatype = datatype;
                        dataType = datatype;
                        logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype.toUpperCase());
                    }
                    if (logDatatype != null) {
                        column.setUse((short)1);
                        column.setLogicalDatatype(logDatatype);
                        if (dataType.toUpperCase().indexOf("TIMESTAMP") > -1) {
                            if (decimalPlaces != null) {
                                column.setDataTypeParameter("precision", decimalPlaces);
                            }
                        } else if (dataType.toUpperCase().indexOf("CHAR") <= -1) {
                            if (maxLength != null) {
                                column.setDataTypeParameter("precision", String.valueOf(maxLength));
                            }
                            if (decimalPlaces != null) {
                                column.setDataTypeParameter("scale", String.valueOf(decimalPlaces));
                            }
                        } else if (maxLength != null) {
                            column.setDataTypeParameter("size", String.valueOf(maxLength));
                        }
                    } else {
                        LOGGER.warn("ODOTable.initColumns() - Unable to find Logical DataType for: " + dataType);
                    }
                }
                this.setValues(sqlConnection, column, colID, ivid);
                this.setNotesAndComments(sqlConnection, column, colID, ivid);
                column.setCommentInRDBMS(remark);
                if (sourceAttributeRef == null || (attribute = (Attribute)this.getExtractionHandler().getImportedObject(sourceAttributeRef)) == null) continue;
                this.getDesign().getExtendedMap().createMapping(attribute, column);
                column.setGeneratorID(attribute.getObjectID());
            }
            rs.close();
        }
    }

    private void setDisplaAs(Column column, String type) {
        if (type != null) {
            if ("TEXT".equalsIgnoreCase(type)) {
                column.setDefaultDisplayAs("Text");
            } else if ("DFLEX".equalsIgnoreCase(type)) {
                column.setDefaultDisplayAs("Text Area");
            } else if ("CHECK BOX".equalsIgnoreCase(type)) {
                column.setDefaultDisplayAs("Checkbox");
            } else if ("COMBO-BOX".equalsIgnoreCase(type)) {
                column.setDefaultDisplayAs("Combo Box");
            } else if ("T-LIST".equalsIgnoreCase(type) || "POP-LIST".equalsIgnoreCase(type)) {
                column.setDefaultDisplayAs("Select List");
            } else if ("RADIO ACROSS".equalsIgnoreCase(type) || "RADIO DOWN".equalsIgnoreCase(type)) {
                column.setDefaultDisplayAs("Radio Group");
            } else {
                column.setDefaultDisplayAs("Other");
            }
        }
    }

    private void setValues(Connection sqlConnection, Column column, String id, String ivid) throws Exception {
        if (this.val_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("low_value").append(',');
            buffer.append("HIGH_VALUE").append(",meaning ");
            buffer.append("FROM").append(' ');
            buffer.append("ci_attribute_values").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("COLUMN_REFERENCE").append('=').append(" ? ");
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            buffer.append("ORDER BY").append(' ').append("radio_sequence");
            String sql = buffer.toString();
            this.val_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.val_statement.setString(1, id);
            this.val_statement.setString(2, ivid);
            rs = this.val_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOTable.setValues():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                ConstraintEnumeration valueList;
                column.setUseDomainConstraints(false);
                String beginValue = rs.getString("low_value");
                String endValue = rs.getString("HIGH_VALUE");
                String description = rs.getString(3);
                if (endValue != null) {
                    AVT avt = new AVT(beginValue, endValue, description);
                    column.addAVT(avt);
                    continue;
                }
                if (column.getValueList() == null) {
                    valueList = new ConstraintEnumeration();
                    column.setValueList(valueList);
                } else {
                    valueList = column.getValueList();
                }
                valueList.add(beginValue, description);
            }
            rs.close();
        }
    }

    private void initPK_UK(Connection sqlConnection, Table table, String id, String ivid) throws Exception {
        if (this.pk_statement == null) {
            String query = "SELECT a.NAME, CONSTRAINT_TYPE,DEFER_STATUS, ENABLED_FLAG,EXCEPTION_TABLE, a.ID,UNIQUE_IDENTIFIER_REFERENCE mapped_uid, COMPLETE_FLAG from CI_UNIQUE_KEY_CONSTRAINTS a where a.parent_ivid = ?  and TABLE_REFERENCE = ?  union SELECT a.NAME, CONSTRAINT_TYPE,DEFER_STATUS, ENABLED_FLAG,EXCEPTION_TABLE, a.ID,UNIQUE_IDENTIFIER_REFERENCE mapped_uid, COMPLETE_FLAG from CI_PRIMARY_KEY_CONSTRAINTS a where a.parent_ivid = ?  and TABLE_REFERENCE = ?  order by CONSTRAINT_TYPE";
            this.pk_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.pk_statement.setString(1, ivid);
            this.pk_statement.setString(2, id);
            this.pk_statement.setString(3, ivid);
            this.pk_statement.setString(4, id);
            rs = this.pk_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOTable.initPK_UK():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                CandidateKey key;
                TableProxyOracle proxy;
                Table exTable;
                String name = rs.getString("NAME");
                String indexID = rs.getString("ID");
                String constraintType = rs.getString("CONSTRAINT_TYPE");
                String deferStatus = rs.getString("DEFER_STATUS");
                String enabledFlag = rs.getString("ENABLED_FLAG");
                String exceptionTable = rs.getString("EXCEPTION_TABLE");
                String mapped_uid = rs.getString("mapped_uid");
                DesignObject obj = this.getDesign().getDesignObject(indexID);
                Index index = null;
                if (obj instanceof Index) {
                    index = (Index)obj;
                }
                if (index == null || index.getTable() != table) {
                    index = table.createIndex();
                    if (obj == null) {
                        index.setObjectID(indexID);
                    }
                }
                index.setName(name);
                String complete = rs.getString("COMPLETE_FLAG");
                if (complete != null && "Y".equalsIgnoreCase(complete)) {
                    index.setMarkedGenerate(true);
                } else {
                    index.setMarkedGenerate(false);
                }
                this.initPK_UKColumns(sqlConnection, index, indexID, ivid);
                this.getExtractionHandler().addToImportedObjects(indexID, index);
                if ("PRIMARY".equalsIgnoreCase(constraintType)) {
                    index.makePK();
                    PKProxyOracle pkProxy = (PKProxyOracle)((StorageDesignOracle)this.getStorageDesign()).getPKProxySet().getProxy(index.getObjectID());
                    if (pkProxy != null) {
                        if ("INIT DEFERRED".equalsIgnoreCase(deferStatus)) {
                            pkProxy.setInitially(FKProxyOracle.getInitiallyChoices()[1]);
                        } else if ("INIT IMMEDIATE".equalsIgnoreCase(deferStatus)) {
                            pkProxy.setInitially(FKProxyOracle.getInitiallyChoices()[0]);
                        } else if ("NOT DEFERRED".equalsIgnoreCase(deferStatus)) {
                            pkProxy.setDeferrable("NO");
                        }
                        if ("Y".equalsIgnoreCase(enabledFlag)) {
                            pkProxy.setEnable("YES");
                        } else {
                            pkProxy.setEnable("NO");
                        }
                        if (exceptionTable != null && (exTable = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(exceptionTable)) != null) {
                            proxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(exTable.getObjectID());
                            pkProxy.setExceptionsTable(proxy);
                        }
                    }
                } else {
                    index.setIndexState("Unique Constraint");
                    UniqueOracle unique = (UniqueOracle)((StorageDesignOracle)this.getStorageDesign()).getUniqueSet().getProxy(index.getObjectID());
                    if (unique != null) {
                        if ("INIT DEFERRED".equalsIgnoreCase(deferStatus)) {
                            unique.setInitially(FKProxyOracle.getInitiallyChoices()[1]);
                        } else if ("INIT IMMEDIATE".equalsIgnoreCase(deferStatus)) {
                            unique.setInitially(FKProxyOracle.getInitiallyChoices()[0]);
                        } else if ("NOT DEFERRED".equalsIgnoreCase(deferStatus)) {
                            unique.setDeferrable("NO");
                        }
                        if ("Y".equalsIgnoreCase(enabledFlag)) {
                            unique.setEnable("YES");
                        } else {
                            unique.setEnable("NO");
                        }
                        if (exceptionTable != null && (exTable = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(exceptionTable)) != null) {
                            proxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(exTable.getObjectID());
                            unique.setExceptionsTable(proxy);
                        }
                    }
                }
                if (mapped_uid != null && (key = (CandidateKey)this.getExtractionHandler().getImportedObject(mapped_uid)) != null) {
                    this.getDesign().getExtendedMap().createMapping(key, index);
                    index.setGeneratorID(key.getObjectID());
                }
                this.setNotesAndComments(sqlConnection, index, indexID, ivid);
            }
            rs.close();
        }
    }

    private void initPK_UKColumns(Connection sqlConnection, Index index, String id, String ivid) throws Exception {
        if (this.pkcol_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_REFERENCE").append(',');
            buffer.append("SEQUENCE_NUMBER").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("ci_key_components").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("CONSTRAINT_REFERENCE").append('=').append(" ? ");
            buffer.append(" and parent_ivid ").append('=').append(" ? ");
            buffer.append("ORDER BY").append(' ').append("SEQUENCE_NUMBER");
            this.pkcol_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.pkcol_statement.setString(1, id);
            this.pkcol_statement.setString(2, ivid);
            rs = this.pkcol_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOTable.initPK_UKColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String columnID = rs.getString("COLUMN_REFERENCE");
                Column column = (Column)this.getExtractionHandler().getImportedObject(columnID);
                if (column == null) continue;
                index.add(column);
            }
            rs.close();
        }
    }

    private void initIndexes(Connection sqlConnection, Table table, String id, String ivid) throws Exception {
        if (this.ind_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(',');
            buffer.append("CLUSTER_REFERENCE").append(',');
            buffer.append("COMPUTE_STATISTICS_FLAG").append(',');
            buffer.append("ID").append(',');
            buffer.append("INDEX_TYPE").append(',');
            buffer.append("RELATION_INDEX_TYPE").append(' ').append(',');
            buffer.append("ivid").append(',');
            buffer.append("COMPLETE_FLAG").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("ci_indexes").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLE_DEFINITION_REFERENCE").append('=').append(" ? ");
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            this.ind_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.ind_statement.setString(1, id);
            this.ind_statement.setString(2, ivid);
            rs = this.ind_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOTable.initIndexes():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                String indexID = rs.getString("ID");
                String computeStats = rs.getString("COMPUTE_STATISTICS_FLAG");
                String relationalIndexType = rs.getString("RELATION_INDEX_TYPE");
                DesignObject obj = this.getDesign().getDesignObject(indexID);
                Index index = null;
                if (obj instanceof Index) {
                    index = (Index)obj;
                }
                if (index == null || index.getTable() != table) {
                    index = table.createIndex();
                    if (obj == null) {
                        index.setObjectID(indexID);
                    }
                }
                index.setName(name);
                this.getExtractionHandler().addToImportedObjects(indexID, index);
                String complete = rs.getString("COMPLETE_FLAG");
                if (complete != null && "Y".equalsIgnoreCase(complete)) {
                    index.setMarkedGenerate(true);
                } else {
                    index.setMarkedGenerate(false);
                }
                this.initIndexColumns(sqlConnection, index, indexID, ivid);
                if ("UNIQUE".equalsIgnoreCase(relationalIndexType)) {
                    index.setIndexState("Unique Plain Index");
                }
                this.setNotesAndComments(sqlConnection, index, indexID, ivid);
                IndexProxyOracle proxy = (IndexProxyOracle)this.getStorageDesign().getIndexProxySet().getProxy(index.getObjectID());
                if (proxy == null) continue;
                if ("Y".equalsIgnoreCase(computeStats)) {
                    proxy.setComputeStatistics("YES");
                } else {
                    proxy.setComputeStatistics("NO");
                }
                if (complete != null && "Y".equalsIgnoreCase(complete)) {
                    proxy.setMarkedGenerate(true);
                    continue;
                }
                proxy.setMarkedGenerate(false);
            }
            rs.close();
        }
    }

    private void initIndexColumns(Connection sqlConnection, Index index, String id, String ivid) throws Exception {
        ArrayList<String> columns = new ArrayList<String>();
        boolean isFunctional = false;
        if (this.indcol_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_REFERENCE").append(',');
            buffer.append("INDEX_ENTRY_TYPE").append(',');
            buffer.append("INDEX_FUNCTION").append(',');
            buffer.append("SEQUENCE_NUMBER").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("ci_index_entries").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("RELATION_INDEX_REFERENCE").append('=').append(" ? ");
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            buffer.append("ORDER BY").append(' ').append("SEQUENCE_NUMBER");
            this.indcol_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.indcol_statement.setString(1, id);
            this.indcol_statement.setString(2, ivid);
            rs = this.indcol_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOTable.initIndexColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String columnID = rs.getString("COLUMN_REFERENCE");
                String indexEntryType = rs.getString("INDEX_ENTRY_TYPE");
                String function = rs.getString("INDEX_FUNCTION");
                if ("FUNCTIONBASED".equalsIgnoreCase(indexEntryType) && function != null) {
                    isFunctional = true;
                    columns.add("FUNCTIONBASED@" + function);
                    continue;
                }
                if (columnID == null) continue;
                columns.add(columnID);
            }
            rs.close();
        }
        Iterator it = columns.iterator();
        String functionStatement = null;
        while (it.hasNext()) {
            String columnID = (String)it.next();
            if (isFunctional) {
                String text = "";
                if (columnID.startsWith("FUNCTIONBASED")) {
                    text = columnID.substring(columnID.indexOf(64) + 1);
                } else {
                    Column column = (Column)this.getExtractionHandler().getImportedObject(columnID);
                    if (column != null) {
                        text = column.getName();
                    }
                }
                if (functionStatement == null) {
                    functionStatement = text;
                    continue;
                }
                functionStatement = functionStatement + ", " + text;
                continue;
            }
            Column column = (Column)this.getExtractionHandler().getImportedObject(columnID);
            if (column == null) continue;
            index.add(column);
        }
        if (functionStatement != null) {
            index.setIndexExpression(functionStatement);
        }
    }

    private void initTableLevelConstraints(Connection sqlConnection, Table table, String id, String ivid) throws Exception {
        if (this.tlc_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(',').append("COMPLETE_FLAG").append(',');
            buffer.append("ID").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("ci_constraints").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLE_REFERENCE").append('=').append(" ? ");
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            buffer.append("AND").append(' ');
            buffer.append("CONSTRAINT_TYPE").append('=').append("'CHECK'").append(' ');
            buffer.append("ORDER BY").append(' ').append("NAME");
            this.tlc_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.tlc_statement.setString(1, id);
            this.tlc_statement.setString(2, ivid);
            rs = this.tlc_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOTable.initTableLevelConstraints():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                String complete = rs.getString("COMPLETE_FLAG");
                String constraintID = rs.getString("ID");
                String condition = this.getConstraintCondition(sqlConnection, constraintID, ivid);
                TableLevelConstraint tlc = table.getCheckConstraintByID(constraintID);
                if (tlc == null) {
                    tlc = table.createCheckConstraint(name, condition);
                    tlc.setObjectID(constraintID);
                    table.addCheckConstraint(tlc);
                } else {
                    tlc.setName(name);
                    tlc.setRule(condition);
                }
                if (complete != null && "Y".equalsIgnoreCase(complete)) {
                    tlc.setGenerateInDDL(true);
                    continue;
                }
                tlc.setGenerateInDDL(false);
            }
            rs.close();
        }
    }

    private String getConstraintCondition(Connection sqlConnection, String constraintID, String tivid) throws Exception {
        String result = "";
        if (this.cnd_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TXT_REF").append('=').append(" ? ");
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            buffer.append("AND").append(' ');
            buffer.append("txt_type").append('=').append("'CDWHCL'").append(' ');
            buffer.append("ORDER BY").append(' ').append("TXT_SEQ");
            this.cnd_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.cnd_statement.setString(1, constraintID);
            this.cnd_statement.setString(2, tivid);
            rs = this.cnd_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOTable.getConstraintCondition(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String text = rs.getString("txt_text");
                if ("".equalsIgnoreCase(result)) {
                    result = text;
                    continue;
                }
                result = result + text;
            }
            rs.close();
        }
        return result;
    }

    private void initTableTriggers(Connection sqlConnection, Table table, String table_id, String ivid, ODExtractionHandler.Branch branch) throws Exception {
        if (this.tr_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select a.ID, a.COMPLETE_FLAG,a.DATABASE_TRIGGER_FOR, ");
            buffer.append(" a.ELEMENT_TYPE_NAME, a.ENABLED_FLAG, a.EXECUTE_TIME, ");
            buffer.append(" a.IRID, a.IVID, a.NAME, a.NEW_ALIAS,");
            buffer.append(" a.OLD_ALIAS, a.PARENT_IVID, a.PLSQL_MODULE_REFERENCE as module_id,");
            buffer.append(" a.TRIGGER_LEVEL, a.TRIGGER_ON_DELETE, a.TRIGGER_ON_INSERT, ");
            buffer.append(" a.TRIGGER_ON_UPDATE ");
            buffer.append(" from ci_database_triggers a ");
            buffer.append("where a.PARENT_IVID = ? ");
            this.tr_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.tr_statement.setString(1, ivid);
            rs = this.tr_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("ODOTable.initTableTriggers():", e);
        }
        if (rs != null) {
            StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
            TableProxyOracle tableProxy = (TableProxyOracle)storage.getTableProxySet().getProxy(table.getObjectID());
            while (rs.next()) {
                String newref = "NEW";
                String oldref = "OLD";
                String id = rs.getString(1);
                String type = rs.getString(6);
                String trigName = rs.getString(9);
                newref = rs.getString(10);
                oldref = rs.getString(11);
                String module_id = rs.getString(13);
                String tr_level = rs.getString(14);
                String event_del = rs.getString(15);
                String event_ins = rs.getString(16);
                String event_upd = rs.getString(17);
                String whenClause = null;
                if (module_id != null) {
                    whenClause = this.getFromTextLines(sqlConnection, "CDIWHN", id, ivid);
                }
                String trBody = null;
                if (branch == null) {
                    trBody = this.getFromTextLines(sqlConnection, "CDIPLS", module_id);
                } else {
                    if (this.vstatement == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("select ivid from i$sdd_object_versions v ");
                        buffer.append("  where ");
                        buffer.append("  v.irid = ? ");
                        buffer.append("  and branch_id = ? ");
                        buffer.append("  and sequence_in_branch  is not null ");
                        buffer.append("  and wastebasket='N' ");
                        buffer.append("  and sequence_in_branch = ");
                        buffer.append("   ( ");
                        buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                        buffer.append("     where ");
                        buffer.append("     v2.irid = ? ");
                        buffer.append("     and branch_id = ? ");
                        buffer.append("     and sequence_in_branch  is not null ");
                        buffer.append("     and wastebasket='N' ");
                        buffer.append("   ) ");
                        this.vstatement = sqlConnection.prepareStatement(buffer.toString());
                    }
                    ResultSet vrs = null;
                    try {
                        this.vstatement.setString(1, module_id);
                        this.vstatement.setString(2, branch.getId());
                        this.vstatement.setString(3, module_id);
                        this.vstatement.setString(4, branch.getId());
                        vrs = this.vstatement.executeQuery();
                    }
                    catch (SQLException e) {
                        LOGGER.error("ODExtractionHandler.getApplicationSystems(): - get branches for app", e);
                    }
                    if (vrs != null) {
                        if (vrs.next()) {
                            String mod_ivid = vrs.getString(1);
                            trBody = this.getFromTextLines(sqlConnection, "CDIPLS", module_id, mod_ivid);
                        }
                        vrs.close();
                    }
                }
                TriggerOracle trigger = null;
                StorageObject obj = storage.getStorageObject(id);
                if (obj instanceof TriggerOracle) {
                    trigger = (TriggerOracle)obj;
                }
                if (trigger == null) {
                    trigger = storage.getTriggerSet().createTrigger();
                    if (obj == null) {
                        trigger.setObjectID(id);
                    }
                }
                trigger.setOwner(tableProxy.getUser());
                trigger.setName(trigName);
                trigger.setTable(tableProxy);
                if (tr_level != null) {
                    if (tr_level.indexOf("ROW") > -1) {
                        trigger.setScope(TriggerOracle.SCOPE_TYPES[0]);
                    } else {
                        trigger.setScope(TriggerOracle.SCOPE_TYPES[1]);
                    }
                }
                if (type.indexOf("BEFORE") > -1) {
                    trigger.setTriggerTime("BEFORE");
                } else if (type.indexOf("AFTER") > -1) {
                    trigger.setTriggerTime("AFTER");
                } else {
                    trigger.setTriggerTime("BEFORE");
                }
                if (event_ins.equalsIgnoreCase("Y")) {
                    trigger.setActions(Trigger.ACTION_TYPES[0]);
                }
                if (event_upd.equalsIgnoreCase("Y")) {
                    trigger.setActions(Trigger.ACTION_TYPES[1]);
                }
                if (event_del.equalsIgnoreCase("Y")) {
                    trigger.setActions(Trigger.ACTION_TYPES[2]);
                }
                if (newref != null && !"NEW".equalsIgnoreCase(newref)) {
                    trigger.setRef_NEW_AS(newref);
                }
                if (oldref != null && !"OLD".equalsIgnoreCase(oldref)) {
                    trigger.setRef_OLD_AS(oldref);
                }
                if (whenClause != null && !"".equalsIgnoreCase(whenClause)) {
                    trigger.setCondition(whenClause);
                }
                if (trBody != null) {
                    trigger.setBody(trBody);
                }
                this.setNotesAndComments(sqlConnection, trigger, id, ivid);
                this.initTrigUpdateColumns(sqlConnection, trigger, id, ivid);
            }
            rs.close();
        }
    }

    private void initTrigUpdateColumns(Connection sqlConnection, TriggerOracle trigger, String trigger_id, String table_ivid) throws SQLException {
        if (this.tr_col_statement == null) {
            String sql = "select column_reference from ci_trigger_column_usages where database_trigger_reference = ? and parent_ivid = ?";
            this.tr_col_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.tr_col_statement.setString(1, trigger_id);
            this.tr_col_statement.setString(2, table_ivid);
            rs = this.tr_col_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("ODOTable.initTrigUpdateColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                Column column;
                String col_ref = rs.getString(1);
                if (col_ref == null || (column = (Column)this.getExtractionHandler().getImportedObject(col_ref)) == null) continue;
                trigger.setColumns(column.getObjectID());
            }
            rs.close();
        }
    }
}

