/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.imports.parser.SQLCommand;
import oracle.dbtools.crest.imports.parser.SQLStatementTypes;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.util.IdeUtil;

public class ScriptParser {
    private static final Logger LOGGER = new Logger(ScriptParser.class);
    private static final String systemLineSeparator = System.getProperty("line.separator");
    static final int INITIAL = 0;
    static final int INSINGLELINECOMMENT = 1;
    static final int INMULTILINECOMMENT = 2;
    static final int INALIAS = 3;
    static final int INSINGLEQUOTE = 4;
    static final int INQUOTEDQUOTE = 5;
    private static String[][] m_startAndEnd = new String[][]{{"", "", "0"}, {"--", "\n", "1"}, {"/*", "*/", "2"}, {"\"", "\"", "3"}, {"'", "'", "4"}, {"q'", "'", "5"}};
    private List<SQLCommand> m_sqlArray = new ArrayList<SQLCommand>();
    private BufferedReader m_reader = null;
    private int m_readerLineCnt = -1;
    private int m_readerLineStartCnt = 0;
    private int m_state = 0;
    private boolean m_firstLine = true;
    private String m_quoteString = "";
    private String m_leftOver = null;
    private boolean sqlServerDDL = false;
    private boolean db2orUDB = false;
    private String db2UDBTerminationString = ";";

    public ScriptParser(InputStream in, int dbType) throws UnsupportedEncodingException {
        this(in);
        if (dbType == 12 || dbType == 5 || dbType == 4) {
            this.sqlServerDDL = true;
        }
        if (dbType == 1 || dbType == 0 || dbType == 10 || dbType == 3 || dbType == 2) {
            this.db2orUDB = true;
            char db2UDBTerminationChar = AbstractSSBDB2.DB2_UDB_STATEMENT_TERMINATION_CHAR;
            this.db2UDBTerminationString = db2UDBTerminationChar == ' ' ? ";" : String.valueOf(AbstractSSBDB2.DB2_UDB_STATEMENT_TERMINATION_CHAR);
        }
    }

    public ScriptParser(InputStream in) throws UnsupportedEncodingException {
        this(new InputStreamReader(in, IdeUtil.getIdeEncoding()));
    }

    public ScriptParser(Reader rdr) {
        this.scriptParserInit(rdr);
    }

    private void scriptParserInit(Reader rdr) {
        this.m_reader = new BufferedReader(rdr);
    }

    public ScriptParser(String s) {
        this(new StringReader(s));
    }

    public void parse() {
        this.m_leftOver = null;
        this.m_readerLineCnt = -1;
        try {
            SQLCommand cmd = this.next();
            while (cmd != null) {
                this.m_sqlArray.add(cmd);
                cmd = this.next();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getStackTrace()[0].toString(), e);
        }
    }

    public SQLCommand next() throws IOException {
        String line = this.getTop(this.m_leftOver);
        this.m_leftOver = null;
        if (line == null) {
            return null;
        }
        SQLCommand stmtProperties = this.getPropertiesWhenNoSpaceRequired(line);
        if (stmtProperties == null) {
            stmtProperties = this.getPropertiesWhenTokensKnown(line);
        }
        if (stmtProperties == null) {
            stmtProperties = this.getPropertiesWhenMulitpleTokensKnown(line);
        }
        if (stmtProperties == null) {
            stmtProperties = this.getHalfRecognizedMultiToken(line);
        }
        if (stmtProperties == null) {
            stmtProperties = this.createUnknownStatementProperties();
        }
        stmtProperties = this.refineStmtRecognition(stmtProperties, line);
        stmtProperties = this.identifyEndOfStatement(line, this.m_reader, stmtProperties);
        return stmtProperties;
    }

    private SQLCommand getHalfRecognizedMultiToken(String line) {
        Set<String> keys = SQLStatementTypes.halfRecognizedMultiToken.keySet();
        for (String key : keys) {
            if (!line.toLowerCase().startsWith(key)) continue;
            return SQLStatementTypes.halfRecognizedMultiToken.get(key);
        }
        return null;
    }

    private void setError(SQLCommand stmtProperties) {
        stmtProperties.setProperty("prop_error_string", "SQLPLUS command failed - not enough arguments");
    }

    /*
     * Enabled aggressive block sorting
     */
    private SQLCommand refineStmtRecognition(SQLCommand stmtProperties, String line) {
        String property = null;
        String propertyNotLowered = null;
        if (stmtProperties.isSqlPlusSetCmd() || stmtProperties.isCreateCmd() || stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_SET_WORKSHEETNAME) {
            String[] tokens = this.getTokens(line);
            if (tokens.length <= 2) {
                this.setError(stmtProperties);
                return stmtProperties;
            }
            propertyNotLowered = tokens[2];
            property = tokens[2].toLowerCase();
            if (property.equals("replace")) {
                if (tokens.length <= 4) {
                    this.setError(stmtProperties);
                    return stmtProperties;
                }
                propertyNotLowered = tokens[4];
                property = tokens[4];
            }
        } else {
            if (stmtProperties.getStmtSubType() != SQLCommand.StmtSubType.G_S_SPOOL && stmtProperties.getStmtSubType() != SQLCommand.StmtSubType.G_S_DEFINE) {
                return stmtProperties;
            }
            String[] tokens = this.getTokens(line);
            if (tokens.length <= 1) {
                return stmtProperties;
            }
            propertyNotLowered = tokens[1];
            property = tokens[1].toLowerCase();
        }
        if (property.equals("on")) {
            stmtProperties.setProperty("prop_status_boolean", true);
        } else if (property.equals("off")) {
            stmtProperties.setProperty("prop_status_boolean", false);
        }
        if (propertyNotLowered != null && !propertyNotLowered.equals("")) {
            stmtProperties.setProperty("prop_file_string", propertyNotLowered);
        } else {
            stmtProperties.setProperty("prop_file_string", property);
        }
        if (stmtProperties.getProperty("prop_status_boolean") == null) {
            stmtProperties.setProperty("prop_status_boolean", true);
        }
        return stmtProperties;
    }

    private String[] getTokens(String line) {
        line = line.replaceAll("\r\n|[\r\n\u2028\u2029\u0085]|\t", " ");
        line = line.replace("  ", " ");
        if ((line = line.trim()).endsWith(";")) {
            line = line.substring(0, line.length() - 1);
        }
        return line.split(" ");
    }

    private SQLCommand getPropertiesWhenMulitpleTokensKnown(String line) {
        String strippedLine = this.stripLine(line);
        Set<String> keys = this.db2orUDB ? SQLStatementTypes.getMultiTokenDB2UDB().keySet() : SQLStatementTypes.multiToken.keySet();
        for (String key : keys) {
            if (!strippedLine.startsWith(key)) continue;
            return SQLStatementTypes.multiToken.get(key);
        }
        return null;
    }

    private SQLCommand createUnknownStatementProperties() {
        return new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_UNKNOWN, SQLCommand.StmtResultType.G_R_UNKNOWN, true);
    }

    private SQLCommand getPropertiesWhenNoSpaceRequired(String line) {
        SQLCommand prop = null;
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        String input = null;
        if ((line = line.trim()).length() >= 2) {
            input = line.trim().substring(0, 2);
            if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(input)) {
                prop = SQLStatementTypes.noSpaceRequiredTokens.get(input);
            } else {
                input = line.trim().substring(0, 1);
                if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(input)) {
                    prop = SQLStatementTypes.noSpaceRequiredTokens.get(input);
                }
            }
        } else {
            input = line;
            if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(input)) {
                prop = SQLStatementTypes.noSpaceRequiredTokens.get(input);
            }
        }
        return prop;
    }

    private SQLCommand getPropertiesWhenTokensKnown(String line) {
        String[] tokens = line.trim().split("[ \n\r\t]");
        if (tokens[0] != null && tokens[0].length() > 0 && tokens[0].charAt(tokens[0].length() - 1) == ';') {
            tokens[0] = tokens[0].replaceAll(";", "");
        }
        return SQLStatementTypes.spaceRequiredTokens.get(tokens[0].toLowerCase(Locale.ENGLISH));
    }

    private StringBuffer findEndOfSQLAndPLSQL(String line, BufferedReader reader, SQLCommand stmtProperties, boolean semiColonTerminates) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        boolean enquote = false;
        int embeddedSemicolon = 0;
        int lineCnt = 1;
        while (searching) {
            int quotes;
            int initialSemicolon = -1;
            if (line == null) {
                quotes = 0;
            } else {
                int[] retval = this.numberOfQuotes(line, true, true);
                quotes = retval[0];
                embeddedSemicolon = retval[1];
                initialSemicolon = retval[2];
            }
            if (quotes % 2 != 0) {
                boolean bl = enquote = !enquote;
            }
            if (line != null && !enquote) {
                if (initialSemicolon != -1 && semiColonTerminates) {
                    this.m_leftOver = line.length() != initialSemicolon + 1 ? line.substring(initialSemicolon + 1) : null;
                    line = line.substring(0, initialSemicolon);
                    searching = false;
                } else if (line.trim().endsWith(";") && embeddedSemicolon == 0 && (semiColonTerminates || stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_BEGIN && line.trim().toUpperCase().endsWith("END;"))) {
                    searching = false;
                    line = line.substring(0, line.lastIndexOf(";"));
                } else if (line.trim().endsWith("\n/") || line.trim().equals("/")) {
                    searching = false;
                    line = line.substring(0, line.lastIndexOf("/"));
                } else if (line.trim().equals(".")) {
                    searching = false;
                    line = line.substring(0, line.lastIndexOf("."));
                } else if (this.sqlServerDDL && line.endsWith("\nGO")) {
                    searching = false;
                    line = line.substring(0, line.length() - 3);
                } else if (this.db2orUDB && line.endsWith(this.db2UDBTerminationString)) {
                    searching = false;
                    line = line.substring(0, line.length() - 1);
                }
                currentStatement.append(line + systemLineSeparator);
                if (searching) {
                    String[] tokens;
                    line = reader.readLine();
                    ++lineCnt;
                    ++this.m_readerLineCnt;
                    if (this.sqlServerDDL && line != null && line.trim().toUpperCase().startsWith("GO") && (tokens = this.getTokens(line)).length > 0 && tokens[0].equalsIgnoreCase("GO")) {
                        searching = false;
                        line = "";
                    }
                }
            } else {
                currentStatement.append(line + systemLineSeparator);
                line = reader.readLine();
                ++lineCnt;
                ++this.m_readerLineCnt;
            }
            if (line != null) continue;
            searching = false;
        }
        stmtProperties.setStartLine(this.m_readerLineStartCnt);
        stmtProperties.setEndLine(this.m_readerLineCnt);
        return currentStatement;
    }

    private StringBuffer findEndOfSQLPLUS(String line, BufferedReader reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        int lineCnt = 1;
        while (searching) {
            if (line.trim().endsWith("-")) {
                currentStatement.append(line + systemLineSeparator);
                line = reader.readLine();
                ++lineCnt;
                ++this.m_readerLineCnt;
                if (line != null) continue;
                searching = false;
                continue;
            }
            if (this.sqlServerDDL && stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_EXECUTE) {
                currentStatement.append(line + systemLineSeparator);
                line = reader.readLine();
                ++lineCnt;
                ++this.m_readerLineCnt;
                if (line == null) {
                    searching = false;
                    continue;
                }
                String[] tokens = this.getTokens(line);
                if (tokens.length <= 0 || !tokens[0].equalsIgnoreCase("GO")) continue;
                searching = false;
                continue;
            }
            searching = false;
            currentStatement.append(line + systemLineSeparator);
        }
        stmtProperties.setStartLine(this.m_readerLineStartCnt);
        stmtProperties.setEndLine(this.m_readerLineCnt);
        if (currentStatement.toString().trim().endsWith(";") && currentStatement.length() > 1) {
            String s = currentStatement.substring(0, currentStatement.lastIndexOf(";"));
            currentStatement = new StringBuffer(s);
        }
        return currentStatement;
    }

    private StringBuffer findEndOfMultiLineComment(String line, BufferedReader reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        int lineCnt = 1;
        while (searching) {
            int nearEndOfComment = line.indexOf("*/");
            if (nearEndOfComment >= 0) {
                searching = false;
                if (nearEndOfComment + 2 == line.length()) {
                    this.m_leftOver = "";
                } else {
                    this.m_leftOver = line.substring(nearEndOfComment + 2);
                    line = line.substring(0, nearEndOfComment + 2);
                }
                currentStatement.append(line + systemLineSeparator);
                continue;
            }
            currentStatement.append(line + systemLineSeparator);
            line = reader.readLine();
            ++lineCnt;
            ++this.m_readerLineCnt;
            if (line != null) continue;
            searching = false;
            currentStatement.append("*/");
        }
        stmtProperties.setStartLine(this.m_readerLineStartCnt);
        stmtProperties.setEndLine(this.m_readerLineCnt);
        return currentStatement;
    }

    private SQLCommand identifyEndOfStatement(String line, BufferedReader reader, SQLCommand stmtProperties) {
        StringBuffer currentStatement = new StringBuffer();
        try {
            switch (stmtProperties.getStmtType()) {
                case G_C_SQL: {
                    currentStatement = this.findEndOfSQLAndPLSQL(line, reader, stmtProperties, true);
                    break;
                }
                case G_C_PLSQL: {
                    currentStatement = this.findEndOfSQLAndPLSQL(line, reader, stmtProperties, false);
                    break;
                }
                case G_C_SQLPLUS: {
                    currentStatement = this.findEndOfSQLPLUS(line, reader, stmtProperties);
                    break;
                }
                case G_C_USERDEFINED: 
                case G_C_COMMENT: {
                    currentStatement = this.findEndOfLine(line, stmtProperties);
                    break;
                }
                case G_C_UNKNOWN: {
                    LOGGER.error("Unsupported Command: " + line);
                }
                case G_C_MULTILINECOMMENT: {
                    currentStatement = this.findEndOfMultiLineComment(line, reader, stmtProperties);
                    break;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage());
        }
        this.m_state = 0;
        if (currentStatement.length() > 0) {
            while (currentStatement.charAt(currentStatement.length() - 1) == '\n' || currentStatement.charAt(currentStatement.length() - 1) == '\r') {
                currentStatement.deleteCharAt(currentStatement.length() - 1);
            }
        }
        stmtProperties.setSql(currentStatement.toString());
        return stmtProperties;
    }

    private StringBuffer findEndOfLine(String line, SQLCommand stmtProperties) {
        StringBuffer currentStatement = new StringBuffer();
        currentStatement.append(line + systemLineSeparator);
        stmtProperties.setStartLine(this.m_readerLineStartCnt);
        stmtProperties.setEndLine(this.m_readerLineCnt);
        return currentStatement;
    }

    public static String removeComments(String currstmt) {
        currstmt = ScriptParser.checkInLineComments(currstmt);
        int position = 0;
        int knownInitialStatePosition = 0;
        int nextPosition = currstmt.indexOf("/*", position);
        while (nextPosition > -1) {
            if (ScriptParser.amIInitial(currstmt.substring(knownInitialStatePosition, nextPosition))) {
                knownInitialStatePosition = nextPosition;
                int nextPos = currstmt.indexOf("*/", nextPosition);
                if (nextPos == -1) {
                    currstmt = currstmt.substring(0, nextPosition);
                    nextPosition = -1;
                    continue;
                }
                currstmt = currstmt.substring(0, nextPosition) + " " + currstmt.substring(nextPos + 2);
                nextPosition = currstmt.indexOf("/*", nextPosition);
                continue;
            }
            ++nextPosition;
            nextPosition = currstmt.indexOf("/*", nextPosition);
        }
        return currstmt;
    }

    private static String checkInLineComments(String currstmt) {
        int position = 0;
        int knownInitialStatePosition = 0;
        int nextPosition = currstmt.indexOf("--", position);
        while (nextPosition > -1) {
            if (ScriptParser.amIInitial(currstmt.substring(knownInitialStatePosition, nextPosition))) {
                knownInitialStatePosition = nextPosition;
                int nextPos = currstmt.indexOf("\n", nextPosition);
                if (nextPos == -1) {
                    currstmt = currstmt.substring(0, nextPosition);
                    nextPosition = -1;
                    continue;
                }
                currstmt = currstmt.substring(0, nextPosition) + systemLineSeparator + currstmt.substring(nextPos + 1);
                nextPosition = currstmt.indexOf("--", nextPosition);
                continue;
            }
            ++nextPosition;
            nextPosition = currstmt.indexOf("--", nextPosition);
        }
        return currstmt;
    }

    private String stripLine(String line) {
        String comp = line;
        comp = comp.replaceAll(" ", "");
        comp = comp.replaceAll("\n", "");
        comp = comp.replaceAll("\r", "");
        comp = comp.replaceAll("\t", "");
        if ((comp = comp.toLowerCase()).indexOf("editionable") > -1) {
            comp = comp.replaceFirst("noneditionable", "");
            comp = comp.replaceFirst("editionable", "");
        }
        return comp;
    }

    private String getTop(String inString) {
        String top;
        block10: {
            top = null;
            try {
                if (inString == null) {
                    top = this.m_reader.readLine();
                    ++this.m_readerLineCnt;
                } else {
                    top = inString;
                }
                if (top == null) {
                    return null;
                }
                while (top.trim().equals("")) {
                    top = this.m_reader.readLine();
                    ++this.m_readerLineCnt;
                    if (top != null) continue;
                    return null;
                }
                if (top != null) {
                    top = top.replaceAll("^\\s+", "");
                }
                this.m_readerLineStartCnt = this.m_readerLineCnt;
                String lowerCaseTop = top.trim().toLowerCase();
                if (!lowerCaseTop.startsWith("create") && !lowerCaseTop.startsWith("drop") && !lowerCaseTop.startsWith("alter")) break block10;
                String currLine = "";
                while (top.indexOf(";") == -1 && top.indexOf("/") == -1 && top.toLowerCase().indexOf("begin") == -1 && currLine != null) {
                    String[] tokens;
                    currLine = this.m_reader.readLine();
                    ++this.m_readerLineCnt;
                    if (currLine == null) continue;
                    if (this.sqlServerDDL && currLine.trim().toUpperCase().startsWith("GO") && (tokens = this.getTokens(currLine)).length > 0 && tokens[0].equalsIgnoreCase("GO")) {
                        top = top + "\nGO";
                        break;
                    }
                    if (this.db2orUDB && currLine.trim().endsWith(this.db2UDBTerminationString)) {
                        top = top + systemLineSeparator + currLine;
                        break;
                    }
                    top = top + systemLineSeparator + currLine;
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getStackTrace()[0].toString(), e);
            }
        }
        return top;
    }

    public SQLCommand[] getSqlStatements() {
        return this.m_sqlArray.toArray(new SQLCommand[this.m_sqlArray.size()]);
    }

    private static boolean amIInitial(String inString) {
        int state = 0;
        int position = 0;
        String quoteString = "";
        boolean[] needToCheckThisType = new boolean[m_startAndEnd.length];
        for (int i = 1; i < m_startAndEnd.length; ++i) {
            needToCheckThisType[i] = true;
        }
        boolean needToCheckUppercaseQ = true;
        while (true) {
            int newPos;
            if (state == 0) {
                int nextMatch;
                int lowestMatch = 100000;
                int matchVal = 0;
                int i = 1;
                for (i = 1; i < m_startAndEnd.length; ++i) {
                    if (!needToCheckThisType[i]) continue;
                    nextMatch = inString.indexOf(m_startAndEnd[i][0], position);
                    if (nextMatch == -1) {
                        needToCheckThisType[i] = false;
                        continue;
                    }
                    if (nextMatch >= lowestMatch || i == 5 && nextMatch + 2 == inString.length()) continue;
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                i = 5;
                if (needToCheckUppercaseQ) {
                    nextMatch = inString.indexOf("Q'", position);
                    if (nextMatch == -1) {
                        needToCheckUppercaseQ = false;
                    } else if (nextMatch < lowestMatch && (i != 5 || nextMatch + 2 != inString.length())) {
                        lowestMatch = nextMatch;
                        matchVal = i;
                    }
                }
                if (matchVal == 5) {
                    quoteString = inString.substring(lowestMatch + 2, lowestMatch + 3);
                    quoteString = ScriptParser.getEndQuoteString(quoteString);
                }
                if (matchVal == 5) {
                    state = 5;
                    position = lowestMatch + 3;
                    continue;
                }
                if (matchVal == 4) {
                    state = 4;
                    position = lowestMatch + 1;
                    continue;
                }
                if (matchVal == 0) {
                    return state == 0;
                }
                state = matchVal;
                position = lowestMatch + m_startAndEnd[matchVal][0].length();
                continue;
            }
            String endString = m_startAndEnd[state][1];
            if (state == 5) {
                endString = quoteString + endString;
            }
            if ((newPos = inString.indexOf(endString, position)) == -1) {
                return state == 0;
            }
            position = newPos + endString.length();
            if (state == 4 || state == 5) {
                quoteString = "";
            }
            state = 0;
        }
    }

    private int[] numberOfQuotes(String inString, boolean returnOnSemicolon, boolean concat) {
        int noOfQuotes = 0;
        int position = 0;
        int embeddedSemicolon = 0;
        int initialSemicolon = -1;
        if (inString.indexOf(10) != -1) {
            int[] retVal = null;
            int lengthSoFar = 0;
            for (String s : inString.split("\n")) {
                retVal = this.numberOfQuotes(s, returnOnSemicolon, concat);
                noOfQuotes += retVal[0];
                if (returnOnSemicolon && retVal[2] != -1) {
                    return new int[]{noOfQuotes, retVal[1], retVal[2] + lengthSoFar};
                }
                lengthSoFar = lengthSoFar + s.length() + "\n".length();
            }
            return new int[]{noOfQuotes, retVal[1], retVal[2]};
        }
        while (true) {
            if (this.m_state == 0) {
                int nextMatch;
                int lowestMatch = 100000;
                int matchVal = 0;
                int i = 1;
                for (i = 1; i < m_startAndEnd.length; ++i) {
                    nextMatch = inString.indexOf(m_startAndEnd[i][0], position);
                    if (nextMatch == -1 || nextMatch >= lowestMatch || i == 5 && nextMatch + 2 == inString.length()) continue;
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                i = 5;
                nextMatch = inString.indexOf("Q'", position);
                if (nextMatch != -1 && nextMatch < lowestMatch && (i != 5 || nextMatch + 2 != inString.length())) {
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                if (returnOnSemicolon && (nextMatch = inString.indexOf(";", position)) != -1 && nextMatch < lowestMatch) {
                    this.setFirstLine(inString);
                    initialSemicolon = nextMatch;
                    int[] retval = new int[]{noOfQuotes, 0, initialSemicolon};
                    return retval;
                }
                if (matchVal == 5) {
                    this.m_quoteString = inString.substring(lowestMatch + 2, lowestMatch + 3);
                    this.m_quoteString = ScriptParser.getEndQuoteString(this.m_quoteString);
                }
                if (matchVal == 5) {
                    ++noOfQuotes;
                    this.m_state = 5;
                    position = lowestMatch + 3;
                    continue;
                }
                if (matchVal == 4) {
                    ++noOfQuotes;
                    this.m_state = 4;
                    position = lowestMatch + 1;
                    continue;
                }
                if (matchVal == 1 && this.m_firstLine && inString.substring(lowestMatch).replaceAll("\\s+$", "").equals("--") && !inString.replaceAll("\\s+$", "").replaceAll("^\\s+", "").equals("--")) {
                    position = lowestMatch + 1;
                    continue;
                }
                if (matchVal == 0) {
                    this.setFirstLine(inString);
                    int[] retval = new int[]{noOfQuotes, 0, initialSemicolon};
                    return retval;
                }
                this.m_state = matchVal;
                position = lowestMatch + m_startAndEnd[matchVal][0].length();
                continue;
            }
            String endString = m_startAndEnd[this.m_state][1];
            if (this.m_state == 5) {
                endString = this.m_quoteString + endString;
            }
            boolean stillGrabbing = false;
            int newPos = inString.indexOf(endString, position);
            if (concat && this.m_firstLine && this.m_state == 1 && newPos == -1 && inString.replaceAll("\\s+$", "").endsWith("-") && !inString.replaceAll("^\\s+", "").startsWith("--")) {
                stillGrabbing = true;
            }
            if (concat && this.m_firstLine && this.m_state == 1) {
                while (newPos != -1) {
                    boolean grabAgain;
                    boolean bl = grabAgain = inString.substring(position, newPos).replaceAll("\\s+$", "").endsWith("-") && !inString.replaceAll("^\\s+", "").startsWith("--");
                    if (!grabAgain) break;
                    if (newPos + 1 <= inString.length()) {
                        newPos = inString.indexOf(endString, newPos + 1);
                        continue;
                    }
                    stillGrabbing = true;
                    newPos = -1;
                }
            }
            if (newPos == -1) {
                if (this.m_state == 1) {
                    if (!stillGrabbing) {
                        this.m_state = 0;
                    }
                    if (inString.trim().endsWith(";")) {
                        embeddedSemicolon = 1;
                    }
                } else if (this.m_state != 0 && inString.trim().endsWith(";")) {
                    embeddedSemicolon = 1;
                }
                this.setFirstLine(inString);
                int[] retval = new int[]{noOfQuotes, embeddedSemicolon, initialSemicolon};
                return retval;
            }
            position = newPos + endString.length();
            if (this.m_state == 4 || this.m_state == 5) {
                ++noOfQuotes;
                this.m_quoteString = "";
            }
            this.m_state = 0;
        }
    }

    void setFirstLine(String inString) {
        if (this.m_firstLine && (!inString.replaceAll("\\s+$", "").endsWith("-") || inString.replaceAll("^\\s+", "").startsWith("--"))) {
            this.m_firstLine = false;
        }
    }

    boolean isQuoteStringValid(String quoteString) {
        boolean retVal = true;
        if (quoteString.equals("\t") || quoteString.equals("\r") || quoteString.equals("\n") || quoteString.equals(" ")) {
            retVal = false;
        }
        return retVal;
    }

    static String getEndQuoteString(String inQuote) {
        String retVal = inQuote;
        if (retVal.equals("[")) {
            retVal = "]";
        } else if (retVal.equals("{")) {
            retVal = "}";
        } else if (retVal.equals("<")) {
            retVal = ">";
        } else if (retVal.equals("(")) {
            retVal = ")";
        }
        return retVal;
    }
}

