/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHBufferpool
extends RowHandler {
    public static final String OBJECT_TYPE = "BUFFER_POOLS";
    private static final Logger LOGGER = new Logger(RHBufferpool.class);

    public RHBufferpool(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createBufferPool(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createBufferPool(VarFileLine line) {
        try {
            String bufferPoolName = this.getField(line, "BUFFER_POOLS_NAME");
            StorageDesignDB2v70 stoDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(this.getDesign().getSelectedRDBMSSite());
            BufferPoolSetDB2 bufPoolSet = stoDesign.getBufferPoolSet();
            Iterator itBufPoolSet = bufPoolSet.iterator();
            while (itBufPoolSet.hasNext()) {
                BufferPoolDB2 bufPool = (BufferPoolDB2)itBufPoolSet.next();
                if (!bufPool.getName().equalsIgnoreCase(bufferPoolName)) continue;
                this.fillElements(line, bufPool);
                this.addCreatedObject(this.getField(line, "general_id"), bufPool);
                this.removeSelectedLine(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fillElements(VarFileLine line, BufferPoolDB2 bufferPool) {
        try {
            int minBuffers = Integer.parseInt(this.getField(line, "BUFFER_POOLS_MIN_BUFFERS"));
            int maxBuffers = Integer.parseInt(this.getField(line, "BUFFER_POOLS_MAX_BUFFERS"));
            bufferPool.setMinBuffers(minBuffers);
            bufferPool.setMaxBuffers(maxBuffers);
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHBufferpool.fillElements : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong MIN or MAX BUFFER format in " + line);
        }
    }
}

