/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;

public class RHCheckConstraint
extends RowHandler
implements StatementsConstants {
    public static final String OBJECT_TYPE = "CHECK_CONSTRAINT";

    public RHCheckConstraint(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createAlias(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createAlias(VarFileLine line) {
        String tableID = this.getField(line, "CHECK_CONSTRAINT_TABLE_ID");
        if (!"0".equalsIgnoreCase(tableID)) {
            Table table = (Table)this.getCreatedObject(tableID);
            if (table != null) {
                String name = this.getField(line, "CHECK_CONSTRAINT_NAME");
                String rule = "";
                VarFileLine commentLine = this.getCommentLine(this.getField(line, "CHECK_CONSTRAINT_TEXT"), "TEXT");
                if (commentLine != null) {
                    rule = this.getField(commentLine, "text_comment");
                }
                if (!"".equalsIgnoreCase(rule)) {
                    TableLevelConstraint constraint = table.createCheckConstraint(name, rule);
                    table.addCheckConstraint(constraint);
                }
            }
        } else {
            Column column;
            String columnID = this.getField(line, "CHECK_CONSTRAINT_COLUMN_ID");
            if (!"0".equalsIgnoreCase(columnID) && (column = (Column)this.getCreatedObject(columnID)) != null) {
                String name = this.getField(line, "CHECK_CONSTRAINT_NAME");
                String rule = "";
                VarFileLine commentLine = this.getCommentLine(this.getField(line, "CHECK_CONSTRAINT_TEXT"), "TEXT");
                if (commentLine != null) {
                    rule = this.getField(commentLine, "text_comment");
                }
                if (!"".equalsIgnoreCase(rule)) {
                    this.initCheckConstraint(rule, name, column);
                }
            }
        }
        this.removeSelectedLine(line);
    }

    private void initCheckConstraint(String check, String name, Column column) {
        boolean isEnumerationLike = Token.hasToken(check, "LIKE");
        boolean isEnumerationIn = Token.hasToken(check, "IN");
        boolean isRangeValueBetween = Token.hasToken(check, "BETWEEN");
        if (isEnumerationLike) {
            String like = Token.getTokenAfter(check, "LIKE");
            like = like.substring(1, like.length() - 1);
            ConstraintEnumeration constraint = new ConstraintEnumeration();
            constraint.add(like);
            constraint.setName(name);
            column.setUseDomainConstraints(false);
            column.setValueList(constraint);
        } else if (isEnumerationIn) {
            String in = Token.getValBetweenBrackets(check).trim();
            ConstraintEnumeration constraint = new ConstraintEnumeration();
            StringTokenizer inToken = new StringTokenizer(in, ",");
            while (inToken.hasMoreTokens()) {
                String token = inToken.nextToken().trim();
                token = token.substring(1, token.length() - 1);
                constraint.add(token);
            }
            constraint.setName(name);
            column.setUseDomainConstraints(false);
            column.setValueList(constraint);
        } else if (isRangeValueBetween) {
            String beforeAnd = Token.getTokenAfter(check, "BETWEEN");
            String afterAnd = Token.getTokenAfter(check, "AND");
            AVT avt = new AVT(beforeAnd, afterAnd, "");
            column.addAVT(avt);
            column.setUseDomainConstraints(false);
        } else {
            CheckConstraint constraint = new CheckConstraint();
            RDBMSTypeSet rdbmsTypeSet = this.getDesign().getRDBMSTypeSet();
            Iterator itRdbms = rdbmsTypeSet.iterator();
            while (itRdbms.hasNext()) {
                RDBMSType type = (RDBMSType)itRdbms.next();
                if (!type.getName().equalsIgnoreCase("IBM DB2 (7.0)")) continue;
                constraint.add(type, check);
            }
            constraint.setName(name);
            column.setUseDomainConstraints(false);
            column.setCheck(constraint);
        }
    }
}

