/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.Logger;

public class RHPlacement
extends RowHandler {
    public static final String OBJECT_TYPE = "PLACEMENT";
    private Fields constants;
    private Map viewsWithPlacement = new TreeMap();
    private List viewsWithNoPlacement = new ArrayList();
    private List lines = new ArrayList();
    private static final Logger LOGGER = new Logger(RHPlacement.class);
    int xmin;
    int ymin;
    int xmax;
    int ymax;

    public RHPlacement(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
        this.constants = constants;
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            if (this.getField(line, "PLACEMENT_DIAGRAM_ID").equalsIgnoreCase(this.constants.getPhysicalDesignID())) {
                this.rearrangeTables(line);
            } else if (!this.lines.contains(line)) {
                this.lines.add(line);
                this.removeSelectedLine(line);
            }
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }

    public void createObjectsInSubViews(Map diagramMap) {
        for (VarFileLine line : this.lines) {
            String diagramID;
            DesignPartView dpv;
            int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
            if (testCool == 1000 || (dpv = (DesignPartView)diagramMap.get(diagramID = this.getField(line, "PLACEMENT_DIAGRAM_ID"))) == null) continue;
            String tableID = this.getField(line, "PLACEMENT_TABLE_ID");
            DesignObject table = (DesignObject)this.getAllCreatedObjects().get(tableID);
            if (table == null) continue;
            try {
                ContainerView topView;
                int left = Integer.parseInt(this.getField(line, "PLACEMENT_LEFT"));
                int top = Integer.parseInt(this.getField(line, "PLACEMENT_TOP"));
                int width = Integer.parseInt(this.getField(line, "PLACEMENT_WIDTH"));
                int height = Integer.parseInt(this.getField(line, "PLACEMENT_HEIGHT"));
                if (width == 0 && height == 0 || (topView = ((ContainerView)table.getTopView()).createViewSynonim(dpv)) == null) continue;
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(left, top, width, height));
                } else {
                    topView.setBounds(new Rectangle(left, top, width, height));
                }
                if (!(topView instanceof TVTable)) continue;
                ((TVTable)topView).addTVFKRelations();
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong Format in RHPlacement.createObjectsInSubViews: ");
                message.append(line.getLine());
                LOGGER.error(message.toString(), e);
                this.importLog.addWarning("Error occured while creating objects in subview near " + line);
            }
        }
    }

    private void rearrangeTables(VarFileLine line) {
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool != 1000) {
            String tableID = this.getField(line, "PLACEMENT_TABLE_ID");
            DesignObject table = (DesignObject)this.getAllCreatedObjects().get(tableID);
            if (table != null) {
                try {
                    TopView topView;
                    int left = Integer.parseInt(this.getField(line, "PLACEMENT_LEFT"));
                    int top = Integer.parseInt(this.getField(line, "PLACEMENT_TOP"));
                    int width = Integer.parseInt(this.getField(line, "PLACEMENT_WIDTH"));
                    int height = Integer.parseInt(this.getField(line, "PLACEMENT_HEIGHT"));
                    int color = Integer.parseInt(this.getField(line, "PLACEMENT_COLOR"));
                    if ((width != 0 || height != 0) && (topView = table.getTopView()) != null) {
                        if (topView.getCellView() != null) {
                            topView.getCellView().setNewBounds(new Rectangle(left, top, width, height));
                        } else {
                            topView.setBounds(new Rectangle(left, top, width, height));
                        }
                        if (table instanceof TableView) {
                            this.viewsWithPlacement.put(table.getObjectID(), table);
                        }
                        RHPlacement.setColor(topView, color);
                    }
                }
                catch (NumberFormatException e) {
                    StringBuffer message = new StringBuffer("wrong Format in RHPlacement.replaceTables: ");
                    message.append(line.getLine());
                    LOGGER.error(message.toString(), e);
                    this.importLog.addWarning("Error occured while rearranging tables in subview near " + line);
                }
                this.removeSelectedLine(line);
            }
        }
    }

    public void rearrangePhysDes() {
        Rectangle rect = null;
        int ocount = 0;
        ArrayList<TopView> topviewCol = new ArrayList<TopView>();
        Iterator viewIt = this.getDesign().getRelationalDesign().getTableViewSet().iterator();
        while (viewIt.hasNext()) {
            ++ocount;
            TableView tv = (TableView)viewIt.next();
            TopView view = tv.getTopView();
            if ((tv = (TableView)this.viewsWithPlacement.get(tv.getObjectID())) == null) {
                this.viewsWithNoPlacement.add(view);
                continue;
            }
            topviewCol.add(view);
            if (rect == null) {
                rect = new Rectangle(view.getBounds());
                continue;
            }
            rect.add(view.getBounds());
        }
        Iterator tableIt = this.getDesign().getRelationalDesign().getTableSet().iterator();
        while (tableIt.hasNext()) {
            ++ocount;
            TopView tv = ((Table)tableIt.next()).getTopView();
            topviewCol.add(tv);
            if (rect == null) {
                rect = new Rectangle(tv.getBounds());
                continue;
            }
            rect.add(tv.getBounds());
        }
        if (ocount > 0 && rect != null) {
            this.xmin = rect.x;
            this.ymin = rect.y;
            this.xmax = this.xmin + rect.width;
            this.ymax = this.ymin + rect.height;
            int dx = 20 - this.xmin;
            int dy = 20 - this.ymin;
            this.translateComponents(dx, dy, topviewCol);
            this.xmin = 20;
            this.ymin = 20;
            this.xmax += dx;
            this.ymax += dy;
            this.arrangeViewsWithoutPositionInVar();
        }
    }

    private void translateComponents(int dx, int dy, Collection topviewCol) {
        for (TopView tv : topviewCol) {
            Point loc = tv.getLocation();
            loc.x += dx;
            loc.y += dy;
            tv.setLocation(loc);
        }
        Iterator it = this.getDesign().getRelationalDesign().getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            Point2D p;
            Object obj;
            int i;
            Object[] points;
            FKIndexAssociation fkIndex = (FKIndexAssociation)it.next();
            TVFKRelation tv = (TVFKRelation)fkIndex.getViewFor(fkIndex.getDesignPart().getMainView());
            if (tv == null) continue;
            EdgeView edge = (EdgeView)tv.getCellView();
            if (edge != null) {
                points = edge.getPoints().toArray();
                for (i = 1; i < points.length - 1; ++i) {
                    obj = points[i];
                    if (obj instanceof Point) {
                        p = (Point)obj;
                        p.x += dx;
                        p.y += dy;
                        continue;
                    }
                    if (!(obj instanceof DiagramConstants.SerializablePoint2D)) continue;
                    p = (DiagramConstants.SerializablePoint2D)obj;
                    ((DiagramConstants.SerializablePoint2D)p).x += (double)dx;
                    ((DiagramConstants.SerializablePoint2D)p).y += (double)dy;
                }
                edge.update();
                continue;
            }
            points = tv.getEdgePoints().toArray();
            for (i = 0; i < points.length; ++i) {
                obj = points[i];
                if (obj instanceof Point) {
                    p = (Point)obj;
                    p.x += dx;
                    p.y += dy;
                    continue;
                }
                if (!(obj instanceof DiagramConstants.SerializablePoint2D)) continue;
                p = (DiagramConstants.SerializablePoint2D)obj;
                ((DiagramConstants.SerializablePoint2D)p).x += (double)dx;
                ((DiagramConstants.SerializablePoint2D)p).y += (double)dy;
            }
        }
    }

    private void arrangeViewsWithoutPositionInVar() {
        int width = 210;
        int height = 120;
        int step = 20;
        Dimension dim = this.getDesign().getRelationalDesign().getMainView().getConfiguration().getWorkSpaceSize();
        int endy = dim.height;
        int starty = this.ymax + step;
        int numy = (endy - starty) / (height + step);
        int endx = this.xmax;
        int startx = this.xmin;
        int numx = (endx - startx) / (width + step);
        int numelems = this.viewsWithNoPlacement.size();
        if (numy * numx < numelems) {
            endx = dim.width;
            numx = (endx - startx) / (width + step);
        }
        while (numy * numx < numelems) {
            if ((width -= step) < step || (height -= step) < step) {
                return;
            }
            numx = (endx - startx) / (width + step);
            numy = (endy - starty) / (height + step);
        }
        Iterator it = this.viewsWithNoPlacement.iterator();
        for (int j = 0; j < numy; ++j) {
            int y = starty + j * (height + step);
            for (int i = 0; i < numx; ++i) {
                int x = startx + i * (width + step);
                if (it.hasNext()) {
                    TopView comp = (TopView)it.next();
                    if (comp.getCellView() != null) {
                        comp.getCellView().setNewBounds(new Rectangle(x, y, width, height));
                        continue;
                    }
                    comp.setBounds(new Rectangle(x, y, width, height));
                    continue;
                }
                return;
            }
        }
    }

    public static void setColor(TopView tv, int int_color) {
        int red = RHPlacement.getRed(int_color);
        int green = RHPlacement.getGreen(int_color);
        int blue = RHPlacement.getBlue(int_color);
        Color color = new Color(red, green, blue);
        tv.setBackgroundColor(color);
        tv.setUseDefaultColor(false);
    }

    private static int getRed(int color) {
        int redmask = 255;
        int result = color & redmask;
        return result;
    }

    private static int getGreen(int color) {
        int mask = 65280;
        int result = color & mask;
        return result >> 8;
    }

    private static int getBlue(int color) {
        int mask = 0xFF0000;
        int result = color & mask;
        return result >> 16;
    }
}

