/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.xmla;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.xmla.XMLAConstants;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVMultidimensional;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLAHandler
implements XMLAConstants {
    private static final Logger LOGGER = new Logger(XMLAHandler.class);
    private ApplicationView appView;
    private ProgressDialog monitor;
    private File currentFile;
    private boolean inExistingDesign;
    private String oldDesignPath;
    private String designName;
    private Design design;
    private Map handledObjects = new TreeMap();
    private Map dimensionAttributes = new TreeMap();

    public XMLAHandler(ApplicationView appView, boolean inExistingDesign) {
        this.appView = appView;
        this.inExistingDesign = inExistingDesign;
        this.design = appView.getCurrentDesign();
    }

    private void setDesignName(String designName) {
        this.designName = !this.inExistingDesign ? designName : this.appView.getDesignName();
        this.appView.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
        if (this.appView.designExists(designName)) {
            this.appView.deleteDesign(designName);
        }
        if (this.appView != null && !this.inExistingDesign) {
            this.appView.setDesignName(designName);
        }
        if (!this.inExistingDesign) {
            this.design.setFileName(this.designName);
        }
    }

    public void parse(File file) {
        if (file.isFile()) {
            try {
                this.oldDesignPath = this.appView.getCurrentDesign().getDesignPath();
                this.currentFile = file;
                new Thread(new Runner()).start();
            }
            catch (Exception e) {
                LOGGER.error("XMLAHandler - Unable to parse file: " + file.getAbsolutePath(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File file, ImportLogger importLog) {
        try {
            FileInputStream is = new FileInputStream(file);
            InputSource inputSource = new InputSource(new InputStreamReader((InputStream)is, IdeUtil.getIdeEncoding()));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            try {
                Document doc;
                NodeList nodeList;
                try {
                    db = dbf.newDocumentBuilder();
                }
                catch (ParserConfigurationException e1) {
                    LOGGER.error(e1);
                }
                if (db != null && (nodeList = (doc = db.parse(inputSource)).getElementsByTagName("Database")).getLength() > 0) {
                    Element databaseElm = (Element)nodeList.item(0);
                    String dbName = this.getElementValue(databaseElm, "Name");
                    String dbDescription = this.getElementValue(databaseElm, "Description");
                    if (dbName != null) {
                        this.setDesignName(dbName);
                        MultidimensionalDesign mdDesign = this.design.addMultidimensionalDesign(dbName);
                        mdDesign.setComment(dbDescription);
                        this.design.setMultidimensionalDesign(mdDesign);
                        this.monitor.setNote(Messages.getString("XMLAHandler.ParseTables"));
                        this.monitor.setProgress(20);
                        this.parseTables(databaseElm, importLog);
                        this.monitor.setNote(Messages.getString("XMLAHandler.ParseDimensions"));
                        this.monitor.setProgress(40);
                        this.parseDimensions(databaseElm, importLog);
                        this.monitor.setNote(Messages.getString("XMLAHandler.ParseCubes"));
                        this.monitor.setProgress(60);
                        this.parseCubes(databaseElm, importLog);
                    } else {
                        this.appView.getCurrentDesign().setDesignPath(this.oldDesignPath);
                        this.design = null;
                        System.gc();
                    }
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            LOGGER.error("XMLAHandler - Unable to parse file: " + file.getAbsolutePath(), e);
            importLog.addError("Error parsing File...");
        }
    }

    private void addToHandledObjects(Object key, Object value) {
        if (!this.handledObjects.containsKey(key)) {
            this.handledObjects.put(key, value);
        } else {
            System.out.println(key + " - " + value);
        }
    }

    private String getElementValue(Element element, String tagName) {
        return this.getElementValue(element, tagName, false);
    }

    private String getElementValue(Element element, String tagName, boolean checkParent) {
        try {
            NodeList nodeList = element.getElementsByTagName(tagName);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elm = (Element)nodeList.item(i);
                if (!checkParent) {
                    String value = elm.getFirstChild().getNodeValue();
                    return value;
                }
                if (elm.getParentNode() != element) continue;
                String value = elm.getFirstChild().getNodeValue();
                return value;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private void parseTables(Element element, ImportLogger importLog) {
        NodeList nodeList = element.getElementsByTagName("DataSourceViews");
        if (nodeList.getLength() > 0) {
            Element dsViewsElm = (Element)nodeList.item(0);
            NodeList dataSourceViewList = dsViewsElm.getElementsByTagName("DataSourceView");
            for (int dsv = 0; dsv < dataSourceViewList.getLength(); ++dsv) {
                String columnExpression;
                Element dataSourceViewElm = (Element)dataSourceViewList.item(dsv);
                NodeList schemaList = dataSourceViewElm.getElementsByTagName("Schema");
                if (schemaList.getLength() <= 0) continue;
                Element schemaElm = (Element)schemaList.item(0);
                List list = this.getTableElements(schemaElm);
                for (Element elm : list) {
                    String tableID = elm.getAttribute("name");
                    String tableName = elm.getAttribute("msprop:DbTableName");
                    if (this.design.getLogicalDesign().getEntitySet().getByName(tableName) != null) continue;
                    Entity entity = this.design.getLogicalDesign().createEntity();
                    entity.setName(tableName);
                    this.addToHandledObjects(tableID, entity);
                    List colList = this.getColumnsElements(elm);
                    for (Element colElm : colList) {
                        String columnID = colElm.getAttribute("name");
                        String isLogical = null;
                        if (colElm.hasAttribute("msprop:IsLogical")) {
                            isLogical = colElm.getAttribute("msprop:IsLogical");
                        }
                        String columnName = colElm.hasAttribute("msprop:DbColumnName") ? colElm.getAttribute("name") : columnID;
                        String type = colElm.getAttribute("type");
                        String maxLength = this.getColumnMaxLength(colElm);
                        columnExpression = "";
                        if (colElm.hasAttribute("msprop:ComputedColumnExpression")) {
                            columnExpression = colElm.getAttribute("msprop:ComputedColumnExpression");
                        }
                        if (isLogical != null && "True".equalsIgnoreCase(isLogical)) {
                            DummyObject doAttribute = new DummyObject(columnName);
                            doAttribute.setProperty("msprop:IsLogical", Boolean.TRUE);
                            doAttribute.setProperty("msprop:ComputedColumnExpression", columnExpression);
                            this.addToHandledObjects(tableID + ":" + columnID, doAttribute);
                            continue;
                        }
                        Attribute attribute = entity.createAttribute();
                        attribute.setName(columnName);
                        this.addToHandledObjects(tableID + ":" + columnID, attribute);
                        this.setAttributeDataType(attribute, type, maxLength);
                    }
                }
                list = this.getUniqueElements(schemaElm);
                for (Element elm : list) {
                    Entity entity;
                    String uniqueID = elm.getAttribute("name");
                    String uniqueName = elm.getAttribute("msdata:ConstraintName");
                    String isPrimary = elm.getAttribute("msdata:PrimaryKey");
                    String tableID = this.getTableForKey(elm);
                    if (tableID == null || (entity = (Entity)this.handledObjects.get(tableID)) == null) continue;
                    CandidateKey key = entity.createCandidateKey();
                    if (!"".equalsIgnoreCase(uniqueName)) {
                        key.setName(uniqueName);
                    } else {
                        key.setName(uniqueID);
                    }
                    this.addToHandledObjects(uniqueID, key);
                    List columns = this.getColumnsForKey(elm);
                    for (String column : columns) {
                        Attribute attribute = (Attribute)entity.getElementByName(column);
                        if (attribute == null) continue;
                        key.add(attribute);
                    }
                    if (!"true".equalsIgnoreCase(isPrimary)) continue;
                    key.makePK();
                }
                list = this.getKeyRefElements(schemaElm);
                for (Element elm : list) {
                    String relationID = elm.getAttribute("name");
                    String referencedKey = elm.getAttribute("refer");
                    String tableID = this.getTableForKey(elm);
                    if (tableID == null) continue;
                    Entity childEntity = (Entity)this.handledObjects.get(tableID);
                    CandidateKey pk = (CandidateKey)this.handledObjects.get(referencedKey);
                    Entity parentEntity = null;
                    if (pk != null) {
                        parentEntity = (Entity)pk.getContainerObject();
                    } else {
                        System.out.println(referencedKey);
                    }
                    if (parentEntity == null || childEntity == null) continue;
                    Relation relation = this.design.getLogicalDesign().createRelation();
                    relation.setName(relationID);
                    this.addToHandledObjects(tableID + ":" + relationID, relation);
                    List columns = this.getColumnsForKey(elm);
                    if (pk.getElements().length >= columns.size()) {
                        for (int i = 0; i < columns.size(); ++i) {
                            String columnName = (String)columns.get(i);
                            Attribute fkAttribute = (Attribute)childEntity.getElementByName(columnName);
                            if (fkAttribute == null) continue;
                            Attribute pkAttribute = (Attribute)pk.getElement(i);
                            fkAttribute.setReferedAttribute(pkAttribute.getObjectID());
                            fkAttribute.setGeneratorID(relation.getObjectID());
                        }
                    }
                    relation.setSourceEntity(parentEntity);
                    relation.setTargetEntity(childEntity);
                    relation.setFireCardinalityChange(false);
                    relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[1]);
                    relation.setFireCardinalityChange(true);
                    relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[0]);
                    TVRelation tvr = (TVRelation)relation.getTopView();
                    if (tvr == null) continue;
                    tvr.addConnection();
                    tvr.resetEdgeParams();
                }
                list = this.getViewElements(schemaElm);
                for (Element elm : list) {
                    String viewID = elm.getAttribute("name");
                    String viewName = elm.getAttribute("msprop:DbTableName");
                    String queryDefinition = elm.getAttribute("msprop:QueryDefinition");
                    if (viewName == null || "".equalsIgnoreCase(viewName)) {
                        viewName = viewID;
                    }
                    EntityView entityView = this.design.getLogicalDesign().createEntityView();
                    entityView.setName(viewName);
                    this.addToHandledObjects(viewID, entityView);
                    if (queryDefinition != null && !"".equalsIgnoreCase(queryDefinition)) {
                        entityView.setViewType("NAMED QUERY");
                    }
                    List colList = this.getColumnsElements(elm);
                    for (Element colElm : colList) {
                        String nameDatatype;
                        String nameLogDT;
                        AttributeView attributeView;
                        String columnID = colElm.getAttribute("name");
                        String isLogical = null;
                        if (colElm.hasAttribute("msprop:IsLogical")) {
                            isLogical = colElm.getAttribute("msprop:IsLogical");
                        }
                        String columnName = colElm.hasAttribute("msprop:DbColumnName") ? colElm.getAttribute("name") : columnID;
                        String type = colElm.getAttribute("type");
                        columnExpression = "";
                        if (colElm.hasAttribute("msprop:ComputedColumnExpression")) {
                            columnExpression = colElm.getAttribute("msprop:ComputedColumnExpression");
                        }
                        if (isLogical != null && "True".equalsIgnoreCase(isLogical)) {
                            attributeView = (AttributeView)entityView.createContainedObject(null);
                            attributeView.setEntityAlias(entityView.getName());
                            attributeView.setName(columnID);
                            attributeView.setSourceType("Derived");
                            attributeView.setFormulaDesc(columnExpression);
                            this.addToHandledObjects(viewID + ":" + columnID, attributeView);
                            continue;
                        }
                        attributeView = (AttributeView)entityView.createContainedObject(null);
                        attributeView.setEntityAlias(entityView.getName());
                        attributeView.setName(columnName);
                        this.addToHandledObjects(viewID + ":" + columnID, attributeView);
                        if (!"".equalsIgnoreCase(columnExpression)) {
                            this.setAttributeExpression(attributeView, columnExpression);
                            continue;
                        }
                        if ("".equalsIgnoreCase(type)) {
                            type = "STRING";
                        }
                        if (type.startsWith("xs:")) {
                            type = type.substring(3);
                        }
                        if ((nameLogDT = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(StorageDesignSqlServerv2k5.RDBMS_TYPE, nameDatatype = StandardDatatypeNames.getUsedDatatypeName(type))) != null) {
                            attributeView.setDataType(nameLogDT);
                            continue;
                        }
                        attributeView.setDataType(nameDatatype);
                    }
                }
            }
        }
    }

    private String getTableForKey(Element element) {
        Element elm;
        String xpath;
        NodeList nodeList = element.getElementsByTagName("selector");
        if (nodeList.getLength() > 0 && !"".equalsIgnoreCase(xpath = (elm = (Element)nodeList.item(0)).getAttribute("xpath"))) {
            if (xpath.startsWith(".//")) {
                xpath = xpath.substring(3);
            }
            return xpath;
        }
        return null;
    }

    private List getColumnsForKey(Element element) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nodeList = element.getElementsByTagName("field");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elm = (Element)nodeList.item(i);
            String xpath = elm.getAttribute("xpath");
            if ("".equalsIgnoreCase(xpath)) continue;
            result.add(xpath);
        }
        return result;
    }

    private List getTableElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("element");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elm = (Element)nodeList.item(i);
            if (elm == null || !elm.hasAttribute("msprop:TableType") || !"Table".equalsIgnoreCase(elm.getAttribute("msprop:TableType"))) continue;
            result.add(elm);
        }
        return result;
    }

    private List getViewElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("element");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elm = (Element)nodeList.item(i);
            if (elm == null) continue;
            if (elm.hasAttribute("msprop:TableType") && "View".equalsIgnoreCase(elm.getAttribute("msprop:TableType"))) {
                result.add(elm);
                continue;
            }
            if (!elm.hasAttribute("msprop:QueryDefinition")) continue;
            result.add(elm);
        }
        return result;
    }

    private List getUniqueElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("unique");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elm = (Element)nodeList.item(i);
            result.add(elm);
        }
        return result;
    }

    private List getKeyRefElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("keyref");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elm = (Element)nodeList.item(i);
            result.add(elm);
        }
        return result;
    }

    private List getColumnsElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("element");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elm = (Element)nodeList.item(i);
            if (elm == null) continue;
            result.add(elm);
        }
        return result;
    }

    private String getColumnMaxLength(Element element) {
        NodeList nodeList = element.getElementsByTagName("maxLength");
        if (nodeList.getLength() > 0) {
            Element elm = (Element)nodeList.item(0);
            return elm.getAttribute("value");
        }
        return "";
    }

    private void setAttributeDataType(Attribute attribute, String type, String maxLength) {
        String nameDatatype;
        LogicalDatatype logDatatype;
        if ("".equalsIgnoreCase(type)) {
            type = "STRING";
        }
        if (type.startsWith("xs:")) {
            type = type.substring(3).trim();
        }
        if ((logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignSqlServerv2k5.RDBMS_TYPE, nameDatatype = StandardDatatypeNames.getUsedDatatypeName(type))) != null) {
            attribute.setUse((short)1);
            attribute.setLogicalDatatype(logDatatype);
            if (!"".equalsIgnoreCase(maxLength)) {
                attribute.setDataTypeParameter("size", maxLength);
            }
        } else {
            LOGGER.warn("XMLAHandler.setAttributeDataType() - Unable to find Logical DataType for: " + nameDatatype);
        }
    }

    private void setAttributeExpression(ContainedObject attribute, String expression) {
        if (!"".equalsIgnoreCase(expression)) {
            attribute.setSourceType("Derived");
            attribute.setFormulaDesc(expression);
        }
    }

    private void parseDimensions(Element element, ImportLogger importLog) {
        NodeList nodeList = element.getElementsByTagName("Dimensions");
        if (nodeList.getLength() > 0) {
            Element dimensionsElm = (Element)nodeList.item(0);
            NodeList dimensionList = dimensionsElm.getElementsByTagName("Dimension");
            for (int i = 0; i < dimensionList.getLength(); ++i) {
                Element dimElm = (Element)dimensionList.item(i);
                String dimID = this.getElementValue(dimElm, "ID");
                String dimName = this.getElementValue(dimElm, "Name");
                oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = this.design.getMultidimensionalDesign().createDimension();
                dimension.setName(dimName);
                this.addToHandledObjects(dimID, dimension);
                String type = this.getElementValue(dimElm, "Type", true);
                if (type != null && "Time".equalsIgnoreCase(type)) {
                    dimension.setTimeDimension(true);
                }
                List list = this.getDimensionAttributes(dimElm);
                Iterator it = list.iterator();
                TreeMap<String, Element> aMap = new TreeMap<String, Element>();
                while (it.hasNext()) {
                    Element attributeElm = (Element)it.next();
                    String attributeID = this.getElementValue(attributeElm, "ID");
                    aMap.put(attributeID, attributeElm);
                    this.dimensionAttributes.put(dimID + ":" + attributeID, attributeElm);
                }
                String keyID = this.getAttributeIDByUsage(dimElm, "Key");
                Level keyLevel = null;
                if (keyID != null) {
                    keyLevel = this.getKeyLevel(keyID, this.getDimensionHierachies(dimElm), dimID, importLog, aMap);
                }
                TreeMap hierarchies = new TreeMap();
                list = this.getDimensionHierachies(dimElm);
                Iterator hIt = list.iterator();
                while (hIt.hasNext()) {
                    ArrayList<Level> hierarchyLevels = new ArrayList<Level>();
                    Element hierarchyElm = (Element)hIt.next();
                    String hierarchyName = this.getElementValue(hierarchyElm, "Name");
                    List levelList = this.getHierachyLevels(hierarchyElm);
                    AbstractMDTV previousTV = null;
                    for (int j = levelList.size() - 1; j >= 0; --j) {
                        AbstractMDTV tv2;
                        AbstractMDTV tv1;
                        boolean levelExists = false;
                        Element levelElm = (Element)levelList.get(j);
                        String levelName = this.getElementValue(levelElm, "Name");
                        String levelSourceAttributeID = this.getElementValue(levelElm, "SourceAttributeID");
                        Level level = (Level)this.handledObjects.get(this.generateUniqueID(levelSourceAttributeID, aMap));
                        if (level == null) {
                            level = this.design.getMultidimensionalDesign().createLevel();
                            level.setName(levelName);
                            this.addToHandledObjects(this.generateUniqueID(levelSourceAttributeID, aMap), level);
                        } else {
                            levelExists = true;
                            if (!level.getName().equalsIgnoreCase(levelName)) {
                                level.setComment(level.getComment() + "\n" + levelName);
                            }
                        }
                        boolean hasLink = false;
                        if (previousTV == null) {
                            if (keyLevel != null && !levelSourceAttributeID.equalsIgnoreCase(keyID)) {
                                tv1 = (AbstractMDTV)keyLevel.getTopView();
                                hasLink = keyLevel.getFirstLinkToTarget(level) != null;
                            } else {
                                tv1 = (AbstractMDTV)dimension.getTopView();
                                boolean bl = hasLink = dimension.getFirstLinkToTarget(level) != null;
                                if (keyLevel == null) {
                                    keyLevel = level;
                                    keyLevel.getLevelKey().clear();
                                    this.initLevelAttributes(keyLevel, keyID, aMap, importLog);
                                }
                            }
                            tv2 = (AbstractMDTV)level.getTopView();
                        } else {
                            tv1 = previousTV;
                            tv2 = (AbstractMDTV)level.getTopView();
                            boolean bl = hasLink = ((AbstractMDObject)previousTV.getModel()).getFirstLinkToTarget(level) != null;
                        }
                        if (!hasLink && tv1 != null && tv2 != null && tv1 != tv2) {
                            Link link = this.design.getMultidimensionalDesign().createLink();
                            link.setSourceTV(tv1);
                            link.setTargetTV(tv2);
                            ((TVLink)link.getTopView()).addConnection();
                        }
                        previousTV = tv2;
                        if (!hierarchyLevels.contains(keyLevel)) {
                            hierarchyLevels.add(keyLevel);
                        }
                        if (!hierarchyLevels.contains(level)) {
                            hierarchyLevels.add(level);
                        }
                        if (levelExists) continue;
                        this.initLevelAttributes(level, levelSourceAttributeID, aMap, importLog);
                    }
                    hierarchies.put(hierarchyName, hierarchyLevels);
                }
                Object[] hierarchyList = hierarchies.keySet().toArray();
                for (int m = 0; m < hierarchyList.length; ++m) {
                    Hierarchy hierarchy;
                    String hName = (String)hierarchyList[m];
                    List hList = (List)hierarchies.get(hName);
                    if (hList == null || (hierarchy = this.design.getMultidimensionalDesign().getHierarchyDefinedByLevels(hList)) == null) continue;
                    hierarchy.setName(hName);
                }
                this.initParentChildHierarchy(dimElm, aMap, importLog, dimension);
            }
            this.initFKLinks();
        }
    }

    private void initFKLinks() {
        Iterator it = this.design.getMultidimensionalDesign().getLinkSet().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            AbstractMDObject mdo1 = link.getSourceMDObject();
            AbstractMDObject mdo2 = link.getTargetMDObject();
            if (!(mdo1 instanceof Level) || !(mdo2 instanceof Level)) continue;
            Level level1 = (Level)mdo1;
            Level level2 = (Level)mdo2;
            ContainerObject ent1 = level1.getLevelEntity();
            ContainerObject ent2 = level2.getLevelEntity();
            if (ent1 == null || ent2 == null || ent1 == ent2) continue;
            ContainedObject[] elements = ent1.getElements();
            for (int i = 0; i < elements.length; ++i) {
                Attribute fkAttribute;
                ContainedObject elm = elements[i];
                if (!elm.isFKElement() || (fkAttribute = (Attribute)elm).getDelegate() == null || fkAttribute.getDelegate().getContainer() != ent2) continue;
                SlowChangingAttribute sca = level1.getSlowChangingAttribute(fkAttribute, fkAttribute.getName());
                if (sca != null) {
                    level1.getSlowChangingAttributes().remove(sca);
                }
                if (link.getRollupLink() == null) continue;
                link.getRollupLink().addChildToParentAttribute(fkAttribute);
            }
        }
    }

    private void initParentChildHierarchy(Element dimElm, Map aMap, ImportLogger importLog, oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        Element parentElm;
        String attributeID = this.getAttributeIDByUsage(dimElm, "Parent");
        if (attributeID != null && (parentElm = (Element)aMap.get(attributeID)) != null) {
            String name = this.getElementValue(parentElm, "Name");
            String rootIdent = this.getElementValue(parentElm, "RootMemberIf");
            Level level = this.design.getMultidimensionalDesign().createLevel();
            level.setName(name);
            level.setValueBasedHierarchy(true);
            this.initLevelAttributes(level, attributeID, aMap, importLog, true);
            String keyID = this.getAttributeIDByUsage(dimElm, "Key");
            if (keyID != null) {
                this.initLevelAttributes(level, keyID, aMap, importLog);
            }
            if (rootIdent != null) {
                level.setRootIdentification(rootIdent);
            }
            AbstractMDTV tv1 = (AbstractMDTV)dimension.getTopView();
            AbstractMDTV tv2 = (AbstractMDTV)level.getTopView();
            if (tv1 != null && tv2 != null) {
                Link link = this.design.getMultidimensionalDesign().createLink();
                link.setSourceTV(tv1);
                link.setTargetTV(tv2);
                ((TVLink)link.getTopView()).addConnection();
            }
            ArrayList<Level> list = new ArrayList<Level>();
            list.add(level);
            Hierarchy hierarchy = this.design.getMultidimensionalDesign().getHierarchyDefinedByLevels(list);
            if (hierarchy != null) {
                hierarchy.setName(name);
            }
        }
    }

    private String generateUniqueID(String sourceAttributeID, Map aMap) {
        Element element = (Element)aMap.get(sourceAttributeID);
        if (element != null) {
            String result = "";
            List list = this.getKeyColumns(element);
            for (Element keyColumnElm : list) {
                String tableID = this.getElementValue(keyColumnElm, "TableID");
                String columnID = this.getElementValue(keyColumnElm, "ColumnID");
                result = result + tableID + "." + columnID + ";";
            }
            return result;
        }
        return "";
    }

    private void initLevelAttributes(Level level, String levelSourceAttributeID, Map aMap, ImportLogger importLog) {
        this.initLevelAttributes(level, levelSourceAttributeID, aMap, importLog, false);
    }

    private void initLevelAttributes(Level level, String levelSourceAttributeID, Map aMap, ImportLogger importLog, boolean toParentKey) {
        Element attributeElm = (Element)aMap.get(levelSourceAttributeID);
        if (attributeElm != null) {
            Element valueElement;
            ContainerObject object;
            String columnID;
            String tableID;
            List keyColumns = this.getKeyColumns(attributeElm);
            for (Element keyColumnElm : keyColumns) {
                ContainedObject attribute;
                tableID = this.getElementValue(keyColumnElm, "TableID");
                columnID = this.getElementValue(keyColumnElm, "ColumnID");
                object = (ContainerObject)this.handledObjects.get(tableID);
                if (object == null) {
                    importLog.addWarning("Entity: " + tableID + " Not Found", true);
                    continue;
                }
                if (level.getLevelEntity() == null) {
                    level.setLevelEntity(object);
                }
                if ((attribute = object.getElementByName(columnID)) != null) {
                    if (toParentKey) {
                        level.addToParentKey(attribute);
                        continue;
                    }
                    level.addToLevelKey(attribute);
                    continue;
                }
                importLog.addWarning("Entity Attribute: " + columnID + " Not Found", true);
            }
            Element nameElement = this.getNameColumn(attributeElm);
            if (nameElement != null) {
                tableID = this.getElementValue(nameElement, "TableID");
                columnID = this.getElementValue(nameElement, "ColumnID");
                object = (ContainerObject)this.handledObjects.get(tableID);
                Object doAttribute = this.handledObjects.get(tableID + ":" + columnID);
                if (doAttribute != null && doAttribute instanceof DummyObject && ((DummyObject)doAttribute).hasProperty("msprop:IsLogical")) {
                    String expression = (String)((DummyObject)doAttribute).getProperty("msprop:ComputedColumnExpression");
                    if (expression != null && !level.hasCalculatedAttribute(columnID, expression.trim())) {
                        CalculatedAttribute calcAttribute = level.createCalculatedAttribute();
                        calcAttribute.setName(columnID);
                        calcAttribute.setFunction(expression.trim());
                        level.addCalculatedAttribute(calcAttribute);
                    }
                } else if (object == null) {
                    importLog.addWarning("Entity: " + tableID + " Not Found", true);
                } else {
                    if (level.getLevelEntity() == null) {
                        level.setLevelEntity(object);
                    } else if (level.getLevelEntity() != object) {
                        importLog.addWarning("NameColumn Entity: " + tableID + " is differ from Level Entity: " + level.getLevelEntity().getName(), true);
                        return;
                    }
                    ContainedObject attribute = object.getElementByName(columnID);
                    if (attribute != null) {
                        if (level.getSlowChangingAttribute(attribute, attribute.getName()) == null) {
                            SlowChangingAttribute scAttribute = new SlowChangingAttribute(level, attribute);
                            level.addDescriptiveAttribute(scAttribute);
                        }
                        level.setNameColumn(attribute);
                    } else {
                        importLog.addWarning("Entity Attribute: " + columnID + " Not Found", true);
                    }
                }
            }
            if ((valueElement = this.getValueColumn(attributeElm)) != null) {
                String tableID2 = this.getElementValue(valueElement, "TableID");
                String columnID2 = this.getElementValue(valueElement, "ColumnID");
                ContainerObject object2 = (ContainerObject)this.handledObjects.get(tableID2);
                Object doAttribute = this.handledObjects.get(tableID2 + ":" + columnID2);
                if (doAttribute != null && doAttribute instanceof DummyObject && ((DummyObject)doAttribute).hasProperty("msprop:IsLogical")) {
                    String expression = (String)((DummyObject)doAttribute).getProperty("msprop:ComputedColumnExpression");
                    if (expression != null && !level.hasCalculatedAttribute(columnID2, expression.trim())) {
                        CalculatedAttribute calcAttribute = level.createCalculatedAttribute();
                        calcAttribute.setName(columnID2);
                        calcAttribute.setFunction(expression.trim());
                        level.addCalculatedAttribute(calcAttribute);
                    }
                } else if (object2 == null) {
                    importLog.addWarning("Entity: " + tableID2 + " Not Found", true);
                } else {
                    if (level.getLevelEntity() == null) {
                        level.setLevelEntity(object2);
                    } else if (level.getLevelEntity() != object2) {
                        importLog.addWarning("ValueColumn Entity: " + tableID2 + " is differ from Level Entity: " + level.getLevelEntity().getName(), true);
                        return;
                    }
                    ContainedObject attribute = object2.getElementByName(columnID2);
                    if (attribute != null) {
                        if (level.getSlowChangingAttribute(attribute, attribute.getName()) == null) {
                            SlowChangingAttribute scAttribute = new SlowChangingAttribute(level, attribute);
                            level.addDescriptiveAttribute(scAttribute);
                        }
                        level.setValueColumn(attribute);
                    } else {
                        importLog.addWarning("Entity Attribute: " + columnID2 + " Not Found", true);
                    }
                }
            }
            List list = this.getAttributeRelationships(attributeElm);
            for (Element arElm : list) {
                ContainedObject attribute;
                ContainerObject object3;
                String columnID3;
                String tableID3;
                String attributeID = this.getElementValue(arElm, "AttributeID");
                Element attrElm = (Element)aMap.get(attributeID);
                if (attrElm == null) continue;
                List kcList = this.getKeyColumns(attrElm);
                for (Element keyColumnElm : kcList) {
                    String expression;
                    DummyObject doAttribute;
                    ContainedObject attribute2;
                    tableID3 = this.getElementValue(keyColumnElm, "TableID");
                    columnID3 = this.getElementValue(keyColumnElm, "ColumnID");
                    object3 = (ContainerObject)this.handledObjects.get(tableID3);
                    if (object3 == null) {
                        importLog.addWarning("Entity: " + tableID3 + " Not Found", true);
                        continue;
                    }
                    if (level.getLevelEntity() == null) {
                        level.setLevelEntity(object3);
                    }
                    if ((attribute2 = level.getLevelEntity().getElementByName(columnID3)) != null) {
                        if (level.getSlowChangingAttribute(attribute2, attribute2.getName()) != null) continue;
                        SlowChangingAttribute scAttribute = new SlowChangingAttribute(level, attribute2);
                        level.addDescriptiveAttribute(scAttribute);
                        continue;
                    }
                    if (this.handledObjects.get(tableID3 + ":" + columnID3) == null || !(this.handledObjects.get(tableID3 + ":" + columnID3) instanceof DummyObject) || (doAttribute = (DummyObject)this.handledObjects.get(tableID3 + ":" + columnID3)) == null || !doAttribute.hasProperty("msprop:IsLogical") || (expression = (String)doAttribute.getProperty("msprop:ComputedColumnExpression")) == null || level.hasCalculatedAttribute(columnID3, expression)) continue;
                    CalculatedAttribute calcAttribute = level.createCalculatedAttribute();
                    calcAttribute.setName(columnID3);
                    calcAttribute.setFunction(expression.trim());
                    level.addCalculatedAttribute(calcAttribute);
                }
                Element nameElm = this.getNameColumn(attrElm);
                if (nameElm == null) continue;
                tableID3 = this.getElementValue(nameElm, "TableID");
                columnID3 = this.getElementValue(nameElm, "ColumnID");
                object3 = (ContainerObject)this.handledObjects.get(tableID3);
                Object doAttribute = this.handledObjects.get(tableID3 + ":" + columnID3);
                if (doAttribute != null && doAttribute instanceof DummyObject && ((DummyObject)doAttribute).hasProperty("msprop:IsLogical")) {
                    String expression = (String)((DummyObject)doAttribute).getProperty("msprop:ComputedColumnExpression");
                    if (expression == null || level.hasCalculatedAttribute(columnID3, expression.trim())) continue;
                    CalculatedAttribute calcAttribute = level.createCalculatedAttribute();
                    calcAttribute.setName(columnID3);
                    calcAttribute.setFunction(expression.trim());
                    level.addCalculatedAttribute(calcAttribute);
                    continue;
                }
                if (object3 == null) {
                    importLog.addWarning("Entity: " + tableID3 + " Not Found", true);
                    continue;
                }
                if (level.getLevelEntity() == null) {
                    level.setLevelEntity(object3);
                } else if (level.getLevelEntity() != object3) break;
                if ((attribute = level.getLevelEntity().getElementByName(columnID3)) == null || level.getSlowChangingAttribute(attribute, attribute.getName()) != null) continue;
                SlowChangingAttribute scAttribute = new SlowChangingAttribute(level, attribute);
                level.addDescriptiveAttribute(scAttribute);
            }
        } else {
            importLog.addWarning("Attribute: " + attributeElm + " Not Found", true);
        }
    }

    private Element getNameColumn(Element element) {
        NodeList nodeList = element.getElementsByTagName("NameColumn");
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private Element getValueColumn(Element element) {
        NodeList nodeList = element.getElementsByTagName("ValueColumn");
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private List getKeyColumns(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("KeyColumns");
        if (nodeList.getLength() > 0) {
            Element keyColumnsElm = (Element)nodeList.item(0);
            NodeList keyColumnList = keyColumnsElm.getElementsByTagName("KeyColumn");
            for (int i = 0; i < keyColumnList.getLength(); ++i) {
                Element elm = (Element)keyColumnList.item(i);
                result.add(elm);
            }
        }
        return result;
    }

    private List getAttributeRelationships(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("AttributeRelationships");
        if (nodeList.getLength() > 0) {
            Element arsElm = (Element)nodeList.item(0);
            NodeList arList = arsElm.getElementsByTagName("AttributeRelationship");
            for (int i = 0; i < arList.getLength(); ++i) {
                Element elm = (Element)arList.item(i);
                result.add(elm);
            }
        }
        return result;
    }

    private List getDimensionAttributes(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("Attributes");
        if (nodeList.getLength() > 0) {
            Element attributesElm = (Element)nodeList.item(0);
            NodeList attributeList = attributesElm.getElementsByTagName("Attribute");
            for (int i = 0; i < attributeList.getLength(); ++i) {
                Element elm = (Element)attributeList.item(i);
                result.add(elm);
            }
        }
        return result;
    }

    private String getAttributeIDByUsage(Element element, String usage) {
        NodeList nodeList = element.getElementsByTagName("Attributes");
        if (nodeList.getLength() > 0) {
            Element attributesElm = (Element)nodeList.item(0);
            NodeList attributeList = attributesElm.getElementsByTagName("Attribute");
            for (int i = 0; i < attributeList.getLength(); ++i) {
                Element elm = (Element)attributeList.item(i);
                String usageStr = this.getElementValue(elm, "Usage");
                if (usageStr == null || !usage.equalsIgnoreCase(usageStr)) continue;
                return this.getElementValue(elm, "ID");
            }
        }
        return null;
    }

    private Level getKeyLevel(String keyID, List hierachies, String dimID, ImportLogger importLog, Map aMap) {
        for (Element hierarchyElm : hierachies) {
            List levelList = this.getHierachyLevels(hierarchyElm);
            for (int i = 0; i < levelList.size(); ++i) {
                Element levelElm = (Element)levelList.get(i);
                String levelName = this.getElementValue(levelElm, "Name");
                String sourceAttributeID = this.getElementValue(levelElm, "SourceAttributeID");
                if (!keyID.equalsIgnoreCase(sourceAttributeID)) continue;
                Level level = this.design.getMultidimensionalDesign().createLevel();
                level.setName(levelName);
                this.addToHandledObjects(this.generateUniqueID(keyID, aMap), level);
                this.initLevelAttributes(level, sourceAttributeID, aMap, importLog);
                return level;
            }
        }
        return null;
    }

    private List getDimensionHierachies(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("Hierarchies");
        if (nodeList.getLength() > 0) {
            Element hierarchiesElm = (Element)nodeList.item(0);
            NodeList hierarchyList = hierarchiesElm.getElementsByTagName("Hierarchy");
            for (int i = 0; i < hierarchyList.getLength(); ++i) {
                Element elm = (Element)hierarchyList.item(i);
                result.add(elm);
            }
        }
        return result;
    }

    private List getHierachyLevels(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("Levels");
        if (nodeList.getLength() > 0) {
            Element levelsElm = (Element)nodeList.item(0);
            NodeList levelList = levelsElm.getElementsByTagName("Level");
            for (int i = 0; i < levelList.getLength(); ++i) {
                Element elm = (Element)levelList.item(i);
                result.add(elm);
            }
        }
        return result;
    }

    private void parseCubes(Element element, ImportLogger importLog) {
        NodeList nodeList = element.getElementsByTagName("Cubes");
        if (nodeList.getLength() > 0) {
            Element cubesElm = (Element)nodeList.item(0);
            NodeList cubeList = cubesElm.getElementsByTagName("Cube");
            int length = cubeList.getLength();
            for (int i = 0; i < length; ++i) {
                Element cubeElm = (Element)cubeList.item(i);
                this.parseCube(cubeElm, importLog);
            }
        }
    }

    private void parseCube(Element element, ImportLogger importLog) {
        List dimList = this.getDimensionsElements(element);
        List mgList = this.getMeasureGroupElements(element);
        for (int i = 0; i < mgList.size(); ++i) {
            Element mgElm = (Element)mgList.get(i);
            this.parseMeasureGroup(mgElm, dimList, importLog);
        }
    }

    private boolean isRowBindingCube(Element element) {
        boolean result = true;
        List measureList = this.getMeasuresElements(element);
        for (Element measureElm : measureList) {
            result = result && this.isRowBindingMeasure(measureElm);
        }
        return result && measureList.size() > 0;
    }

    private boolean isRowBindingMeasure(Element element) {
        NodeList nodeList = element.getElementsByTagName("Source");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String type;
            Element elm = (Element)nodeList.item(i);
            if (!elm.hasAttribute("xsi:type") || !"RowBinding".equalsIgnoreCase(type = elm.getAttribute("xsi:type"))) continue;
            return true;
        }
        return false;
    }

    private boolean isLinkedCube(Element element) {
        NodeList nodeList = element.getElementsByTagName("Source");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elm = (Element)nodeList.item(i);
            if (elm.getParentNode() != element) continue;
            return true;
        }
        return false;
    }

    private void parseMeasureGroup(Element element, List dimensionsList, ImportLogger importLog) {
        String mgID = this.getElementValue(element, "ID");
        String mgName = this.getElementValue(element, "Name");
        if (this.isLinkedCube(element) || this.isRowBindingCube(element)) {
            return;
        }
        Cube cube = (Cube)this.handledObjects.get("MeasureGroup:" + mgID);
        if (cube == null && (cube = (Cube)this.design.getMultidimensionalDesign().getCubeSet().getByName(mgName)) == null) {
            cube = this.design.getMultidimensionalDesign().createCube();
            cube.setName(mgName);
            this.addToHandledObjects("MeasureGroup:" + mgID, cube);
        }
        List measureList = this.getMeasuresElements(element);
        for (Element measureElm : measureList) {
            String measureName = this.getElementValue(measureElm, "Name");
            String aggregateFunction = this.getElementValue(measureElm, "AggregateFunction");
            if (cube.getMeasureByName(measureName) != null) continue;
            Measure measure = this.design.getMultidimensionalDesign().createMeasure();
            measure.setName(measureName);
            cube.addMeasure(measure);
            String function = "SUM";
            if (aggregateFunction != null) {
                function = aggregateFunction;
            }
            Measure.AggregateFunction af = measure.createAggregateFunction(function);
            measure.addAggregateFunction(af);
            measure.setDefaultAggregationFunction(af);
            String tableID = this.getElementValue(measureElm, "TableID");
            String columnID = this.getElementValue(measureElm, "ColumnID");
            if (tableID == null || columnID == null) continue;
            ContainerObject object = (ContainerObject)this.handledObjects.get(tableID);
            if (object == null) {
                importLog.addWarning("Entity: " + tableID + " Not Found", true);
                continue;
            }
            cube.addFactEntity(object);
            ContainedObject attribute = object.getElementByName(columnID);
            if (attribute != null) {
                measure.setMeasureFact(attribute);
                continue;
            }
            DummyObject doAttribute = (DummyObject)this.handledObjects.get(tableID + ":" + columnID);
            if (doAttribute != null) {
                String expression = (String)doAttribute.getProperty("msprop:ComputedColumnExpression");
                if (expression == null) continue;
                measure.setFormula(true);
                measure.setCustomFormula(true);
                measure.setFormula(expression);
                measure.setOracleAWFormulaType(Measure.MS_COMPUTED_FORMULA);
                continue;
            }
            importLog.addWarning("Entity Attribute: " + columnID + " Not Found", true);
        }
        List dimList = this.getDimensionsElements(element);
        for (Element dimElm : dimList) {
            List list;
            Element aElm;
            oracle.dbtools.crest.model.design.multidimensional.Dimension icDim;
            List list2;
            Element aElm2;
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension;
            DummyObject doDimension;
            String cubeDimID = this.getElementValue(dimElm, "CubeDimensionID");
            String dimType = dimElm.getAttribute("xsi:type");
            if (dimType.equalsIgnoreCase("RegularMeasureGroupDimension")) {
                doDimension = this.getDimension(cubeDimID, dimensionsList);
                if (doDimension == null) continue;
                dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)doDimension.getProperty("Dimension");
                AbstractMDTV tv1 = (AbstractMDTV)cube.getTopView();
                AbstractMDTV tv2 = (AbstractMDTV)dimension.getTopView();
                if (tv1 == null || tv2 == null) continue;
                String lname = cube.getName() + "-" + dimension.getName() + "." + doDimension.getName();
                if (this.design.getMultidimensionalDesign().getRollupLinkSet().getByName(lname) != null) continue;
                Link link = this.design.getMultidimensionalDesign().createLink();
                link.setSourceTV(tv1);
                link.setTargetTV(tv2);
                ((TVLink)link.getTopView()).addConnection();
                if (doDimension.getName() == null || "".equalsIgnoreCase(doDimension.getName()) || link.getRollupLink() == null) continue;
                link.getRollupLink().setName(cube.getName() + "-" + dimension.getName() + "." + doDimension.getName());
                ContainedObject attribute = this.getGranularityAttribute(dimElm, importLog);
                if (attribute == null) continue;
                link.getRollupLink().addChildToParentAttribute(attribute);
                continue;
            }
            if (!dimType.equalsIgnoreCase("ReferenceMeasureGroupDimension") || (doDimension = this.getDimension(cubeDimID, dimensionsList)) == null) continue;
            dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)doDimension.getProperty("Dimension");
            Level sourceLevel = null;
            Level targetLevel = null;
            String attributeID = this.getGranularityAttributeID(dimElm);
            if (attributeID != null && (aElm2 = (Element)this.dimensionAttributes.get(cubeDimID + ":" + attributeID)) != null && (list2 = this.getKeyColumns(aElm2)).size() > 0) {
                Element keyElm = (Element)list2.get(0);
                String tableID = this.getElementValue(keyElm, "TableID");
                String columnID = this.getElementValue(keyElm, "ColumnID");
                if (tableID != null && columnID != null) {
                    ContainerObject object = (ContainerObject)this.handledObjects.get(tableID);
                    if (object == null) {
                        importLog.addWarning("Entity/View: " + tableID + " Not Found", true);
                    } else {
                        ContainedObject attribute = object.getElementByName(columnID);
                        if (attribute != null) {
                            targetLevel = this.getLevelForAttribute(dimension, attribute);
                        } else {
                            importLog.addWarning("Entity/View Attribute: " + columnID + " Not Found", true);
                        }
                    }
                }
            }
            if (targetLevel == null) continue;
            String intermediateCubeDimensionID = this.getElementValue(dimElm, "IntermediateCubeDimensionID");
            String intermediateGranularityAttributeID = this.getElementValue(dimElm, "IntermediateGranularityAttributeID");
            if (intermediateCubeDimensionID == null || intermediateGranularityAttributeID == null || (icDim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.handledObjects.get(intermediateCubeDimensionID)) == null || (aElm = (Element)this.dimensionAttributes.get(intermediateCubeDimensionID + ":" + intermediateGranularityAttributeID)) == null || (list = this.getKeyColumns(aElm)).size() <= 0) continue;
            Element keyElm = (Element)list.get(0);
            String tableID = this.getElementValue(keyElm, "TableID");
            String columnID = this.getElementValue(keyElm, "ColumnID");
            if (tableID == null || columnID == null) continue;
            ContainerObject object = (ContainerObject)this.handledObjects.get(tableID);
            if (object == null) {
                importLog.addWarning("Entity/View: " + tableID + " Not Found", true);
                continue;
            }
            ContainedObject attribute = object.getElementByName(columnID);
            if (attribute != null) {
                sourceLevel = this.getLevelForAttribute(icDim, attribute);
                if (sourceLevel == null || sourceLevel.getFirstLinkToTarget(targetLevel) != null) continue;
                AbstractMDTV tv1 = (AbstractMDTV)sourceLevel.getTopView();
                AbstractMDTV tv2 = (AbstractMDTV)targetLevel.getTopView();
                Link link = this.design.getMultidimensionalDesign().createLink();
                link.setSourceTV(tv1);
                link.setTargetTV(tv2);
                ((TVLink)link.getTopView()).addConnection();
                if (link.getRollupLink() == null) continue;
                link.getRollupLink().addChildToParentAttribute(attribute);
                continue;
            }
            importLog.addWarning("Entity/View Attribute: " + columnID + " Not Found", true);
        }
    }

    private Level getLevelForAttribute(oracle.dbtools.crest.model.design.multidimensional.Dimension dim, ContainedObject attribute) {
        for (Level level : dim.getAllLevels()) {
            ArrayList list = new ArrayList();
            list.addAll(level.getLevelKey());
            list.addAll(level.getDescriptiveAttributes());
            if (!list.contains(attribute)) continue;
            return level;
        }
        return null;
    }

    private String getGranularityAttributeID(Element dimElm) {
        List dimAttributes = this.getDimensionAttributes(dimElm);
        for (Element aElm : dimAttributes) {
            String type = this.getElementValue(aElm, "Type");
            if (type == null || !"Granularity".equalsIgnoreCase(type)) continue;
            return this.getElementValue(aElm, "AttributeID");
        }
        return null;
    }

    private ContainedObject getGranularityAttribute(Element dimElm, ImportLogger importLog) {
        List dimAttributes = this.getDimensionAttributes(dimElm);
        for (Element aElm : dimAttributes) {
            List keyColList;
            String type = this.getElementValue(aElm, "Type");
            if (type == null || !"Granularity".equalsIgnoreCase(type) || (keyColList = this.getKeyColumns(aElm)).size() <= 0) continue;
            Element keyColumn = (Element)keyColList.get(0);
            String tableID = this.getElementValue(keyColumn, "TableID");
            String columnID = this.getElementValue(keyColumn, "ColumnID");
            if (tableID == null || columnID == null) continue;
            ContainerObject object = (ContainerObject)this.handledObjects.get(tableID);
            if (object == null) {
                importLog.addWarning("Entity/View: " + tableID + " Not Found", true);
                continue;
            }
            ContainedObject attribute = object.getElementByName(columnID);
            if (attribute != null) {
                return attribute;
            }
            importLog.addWarning("Entity/View Attribute: " + columnID + " Not Found", true);
        }
        return null;
    }

    private DummyObject getDimension(String cubeDimID, List dimList) {
        for (Element dimElm : dimList) {
            String dimID = this.getElementValue(dimElm, "ID");
            if (!cubeDimID.equals(dimID)) continue;
            String dimensionID = this.getElementValue(dimElm, "DimensionID");
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)this.handledObjects.get(dimensionID);
            DummyObject doDimension = new DummyObject(this.getElementValue(dimElm, "Name", true));
            doDimension.setProperty("Dimension", dimension);
            return doDimension;
        }
        return null;
    }

    private List getDimensionsElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("Dimensions");
        if (nodeList.getLength() > 0) {
            Element dimensionsElm = (Element)nodeList.item(0);
            NodeList dimensionList = dimensionsElm.getElementsByTagName("Dimension");
            for (int i = 0; i < dimensionList.getLength(); ++i) {
                Element dimElm = (Element)dimensionList.item(i);
                result.add(dimElm);
            }
        }
        return result;
    }

    private List getMeasuresElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("Measures");
        if (nodeList.getLength() > 0) {
            Element measuresElm = (Element)nodeList.item(0);
            NodeList measureList = measuresElm.getElementsByTagName("Measure");
            for (int i = 0; i < measureList.getLength(); ++i) {
                Element measureElm = (Element)measureList.item(i);
                result.add(measureElm);
            }
        }
        return result;
    }

    private List getMeasureGroupElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName("MeasureGroups");
        if (nodeList.getLength() > 0) {
            Element mgsElm = (Element)nodeList.item(0);
            NodeList mgList = mgsElm.getElementsByTagName("MeasureGroup");
            for (int i = 0; i < mgList.getLength(); ++i) {
                Element mgElm = (Element)mgList.item(i);
                result.add(mgElm);
            }
        }
        return result;
    }

    private class DummyObject {
        Map map = new TreeMap();
        String name = "";

        public DummyObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setProperty(Object key, Object value) {
            this.map.put(key, value);
        }

        public Object getProperty(Object key) {
            return this.map.get(key);
        }

        public boolean hasProperty(Object key) {
            return this.map.containsKey(key);
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                XMLAHandler.this.design.closeAllDiagrams();
                ImportLogger importLog = new ImportLogger();
                try {
                    XMLAHandler.this.monitor = new ProgressDialog(XMLAHandler.this.appView, "", 0, 100);
                    try {
                        try {
                            XMLAHandler.this.monitor.setNote(Messages.getString("XMLAHandler.ParseFile"));
                            XMLAHandler.this.monitor.setProgress(10);
                            XMLAHandler.this.parseFile(XMLAHandler.this.currentFile, importLog);
                            try {
                                XMLAHandler.this.monitor.setNote(Messages.getString("XMLAHandler.RearrangeLogicalModel"));
                                XMLAHandler.this.monitor.setProgress(80);
                                XMLAHandler.this.design.getLogicalDesign().rearrangeEntities();
                                XMLAHandler.this.design.getLogicalDesign().rearrangeViews();
                                XMLAHandler.this.monitor.setNote(Messages.getString("XMLAHandler.RearrangeMultidimentionalModel"));
                                XMLAHandler.this.monitor.setProgress(90);
                                ((DPVMultidimensional)XMLAHandler.this.design.getMultidimensionalDesign().getMainView()).rearrangeDiagram(true);
                                XMLAHandler.this.monitor.setNote(Messages.getString("XMLAHandler.GenerateMultidimentionalModelCompactDiagram"));
                                XMLAHandler.this.monitor.setProgress(95);
                                XMLAHandler.this.design.getMultidimensionalDesign().getCompactDiagram().generateDiagram();
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to rearrange Layout", e);
                            }
                            XMLAHandler.this.monitor.setProgress(100);
                            if (XMLAHandler.this.inExistingDesign) {
                                XMLAHandler.this.appView.getCurrentDesign().setDesignPath(XMLAHandler.this.oldDesignPath);
                            } else {
                                XMLAHandler.this.appView.getCurrentDesign().setDesignPath("");
                            }
                            XMLAHandler.this.appView.synchronizeTitle();
                            System.gc();
                        }
                        finally {
                            XMLAHandler.this.appView.setImporting(false);
                        }
                    }
                    finally {
                        XMLAHandler.this.monitor.close();
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            XMLAHandler.this.design.getLogicalDesign().setMainViewVisible(true);
                            XMLAHandler.this.design.getRelationalDesign().setMainViewVisible(true);
                            XMLAHandler.this.design.getMultidimensionalDesign().setMainViewVisible(true);
                            XMLAHandler.this.appView.centerDesign();
                            XMLAHandler.this.design.getMultidimensionalDesign().getMainView().centerDesign();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (XMLAHandler.this.appView.getSettings().showImportLog()) {
                    LogReport logPanel = new LogReport(XMLAHandler.this.appView);
                    logPanel.setLog(importLog.generateReport(XMLAHandler.this.appView));
                    logPanel.showDialog(new Dimension(750, 550));
                }
            }
            catch (Exception e) {
                XMLAHandler.this.design.destroyAll(false);
                XMLAHandler.this.design = null;
                LOGGER.error("Error Parsing File: " + XMLAHandler.this.designName, e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("XMLAHandler.UnableToImportTheFile"), Messages.getString("XMLAHandler.ErrorImportingFile"), 0);
            }
        }
    }
}

