/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.ChangeRequestPropertiesDialog;

public class ChangeRequest
extends DesignObject {
    private String reason = "";
    private String status = STATUS_STATES_INTERNAL[0];
    private boolean completed = false;
    private String requestDate = "";
    private String completionDate = "";
    private String implDescription = "";
    public static final String[] STATUS_STATES_DISPLAY = new String[]{Messages.getString("ChangeRequest.Proposed"), Messages.getString("ChangeRequest.Agreed"), Messages.getString("ChangeRequest.Implemented"), Messages.getString("ChangeRequest.Implementing"), Messages.getString("ChangeRequest.Rejected")};
    public static final String[] STATUS_STATES_INTERNAL = new String[]{"Proposed", "Agreed", "Implemented", "Implementing", "Rejected"};
    private static Set statusSet = null;
    private ArrayList objects;
    public static final String TYPE_NAME = "ChangeRequest";

    public ChangeRequest(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ChangeRequestPropertiesDialog dialog = new ChangeRequestPropertiesDialog(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    private boolean checkStatus(String value) {
        if (statusSet == null) {
            statusSet = new HashSet();
            statusSet.addAll(Arrays.asList(STATUS_STATES_INTERNAL));
        }
        return statusSet.contains(value);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(String completionDate) {
        if (completionDate != null && completionDate.equals(this.completionDate)) {
            return;
        }
        this.completionDate = completionDate;
    }

    public String getImplDescription() {
        return this.implDescription;
    }

    public void setImplDescription(String implDescription) {
        if (implDescription != null && implDescription.equals(this.implDescription)) {
            return;
        }
        this.implDescription = implDescription;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        if (reason != null && reason.equals(this.reason)) {
            return;
        }
        this.reason = reason;
    }

    public String getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(String requestDate) {
        if (requestDate != null && requestDate.equals(this.requestDate)) {
            return;
        }
        this.requestDate = requestDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        if (status != null && status.equals(this.status)) {
            return;
        }
        if (this.checkStatus(status)) {
            this.status = status;
        }
    }

    public ArrayList getObjects() {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        return this.objects;
    }

    public void addObject(DesignObject object) {
        if (!object.isBackup() && !this.getObjects().contains(object)) {
            this.getObjects().add(object);
        }
    }

    public void removeObject(DesignObject object) {
        this.getObjects().remove(object);
    }

    public void setObject(DesignObject obj) {
        if (!obj.isBackup() && !this.getObjects().contains(obj)) {
            this.getObjects().add(obj);
        }
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "changerequest/" + this.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

