/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.awt.Color;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.util.GUID;

public class ClassificationType {
    private String typeName;
    private Color typeColor;
    private String typeID = "";
    private boolean readOnly = false;
    private String typePrefix;
    public static final String TYPE_FACT_ID = "1";
    public static final String TYPE_DIMENSION_ID = "2";
    public static final String TYPE_LOGGING_ID = "3";
    public static final String TYPE_SUMMARY_ID = "4";
    public static final String TYPE_TEMPORARY_ID = "5";

    public String getTypePrefix() {
        return this.typePrefix;
    }

    public void setTypePrefix(String typePrefix) {
        this.typePrefix = typePrefix;
    }

    public ClassificationType(String name, Color color, String prefix) {
        this.typeName = name;
        this.typeColor = color;
        this.typeID = new GUID().toString();
        this.typePrefix = prefix;
    }

    public ClassificationType(String name, Color color, String id, String prefix) {
        this.typeName = name;
        this.typeColor = color;
        this.typeID = id;
        this.typePrefix = prefix;
    }

    public ClassificationType(String name, Color color, String id, boolean readOnly, String prefix) {
        this(name, color, id, prefix);
        this.readOnly = readOnly;
    }

    public String getTypeName() {
        if (this.typeID.equals(TYPE_FACT_ID)) {
            return ContainerObject.TYPE_FACT;
        }
        if (this.typeID.equals(TYPE_DIMENSION_ID)) {
            return ContainerObject.TYPE_DIMENSION;
        }
        if (this.typeID.equals(TYPE_LOGGING_ID)) {
            return ContainerObject.TYPE_LOGGING;
        }
        if (this.typeID.equals(TYPE_SUMMARY_ID)) {
            return ContainerObject.TYPE_SUMMARY;
        }
        if (this.typeID.equals(TYPE_TEMPORARY_ID)) {
            return ContainerObject.TYPE_TEMPORARY;
        }
        return this.typeName;
    }

    public void setTypeName(String newName) {
        this.typeName = newName;
    }

    public Color getTypeColor() {
        return this.typeColor;
    }

    public void setTypeColor(Color newColor) {
        this.typeColor = newColor;
    }

    public ClassificationType copy() {
        return new ClassificationType(this.typeName, this.typeColor, this.typeID, this.readOnly, this.typePrefix);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public void setTypeID(String id) {
        this.typeID = id;
    }

    public String toString() {
        return this.getTypeName();
    }

    public boolean equalID(String id) {
        return this.getTypeID().equalsIgnoreCase(id);
    }
}

