/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;

public class NameSpaceController
implements ModelObjectSetListener {
    protected Map names = new TreeMap();
    boolean caseSensitive = false;
    ElementSet set;

    public NameSpaceController(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public NameSpaceController() {
    }

    public void addElementSet(ElementSet set) {
        this.set = set;
        this.initNames(set);
    }

    void initNames(ElementSet set) {
        this.names.clear();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            this.addObject(obj);
        }
        if (set instanceof ModelObjectSet) {
            ((ModelObjectSet)set).addSetListener(this);
        }
    }

    void addObject(Object obj) {
        if (obj instanceof ModelObject) {
            String name = ((ModelIDObject)obj).getLongName();
            if (!this.caseSensitive) {
                this.names.put(name.toUpperCase(), obj);
            } else {
                this.names.put(name, obj);
            }
        } else {
            this.names.put(obj.toString(), obj);
        }
    }

    public String getValidName(ModelObject obj, String name) {
        String newName;
        Object ex_obj;
        String oldName = obj.getName();
        String longName = obj.getLongName();
        int ind = longName.indexOf(oldName);
        String prefix = "";
        if (ind > 0) {
            prefix = longName.substring(0, ind);
        }
        if ((ex_obj = this.names.get(newName = prefix + name)) == null || ex_obj == obj) {
            return name;
        }
        newName = this.createNameVariant(newName);
        if (ind > 0) {
            return newName.substring(ind);
        }
        return newName;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
    }

    public String createNameVariant(String name) {
        StringBuffer buffer = new StringBuffer(name);
        String newName = name;
        buffer.append(this.getVariantSeparator());
        int length = buffer.length();
        for (int i = 1; i <= this.names.size(); ++i) {
            buffer.setLength(length);
            buffer.append(i);
            newName = buffer.toString();
            if (this.names.containsKey(newName.toUpperCase())) continue;
            return newName;
        }
        return newName;
    }

    protected String getSeparator() {
        return "_";
    }

    protected String getVariantSeparator() {
        return "v";
    }
}

