/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

public class ObjectChangeEvent {
    public static final ObjectChangeEvent NAME_CHANGED = new ObjectChangeEvent("Name changed");
    public static final ObjectChangeEvent DESIGN_OBJECT_NAME_CHANGED = new ObjectChangeEvent("Design Object Name Changed");
    public static final ObjectChangeEvent CONNECTION_ADDED = new ObjectChangeEvent("Relation.Connection added");
    public static final ObjectChangeEvent CONNECTION_REMOVED = new ObjectChangeEvent("Relation.Connection removed");
    public static final ObjectChangeEvent ENTITY_IN_RELATION_REMOVED = new ObjectChangeEvent("Entity in relation removed");
    public static final ObjectChangeEvent RELATION_ENDPOINT_CHANGED = new ObjectChangeEvent("Relation end point changed");
    public static final ObjectChangeEvent RELATION_OPTIONALITY_CHANGED = new ObjectChangeEvent("Relation optionality changed");
    public static final ObjectChangeEvent RELATION_CARDINALITY_CHANGED = new ObjectChangeEvent("Relation cardinality changed");
    public static final ObjectChangeEvent NULLS_ALLOWED_CHANGED = new ObjectChangeEvent("Nulls allowed changed");
    public static final ObjectChangeEvent ATTRIBUTE_DOMAIN_CHANGED = new ObjectChangeEvent("Attribute domain changed");
    public static final ObjectChangeEvent ROOT_CHANGED = new ObjectChangeEvent("Root changed");
    public static final ObjectChangeEvent CHANGER_CHANGED = new ObjectChangeEvent("Changer changed");
    public static final ObjectChangeEvent PK_CHANGED = new ObjectChangeEvent("Primary key changed");
    public static final ObjectChangeEvent PK_REMOVED = new ObjectChangeEvent("Primary key removed");
    public static final ObjectChangeEvent KEY_CHANGED_TO_PK = new ObjectChangeEvent("Key changed (became PK)");
    public static final ObjectChangeEvent KEY_CHANGED_NO_PK = new ObjectChangeEvent("Key changed (No longer PK)");
    public static final ObjectChangeEvent KEY_CHANGED_TO_UNIQUE = new ObjectChangeEvent("Key changed (became Unique)");
    public static final ObjectChangeEvent KEY_CHANGED_NO_UNIQUE = new ObjectChangeEvent("Key changed (No longer Unique");
    public static final ObjectChangeEvent DOMAIN_CHANGED = new ObjectChangeEvent("Domain changed");
    public static final ObjectChangeEvent HIERARCHICAL_PARENT_CHANGED = new ObjectChangeEvent("Hierarchical parent changed");
    public static final ObjectChangeEvent OBJECT_REMOVED = new ObjectChangeEvent("Object has been removed from model");
    public static final ObjectChangeEvent ELEMENT_ADDED = new ObjectChangeEvent("Element has been added");
    public static final ObjectChangeEvent ELEMENT_REMOVED = new ObjectChangeEvent("Element has been removed");
    public static final ObjectChangeEvent ADD_FK = new ObjectChangeEvent("Foreign Key added");
    public static final ObjectChangeEvent FKINDEX_ADDED = new ObjectChangeEvent("Foreign Key Index  added");
    public static final ObjectChangeEvent FKINDEX_REMOVED = new ObjectChangeEvent("Foreign Key Index  removed");
    public static final ObjectChangeEvent TOPVIEW_REMOVED = new ObjectChangeEvent("TopView Synonim  removed");
    public static final ObjectChangeEvent LOGICALDATATYPE_CHANGED = new ObjectChangeEvent("LogicalDatatype changed");
    public static final ObjectChangeEvent TRANSFORMATIONTASK_ADDED = new ObjectChangeEvent("Transformation Task Added");
    public static final ObjectChangeEvent TRANSFORMATIONTASK_REMOVED = new ObjectChangeEvent("Transformation Task Removed");
    public static final ObjectChangeEvent PARENTFOLDER_CHANGED = new ObjectChangeEvent("Parent Folder Changed");
    public static final ObjectChangeEvent PROCESS_DECOMPOSED = new ObjectChangeEvent("Process Decomposed");
    public static final ObjectChangeEvent PREDEFINED_STATUS_CHANGED = new ObjectChangeEvent("Predefined status changed");
    public static final ObjectChangeEvent FK_ATTRIBUTES_CHANGED = new ObjectChangeEvent("FK Attributes changed");
    public static final ObjectChangeEvent USE_DEFAULT_CHANGED = new ObjectChangeEvent("Use default changed");
    public static final ObjectChangeEvent SCHEMA_CHANGED = new ObjectChangeEvent("Schema changed");
    public static final ObjectChangeEvent OBJECT_ID_CHANED = new ObjectChangeEvent("Object ID changed");
    private String description = "";
    private Object affected;

    public ObjectChangeEvent(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }

    public void setAffected(Object object) {
        this.affected = object;
    }

    public Object getAffected() {
        return this.affected;
    }

    public boolean isType(ObjectChangeEvent event) {
        return this.equals(event) || this.description.equalsIgnoreCase(event.getDescription());
    }

    public static void clearEvents() {
        DOMAIN_CHANGED.setAffected(null);
        NAME_CHANGED.setAffected(null);
        CONNECTION_ADDED.setAffected(null);
        CONNECTION_REMOVED.setAffected(null);
        ENTITY_IN_RELATION_REMOVED.setAffected(null);
        RELATION_ENDPOINT_CHANGED.setAffected(null);
        RELATION_OPTIONALITY_CHANGED.setAffected(null);
        RELATION_CARDINALITY_CHANGED.setAffected(null);
        NULLS_ALLOWED_CHANGED.setAffected(null);
        ATTRIBUTE_DOMAIN_CHANGED.setAffected(null);
        ROOT_CHANGED.setAffected(null);
        CHANGER_CHANGED.setAffected(null);
        PK_CHANGED.setAffected(null);
        PK_REMOVED.setAffected(null);
        KEY_CHANGED_TO_PK.setAffected(null);
        KEY_CHANGED_NO_PK.setAffected(null);
        KEY_CHANGED_TO_UNIQUE.setAffected(null);
        KEY_CHANGED_NO_UNIQUE.setAffected(null);
        HIERARCHICAL_PARENT_CHANGED.setAffected(null);
        OBJECT_REMOVED.setAffected(null);
        ELEMENT_ADDED.setAffected(null);
        ELEMENT_REMOVED.setAffected(null);
        ADD_FK.setAffected(null);
        FKINDEX_ADDED.setAffected(null);
        FKINDEX_REMOVED.setAffected(null);
        TOPVIEW_REMOVED.setAffected(null);
        LOGICALDATATYPE_CHANGED.setAffected(null);
        TRANSFORMATIONTASK_ADDED.setAffected(null);
        TRANSFORMATIONTASK_REMOVED.setAffected(null);
        PARENTFOLDER_CHANGED.setAffected(null);
        PROCESS_DECOMPOSED.setAffected(null);
        PREDEFINED_STATUS_CHANGED.setAffected(null);
        FK_ATTRIBUTES_CHANGED.setAffected(null);
        USE_DEFAULT_CHANGED.setAffected(null);
        SCHEMA_CHANGED.setAffected(null);
        OBJECT_ID_CHANED.setAffected(null);
    }
}

