/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SensitiveTypeSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.SensitiveTypePropertiesDialog;

public class SensitiveType
extends ModelIDObject {
    public static final String TYPE_NAME = "SensitiveType";
    private ApplicationView appView;
    private String description = "";
    private boolean isBeingRemoved = false;
    private SensitiveTypeSet stSet;
    private boolean removed = false;
    private boolean generateInDDL = true;
    private boolean enable = true;

    public SensitiveType(ApplicationView appView) {
        this.appView = appView;
        this.createGlobalID();
    }

    @Override
    public ApplicationView getAppView() {
        return this.appView;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getOwnerDesignName() {
        return "";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void showPropertyDialog(Design design) {
        if (!this.isDialogVisible()) {
            SensitiveTypePropertiesDialog dialog = new SensitiveTypePropertiesDialog(this.getAppView(), this, design);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void showPropertyDialog() {
        this.showPropertyDialog(null);
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public void remove() {
        if (!this.getIsBeingRemoved()) {
            this.setIsBeingRemoved(true);
            if (this.getSensitiveTypeSet() != null) {
                this.getSensitiveTypeSet().remove(this);
            }
            ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
            event.setAffected(this);
            this.fireChange(event);
            event.setAffected(null);
            this.setIsBeingRemoved(false);
            this.removed = true;
            this.closePropertiesDialog();
            this.getAppView().saveSensitiveTypes();
        }
    }

    protected void setIsBeingRemoved(boolean value) {
        this.isBeingRemoved = value;
    }

    public boolean getIsBeingRemoved() {
        return this.isBeingRemoved;
    }

    public void setSensitiveTypeSet(SensitiveTypeSet set) {
        this.stSet = set;
    }

    public SensitiveTypeSet getSensitiveTypeSet() {
        return this.stSet;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean getGenerateInDDL() {
        return this.generateInDDL;
    }

    public void setGenerateInDDL(boolean generateInDDL) {
        this.generateInDDL = generateInDDL;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

