/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.businessinfo.ContactPropertiesDialogEx;

public class BIContact
extends DesignObject {
    private List emails = new ArrayList();
    private List locations = new ArrayList();
    private List parties = new ArrayList();
    private List phones = new ArrayList();
    private List urls = new ArrayList();
    public static final String TYPE_NAME = "Contact";

    public BIContact(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ContactPropertiesDialogEx dialog = new ContactPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public List getEmails() {
        return this.emails;
    }

    public void addEmail(BIEmail email) {
        if (!this.emails.contains(email)) {
            this.emails.add(email);
            email.addContact(this);
        }
    }

    public void removeEmail(BIEmail email) {
        this.emails.remove(email);
        email.removeContact(this);
    }

    public void clearEmails() {
        for (BIEmail email : this.emails) {
            email.removeContact(this);
        }
        this.emails.clear();
    }

    public List getLocations() {
        return this.locations;
    }

    public void addLocation(BILocation location) {
        if (!this.locations.contains(location)) {
            this.locations.add(location);
            location.addContact(this);
        }
    }

    public void removeLocation(BILocation location) {
        this.locations.remove(location);
        location.removeContact(this);
    }

    public void clearLocations() {
        for (BILocation location : this.locations) {
            location.removeContact(this);
        }
        this.locations.clear();
    }

    public List getParties() {
        return this.parties;
    }

    public void addResParty(BIResponsibleParty party) {
        if (!this.parties.contains(party)) {
            this.parties.add(party);
        }
    }

    public void removeResParty(BIResponsibleParty party) {
        this.parties.remove(party);
    }

    public List getPhones() {
        return this.phones;
    }

    public void addPhone(BIPhone phone) {
        if (!this.phones.contains(phone)) {
            this.phones.add(phone);
            phone.addContact(this);
        }
    }

    public void removePhone(BIPhone phone) {
        this.phones.remove(phone);
        phone.removeContact(this);
    }

    public void clearPhones() {
        for (BIPhone phone : this.phones) {
            phone.removeContact(this);
        }
        this.phones.clear();
    }

    public List getUrls() {
        return this.urls;
    }

    public void addUrl(BIResourceLocator url) {
        if (!this.urls.contains(url)) {
            this.urls.add(url);
            url.addContact(this);
        }
    }

    public void removeUrl(BIResourceLocator url) {
        this.urls.remove(url);
        url.removeContact(this);
    }

    public void clearUrls() {
        for (BIResourceLocator url : this.urls) {
            url.removeContact(this);
        }
        this.urls.clear();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "contact/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

