/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.businessinfo.BIDocumentSet;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.editor.businessinfo.DocumentPropertiesDialogEx;

public class BIDocument
extends DesignObject {
    private String reference = "";
    private String type = "";
    private List elements = new ArrayList();
    private BIDocument parentDocument = null;
    private List subDocuments = new ArrayList();
    public static final String TYPE_NAME = "Document";

    public BIDocument(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DocumentPropertiesDialogEx dialog = new DocumentPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "Doc";
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List getElements() {
        return this.elements;
    }

    public void addElement(DesignObject element) {
        if (element instanceof Table ? ((Table)element).isBackup() : element instanceof FKIndexAssociation && ((FKIndexAssociation)element).isBackupFK()) {
            return;
        }
        if (!this.elements.contains(element) && element.getObjectID() != null) {
            DesignObject obj = this.getByID(element);
            if (obj != null) {
                this.elements.remove(obj);
            }
            this.elements.add(element);
        }
    }

    public void addElement(DesignPart element) {
        if (!this.elements.contains(element)) {
            this.elements.add(element);
        }
    }

    public void removeElement(DesignObject element) {
        this.elements.remove(element);
    }

    public BIDocument getParentDocument() {
        return this.parentDocument;
    }

    public void setParentDocument(BIDocument parent) {
        if (this.parentDocument != parent) {
            if (this.parentDocument != null) {
                this.parentDocument.removeSubDocument(this);
            }
            if (parent != null) {
                parent.addSubDocument(this);
            }
            this.parentDocument = parent;
            BIDocumentSet docSet = (BIDocumentSet)this.getParent();
            docSet.fireChange(SetEvent.STRUCTURE_CHANGED);
        }
    }

    public List getSubDocuments() {
        return this.subDocuments;
    }

    public void setSubDocuments(List subDocuments) {
        this.subDocuments = subDocuments;
    }

    public void addSubDocument(BIDocument subDocument) {
        if (!this.subDocuments.contains(subDocument)) {
            this.subDocuments.add(subDocument);
        }
    }

    public void removeSubDocument(BIDocument subDocument) {
        if (this.subDocuments.contains(subDocument)) {
            this.subDocuments.remove(subDocument);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.subDocuments.size() <= 0;
    }

    @Override
    public int getNumberOfChildren() {
        return this.subDocuments.size();
    }

    @Override
    public ModelObject getChild(int index) {
        return (BIDocument)this.subDocuments.get(index);
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        ((BIDocument)desObject).setReference(this.getReference());
        ((BIDocument)desObject).setType(this.getType());
        Iterator it = this.getElements().iterator();
        while (it.hasNext()) {
            ((BIDocument)desObject).addElement((DesignObject)it.next());
        }
    }

    private DesignObject getByID(DesignObject object) {
        for (DesignObject next : this.elements) {
            if (!next.getObjectID().equalsIgnoreCase(object.getObjectID())) continue;
            return next;
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "document/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

