/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.businessinfo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.businessinfo.LocationPropertiesDialogEx;

public class BILocation
extends DesignObject {
    private String locationType = "";
    private String address = "";
    private String city = "";
    private String postCode = "";
    private String area = "";
    private String country = "";
    private List contacts = new ArrayList();
    public static final String TYPE_NAME = "Location";

    public BILocation(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "Loc";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LocationPropertiesDialogEx dialog = new LocationPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public void setLocationType(String locationType) {
        this.locationType = locationType;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public List getContacts() {
        return this.contacts;
    }

    public void addContact(BIContact contact) {
        if (!this.contacts.contains(contact)) {
            this.contacts.add(contact);
        }
    }

    public void removeContact(BIContact contact) {
        this.contacts.remove(contact);
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        ((BILocation)desObject).setLocationType(this.getLocationType());
        ((BILocation)desObject).setAddress(this.getAddress());
        ((BILocation)desObject).setCity(this.getCity());
        ((BILocation)desObject).setPostCode(this.getPostCode());
        ((BILocation)desObject).setArea(this.getArea());
        ((BILocation)desObject).setCountry(this.getCountry());
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "location/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

