/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype;

import java.util.Arrays;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.DataTypeListener;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractDataType
implements MDDataType {
    private static final Logger LOGGER = new Logger(Token.class);

    @Override
    public String getName() {
        throw new RuntimeException("Should be overriden, getName() should return the name constant in MDDataTypeNames");
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public boolean isFlyweight() {
        return this.isImplicitSized();
    }

    @Override
    public boolean isImplicitSized() {
        return false;
    }

    @Override
    public boolean isVarSized() {
        return false;
    }

    @Override
    public boolean isPacked() {
        return false;
    }

    @Override
    public String getType() {
        if (this.isImplicitSized()) {
            return "builtin";
        }
        if (this.isFixedLength()) {
            return "fixed";
        }
        if (this.isVarSized()) {
            return "var";
        }
        if (this.isPacked()) {
            return "packed";
        }
        return "";
    }

    @Override
    public int getPrecision() {
        throw new RuntimeException("Class that is not packed type, getPrecision() invalid.");
    }

    @Override
    public void setPrecision(int precision) {
        throw new RuntimeException("Class that is not packed type, setPrecision() invalid.");
    }

    @Override
    public void setPrecisionStr(String precision) {
        throw new RuntimeException("Class that is not packed type, setPrecision() invalid.");
    }

    @Override
    public String getPrecisionStr() {
        throw new RuntimeException("Class that is not packed type, getPrecision() invalid.");
    }

    @Override
    public int getScale() {
        throw new RuntimeException("Class that is not packed type, getScale() invalid.");
    }

    @Override
    public void setScale(int scale) {
        throw new RuntimeException("Class that is not packed type, setScale() invalid.");
    }

    @Override
    public String getSize() {
        throw new RuntimeException("Should be overriden, getSize() invalid.");
    }

    @Override
    public void setSize(String size) {
        throw new RuntimeException("Should be overriden, setSize() invalid.");
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public MDDataType deepCopy() {
        if (this.isFlyweight()) {
            return this;
        }
        throw new RuntimeException("Should be overriden for non-flyweights, deepCopy() invalid.");
    }

    @Override
    public String getSQL() {
        return this.getName();
    }

    @Override
    public void appendTo(StringBuffer buffer) {
        buffer.append(this.getName());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.appendTo(buffer);
        return buffer.toString();
    }

    @Override
    public void addDataTypeListener(DataTypeListener listener) {
    }

    @Override
    public void removeDataTypeListener(DataTypeListener listener) {
    }

    @Override
    public int getByteSize() {
        return AbstractDataType.parseSize(this.getSize());
    }

    public static int parseSize(String size) {
        try {
            int intSize = -1;
            String[] setK = new String[]{"k", "K"};
            List<String> listK = Arrays.asList(setK);
            String[] setM = new String[]{"m", "M"};
            List<String> listM = Arrays.asList(setM);
            String[] setG = new String[]{"g", "G"};
            List<String> listG = Arrays.asList(setG);
            String[] setNumbers = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
            List<String> listNumbers = Arrays.asList(setNumbers);
            if (size.equalsIgnoreCase("")) {
                return 0;
            }
            if (listK.contains(size.substring(size.length() - 1))) {
                intSize = Integer.parseInt(size.substring(0, size.length() - 1));
                return intSize * 1024;
            }
            if (listM.contains(size.substring(size.length() - 1))) {
                intSize = Integer.parseInt(size.substring(0, size.length() - 1));
                return intSize * 1026;
            }
            if (listG.contains(size.substring(size.length() - 1))) {
                intSize = Integer.parseInt(size.substring(0, size.length() - 1));
                return intSize * 1027;
            }
            if (listNumbers.contains(size.substring(size.length() - 1))) {
                intSize = Integer.parseInt(size);
                return intSize;
            }
            return -1;
        }
        catch (Exception e) {
            LOGGER.error("Error in parsing datatype size", e);
            return -1;
        }
    }

    @Override
    public boolean hasPrecision() {
        return false;
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    @Override
    public boolean hasSize() {
        return false;
    }

    public String getPrecisionText() {
        return Messages.getString("AbstractDataType.NotApplicable");
    }

    public String getScaleText() {
        return Messages.getString("AbstractDataType.NotApplicable");
    }

    public String getSizeText() {
        return Messages.getString("AbstractDataType.NotApplicable");
    }
}

