/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle;

import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDVarSized;

public class MDNVarChar2Oracle
extends MDVarSized {
    @Override
    public String getMaxSize() {
        return "4000";
    }

    @Override
    public String getName() {
        return "NVARCHAR2";
    }

    @Override
    public MDDataType deepCopy() {
        MDNVarChar2Oracle copy = new MDNVarChar2Oracle();
        copy.setSize(this.getSize());
        return copy;
    }

    @Override
    public int getByteSize() {
        return AbstractDataType.parseSize(this.getSize()) + 2;
    }

    @Override
    public void appendTo(StringBuffer buffer) {
        String numeric = this.size;
        if (numeric == null || "".equalsIgnoreCase(numeric) || "0".equalsIgnoreCase(numeric) || "1".equalsIgnoreCase(numeric)) {
            buffer.append(this.getName());
        } else {
            buffer.append(this.getName());
            buffer.append(" (");
            String s = this.getSize();
            s = s.replaceFirst("max", this.getMaxSize());
            s = s.replaceFirst("MAX", this.getMaxSize());
            buffer.append(s);
            buffer.append(')');
        }
    }
}

