/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.sqlserver;

import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.MDUnknown;
import oracle.dbtools.crest.model.datatype.sqlserver.MDBigIntSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDBinarySqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDBitSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDCharSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDDateSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDDateTimeSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDDecimalSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDFloatSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDImageSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDIntSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDMoneySqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDNCharSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDNTextSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDNVarCharSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDNumericSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDRealSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDRowIDSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDSmallDateTimeSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDSmallIntSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDSmallMoneySqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDSqlVariantSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDSysNameSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDTextSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDTimestampSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDTinyIntSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDUniqueidentifierSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDVarBinarySqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDVarCharSqlServer;
import oracle.dbtools.crest.model.datatype.sqlserver.MDXMLTypeSqlServer;

public class MDDataTypeFactorySqlServer
extends MDDataTypeFactory {
    private boolean allowVarcharMax = false;

    @Override
    public MDDataType createType(String name, String size) {
        MDDataType dataType = null;
        if ("CHAR".equals(name)) {
            dataType = new MDCharSqlServer();
        } else if ("VARCHAR".equals(name)) {
            dataType = new MDVarCharSqlServer();
            ((MDVarCharSqlServer)dataType).setAllowVarcharMax(this.allowVarcharMax);
        } else if ("VARBINARY".equals(name)) {
            dataType = new MDVarBinarySqlServer();
        } else if ("NCHAR".equals(name)) {
            dataType = new MDNCharSqlServer();
        } else if ("NVARCHAR".equals(name)) {
            dataType = new MDNVarCharSqlServer();
        } else if ("BINARY".equals(name)) {
            dataType = new MDBinarySqlServer();
        } else {
            if ("DECIMAL".equals(name)) {
                dataType = new MDDecimalSqlServer();
                dataType.setPrecision(MDDataTypeFactory.stringToInt(size));
                return dataType;
            }
            if ("NUMERIC".equals(name)) {
                MDDecimalSqlServer dec = new MDDecimalSqlServer();
                dec.setNumericSynonym();
                dec.setPrecision(MDDataTypeFactory.stringToInt(size));
                return dec;
            }
            if ("FLOAT".equals(name)) {
                dataType = new MDFloatSqlServer();
                dataType.setPrecision(MDDataTypeFactory.stringToInt(size));
                return dataType;
            }
            if ("REAL".equals(name)) {
                dataType = new MDRealSqlServer();
                dataType.setPrecision(MDDataTypeFactory.stringToInt(size));
                return dataType;
            }
        }
        if (dataType == null) {
            dataType = super.createUDNativeType(name, size);
        } else {
            dataType.setSize(size);
        }
        return dataType;
    }

    @Override
    public MDDataType createType(String name, int precision, int scale) {
        if ("DECIMAL".equals(name)) {
            MDDecimalSqlServer dec = new MDDecimalSqlServer();
            dec.setPrecision(precision);
            dec.setScale(scale);
            return dec;
        }
        if ("NUMERIC".equals(name)) {
            MDDecimalSqlServer dec = new MDDecimalSqlServer();
            dec.setNumericSynonym();
            dec.setPrecision(precision);
            dec.setScale(scale);
            return dec;
        }
        return super.createUDNativeType(name, precision, scale);
    }

    @Override
    protected void initFlyWeights() {
        MDDecimalSqlServer numeric = new MDDecimalSqlServer();
        numeric.setNumericSynonym();
        this.flyweights.put("INT", new MDIntSqlServer());
        this.flyweights.put("INTEGER", new MDIntSqlServer());
        this.flyweights.put("BIGINT", new MDBigIntSqlServer());
        this.flyweights.put("UNIQUEIDENTIFIER", new MDUniqueidentifierSqlServer());
        this.flyweights.put("REAL", new MDRealSqlServer());
        this.flyweights.put("FLOAT", new MDFloatSqlServer());
        this.flyweights.put("SMALLDATETIME", new MDSmallDateTimeSqlServer());
        this.flyweights.put("TIMESTAMP", new MDTimestampSqlServer());
        this.flyweights.put("DATE", new MDDateSqlServer());
        this.flyweights.put("DATETIME", new MDDateTimeSqlServer());
        this.flyweights.put("TINYINT", new MDTinyIntSqlServer());
        this.flyweights.put("SMALLINT", new MDSmallIntSqlServer());
        this.flyweights.put("BIT", new MDBitSqlServer());
        this.flyweights.put("MONEY", new MDMoneySqlServer());
        this.flyweights.put("SMALLMONEY", new MDSmallMoneySqlServer());
        this.flyweights.put("MONEY", new MDMoneySqlServer());
        this.flyweights.put("UNKNOWN", new MDUnknown());
        MDVarCharSqlServer dt = new MDVarCharSqlServer();
        dt.setAllowVarcharMax(this.allowVarcharMax);
        this.flyweights.put("VARCHAR", dt);
        this.flyweights.put("SYSNAME", new MDSysNameSqlServer());
    }

    @Override
    protected void initHeavyWeights() {
        this.heavyweights.put("CHAR", MDCharSqlServer.class);
        this.heavyweights.put("DECIMAL", MDDecimalSqlServer.class);
        this.heavyweights.put("NUMERIC", MDNumericSqlServer.class);
        this.heavyweights.put("IMAGE", MDImageSqlServer.class);
        this.heavyweights.put("TEXT", MDTextSqlServer.class);
        this.heavyweights.put("NVARCHAR", MDNVarCharSqlServer.class);
        this.heavyweights.put("NTEXT", MDNTextSqlServer.class);
        this.heavyweights.put("BINARY", MDBinarySqlServer.class);
        this.heavyweights.put("VARBINARY", MDVarBinarySqlServer.class);
        this.heavyweights.put("SQL_VARIANT", MDSqlVariantSqlServer.class);
        this.heavyweights.put("NCHAR", MDNCharSqlServer.class);
        this.heavyweights.put("ROWID", MDRowIDSqlServer.class);
        this.heavyweights.put("XML", MDXMLTypeSqlServer.class);
    }

    @Override
    public int getMaxPrecision(String type) {
        String tupper = type.toUpperCase();
        if (tupper.startsWith("DATETIME")) {
            return 7;
        }
        if (tupper.equals("FLOAT")) {
            return 53;
        }
        return 28;
    }

    public boolean isAllowVarcharMax() {
        return this.allowVarcharMax;
    }

    public void setAllowVarcharMax(boolean allowVarcharMax) {
        this.allowVarcharMax = allowVarcharMax;
    }
}

