/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;

public abstract class AbstractViewElement
extends ContainedObject {
    private String alias = "";
    private ContainedObjectWithDomain referencedColumn;
    private String expression = "";
    private String dataType = "";
    private AbstractView view = null;
    private ContainerWithKeyObject table = null;
    private String tableAlias = "";
    private boolean reference = false;
    private ContainedObject referencedColumnView;
    private String referencedColumnViewID;
    private TypeElement typeElement;
    private String headerAlias = "";
    private String viewID;

    public AbstractViewElement(DesignPart designPart) {
        super(designPart);
    }

    public String getDataType() {
        return this.getDataType(0);
    }

    private String getDataType(int nestedLevel) {
        if (this.getReferencedColumn() != null) {
            return this.getReferencedColumn().getDatatypeString(this.getDesignPart().getSelectedRDBMSType().getName());
        }
        if (this.getReferencedColumnView() != null && nestedLevel < 10) {
            return ((AbstractViewElement)this.getReferencedColumnView()).getDataType(nestedLevel + 1);
        }
        if (this.typeElement != null) {
            return this.typeElement.getDataType(this.getDesignPart().getSelectedRDBMSType().getName());
        }
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public ContainedObjectWithDomain getReferencedColumn() {
        return this.referencedColumn;
    }

    public void setReferencedColumn(ContainedObjectWithDomain referencedColumn) {
        if (this.referencedColumn != referencedColumn) {
            if (this.referencedColumn != null) {
                this.referencedColumn.removeObjectListener(this);
            }
            this.referencedColumn = referencedColumn;
            if (referencedColumn != null) {
                referencedColumn.addObjectListener(this);
                if (this.getContainer() != null) {
                    referencedColumn.addObjectListener(this.getContainer());
                }
            }
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        String oldAlias = this.alias;
        this.alias = alias == null ? "" : alias;
        if (!oldAlias.equals(this.alias)) {
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public AbstractView getView() {
        if (this.view == null && this.viewID != null && !"".equals(this.viewID)) {
            this.view = (AbstractView)this.getDesign().getDesignObject(this.viewID);
        }
        return this.view;
    }

    public void setView(AbstractView view) {
        this.view = view;
    }

    public ContainerWithKeyObject getTable() {
        return this.table;
    }

    public void setTable(ContainerWithKeyObject table) {
        this.table = table;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias == null ? "" : tableAlias;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPresentationName());
        return buffer.toString();
    }

    public String getPresentationName(boolean hasHeader) {
        String name = this.getHeaderAlias();
        if (!hasHeader || name == null || "".equalsIgnoreCase(name)) {
            name = this.getAlias();
        }
        if (name == null || "".equalsIgnoreCase(name)) {
            name = this.getReferencedName();
        }
        if (name.startsWith("NULL SET") && !"".equals(this.getExpression())) {
            name = this.getExpression();
        }
        return name;
    }

    public String getPresentationName() {
        String name = this.getHeaderAlias();
        if (name == null || "".equalsIgnoreCase(name)) {
            name = this.getPresentationName(false);
        } else {
            boolean hasHeader = ((AbstractView)this.getContainer()).hasValidHeader();
            name = this.getPresentationName(hasHeader);
        }
        return name;
    }

    public boolean isReference() {
        return this.reference;
    }

    public void setReference(boolean reference) {
        this.reference = reference;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        if (object instanceof ContainedObject && event.isType(ObjectChangeEvent.NAME_CHANGED) && object == this.getReferencedColumn()) {
            this.setName(object.getName());
        }
    }

    public ContainedObject getReferencedColumnView() {
        ContainedObject temp;
        if (this.referencedColumnView == null && this.referencedColumnViewID != null && (temp = (ContainedObject)this.getDesign().getDesignObject(this.referencedColumnViewID)) != null) {
            this.setReferencedColumnView(temp);
        }
        return this.referencedColumnView;
    }

    public void setReferencedColumnView(ContainedObject referencedColumnView) {
        if (this.referencedColumnView != referencedColumnView) {
            if (this.referencedColumnView != null) {
                this.referencedColumnView.removeObjectListener(this);
            }
            this.referencedColumnView = referencedColumnView;
            if (referencedColumnView != null) {
                referencedColumnView.addObjectListener(this);
                if (this.getContainer() != null) {
                    referencedColumnView.addObjectListener(this.getContainer());
                }
            }
        }
    }

    public String getReferencedColumnViewID() {
        if (this.referencedColumnView != null) {
            this.referencedColumnViewID = this.referencedColumnView.getObjectID();
        }
        return this.referencedColumnViewID;
    }

    public void setReferencedColumnViewID(String referencedColumnViewID) {
        this.referencedColumnViewID = referencedColumnViewID;
    }

    public String getReferencedName() {
        if (this.getReferencedColumnView() != null) {
            AbstractViewElement el = (AbstractViewElement)this.getReferencedColumnView();
            return el.getPresentationName();
        }
        if (this.getReferencedColumn() != null) {
            return this.getReferencedColumn().getName();
        }
        if (!"".equals(this.getAlias())) {
            return this.getAlias();
        }
        return this.getName();
    }

    public ContainerObject getReferencedContainer() {
        if (this.getReferencedColumnView() != null) {
            return this.getReferencedColumnView().getContainer();
        }
        if (this.getReferencedColumn() != null) {
            return this.getReferencedColumn().getContainer();
        }
        return null;
    }

    public String getViewID() {
        if (this.view != null) {
            this.viewID = this.view.getObjectID();
        }
        return this.viewID;
    }

    public void setViewID(String viewID) {
        this.viewID = viewID;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public void setTypeElement(TypeElement typeElement) {
        this.typeElement = typeElement;
    }

    public String getHeaderAlias() {
        return this.headerAlias;
    }

    public void setHeaderAlias(String headerAlias) {
        this.headerAlias = headerAlias;
    }

    @Override
    public boolean isDeprecated() {
        if (this.referencedColumn != null) {
            return this.referencedColumn.isDeprecated();
        }
        return super.isDeprecated();
    }
}

