/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NameValidator;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;

public abstract class ContainedObject
extends DesignObject
implements LongNameObject,
ObjectListener {
    private ContainerObject container;
    private boolean nullAllowed = true;
    private boolean unique = false;
    private String constraintName;
    protected boolean useDomainConstraints = true;
    private CheckConstraint check;
    private ConstraintEnumeration valueList;
    private Set avts = new TreeSet();
    private StructuredType structuredType = null;
    private CollectionType collectionType = null;
    public static final String NLS_TYPE_MANUAL = Messages.getString("ContainedObject.Manual");
    public static final String NLS_TYPE_SYSTEM = Messages.getString("ContainedObject.System");
    public static final String NLS_TYPE_DERIVED = Messages.getString("ContainedObject.Derived");
    public static final String NLS_TYPE_AGGREGATE = Messages.getString("ContainedObject.Aggregate");
    public static final String[] SOURCE_TYPE_STATES_DISPLAY = new String[]{"", NLS_TYPE_MANUAL, NLS_TYPE_SYSTEM, NLS_TYPE_DERIVED, NLS_TYPE_AGGREGATE};
    public static final String TYPE_MANUAL = "Manual";
    public static final String TYPE_SYSTEM = "System";
    public static final String TYPE_DERIVED = "Derived";
    public static final String TYPE_AGGREGATE = "Aggregate";
    public static final String[] SOURCE_TYPE_STATES_INTERNAL = new String[]{"", "Manual", "System", "Derived", "Aggregate"};
    private static Set sourceTypeSet = null;
    private String sourceType = "";
    private String formulaDesc = "";
    private StringBuffer buffer = new StringBuffer();
    private String synonym = "";
    private String structAttributeID = "";
    private boolean oid = false;
    protected String scopeId = null;
    private List nestedObjects = new ArrayList();
    private ContainedObject parentObject;
    private int avtSortOrder = 0;
    private String referedAttribute;

    public ContainedObject(DesignPart designPart) {
        super(designPart);
        if (designPart.getDesign().getAppView() != null) {
            this.setNullsAllowed(designPart.getDesign().getAppView().getSettings().getNullsAllowed());
        }
    }

    public void setContainer(ContainerObject container) {
        if (this.isWriteable()) {
            this.container = container;
            if (container != null) {
                this.setBackup(container.isBackup());
            }
        }
    }

    public ContainerObject getContainer() {
        return this.container;
    }

    public boolean belongsTo(ContainerObject container) {
        return this.getContainer() == container;
    }

    public void setNullsAllowed(boolean allowed) {
        if (this.isWriteable() && allowed != this.nullAllowed) {
            this.nullAllowed = allowed;
            if (allowed) {
                this.unique = false;
            }
            this.fireChange(ObjectChangeEvent.NULLS_ALLOWED_CHANGED);
        }
    }

    public boolean getNullsAllowed() {
        return this.nullAllowed;
    }

    public void setUnique(boolean unique) {
        if (this.isWriteable()) {
            this.unique = unique;
        }
    }

    public String getConstraintName() {
        if (this.constraintName != null) {
            return this.constraintName;
        }
        return "";
    }

    public void setConstraintName(String name) {
        if (this.isWriteable()) {
            this.constraintName = name;
        }
    }

    public boolean getUseDomainConstraints() {
        return this.useDomainConstraints;
    }

    public void setUseDomainConstraints(boolean value) {
        if (this.isWriteable() && this.useDomainConstraints != value) {
            this.useDomainConstraints = value;
            this.fireChange(ObjectChangeEvent.ATTRIBUTE_DOMAIN_CHANGED);
        }
    }

    public CheckConstraint getCheck() {
        return this.check;
    }

    public void setCheck(CheckConstraint check) {
        if (this.isWriteable()) {
            this.check = check;
            if (check != null) {
                this.check.setDesign(this.getDesign());
            }
        }
    }

    public void addAVT(AVT avt) {
        if (!this.avts.contains(avt)) {
            this.avts.add(avt);
        }
    }

    public Set getAVTs() {
        LogicalDatatype logicalDatatype;
        if (this.avts.size() > 1 && this instanceof ContainedObjectWithDomain && (logicalDatatype = ((ContainedObjectWithDomain)this).getLogicalDatatype()) != null && logicalDatatype.isNumeric()) {
            TreeSet sortedSet = new TreeSet(new AVTNumberComparator());
            sortedSet.addAll(this.avts);
            return sortedSet;
        }
        return this.avts;
    }

    public void removeAVT(AVT avt) {
        if (this.avts.contains(avt)) {
            this.avts.remove(avt);
        }
    }

    public void clearAVTs() {
        this.avts.clear();
    }

    public ConstraintEnumeration getValueList() {
        return this.valueList;
    }

    public void setValueList(ConstraintEnumeration valueList) {
        this.valueList = valueList;
        if (valueList != null) {
            valueList.setDesign(this.getDesign());
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String getLongName() {
        this.buffer.setLength(0);
        if (this.container != null) {
            this.buffer.append(this.container.getLongName());
            this.buffer.append('.');
        }
        this.buffer.append(this.getName());
        return this.buffer.toString();
    }

    @Override
    public String getLongName(boolean includeContainerSchema) {
        if (includeContainerSchema) {
            return this.getLongName();
        }
        this.buffer.setLength(0);
        if (this.container != null) {
            this.buffer.append(this.container.getName());
            this.buffer.append('.');
        }
        this.buffer.append(this.getName());
        return this.buffer.toString();
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainer() != null && this.getContainer().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    public boolean isFKElement() {
        return false;
    }

    @Override
    public boolean isContainedObject() {
        return true;
    }

    public ContainedObject getDelegateElement() {
        return null;
    }

    public int getIndex() {
        if (this.getContainer() != null) {
            return this.getContainer().getIndexOf(this);
        }
        return -1;
    }

    public int getPositionInContainerOneBased() {
        return this.getIndex() + 1;
    }

    public void moveToIndex(int index) {
        if (this.getContainer() != null) {
            this.getContainer().moveToIndex(this, index);
        }
    }

    @Override
    public Object getParent() {
        if (this.getContainer() != null) {
            return this.getContainer();
        }
        return super.getParent();
    }

    @Override
    public void remove() {
        if (this.parentObject != null) {
            this.parentObject.removeNestedObject(this);
        }
        this.removeNestedObjects();
        this.parentObject = null;
        boolean firstTime = !this.getIsBeingRemoved();
        super.remove();
        if (firstTime && this.getContainer() != null) {
            this.getContainer().remove(this);
        }
    }

    public void removeNestedObjects() {
        Object[] nest = this.nestedObjects.toArray();
        for (int i = 0; i < nest.length; ++i) {
            ContainedObject cob = (ContainedObject)nest[i];
            cob.remove();
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.NAME_CHANGED)) {
            this.setName(this.getName());
        }
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String synonym) {
        if (!this.synonym.equals(synonym)) {
            this.synonym = synonym;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView dpv) {
        return this.getContainer().hasRepresentationInDPV(dpv);
    }

    private boolean checkSourceType(String value) {
        if (sourceTypeSet == null) {
            sourceTypeSet = new HashSet();
            sourceTypeSet.addAll(Arrays.asList(SOURCE_TYPE_STATES_INTERNAL));
        }
        return sourceTypeSet.contains(value);
    }

    public String getFormulaDesc() {
        return this.formulaDesc;
    }

    public void setFormulaDesc(String formulaDesc) {
        if (formulaDesc != null && formulaDesc.equals(this.formulaDesc)) {
            return;
        }
        this.formulaDesc = formulaDesc;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        if (sourceType != null && sourceType.equals(this.sourceType)) {
            return;
        }
        if (this.checkSourceType(sourceType)) {
            this.sourceType = sourceType;
        }
    }

    public String getStructAttributeID() {
        return this.structAttributeID;
    }

    public void setStructAttributeID(String structAttributeID) {
        this.structAttributeID = structAttributeID != null ? structAttributeID : "";
    }

    public boolean isOid() {
        return this.oid;
    }

    public void setOid(boolean oid) {
        this.oid = oid;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public ContainerObject getScope() {
        if (this.scopeId == null) {
            return null;
        }
        return (ContainerObject)this.getDesign().getDesignObject(this.scopeId);
    }

    public StructuredType getStructuredType() {
        return this.structuredType;
    }

    public void setStructuredType(StructuredType structuredType) {
        this.structuredType = structuredType;
    }

    public ContainedObject getParentObject() {
        return this.parentObject;
    }

    public void setParentObject(ContainedObject parentObject) {
        if (this.parentObject != parentObject) {
            if (this.parentObject != null) {
                this.parentObject.removeNestedObject(this);
            }
            this.parentObject = parentObject;
            if (this.parentObject != null) {
                this.parentObject.addNestedObject(this);
                this.setName(this.getShortName());
            }
        }
    }

    public void addNestedObject(ContainedObject nested) {
        if (!this.nestedObjects.contains(nested)) {
            this.nestedObjects.add(nested);
        }
    }

    public void removeNestedObject(ContainedObject nested) {
        this.nestedObjects.remove(nested);
    }

    public boolean isAtomic() {
        return this.getStructuredType() == null;
    }

    public boolean isNested() {
        return this.parentObject != null;
    }

    @Override
    public boolean setName(String name) {
        String pnameDot;
        int ind;
        if (this.parentObject != null && (ind = name.lastIndexOf(pnameDot = this.parentObject.getName() + ".")) > -1) {
            name = name.substring(ind + pnameDot.length());
        }
        return super.setName(name);
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (this.parentObject != null) {
            name = this.parentObject.getName() + "." + name;
        }
        return name;
    }

    @Override
    public String getFormatedName(NameValidator sd, boolean quoted) {
        String fname = super.getName();
        if (quoted || this.getNameHasQuotes() || !sd.isValidName(fname)) {
            fname = "\"" + fname + "\"";
        }
        if (this.parentObject != null) {
            fname = this.parentObject.getFormatedName(sd, quoted) + "." + fname;
        }
        return fname;
    }

    public String getShortName() {
        String pnameDot;
        int ind;
        String name = super.getName();
        if (this.parentObject != null && (ind = name.lastIndexOf(pnameDot = this.parentObject.getName() + ".")) > -1) {
            name = name.substring(ind + pnameDot.length());
        }
        return name;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public String getSize() {
        return "";
    }

    public XtdMapping getDeletedMapping(ContainerObject container) {
        String cont_id = container.getObjectID();
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, container.getDesignPartId());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                if (!mapping.isMappingForContainer(cont_id)) continue;
                return mapping;
            }
        }
        return null;
    }

    public XtdMapping getDeletedMapping(String containerID, String designPartID) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, designPartID);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                if (containerID.equals(mapping.getRecreatedContainerID())) {
                    return mapping;
                }
                String deletedID = mapping.getDeletedID();
                String contID = ContainerObject.getContainerID_From(deletedID);
                if (!containerID.equals(contID)) continue;
                return mapping;
            }
        }
        return null;
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (dirty && this.getContainer() != null) {
            this.getContainer().setDirty(dirty);
        }
    }

    public int getAVTSortOrder() {
        return this.avtSortOrder;
    }

    public void setAVTSortOrder(int sortOrder) {
        this.avtSortOrder = sortOrder;
    }

    public List getNestedObjects() {
        return this.nestedObjects;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        DesignObject object = null;
        if ("structuredType".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(id);
        } else if ("collectionType".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getDataTypesDesign().getCollectionTypeSet().getObjectByID(id);
        }
        if (object != null) {
            return object;
        }
        return super.translateIdToObject(propertyName, id);
    }

    public AVT createAVT() {
        return new AVT();
    }

    public List getAVTList() {
        ArrayList<AVT> list = new ArrayList<AVT>();
        for (AVT avt : this.getAVTs()) {
            list.add(avt);
        }
        return list;
    }

    public void applyAVTList(List avtList) {
        this.avts.clear();
        this.avts.addAll(avtList);
    }

    @Override
    public void setObjectID(String id) {
        String oldID = this.getObjectID();
        super.setObjectID(id);
        ContainerObject container = this.getContainer();
        if (container != null && oldID == null) {
            container.putInLocalIDMap(id, this);
        }
        if (container != null && id != null && oldID != null && !id.equals(oldID)) {
            container.updateLocalObjectId(oldID, id);
        }
    }

    public String getReferedAttribute() {
        return this.referedAttribute;
    }

    public void setReferedAttribute(String referedAttribute) {
        this.referedAttribute = referedAttribute;
    }

    public void setMandatory(boolean mandatory) {
        this.setNullsAllowed(!mandatory);
    }

    public boolean isMandatory() {
        return !this.getNullsAllowed();
    }

    @Override
    public boolean isRemoteObject() {
        if (this.getContainer() != null) {
            return this.getContainer().isRemoteObject();
        }
        return false;
    }

    public void showPropertyDialog(Dialog owner) {
        this.showPropertyDialog();
    }

    private class AVTNumberComparator
    implements Comparator {
        private AVTNumberComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                double d1 = Double.parseDouble(((AVT)o1).getBeginValue());
                double d2 = Double.parseDouble(((AVT)o2).getBeginValue());
                if (d1 > d2) {
                    return 1;
                }
                if (d1 < d2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception e) {
                return ((AVT)o1).getBeginValue().compareTo(((AVT)o2).getBeginValue());
            }
        }
    }
}

