/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.fcp.vcs.DeletedFile;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.DesignObjectComparator;
import oracle.dbtools.crest.model.design.compare.EmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.FKComparator;
import oracle.dbtools.crest.model.design.compare.IndexComparator;
import oracle.dbtools.crest.model.design.compare.NoteComparator;
import oracle.dbtools.crest.model.design.compare.PropertyFilter;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableConstraintComparator;
import oracle.dbtools.crest.model.design.compare.TableViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.AttributeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDIndexComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDModelComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDTableComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CollectionTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.DistinctTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.EntityComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.EntityViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.InheritanceRelationComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.KeyComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.LogicalSubViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.MethodComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.RelationComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.RelationalSubViewComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.StructuredTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.TypeElementComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLCollectionTypeComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLDistinctTypeComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLIndexComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLMethodComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLStructuredTypeComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLTableComparator;
import oracle.dbtools.crest.model.design.compare.ddl.DDLTypeElementComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SequenceComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SnapshotComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StorageTemplateComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.dbtools.crest.util.compare.CompareMapping;
import oracle.dbtools.crest.util.compare.CompareMappingObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.format.DefaultFCAgent;
import oracle.dbtools.crest.util.options.format.DefaultFCCube;
import oracle.dbtools.crest.util.options.format.DefaultFCDimension;
import oracle.dbtools.crest.util.options.format.DefaultFCEntity;
import oracle.dbtools.crest.util.options.format.DefaultFCInOutParams;
import oracle.dbtools.crest.util.options.format.DefaultFCInfoStore;
import oracle.dbtools.crest.util.options.format.DefaultFCLabel;
import oracle.dbtools.crest.util.options.format.DefaultFCLevel;
import oracle.dbtools.crest.util.options.format.DefaultFCLogicalView;
import oracle.dbtools.crest.util.options.format.DefaultFCNote;
import oracle.dbtools.crest.util.options.format.DefaultFCProcess;
import oracle.dbtools.crest.util.options.format.DefaultFCRelationalView;
import oracle.dbtools.crest.util.options.format.DefaultFCStructuredType;
import oracle.dbtools.crest.util.options.format.DefaultFCTable;
import oracle.dbtools.crest.util.options.format.DefaultFCTransformation;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.format.DefaultLWCDTInheritance;
import oracle.dbtools.crest.util.options.format.DefaultLWCDTReference;
import oracle.dbtools.crest.util.options.format.DefaultLWCFlow;
import oracle.dbtools.crest.util.options.format.DefaultLWCForeignKey;
import oracle.dbtools.crest.util.options.format.DefaultLWCInheritanceRelation;
import oracle.dbtools.crest.util.options.format.DefaultLWCLink;
import oracle.dbtools.crest.util.options.format.DefaultLWCRelation;
import oracle.dbtools.crest.util.options.format.DefaultLWCTypeSubstitution;
import oracle.dbtools.crest.util.options.format.DefaultLineWidthAndColor;
import oracle.dbtools.crest.util.options.format.DefaultRALabel;
import oracle.dbtools.crest.util.options.namingstandards.GlossaryFile;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.dbtools.crest.util.options.namingstandards.WordRule;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DesignLevelSettings {
    public static String fileVersion = "";
    public static final String DESIGN_LEVEL_SETTINGS_FILE_NAME = "dl_settings.xml";
    private static final String SETTINGS_VERSION = "version";
    public static final String SETTINGS_ELEMENT = "settings";
    public static final String SUBSTITUTION_PATTERNS = "substitution_patterns";
    public static final String OLD_STRING = "oldstring";
    public static final String NEW_STRING = "newstring";
    public static final String SELECTED = "selected";
    public static final String COMMENTS = "comments";
    public static final String CASE_SENSITIVE = "casesensitive";
    public static final String COLOR = "color";
    public static final String PREFIX = "prefix";
    public static final String WIDTH = "width";
    public static final String CLASSNAME = "classname";
    public static final String ATTRIBUTE = "attribute";
    public static final String VALUE = "value";
    public static final String CLASSIFICATION_TYPES = "classification_types";
    public static final String NAMING_STANDARD_RULE = "naming_standard_rules";
    public static final String LOGICAL = "logical";
    public static final String SEPARATOR = "separator";
    public static final String LOGICALCHAR = "char";
    public static final String ENTITY = "entity";
    public static final String RELATIONAL = "relational";
    public static final String MANDATORY = "mandatory";
    public static final String TYPE = "type";
    public static final String COLUMN = "column";
    public static final String DOMAIN = "domain";
    public static final String DOMAINS = "domains";
    public static final String TABLE = "table";
    public static final String TAG_VALUE = "value";
    public static final String TAG_NAME = "name";
    public static final String LOGICALTYPE_FOR_DOMAIN_PRESENTATION = "logical_type_for_domain_presentation";
    public static final String AUTOMATIC_PK_GENERATION = "automatic_pk_generation";
    public static final String AUTOMATIC_UK_GENERATION = "automatic_uk_generation";
    public static final String AUTOMATIC_FK_GENERATION = "automatic_fk_generation";
    public static final String PRESERVE_DDL_GENERATION_OPTIONS = "preserve_ddl_generation_options";
    public static final String COMPARE_MAPPING_ELEMENTS = "comparemapping";
    public static final String COMPARE_MAPPING_ELEMENT = "mapping";
    public static final String COMPARE_MAPPING_SOURCE_PARENT = "sourceparent";
    public static final String COMPARE_MAPPING_TARGET_PARENT = "targetparent";
    public static final String COMPARE_MAPPING_SOURCE_OBJECT = "sourceobject";
    public static final String COMPARE_MAPPING_TARGET_OBJECT = "targetobject";
    public static final String COMPARE_MAPPING_SELECTED = "selected";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String DEFAULT_FONTS_AND_COLORS = "default_fonts_and_colors";
    public static final String DEFAULT_LINE_WIDTHS_AND_COLORS = "default_line_widths_and_colors";
    public static final String FC_OBJECT = "fc_object";
    public static final String LWC_OBJECT = "lwc_object";
    public static final String ABBREVIATED_ONLY = "abbreviated_only";
    public static final String CONSTRAINTS = "constraints";
    public static final String PK_VALUE = "pk";
    public static final String FK_VALUE = "fk";
    public static final String CK_VALUE = "ck";
    public static final String UN_VALUE = "un";
    public static final String IDX_VALUE = "idx";
    public static final String AUTOMATIC_IDX_VALUE = "automatic_idx";
    public static final String COLCK_VALUE = "colck";
    public static final String COLNNC_VALUE = "colnnc";
    public static final String COLUMN_FK_VALUE = "column_foreign_key";
    public static final String UI_VALUE = "ui";
    public static final String RELATION_ATTRIBUTE_VALUE = "relation_attribute";
    public static final String SURROGATE_KEY = "surrogate_key";
    public static final String SURROGATE_KEY_COL = "surrogate_key_col";
    public static final String DISCRIMINATOR_COL = "discriminator_col";
    public static final String GLOSSARY = "glossaries";
    public static final String GLOSSARIES = "glossary_file";
    public static final char NEW_LINE = '\n';
    public static final char TAB = '\t';
    private List<MergeConflict> mergeConflicts = new ArrayList<MergeConflict>();
    private List<DeletedFile> deletedFiles = new ArrayList<DeletedFile>();
    private boolean logicalTypeForDomainPresentation = false;
    private List substitutionList = new ArrayList();
    private List classificationTypeList;
    private NamingStandardRule namingRule;
    private boolean automaticUKGeneration;
    private boolean automaticPKGeneration;
    private boolean automaticFKGeneration;
    private boolean preserveDDLGenerationOptions;
    private CompareMapping compareMapping;
    public List defaultFCObjects = new ArrayList();
    public List defaultLWCObjects = new ArrayList();
    private Design design;
    private static final Logger LOGGER = new Logger(DesignLevelSettings.class);

    public DesignLevelSettings(Design design) {
        this.design = design;
        this.loadDefaultValues();
        this.loadDesignLevelSettingsFile(XMLTransformationManager.getDefaultSystemTypesPath());
    }

    private void loadDefaultValues() {
        this.initDefaultFCObjects();
        this.initDefaultLWCObjects();
        this.initDefaultClassificationTypes();
    }

    public NamingStandardRule getNamingStandardRule() {
        if (this.namingRule == null) {
            this.namingRule = new NamingStandardRule();
        }
        return this.namingRule;
    }

    public boolean isLogicalTypeForDomainPresentation() {
        return this.logicalTypeForDomainPresentation;
    }

    public void setLogicalTypeForDomainPresentation(boolean logicalTypeForDomainPresentation) {
        this.logicalTypeForDomainPresentation = logicalTypeForDomainPresentation;
    }

    public CompareMapping getCompareMapping() {
        if (this.compareMapping == null) {
            this.compareMapping = new CompareMapping();
        }
        return this.compareMapping;
    }

    public List getSubstitutionList() {
        return this.substitutionList;
    }

    public List getClassificationTypeList() {
        if (this.classificationTypeList == null) {
            this.classificationTypeList = new ArrayList();
        }
        return this.classificationTypeList;
    }

    public ClassificationType getClassificationTypeByID(String typeID) {
        for (ClassificationType typeExists : this.classificationTypeList) {
            if (!typeExists.equalID(typeID)) continue;
            return typeExists;
        }
        return null;
    }

    public String getClassificationTypeNameByID(String typeID) {
        if (this.getClassificationTypeByID(typeID) != null) {
            return this.getClassificationTypeByID(typeID).getTypeName();
        }
        return "";
    }

    public ClassificationType getClassificationTypeByName(String name) {
        for (ClassificationType nameExists : this.classificationTypeList) {
            if (!nameExists.getTypeName().equalsIgnoreCase(name)) continue;
            return nameExists;
        }
        return null;
    }

    public Object[] getClassificationTypeNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(null);
        for (ClassificationType ct : this.classificationTypeList) {
            list.add(ct.getTypeName());
        }
        return list.toArray();
    }

    public void setNamingStandardRule(NamingStandardRule namingStandardRule) {
        this.namingRule = namingStandardRule;
    }

    public void setAutomaticUKGeneration(boolean automaticUKGeneration) {
        this.automaticUKGeneration = automaticUKGeneration;
    }

    public boolean isAutomaticUKGeneration() {
        return this.automaticUKGeneration;
    }

    public boolean isAutomaticPKGeneration() {
        return this.automaticPKGeneration;
    }

    public void setAutomaticPKGeneration(boolean automaticPKGeneration) {
        this.automaticPKGeneration = automaticPKGeneration;
    }

    public void setAutomaticFKGeneration(boolean automaticFKGeneration) {
        this.automaticFKGeneration = automaticFKGeneration;
    }

    public boolean isAutomaticFKGeneration() {
        return this.automaticFKGeneration;
    }

    public void setPreserveDDLGenerationOptions(boolean preserveDDLGenerationOptions) {
        this.preserveDDLGenerationOptions = preserveDDLGenerationOptions;
    }

    public boolean isPreserveDDLGenerationOptions() {
        return this.preserveDDLGenerationOptions;
    }

    public CompareMapping getCompareMappingList() {
        if (this.compareMapping == null) {
            this.compareMapping = new CompareMapping();
        }
        return this.compareMapping;
    }

    public void saveDesignLevelLSettingsFile(String path) {
        try {
            long rev;
            File file = new File(path);
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(this.getDesignLevelSettingsAsString());
            osw.close();
            if (Extension.isSVNExtensionLoaded() && file.exists() && this.design.isVersioned() && (rev = SVNClientHelper.getInstance().getRevision(file)) == -1L) {
                SVNClientHelper.getInstance().doAdd(file);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to Save Design Level Settings: ", e);
        }
    }

    public void loadDesignLevelSettings(Document doc) {
        try {
            fileVersion = doc.getDocumentElement().getAttribute(SETTINGS_VERSION);
            String value = this.getValue(doc, LOGICALTYPE_FOR_DOMAIN_PRESENTATION);
            if (!"".equalsIgnoreCase(value)) {
                this.logicalTypeForDomainPresentation = Boolean.valueOf(value);
            }
            if (!"".equalsIgnoreCase(value = this.getValue(doc, AUTOMATIC_PK_GENERATION))) {
                this.automaticPKGeneration = Boolean.valueOf(value);
            }
            if (!"".equalsIgnoreCase(value = this.getValue(doc, AUTOMATIC_UK_GENERATION))) {
                this.automaticUKGeneration = Boolean.valueOf(value);
            }
            if (!"".equalsIgnoreCase(value = this.getValue(doc, AUTOMATIC_FK_GENERATION))) {
                this.automaticFKGeneration = Boolean.valueOf(value);
            }
            if (!"".equalsIgnoreCase(value = this.getValue(doc, PRESERVE_DDL_GENERATION_OPTIONS))) {
                this.preserveDDLGenerationOptions = Boolean.valueOf(value);
            }
            if (this.checkFileVersion()) {
                this.initCompareMappings(doc);
            } else {
                this.getCompareMapping().clearCompareMappingsList();
                this.getCompareMapping().init();
                Iterator<String> i = this.getCompareMapping().getCompareMap().keySet().iterator();
                while (i.hasNext()) {
                    this.getCompareMapping().addCompareMappingObject(this.getCompareMapping().getCompareMap().get(i.next()));
                }
            }
            this.initSubstitutionPatterns(doc);
            this.initClassificationTypes(doc);
            this.initDefaultFontsAndColors(doc);
            this.initDefaultLineWidthsAndColors(doc);
            this.initNamingStandardRule(doc);
            this.initEngineeringParams(doc);
            this.initEngineeringCompare(doc);
            this.initModelCompare(doc);
            this.initModelCompareStorage(doc);
            this.initNamingOptions(doc);
            this.initMergeConflicts(doc);
            this.initDeletedFiles(doc);
        }
        catch (Exception e) {
            LOGGER.error("Unable to load design level Settings: ", e);
        }
    }

    private void initSubstitutionPatterns(Document doc) {
        Element element;
        this.substitutionList.clear();
        NodeList list = doc.getElementsByTagName(SUBSTITUTION_PATTERNS);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            NodeList lsDialogs = element.getElementsByTagName("*");
            int dialogLength = lsDialogs.getLength();
            for (int i = 0; i < dialogLength; ++i) {
                Element dialog = (Element)lsDialogs.item(i);
                if (dialog == null) continue;
                try {
                    String oldString = dialog.getAttribute(OLD_STRING);
                    String newString = dialog.getAttribute(NEW_STRING);
                    boolean selected = Boolean.valueOf(dialog.getAttribute("selected"));
                    boolean caseSensitive = Boolean.valueOf(dialog.getAttribute(CASE_SENSITIVE));
                    String comments = dialog.getAttribute(COMMENTS);
                    SubstitutionPattern substPattern = new SubstitutionPattern(oldString, newString, selected, caseSensitive, comments);
                    this.substitutionList.add(substPattern);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    private void initClassificationTypes(Document doc) {
        Element element;
        this.getClassificationTypeList().clear();
        NodeList list = doc.getElementsByTagName(CLASSIFICATION_TYPES);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            NodeList types = element.getElementsByTagName(TYPE);
            int typesLength = types.getLength();
            for (int i = 0; i < typesLength; ++i) {
                Element elem = (Element)types.item(i);
                if (elem == null) continue;
                try {
                    String elementName = elem.getAttribute(TAG_NAME);
                    int elementColor = Integer.parseInt(elem.getAttribute(COLOR));
                    String elementPrefix = elem.getAttribute(PREFIX);
                    String elementID = elem.getAttribute("id");
                    boolean isReadOnly = false;
                    if (elementID.equals("1") || elementID.equals("2") || elementID.equals("3") || elementID.equals("4") || elementID.equals("5")) {
                        isReadOnly = true;
                    }
                    ClassificationType classType = null;
                    classType = !elementID.equalsIgnoreCase("") ? this.getClassificationTypeByID(elementID) : this.getClassificationTypeByName(elementName);
                    if (classType != null) {
                        classType.setTypeName(elementName);
                        classType.setTypePrefix(elementPrefix);
                        classType.setTypeColor(new Color(elementColor));
                        classType.setReadOnly(isReadOnly);
                        continue;
                    }
                    classType = new ClassificationType(elementName, new Color(elementColor), "", isReadOnly, elementPrefix);
                    if (!"".equalsIgnoreCase(elementID)) {
                        classType.setTypeID(elementID);
                    }
                    this.getClassificationTypeList().add(classType);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Unable to initialize classification types: ", e);
                }
            }
        }
    }

    public void initDefaultClassificationTypes() {
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_FACT, new Color(255, 226, 198), "1", true, ""));
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_DIMENSION, new Color(228, 208, 253), "2", true, ""));
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_LOGGING, new Color(228, 228, 228), "3", true, ""));
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_SUMMARY, new Color(207, 244, 202), "4", true, ""));
        this.getClassificationTypeList().add(new ClassificationType(ContainerObject.TYPE_TEMPORARY, new Color(255, 255, 255), "5", true, ""));
    }

    private void initDefaultFontsAndColors(Document doc) {
        Element element;
        NodeList list = doc.getElementsByTagName(DEFAULT_FONTS_AND_COLORS);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            NodeList fos = element.getElementsByTagName(FC_OBJECT);
            int fosLength = fos.getLength();
            for (int i = 0; i < fosLength; ++i) {
                Element foElm = (Element)fos.item(i);
                if (foElm == null) continue;
                try {
                    String className = foElm.getAttribute(CLASSNAME);
                    DefaultFontAndColor dfc = this.getDefaultFCObject(className);
                    if (dfc == null) continue;
                    int background = Integer.parseInt(foElm.getAttribute(BACKGROUND));
                    int foreground = Integer.parseInt(foElm.getAttribute(FOREGROUND));
                    dfc.setBackgroundColor(new Color(background));
                    dfc.setForegroundColor(new Color(foreground));
                    Element fontsElm = this.getFirstElementByTagName("fonts", foElm);
                    if (fontsElm == null) continue;
                    NodeList fonts = fontsElm.getElementsByTagName("font_object");
                    int fontsLength = fonts.getLength();
                    for (int j = 0; j < fontsLength; ++j) {
                        Element font = (Element)fonts.item(j);
                        String type = font.getAttribute("fo_type");
                        FontObject fo = dfc.getFontObject(type);
                        if (fo == null) continue;
                        int fontColor = Integer.parseInt(font.getAttribute("font_color"));
                        String fontName = font.getAttribute("font_name");
                        int fontSize = Integer.parseInt(font.getAttribute("font_size"));
                        int fontStyle = Integer.parseInt(font.getAttribute("font_style"));
                        fo.setColor(new Color(fontColor));
                        fo.setFont(new Font(fontName, fontStyle, fontSize));
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private void initDefaultLineWidthsAndColors(Document doc) {
        Element element;
        NodeList list = doc.getElementsByTagName(DEFAULT_LINE_WIDTHS_AND_COLORS);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            NodeList fos = element.getElementsByTagName(LWC_OBJECT);
            int fosLength = fos.getLength();
            for (int i = 0; i < fosLength; ++i) {
                Element foElm = (Element)fos.item(i);
                if (foElm == null) continue;
                try {
                    String className = foElm.getAttribute(CLASSNAME);
                    DefaultLineWidthAndColor dlwc = this.getDefaultLWCObject(className);
                    if (dlwc == null) continue;
                    int color = Integer.parseInt(foElm.getAttribute(COLOR));
                    int width = Integer.parseInt(foElm.getAttribute(WIDTH));
                    dlwc.setColor(new Color(color));
                    dlwc.setWidth(width);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    private void initNamingStandardRule(Document doc) {
        Element element = this.getFirstElementByTagName(NAMING_STANDARD_RULE, doc.getDocumentElement());
        if (element != null) {
            Element el;
            Element domElm;
            boolean opt;
            Element relElm;
            boolean opt2;
            Element elem;
            Element logElm = this.getFirstElementByTagName(LOGICAL, element);
            if (logElm != null) {
                try {
                    Element el2 = this.getFirstElementByTagName(SEPARATOR, logElm);
                    if (el2 != null) {
                        this.getNamingStandardRule().setLogicalSep(el2.getAttribute("value"));
                        this.getNamingStandardRule().setLogicalChar(el2.getAttribute(LOGICALCHAR));
                    }
                    this.getNamingStandardRule().getEntitiesList().clear();
                    Element entity = this.getFirstElementByTagName(ENTITY, logElm);
                    if (entity != null) {
                        NodeList ent = entity.getElementsByTagName("value");
                        int entLength = ent.getLength();
                        for (int j = 0; j < entLength; ++j) {
                            Element elem2 = (Element)ent.item(j);
                            String type = elem2.getAttribute(TYPE);
                            boolean opt3 = Boolean.valueOf(elem2.getAttribute(MANDATORY));
                            this.getNamingStandardRule().getEntitiesList().add(new WordRule(type, opt3));
                        }
                    }
                    this.getNamingStandardRule().getAttributesList().clear();
                    Element attribute = this.getFirstElementByTagName(ATTRIBUTE, logElm);
                    if (attribute != null) {
                        NodeList atr = attribute.getElementsByTagName("value");
                        int atrLength = atr.getLength();
                        for (int j = 0; j < atrLength; ++j) {
                            elem = (Element)atr.item(j);
                            String type = elem.getAttribute(TYPE);
                            opt2 = Boolean.valueOf(elem.getAttribute(MANDATORY));
                            this.getNamingStandardRule().getAttributesList().add(new WordRule(type, opt2));
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((relElm = this.getFirstElementByTagName(RELATIONAL, element)) != null) {
                try {
                    Element el3 = this.getFirstElementByTagName(SEPARATOR, relElm);
                    if (el3 != null) {
                        this.getNamingStandardRule().setRelSep(el3.getAttribute("value"));
                        String abbr = el3.getAttribute(ABBREVIATED_ONLY);
                        if (abbr != null && !"".equalsIgnoreCase(abbr)) {
                            if ("true".equalsIgnoreCase(abbr)) {
                                this.getNamingStandardRule().setAbbreviatedOnly(true);
                            } else {
                                this.getNamingStandardRule().setAbbreviatedOnly(false);
                            }
                        }
                    }
                    this.getNamingStandardRule().getTablesList().clear();
                    Element table = this.getFirstElementByTagName(TABLE, relElm);
                    if (table != null) {
                        NodeList tbl = table.getElementsByTagName("value");
                        int tblLength = tbl.getLength();
                        for (int j = 0; j < tblLength; ++j) {
                            elem = (Element)tbl.item(j);
                            String type = elem.getAttribute(TYPE);
                            opt2 = Boolean.valueOf(elem.getAttribute(MANDATORY));
                            this.getNamingStandardRule().getTablesList().add(new WordRule(type, opt2));
                        }
                    }
                    this.getNamingStandardRule().getColumnsList().clear();
                    Element column = this.getFirstElementByTagName(COLUMN, relElm);
                    if (column != null) {
                        NodeList clm = column.getElementsByTagName("value");
                        int clmLength = clm.getLength();
                        for (int j = 0; j < clmLength; ++j) {
                            Element elem3 = (Element)clm.item(j);
                            String type = elem3.getAttribute(TYPE);
                            opt = Boolean.valueOf(elem3.getAttribute(MANDATORY));
                            this.getNamingStandardRule().getColumnsList().add(new WordRule(type, opt));
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((domElm = this.getFirstElementByTagName(DOMAINS, element)) != null) {
                try {
                    el = this.getFirstElementByTagName(SEPARATOR, domElm);
                    if (el != null) {
                        this.getNamingStandardRule().setDomainsSep(el.getAttribute("value"));
                    }
                    this.getNamingStandardRule().getDomainsList().clear();
                    Element domain = this.getFirstElementByTagName(DOMAIN, domElm);
                    if (domain != null) {
                        NodeList dom = domain.getElementsByTagName("value");
                        int domLength = dom.getLength();
                        for (int j = 0; j < domLength; ++j) {
                            Element elem4 = (Element)dom.item(j);
                            String type = elem4.getAttribute(TYPE);
                            opt = Boolean.valueOf(elem4.getAttribute(MANDATORY));
                            this.getNamingStandardRule().getDomainsList().add(new WordRule(type, opt));
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((el = this.getFirstElementByTagName(CONSTRAINTS, element)) != null) {
                Element valueElement = this.getFirstElementByTagName(PK_VALUE, el);
                if (valueElement != null) {
                    this.getNamingStandardRule().setPkConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(FK_VALUE, el)) != null) {
                    this.getNamingStandardRule().setFkConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(CK_VALUE, el)) != null) {
                    this.getNamingStandardRule().setCkConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(UN_VALUE, el)) != null) {
                    this.getNamingStandardRule().setUnConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(IDX_VALUE, el)) != null) {
                    this.getNamingStandardRule().setIdxConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(AUTOMATIC_IDX_VALUE, el)) != null) {
                    this.getNamingStandardRule().setAutomaticIdxConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(COLCK_VALUE, el)) != null) {
                    this.getNamingStandardRule().setColckConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(COLNNC_VALUE, el)) != null) {
                    this.getNamingStandardRule().setColNNConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(COLUMN_FK_VALUE, el)) != null) {
                    this.getNamingStandardRule().setFkColumn(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(UI_VALUE, el)) != null) {
                    this.getNamingStandardRule().setUIConstr(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(RELATION_ATTRIBUTE_VALUE, el)) != null) {
                    this.getNamingStandardRule().setRelationAttribute(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(SURROGATE_KEY, el)) != null) {
                    this.getNamingStandardRule().setSurrogateKey(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(SURROGATE_KEY_COL, el)) != null) {
                    this.getNamingStandardRule().setSurrogateKeyColumn(valueElement.getAttribute("value"));
                }
                if ((valueElement = this.getFirstElementByTagName(DISCRIMINATOR_COL, el)) != null) {
                    this.getNamingStandardRule().setDiscriminatorColumn(valueElement.getAttribute("value"));
                }
            }
            Element e = this.getFirstElementByTagName(GLOSSARY, element);
            this.getNamingStandardRule().getGlossariesList().clear();
            if (e != null) {
                NodeList nodes = e.getElementsByTagName(GLOSSARIES);
                int nodesLength = nodes.getLength();
                for (int i = 0; i < nodesLength; ++i) {
                    Element elm = (Element)nodes.item(i);
                    String value = elm.getAttribute("value");
                    this.getNamingStandardRule().getGlossariesList().add(new GlossaryFile(value));
                }
            }
        }
    }

    private void initNamingOptions(Document doc) {
        ArrayList<DesignPart> allModels = new ArrayList<DesignPart>();
        Iterator it = this.design.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            DesignPart dp = (DesignPart)it.next();
            allModels.add(dp);
        }
        allModels.add(this.design.getLogicalDesign());
        NodeList elems = doc.getElementsByTagName("model_options");
        for (int i = 0; i < elems.getLength(); ++i) {
            Element modelOption = (Element)elems.item(i);
            String modelID = modelOption.getAttribute("objectid");
            for (DesignPart design : allModels) {
                if (!design.getObjectID().equals(modelID)) continue;
                NodeList namingOptions = modelOption.getElementsByTagName("naming_option");
                for (int j = 0; j < namingOptions.getLength(); ++j) {
                    Element namingOption = (Element)namingOptions.item(j);
                    String className = namingOption.getAttribute("class_name");
                    int maxNameLength = Integer.parseInt(namingOption.getAttribute("max_name_length"));
                    int caseType = Integer.parseInt(namingOption.getAttribute("case_type"));
                    String validChars = namingOption.getAttribute("valid_characters");
                    boolean allValid = Boolean.valueOf(namingOption.getAttribute("all_valid"));
                    NamingOptionsHolder noh = design.getNamingOptionsHolderFor(className);
                    noh.setCaseType(caseType);
                    noh.setIsValid(allValid);
                    noh.setMaxNameLength(maxNameLength);
                    noh.setValidChars(validChars);
                }
            }
        }
    }

    private void initMergeConflicts(Document doc) {
        NodeList mergeConflictsNodes = doc.getElementsByTagName("merge_conflict");
        List<MergeConflict> mergeConflicts = this.getMergeConflicts();
        mergeConflicts.clear();
        for (int i = 0; i < mergeConflictsNodes.getLength(); ++i) {
            Element mergeConflictElement = (Element)mergeConflictsNodes.item(i);
            String localFile = mergeConflictElement.getAttribute("path");
            String localLabel = mergeConflictElement.getAttribute("local_version_extension");
            String repositoryLabel = mergeConflictElement.getAttribute("remote_version_extension");
            String textStatus = mergeConflictElement.getAttribute("text_status");
            String propertyStatus = mergeConflictElement.getAttribute("property_status");
            mergeConflicts.add(new MergeConflict(new File(this.design.getDesignPath() + localFile), localLabel, null, repositoryLabel, textStatus, propertyStatus));
        }
    }

    private void initDeletedFiles(Document doc) {
        NodeList deletedFilesNodes = doc.getElementsByTagName("deleted_file");
        List<DeletedFile> deletedFiles = this.getDeletedFiles();
        deletedFiles.clear();
        for (int i = 0; i < deletedFilesNodes.getLength(); ++i) {
            Element deletedFileElement = (Element)deletedFilesNodes.item(i);
            String deletedFilePath = deletedFileElement.getAttribute("path");
            String deletedFileUrl = deletedFileElement.getAttribute("url");
            Long deletedFileRevision = Long.valueOf(deletedFileElement.getAttribute("revision"));
            deletedFiles.add(new DeletedFile(new File(this.design.getDesignPath() + deletedFilePath), deletedFileUrl, deletedFileRevision));
        }
    }

    private void initCompareMappings(Document doc) {
        try {
            this.getCompareMapping().clearCompareMappingsList();
            NodeList nodeList = doc.getElementsByTagName(COMPARE_MAPPING_ELEMENT);
            int nlLength = nodeList.getLength();
            for (int i = 0; i < nlLength; ++i) {
                Element element = (Element)nodeList.item(i);
                if (element == null) continue;
                String sourceParent = element.getAttribute(COMPARE_MAPPING_SOURCE_PARENT);
                String targetParent = element.getAttribute(COMPARE_MAPPING_TARGET_PARENT);
                String sourceObject = element.getAttribute(COMPARE_MAPPING_SOURCE_OBJECT);
                String targetObject = element.getAttribute(COMPARE_MAPPING_TARGET_OBJECT);
                CompareMappingObject compObj = new CompareMappingObject(sourceParent, sourceObject, targetParent, targetObject);
                this.getCompareMapping().addCompareMappingObject(compObj);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to initialize Compare mappings: ", e);
        }
    }

    public Element getFirstElementByTagName(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            Element elem = (Element)nodes.item(0);
            return elem;
        }
        return null;
    }

    private void initDefaultFCObjects() {
        this.defaultFCObjects.clear();
        DefaultFCEntity dfcEntity = new DefaultFCEntity("Entity", new Color(164, 225, 255), Color.BLUE);
        DefaultFCLogicalView dfcLogicalView = new DefaultFCLogicalView("Logical View", new Color(255, 155, 106), Color.BLUE);
        DefaultFCTable dfcTable = new DefaultFCTable("Table", new Color(255, 255, 180), Color.BLUE);
        DefaultFCRelationalView dfcRelView = new DefaultFCRelationalView("Relational View", new Color(150, 255, 150), Color.BLUE);
        DefaultFCStructuredType dfcStructuredType = new DefaultFCStructuredType("Structured Type", new Color(140, 250, 220), Color.BLACK);
        DefaultFCCube dfcCube = new DefaultFCCube("Cube", new Color(255, 226, 198), Color.BLACK);
        DefaultFCDimension dfcDimension = new DefaultFCDimension("Dimension", new Color(0, 250, 20), Color.BLACK);
        DefaultFCLevel dfcLevel = new DefaultFCLevel("Level", new Color(228, 208, 253), Color.BLACK);
        DefaultFCProcess dfcProcess = new DefaultFCProcess("Process", new Color(255, 255, 150), Color.BLACK);
        DefaultFCAgent dfcAgent = new DefaultFCAgent("External Agent", new Color(170, 255, 170), Color.BLACK);
        DefaultFCInfoStore dfcInfoStore = new DefaultFCInfoStore("Information Store", new Color(100, 205, 255), Color.BLACK);
        DefaultFCInOutParams dfcInOutParams = new DefaultFCInOutParams("In-Out Parameters", new Color(250, 250, 250), Color.BLACK);
        DefaultFCTransformation dfcTransformation = new DefaultFCTransformation("Transformation", new Color(255, 255, 213), Color.BLACK);
        DefaultFCNote dfcNote = new DefaultFCNote("Note", Color.LIGHT_GRAY, Color.BLACK);
        DefaultFCLabel dfcLabel = new DefaultFCLabel("Label", Color.WHITE, Color.BLACK);
        DefaultRALabel dfcRA = new DefaultRALabel("Relationship Attributes", new Color(255, 153, 102), Color.BLACK);
        DefaultFCLabel dfcLegend = new DefaultFCLabel("Legend", Color.WHITE, Color.BLACK);
        this.defaultFCObjects.add(dfcEntity);
        this.defaultFCObjects.add(dfcLogicalView);
        this.defaultFCObjects.add(dfcTable);
        this.defaultFCObjects.add(dfcRelView);
        this.defaultFCObjects.add(dfcStructuredType);
        this.defaultFCObjects.add(dfcCube);
        this.defaultFCObjects.add(dfcDimension);
        this.defaultFCObjects.add(dfcLevel);
        this.defaultFCObjects.add(dfcProcess);
        this.defaultFCObjects.add(dfcAgent);
        this.defaultFCObjects.add(dfcInfoStore);
        this.defaultFCObjects.add(dfcInOutParams);
        this.defaultFCObjects.add(dfcTransformation);
        this.defaultFCObjects.add(dfcNote);
        this.defaultFCObjects.add(dfcLabel);
        this.defaultFCObjects.add(dfcRA);
        this.defaultFCObjects.add(dfcLegend);
    }

    private void initDefaultLWCObjects() {
        this.defaultLWCObjects.clear();
        DefaultLWCRelation dlwcRelation = new DefaultLWCRelation("Logical Relation", Color.BLACK, 1);
        DefaultLWCInheritanceRelation dlwcInheritance = new DefaultLWCInheritanceRelation("Logical Inheritance", Color.RED, 1);
        DefaultLWCForeignKey dlwcForeignKey = new DefaultLWCForeignKey("Relational Foreign Key", Color.BLACK, 1);
        DefaultLWCTypeSubstitution dlwcTypeSubstitution = new DefaultLWCTypeSubstitution("Type Substitution", new Color(0, 200, 20), 1);
        DefaultLWCDTReference dlwcDTReference = new DefaultLWCDTReference("Datatype Reference", Color.BLUE, 1);
        DefaultLWCDTInheritance dlwcDTInheritance = new DefaultLWCDTInheritance("Datatype Inheritance", Color.RED, 1);
        DefaultLWCLink dlwcLink = new DefaultLWCLink("Multidimentional Link", Color.BLUE, 1);
        DefaultLWCLink dlwcHierarchy = new DefaultLWCLink("Multidimensional Hierarchy", new Color(0, 200, 20), 1);
        DefaultLWCFlow dlwcFlow = new DefaultLWCFlow("Process Flow", Color.RED, 1);
        this.defaultLWCObjects.add(dlwcRelation);
        this.defaultLWCObjects.add(dlwcInheritance);
        this.defaultLWCObjects.add(dlwcForeignKey);
        this.defaultLWCObjects.add(dlwcTypeSubstitution);
        this.defaultLWCObjects.add(dlwcDTReference);
        this.defaultLWCObjects.add(dlwcDTInheritance);
        this.defaultLWCObjects.add(dlwcLink);
        this.defaultLWCObjects.add(dlwcHierarchy);
        this.defaultLWCObjects.add(dlwcFlow);
    }

    public DefaultFontAndColor getDefaultFCObject(String className) {
        for (DefaultFontAndColor dfc : this.defaultFCObjects) {
            if (!dfc.getClassName().equalsIgnoreCase(className)) continue;
            return dfc;
        }
        return null;
    }

    public DefaultLineWidthAndColor getDefaultLWCObject(String className) {
        for (DefaultLineWidthAndColor dlwc : this.defaultLWCObjects) {
            if (!dlwc.getClassName().equalsIgnoreCase(className)) continue;
            return dlwc;
        }
        return null;
    }

    public List getDefaultFCObjects() {
        return this.defaultFCObjects;
    }

    public List getDefaultLWCObjects() {
        return this.defaultLWCObjects;
    }

    private void addDesignLevelSettings(StringBuffer buffer) {
        this.appendElement(LOGICALTYPE_FOR_DOMAIN_PRESENTATION, Boolean.toString(this.logicalTypeForDomainPresentation), buffer);
        this.appendElement(AUTOMATIC_PK_GENERATION, Boolean.toString(this.automaticPKGeneration), buffer);
        this.appendElement(AUTOMATIC_UK_GENERATION, Boolean.toString(this.automaticUKGeneration), buffer);
        this.appendElement(AUTOMATIC_FK_GENERATION, Boolean.toString(this.automaticFKGeneration), buffer);
        this.appendElement(PRESERVE_DDL_GENERATION_OPTIONS, Boolean.toString(this.preserveDDLGenerationOptions), buffer);
        this.appendSubstitutionPatterns(buffer);
        this.appendClassificationTypes(buffer);
        this.appendDefaultFontsAndColors(buffer);
        this.appendDefaultLineWidthsAndColors(buffer);
        this.appendNamingStandardRules(buffer);
        this.appendCompareMappings(buffer);
        this.appendEngineeringParams(buffer);
        this.appendEngineeringCompare(buffer);
        this.appendModelCompare(buffer);
    }

    private void appendSubstitutionPatterns(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(SUBSTITUTION_PATTERNS).append('>');
        for (SubstitutionPattern substPattern : this.substitutionList) {
            String sourceString = substPattern.getSourceString().trim();
            if (sourceString.length() == 0) continue;
            buffer.append('\n');
            buffer.append('\t').append('\t');
            buffer.append("<substitutions").append(' ');
            buffer.append("oldstring=\"").append(substPattern.getSourceString()).append("\" ");
            buffer.append("newstring=\"").append(String.valueOf(substPattern.getReplacementString())).append("\" ");
            buffer.append("selected=\"").append(String.valueOf(substPattern.isSelected())).append("\" ");
            buffer.append("casesensitive=\"").append(String.valueOf(substPattern.isCaseSensitive())).append("\" ");
            buffer.append("comments=\"").append(String.valueOf(substPattern.getComments())).append("\" ");
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(SUBSTITUTION_PATTERNS).append(">");
    }

    private void appendClassificationTypes(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(CLASSIFICATION_TYPES).append('>');
        for (ClassificationType classificationType : this.getClassificationTypeList()) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append(TYPE).append(' ');
            buffer.append("name=\"").append(classificationType.getTypeName()).append("\" ");
            buffer.append("color=\"").append(classificationType.getTypeColor().getRGB()).append("\" ");
            buffer.append("prefix=\"").append(classificationType.getTypePrefix()).append("\" ");
            buffer.append("id=\"").append(classificationType.getTypeID()).append("\" ");
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(CLASSIFICATION_TYPES).append(">");
    }

    private void appendDefaultFontsAndColors(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(DEFAULT_FONTS_AND_COLORS).append('>');
        for (DefaultFontAndColor dfc : this.defaultFCObjects) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append(FC_OBJECT).append(' ');
            buffer.append("classname=\"").append(dfc.getClassName()).append("\" ");
            buffer.append("background=\"").append(dfc.getBackgroundColor().getRGB()).append("\" ");
            buffer.append("foreground=\"").append(dfc.getForegroundColor().getRGB()).append("\"");
            buffer.append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append('<').append("fonts").append('>');
            for (FontObject fo : dfc.getEditableFonts()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("font_object").append(' ');
                buffer.append("fo_type=\"").append(fo.getType()).append("\" ");
                buffer.append("font_color=\"").append(fo.getColor().getRGB()).append("\" ");
                buffer.append("font_name=\"").append(fo.getFont().getName()).append("\" ");
                buffer.append("font_size=\"").append(fo.getFont().getSize()).append("\" ");
                buffer.append("font_style=\"").append(fo.getFont().getStyle()).append("\"");
                buffer.append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("fonts").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append(FC_OBJECT).append(">");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(DEFAULT_FONTS_AND_COLORS).append(">");
    }

    private void appendDefaultLineWidthsAndColors(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(DEFAULT_LINE_WIDTHS_AND_COLORS).append('>');
        for (DefaultLineWidthAndColor dlwc : this.defaultLWCObjects) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append(LWC_OBJECT).append(' ');
            buffer.append("classname=\"").append(dlwc.getClassName()).append("\" ");
            buffer.append("color=\"").append(dlwc.getColor().getRGB()).append("\" ");
            buffer.append("width=\"").append(dlwc.getWidth()).append("\"");
            buffer.append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append(LWC_OBJECT).append(">");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(DEFAULT_LINE_WIDTHS_AND_COLORS).append(">");
    }

    private void appendNamingStandardRules(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append("<").append(NAMING_STANDARD_RULE).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append(LOGICAL).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(SEPARATOR).append(' ');
        if (this.namingRule == null) {
            this.namingRule = this.getNamingStandardRule();
        }
        buffer.append("value= \"").append(this.namingRule.getLogicalSep()).append("\"").append(' ');
        buffer.append("char=\"").append(this.namingRule.getLogicalChar()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(ENTITY).append(">");
        this.getListElements(this.namingRule.getEntitiesList(), buffer);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(ENTITY).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(ATTRIBUTE).append(">");
        this.getListElements(this.namingRule.getAttributesList(), buffer);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(ATTRIBUTE).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(LOGICAL).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append(RELATIONAL).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(SEPARATOR).append(' ');
        buffer.append("value= \"").append(this.namingRule.getRelSep()).append("\"").append(' ');
        buffer.append("abbreviated_only=\"").append(this.namingRule.isAbbreviatedOnly()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(TABLE).append(">");
        this.getListElements(this.namingRule.getTablesList(), buffer);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(TABLE).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(COLUMN).append(">");
        this.getListElements(this.namingRule.getColumnsList(), buffer);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(COLUMN).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(RELATIONAL).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append(DOMAINS).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(SEPARATOR).append(' ');
        buffer.append("value= \"").append(this.namingRule.getDomainsSep()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append(DOMAIN).append(">");
        this.getListElements(this.namingRule.getDomainsList(), buffer);
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("</").append(DOMAIN).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(DOMAINS).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append(CONSTRAINTS).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("pk value=\"").append(this.namingRule.getPkConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("fk value=\"").append(this.namingRule.getFkConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("ck value=\"").append(this.namingRule.getCkConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("un value=\"").append(this.namingRule.getUnConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("idx value=\"").append(this.namingRule.getIdxConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("automatic_idx value=\"").append(this.namingRule.getAutomaticIdxConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("colck value=\"").append(this.namingRule.getColckConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("colnnc value=\"").append(this.namingRule.getColNNConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("column_foreign_key value=\"").append(this.namingRule.getFkColumn()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("ui value=\"").append(this.namingRule.getUIConstr()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("relation_attribute value=\"").append(this.namingRule.getRelationAttribute()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("surrogate_key value=\"").append(this.namingRule.getSurrogateKey()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("surrogate_key_col value=\"").append(this.namingRule.getSurrogateKeyColumn()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append('\t').append("<").append("discriminator_col value=\"").append(this.namingRule.getDiscriminatorColumn()).append("\"").append("/>");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(CONSTRAINTS).append(">");
        buffer.append('\n');
        buffer.append('\t').append('\t').append("<").append(GLOSSARY).append(">");
        for (GlossaryFile gl : this.namingRule.getGlossariesList()) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append(GLOSSARIES).append(' ');
            buffer.append("value=\"").append(gl.getFilePath()).append("\"");
            buffer.append("/>");
        }
        buffer.append('\n');
        buffer.append('\t').append('\t').append("</").append(GLOSSARY).append(">");
        buffer.append('\n');
        buffer.append('\t').append("</").append(NAMING_STANDARD_RULE).append(">");
    }

    public void appendCompareMappings(StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(COMPARE_MAPPING_ELEMENTS).append('>');
        Iterator<String> it = this.getCompareMapping().getCompareMap().keySet().iterator();
        while (it.hasNext()) {
            buffer.append('\n');
            CompareMappingObject mappingObj = this.getCompareMapping().getCompareMap().get(it.next());
            buffer.append('\t').append('<').append(COMPARE_MAPPING_ELEMENT).append(' ');
            buffer.append(COMPARE_MAPPING_SOURCE_PARENT).append(' ').append("=\"").append(mappingObj.getSourceParentName()).append("\"").append(' ');
            buffer.append(COMPARE_MAPPING_SOURCE_OBJECT).append(' ').append("=\"").append(mappingObj.getSourceObjectName()).append("\"").append(' ');
            buffer.append(COMPARE_MAPPING_TARGET_PARENT).append(' ').append("=\"").append(mappingObj.getTargetParentName()).append("\"").append(' ');
            buffer.append(COMPARE_MAPPING_TARGET_OBJECT).append(' ').append("=\"").append(mappingObj.getTargetObjectName()).append("\"").append(' ');
            buffer.append("selected").append(' ').append("=\"").append(mappingObj.isSelected()).append("\" />");
        }
        buffer.append('\n');
        buffer.append('\t').append("</").append(COMPARE_MAPPING_ELEMENTS).append('>');
    }

    private void appendEngineeringParams(StringBuffer buffer) {
        if (this.design != null) {
            buffer.append('\n');
            buffer.append('\t').append("<").append("engineering_params").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("delete_without_origin").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isDeleteWithoutOrigin()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("engineer_coordinates").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isEngineerCoordinates()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("engineer_generated").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isEngineerGenerated()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("show_engineering_intree").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isShowEngineeringInTree()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("apply_naming_std").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isApplyNameStandardization()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("use_pref_abbreviation").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.isUsePreferredAbbreviation()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("upload_directory").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.getUnloadDirectory()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("date_format").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.getEngDateFormat()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("timestamp_format").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.getEngTimestampFormat()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("timestamp_tz_format").append(' ');
            buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(String.valueOf(this.design.getEngTimestampWTZFormat()))).append("\"").append("/>");
            buffer.append('\n');
            buffer.append('\t').append("</").append("engineering_params").append(">");
        }
    }

    private void appendEngineeringCompare(StringBuffer buffer) {
        if (this.design != null) {
            buffer.append('\n');
            buffer.append('\t').append("<").append("eng_compare");
            buffer.append(' ').append("show_sel_prop_only").append("=\"").append(this.design.getShowSelPropsOnly()).append("\"");
            buffer.append(' ').append("not_apply_for_new_objects").append("=\"").append(this.design.getNotForNewObjects()).append("\"");
            buffer.append(' ').append("exclude_from_tree").append("=\"").append(this.design.getExcludeFromTree()).append("\"").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("entity_table").append(">");
            for (EngPropertyHolder propHolder : this.design.getEntTablePropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("entity_table").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("attribute_column").append(">");
            for (EngPropertyHolder propHolder : this.design.getAttrColPropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("attribute_column").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("key_index").append(">");
            for (EngPropertyHolder propHolder : this.design.getKeyIdxPropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("key_index").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("relation_fk").append(">");
            for (EngPropertyHolder propHolder : this.design.getRelFKPropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("relation_fk").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("relation_table").append(">");
            for (EngPropertyHolder propHolder : this.design.getRelTablePropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("relation_table").append(">");
            buffer.append('\n');
            buffer.append('\t').append('\t').append("<").append("entityview_view").append(">");
            for (EngPropertyHolder propHolder : this.design.getViewPropertyList()) {
                buffer.append('\n');
                buffer.append('\t').append('\t').append('\t').append("<").append("property").append(' ').append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propHolder.getName())).append("\"").append(' ');
                buffer.append("selected").append("=\"").append(propHolder.isSelected()).append("\"").append("/>");
            }
            buffer.append('\n');
            buffer.append('\t').append('\t').append("</").append("entityview_view").append(">");
            buffer.append('\n');
            buffer.append('\t').append("</").append("eng_compare").append(">");
        }
    }

    private void appendModelCompare(StringBuffer buffer) {
        if (this.design != null) {
            buffer.append('\n');
            buffer.append('\t').append("<").append("model_compare_props_filter").append(">");
            this.addFiltersToBuffer(ColumnComparator.getStaticPropertiesFilterList(), "column_comparator", buffer);
            this.addFiltersToBuffer(DesignObjectComparator.getStaticPropertiesFilterList(), "design_object_comparator", buffer);
            this.addFiltersToBuffer(EmptyPropertiesComparator.getStaticPropertiesFilterList(), "empty_properties_comparator", buffer);
            this.addFiltersToBuffer(FKComparator.getStaticPropertiesFilterList(), "index_comparator", buffer);
            this.addFiltersToBuffer(NoteComparator.getStaticPropertiesFilterList(), "note_comparator", buffer);
            this.addFiltersToBuffer(TableComparator.getStaticPropertiesFilterList(), "table_comparator", buffer);
            this.addFiltersToBuffer(TableConstraintComparator.getStaticPropertiesFilterList(), "table_constraint_comparator", buffer);
            this.addFiltersToBuffer(TableViewComparator.getStaticPropertiesFilterList(), "table_view_comparator", buffer);
            this.addFiltersToBuffer(AttributeComparator.getStaticPropertiesFilterList(), "attribute_comparator", buffer);
            this.addFiltersToBuffer(CollectionTypeComparator.getStaticPropertiesFilterList(), "collection_type_comparator", buffer);
            this.addFiltersToBuffer(CWDIndexComparator.getStaticPropertiesFilterList(), "cwd_index_comparator", buffer);
            this.addFiltersToBuffer(CWDModelComparator.getStaticPropertiesFilterList(), "cwd_model_comparator", buffer);
            this.addFiltersToBuffer(CWDTableComparator.getStaticPropertiesFilterList(), "cwd_table_comparator", buffer);
            this.addFiltersToBuffer(DistinctTypeComparator.getStaticPropertiesFilterList(), "distinct_type_comparator", buffer);
            this.addFiltersToBuffer(EntityComparator.getStaticPropertiesFilterList(), "entity_comparator", buffer);
            this.addFiltersToBuffer(EntityViewComparator.getStaticPropertiesFilterList(), "entity_view_comparator", buffer);
            this.addFiltersToBuffer(InheritanceRelationComparator.getStaticPropertiesFilterList(), "inheritance_relation_comparator", buffer);
            this.addFiltersToBuffer(KeyComparator.getStaticPropertiesFilterList(), "key_comparator", buffer);
            this.addFiltersToBuffer(LogicalSubViewComparator.getStaticPropertiesFilterList(), "logical_subview_comparator", buffer);
            this.addFiltersToBuffer(MethodComparator.getStaticPropertiesFilterList(), "method_comparator", buffer);
            this.addFiltersToBuffer(RelationalSubViewComparator.getStaticPropertiesFilterList(), "relational_subview_comparator", buffer);
            this.addFiltersToBuffer(RelationComparator.getStaticPropertiesFilterList(), "relation_comparator", buffer);
            this.addFiltersToBuffer(StructuredTypeComparator.getStaticPropertiesFilterList(), "structured_type_comparator", buffer);
            this.addFiltersToBuffer(TypeElementComparator.getStaticPropertiesFilterList(), "type_element_comparator", buffer);
            this.addFiltersToBuffer(DDLCollectionTypeComparator.getStaticPropertiesFilterList(), "ddl_collection_type_comparator", buffer);
            this.addFiltersToBuffer(DDLDistinctTypeComparator.getStaticPropertiesFilterList(), "ddl_distinct_type_comparator", buffer);
            this.addFiltersToBuffer(DDLIndexComparator.getStaticPropertiesFilterList(), "ddl_index_comparator", buffer);
            this.addFiltersToBuffer(DDLMethodComparator.getStaticPropertiesFilterList(), "ddl_method_comparator", buffer);
            this.addFiltersToBuffer(DDLStructuredTypeComparator.getStaticPropertiesFilterList(), "ddl_structured_type_comparator", buffer);
            this.addFiltersToBuffer(DDLTableComparator.getStaticPropertiesFilterList(), "ddl_table_comparator", buffer);
            this.addFiltersToBuffer(DDLTypeElementComparator.getStaticPropertiesFilterList(), "ddl_type_element_comparator", buffer);
            this.addFiltersToBuffer(SequenceComparator.getStaticPropertiesFilterList(), "sequence_comparator", buffer);
            this.addFiltersToBuffer(SnapshotComparator.getStaticPropertiesFilterList(), "snapshot_comparator", buffer);
            this.addFiltersToBuffer(StorageTemplateComparator.getStaticPropertiesFilterList(), "storage_template_comparator", buffer);
            buffer.append('\n');
            buffer.append('\t').append("</").append("model_compare_props_filter").append(">");
        }
    }

    private void initEngineeringParams(Document doc) {
        Element element;
        if (this.design != null && (element = this.getFirstElementByTagName("engineering_params", doc.getDocumentElement())) != null) {
            Element e = this.getFirstElementByTagName("delete_without_origin", element);
            if (e != null) {
                this.design.setDeleteWithoutOrigin("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("engineer_coordinates", element)) != null) {
                this.design.setEngineerCoordinates("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("engineer_generated", element)) != null) {
                this.design.setEngineerGenerated("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("show_engineering_intree", element)) != null) {
                this.design.setShowEngineeringInTree("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("apply_naming_std", element)) != null && !"".equals(e.getAttribute("value"))) {
                this.design.setApplyNameStandardization("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("use_pref_abbreviation", element)) != null && !"".equals(e.getAttribute("value"))) {
                this.design.setUsePreferredAbbreviation("true".equalsIgnoreCase(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("upload_directory", element)) != null) {
                this.design.setUnloadDirectory(StringUtilities.decodeAttributeValue(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("date_format", element)) != null) {
                this.design.setEngDateFormat(StringUtilities.decodeAttributeValue(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("timestamp_format", element)) != null) {
                this.design.setEngTimestampFormat(StringUtilities.decodeAttributeValue(e.getAttribute("value")));
            }
            if ((e = this.getFirstElementByTagName("timestamp_tz_format", element)) != null) {
                this.design.setEngTimestampWTZFormat(StringUtilities.decodeAttributeValue(e.getAttribute("value")));
            }
        }
    }

    private void initEngineeringCompare(Document doc) {
        if (this.design != null) {
            NodeList elems = doc.getElementsByTagName("eng_compare");
            for (int i = 0; i < elems.getLength(); ++i) {
                Element e = (Element)elems.item(i);
                String showSelOnly = StringUtilities.decodeAttributeValue(e.getAttribute("show_sel_prop_only"));
                String notApply = StringUtilities.decodeAttributeValue(e.getAttribute("not_apply_for_new_objects"));
                String exclFromTree = StringUtilities.decodeAttributeValue(e.getAttribute("exclude_from_tree"));
                this.design.setShowSelPropsOnly(Boolean.valueOf(showSelOnly));
                this.design.setNotForNewObjects(Boolean.valueOf(notApply));
                this.design.setExcludeFromTree(Boolean.valueOf(exclFromTree));
            }
            NodeList engParams = doc.getDocumentElement().getElementsByTagName("property");
            int length = engParams.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)engParams.item(i);
                if (elm.getParentNode().getNodeName().equalsIgnoreCase("entity_table")) {
                    this.addToList(elm, this.design.getEntTablePropertyList());
                    continue;
                }
                if (elm.getParentNode().getNodeName().equalsIgnoreCase("attribute_column")) {
                    this.addToList(elm, this.design.getAttrColPropertyList());
                    continue;
                }
                if (elm.getParentNode().getNodeName().equalsIgnoreCase("key_index")) {
                    this.addToList(elm, this.design.getKeyIdxPropertyList());
                    continue;
                }
                if (elm.getParentNode().getNodeName().equalsIgnoreCase("relation_fk")) {
                    this.addToList(elm, this.design.getRelFKPropertyList());
                    continue;
                }
                if (elm.getParentNode().getNodeName().equalsIgnoreCase("relation_table")) {
                    this.addToList(elm, this.design.getRelTablePropertyList());
                    continue;
                }
                if (!elm.getParentNode().getNodeName().equalsIgnoreCase("entityview_view")) continue;
                this.addToList(elm, this.design.getViewPropertyList());
            }
        }
    }

    private void initModelCompare(Document doc) {
        NodeList elems;
        if (this.design != null && (elems = doc.getElementsByTagName("model_compare_props_filter")) != null) {
            ColumnComparator.getStaticPropertiesFilterList().clear();
            DesignObjectComparator.getStaticPropertiesFilterList().clear();
            EmptyPropertiesComparator.getStaticPropertiesFilterList().clear();
            FKComparator.getStaticPropertiesFilterList().clear();
            IndexComparator.getStaticPropertiesFilterList().clear();
            NoteComparator.getStaticPropertiesFilterList().clear();
            TableComparator.getStaticPropertiesFilterList().clear();
            TableConstraintComparator.getStaticPropertiesFilterList().clear();
            TableViewComparator.getStaticPropertiesFilterList().clear();
            AttributeComparator.getStaticPropertiesFilterList().clear();
            CollectionTypeComparator.getStaticPropertiesFilterList().clear();
            CWDIndexComparator.getStaticPropertiesFilterList().clear();
            CWDModelComparator.getStaticPropertiesFilterList().clear();
            CWDTableComparator.getStaticPropertiesFilterList().clear();
            DistinctTypeComparator.getStaticPropertiesFilterList().clear();
            EntityComparator.getStaticPropertiesFilterList().clear();
            EntityViewComparator.getStaticPropertiesFilterList().clear();
            InheritanceRelationComparator.getStaticPropertiesFilterList().clear();
            KeyComparator.getStaticPropertiesFilterList().clear();
            LogicalSubViewComparator.getStaticPropertiesFilterList().clear();
            MethodComparator.getStaticPropertiesFilterList().clear();
            RelationalSubViewComparator.getStaticPropertiesFilterList().clear();
            RelationComparator.getStaticPropertiesFilterList().clear();
            StructuredTypeComparator.getStaticPropertiesFilterList().clear();
            TypeElementComparator.getStaticPropertiesFilterList().clear();
            DDLCollectionTypeComparator.getStaticPropertiesFilterList().clear();
            DDLDistinctTypeComparator.getStaticPropertiesFilterList().clear();
            DDLIndexComparator.getStaticPropertiesFilterList().clear();
            DDLMethodComparator.getStaticPropertiesFilterList().clear();
            DDLStructuredTypeComparator.getStaticPropertiesFilterList().clear();
            DDLTableComparator.getStaticPropertiesFilterList().clear();
            DDLTypeElementComparator.getStaticPropertiesFilterList().clear();
            SequenceComparator.getStaticPropertiesFilterList().clear();
            SnapshotComparator.getStaticPropertiesFilterList().clear();
            NodeList elemParams = doc.getDocumentElement().getElementsByTagName("property_filter");
            int length = elemParams.getLength();
            for (int i = 0; i < length; ++i) {
                Element elem = (Element)elemParams.item(i);
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("column_comparator")) {
                    this.addFilterToList(elem, ColumnComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("design_object_comparator")) {
                    this.addFilterToList(elem, DesignObjectComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("empty_properties_comparator")) {
                    this.addFilterToList(elem, EmptyPropertiesComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("fk_comparator")) {
                    this.addFilterToList(elem, FKComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("index_comparator")) {
                    this.addFilterToList(elem, IndexComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("note_comparator")) {
                    this.addFilterToList(elem, NoteComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("table_comparator")) {
                    this.addFilterToList(elem, TableComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("table_constraint_comparator")) {
                    this.addFilterToList(elem, TableConstraintComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("table_view_comparator")) {
                    this.addFilterToList(elem, TableViewComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("attribute_comparator")) {
                    this.addFilterToList(elem, AttributeComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("collection_type_comparator")) {
                    this.addFilterToList(elem, CollectionTypeComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("cwd_index_comparator")) {
                    this.addFilterToList(elem, CWDIndexComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("cwd_model_comparator")) {
                    this.addFilterToList(elem, CWDModelComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("cwd_table_comparator")) {
                    this.addFilterToList(elem, CWDTableComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("distinct_type_comparator")) {
                    this.addFilterToList(elem, DistinctTypeComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("entity_comparator")) {
                    this.addFilterToList(elem, EntityComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("entity_view_comparator")) {
                    this.addFilterToList(elem, EntityViewComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("inheritance_relation_comparator")) {
                    this.addFilterToList(elem, InheritanceRelationComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("key_comparator")) {
                    this.addFilterToList(elem, KeyComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("logical_subview_comparator")) {
                    this.addFilterToList(elem, LogicalSubViewComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("method_comparator")) {
                    this.addFilterToList(elem, MethodComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("relational_subview_comparator")) {
                    this.addFilterToList(elem, RelationalSubViewComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("relation_comparator")) {
                    this.addFilterToList(elem, RelationComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("structured_type_comparator")) {
                    this.addFilterToList(elem, StructuredTypeComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("type_element_comparator")) {
                    this.addFilterToList(elem, TypeElementComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("ddl_collection_type_comparator")) {
                    this.addFilterToList(elem, DDLCollectionTypeComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("ddl_distinct_type_comparator")) {
                    this.addFilterToList(elem, DDLDistinctTypeComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("ddl_index_comparator")) {
                    this.addFilterToList(elem, DDLIndexComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("ddl_method_comparator")) {
                    this.addFilterToList(elem, DDLMethodComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("ddl_structured_type_comparator")) {
                    this.addFilterToList(elem, DDLStructuredTypeComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("ddl_table_comparator")) {
                    this.addFilterToList(elem, DDLTableComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("ddl_type_element_comparator")) {
                    this.addFilterToList(elem, DDLTypeElementComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("sequence_comparator")) {
                    this.addFilterToList(elem, SequenceComparator.getStaticPropertiesFilterList());
                    continue;
                }
                if (!elem.getParentNode().getNodeName().equalsIgnoreCase("snapshot_comparator")) continue;
                this.addFilterToList(elem, SnapshotComparator.getStaticPropertiesFilterList());
            }
        }
    }

    private void initModelCompareStorage(Document doc) {
        NodeList elems;
        if (this.design != null && (elems = doc.getElementsByTagName("model_compare_storage_props_filter")) != null) {
            IndexComparator.getStaticStoragePropertiesFilterList().clear();
            TableComparator.getStaticStoragePropertiesFilterList().clear();
            SnapshotComparator.getStaticStoragePropertiesFilterList().clear();
            NodeList elemParams = doc.getDocumentElement().getElementsByTagName("property_filter");
            int length = elemParams.getLength();
            for (int i = 0; i < length; ++i) {
                Element elem = (Element)elemParams.item(i);
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("index_comparator")) {
                    this.addFilterToList(elem, IndexComparator.getStaticStoragePropertiesFilterList());
                    continue;
                }
                if (elem.getParentNode().getNodeName().equalsIgnoreCase("snapshot_comparator")) {
                    this.addFilterToList(elem, SnapshotComparator.getStaticStoragePropertiesFilterList());
                    continue;
                }
                if (!elem.getParentNode().getNodeName().equalsIgnoreCase("table_comparator")) continue;
                this.addFilterToList(elem, TableComparator.getStaticStoragePropertiesFilterList());
            }
        }
    }

    private void appendElement(String elmName, String value, StringBuffer buffer) {
        buffer.append('\n');
        buffer.append('\t').append('<').append(elmName).append(' ').append("value").append("=\"").append(value).append("\" />");
    }

    public void getListElements(List list, StringBuffer buffer) {
        for (WordRule wr : list) {
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append('\t').append("<").append("value").append(' ');
            buffer.append("type=\"").append(wr.getWordType()).append("\"").append(' ');
            buffer.append("mandatory=\"").append(wr.isMandatory()).append("\"");
            buffer.append("/>");
        }
    }

    private void addFiltersToBuffer(List filterList, String filterTag, StringBuffer buffer) {
        StringBuffer buf = new StringBuffer();
        buf.append('\n');
        buf.append('\t').append('\t').append("<").append(filterTag).append(">");
        boolean found = this.addFilterToBuffer(filterList, buf);
        buf.append('\n');
        buf.append('\t').append('\t').append("</").append(filterTag).append(">");
        if (found) {
            buffer.append(buf);
        }
    }

    private String getValue(Document doc, String tagName) {
        Element element;
        NodeList list = doc.getElementsByTagName(tagName);
        if (list.getLength() > 0 && (element = (Element)list.item(0)) != null) {
            return element.getAttribute("value");
        }
        return "";
    }

    private boolean addFilterToBuffer(List filterList, StringBuffer buffer) {
        boolean found = false;
        for (PropertyFilter propFilter : filterList) {
            if (propFilter.isSelected()) continue;
            buffer.append('\n');
            buffer.append('\t').append('\t').append('\t').append("<").append("property_filter").append(' ');
            buffer.append(TAG_NAME).append("=\"").append(StringUtilities.encodeAttributeValue(propFilter.getName())).append("\"").append(' ');
            buffer.append("selected").append("=\"").append(propFilter.isSelected()).append("\"").append("/>");
            found = true;
        }
        return found;
    }

    private void addFilterToList(Element elem, List filterList) {
        String propName = StringUtilities.decodeAttributeValue(elem.getAttribute(TAG_NAME));
        String selected = StringUtilities.decodeAttributeValue(elem.getAttribute("selected"));
        PropertyFilter pf = new PropertyFilter(propName);
        pf.setSelected(Boolean.valueOf(selected));
        filterList.add(pf);
    }

    private void addToList(Element elem, List elemList) {
        String propName = StringUtilities.decodeAttributeValue(elem.getAttribute(TAG_NAME));
        String selected = StringUtilities.decodeAttributeValue(elem.getAttribute("selected"));
        for (EngPropertyHolder h : elemList) {
            if (!propName.equalsIgnoreCase(h.getName())) continue;
            h.setSelected(Boolean.valueOf(selected));
            break;
        }
    }

    public String getDesignLevelSettingsAsString() {
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append('\n');
        buffer.append('<').append(SETTINGS_ELEMENT).append('>');
        this.addDesignLevelSettings(buffer);
        buffer.append('\n');
        buffer.append("</").append(SETTINGS_ELEMENT).append('>');
        return buffer.toString();
    }

    public void loadDesignLevellSettingsFromString(String dlSettings) {
        try {
            StringReader sr = new StringReader(dlSettings);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(sr);
            Document doc = builder.parse(inputSource);
            this.loadDesignLevelSettings(doc);
        }
        catch (Exception e) {
            LOGGER.error("Unable to initialize Settings: ", e);
        }
    }

    public void loadDesignLevelSettingsFile(String designPath) {
        try {
            File file = new File(designPath, DESIGN_LEVEL_SETTINGS_FILE_NAME);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                this.loadDesignLevelSettings(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load Design Level Settings: ", e);
        }
    }

    private boolean checkFileVersion() {
        if (fileVersion != null && fileVersion != "") {
            Float f = new Float(fileVersion);
            if (this.design.getLoadedVersion() >= f.floatValue()) {
                return true;
            }
        }
        return false;
    }

    public List<MergeConflict> getMergeConflicts() {
        return this.mergeConflicts;
    }

    public List<DeletedFile> getDeletedFiles() {
        return this.deletedFiles;
    }

    public String toString() {
        return "Design Level Settings";
    }
}

