/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.Collections;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.swingui.ApplicationView;

public class DesignObjectCollection
extends ModelIDObjectSet
implements SetListener {
    private static final DesignObject[] PROTO_ARRAY = new DesignObject[0];
    protected boolean requireSort = false;
    Object elDescriptor;
    private boolean canCreateElement = false;

    public DesignObjectCollection() {
        this.requireSort = false;
    }

    public DesignObjectCollection(boolean requireSort) {
        this.requireSort = requireSort;
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public ModelIDObject createElement(String id) {
        return null;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "DesignObject";
    }

    @Override
    public boolean canCreateElement() {
        return this.canCreateElement;
    }

    public void setCanCreateElement(boolean flag) {
        this.canCreateElement = flag;
    }

    @Override
    public void add(ModelObject object) {
        if (object instanceof DesignObjectPlaceHolder) {
            object.setParent(this);
        }
        super.add(object);
    }

    @Override
    public void doAdd() {
        if (this.requireSort && ApplicationView.canLogging) {
            this.sort();
        }
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, ModelObjectSet.NAME_COMPARATOR);
    }

    public DesignObjectPlaceHolder removePlaceHolderFor(DesignObject object) {
        DesignObject[] ar = (DesignObject[])this.toArray();
        for (int i = 0; i < ar.length; ++i) {
            DesignObject deso = ar[i];
            if (!(deso instanceof DesignObjectPlaceHolder) || ((DesignObjectPlaceHolder)deso).getDesignObject() != object) continue;
            this.remove(deso);
            object.removeObjectListener((DesignObjectPlaceHolder)deso);
            if (object instanceof ContainerObject) {
                ((ContainerObject)object).removeContainerListener((DesignObjectPlaceHolder)deso);
            }
            return (DesignObjectPlaceHolder)deso;
        }
        return null;
    }

    public boolean containsPlaceHolderFor(DesignObject object) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DesignObject deso = (DesignObject)it.next();
            if (!(deso instanceof DesignObjectPlaceHolder) || ((DesignObjectPlaceHolder)deso).getDesignObject() != object) continue;
            return true;
        }
        return false;
    }

    public DesignObjectPlaceHolder getPlaceHolderFor(DesignObject object) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DesignObject deso = (DesignObject)it.next();
            if (!(deso instanceof DesignObjectPlaceHolder) || ((DesignObjectPlaceHolder)deso).getDesignObject() != object) continue;
            return (DesignObjectPlaceHolder)deso;
        }
        return null;
    }

    public void setElementDescriptor(Object elementDescriptor) {
        this.elDescriptor = elementDescriptor;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (SetEvent.SORT_COLLECTION.equals(event)) {
            this.sort();
        }
    }
}

