/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.DiagramViewListener;
import oracle.dbtools.crest.model.design.DiagramViewSet;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.LabelSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.undo.DP_UndoManager;
import oracle.dbtools.crest.model.design.undo.NoteCreateEdit;
import oracle.dbtools.crest.model.design.undo.NoteRemoveEdit;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.search.Searchable;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;

public abstract class DesignPart
extends ModelIDObject
implements SetListener,
Searchable {
    public static final String SUB_VIEW_TYPE = "SUB_VIEW_TYPE";
    public static final String DISPLAY_TYPE = "DISPLAY_TYPE";
    private List tasks = Collections.synchronizedList(new ArrayList());
    private boolean loaded = true;
    private boolean shouldBeOpen = false;
    protected Set designListeners = new HashSet();
    private Set listeners = new HashSet();
    private Set undoListeners = new HashSet();
    private Set dvListeners = new HashSet();
    protected DesignPartView mainView;
    protected SubViewObjectSet subViews;
    protected DesignPartViewPlaceHolder dpvPlaceHolder;
    private boolean isVisible = false;
    private TreeMap filesMap = new TreeMap();
    private TreeMap repositoryMap = new TreeMap();
    private List documents;
    private List responsibleParties = new ArrayList();
    private DiagramViewSet dvSet;
    private List namingOptionsHolderList = new ArrayList();
    private List exportedSubViews = new ArrayList();
    private boolean fullExport = false;
    private boolean newModel = true;
    private LabelSet labelSet;
    private boolean isDeleting = false;
    private DP_UndoManager undoManager = new DP_UndoManager();
    protected boolean listOfObjectsChanged = false;
    private boolean objectListChanged = false;
    protected Map f2tMap = null;
    protected Map dfMap = null;
    private String mainViewID = null;
    protected ArrayList<SearchDockable> allSearchDockables;
    private List lastSearchResult;
    private static final Logger LOGGER = new Logger(DesignPart.class);
    protected List typeOrder;

    public DesignPart() {
        this.subViews = new SubViewObjectSet(this, Messages.getString("DesignPart.Subviews"));
        this.subViews.setParent(this);
        this.subViews.setElementDescriptor(SUB_VIEW_TYPE);
    }

    public void addDesignPartListener(DesignPartListener listener) {
        this.listeners.add(listener);
    }

    public void removeDesignPartListener(DesignPartListener listener) {
        this.listeners.remove(listener);
    }

    public void addDiagramViewListener(DiagramViewListener listener) {
        this.dvListeners.add(listener);
    }

    public void removeDiagramViewListener(DiagramViewListener listener) {
        this.dvListeners.remove(listener);
    }

    public void fireDeleted() {
        DiagramViewListener[] array = this.dvListeners.toArray(new DiagramViewListener[0]);
        for (int i = 0; i < array.length; ++i) {
            DiagramViewListener dpl = array[i];
            dpl.designPartDeleted(this);
        }
    }

    protected void fireAdded(DesignObject object) {
        DesignPartListener[] array = this.listeners.toArray(new DesignPartListener[0]);
        for (int i = 0; i < array.length; ++i) {
            DesignPartListener dpl = array[i];
            dpl.objectAdded(this, object);
        }
        this.setObjectListChanged(true);
    }

    protected void fireRemoved(DesignObject object) {
        for (DesignPartListener dpl : this.listeners) {
            dpl.objectRemoved(this, object);
        }
        this.setObjectListChanged(true);
    }

    public abstract Collection getAllTopLevelObjects();

    public abstract StorableObject createObject(String var1, String var2, String var3);

    public abstract void clearAll();

    protected abstract DesignPartView createDesignPartSubView(String var1);

    public DesignPartView createDesignPartSubView() {
        DesignPartView dpv = this.createDesignPartSubView(this.getName() + " - " + this.getSubViewTypeName());
        dpv.setDPVId(this.getAppView().getIDGenerator().createNewID());
        dpv.getTabbedPane().setName(dpv.getName());
        dpv.getTabbedPane().add(dpv);
        dpv.getTabbedPane().setSelectedComponent(dpv);
        dpv.getTabbedPane().addChangeListener(this.getAppView());
        this.setDirty(true);
        return dpv;
    }

    private boolean componentsCollectionContainsName(SubViewObjectSet col, String name) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            if (!name.equalsIgnoreCase(((DesignObject)it.next()).getName())) continue;
            return true;
        }
        return false;
    }

    public String getNameVersion(SubViewObjectSet col, String name) {
        boolean ok = false;
        String oldName = name;
        int i = 0;
        while (!ok) {
            name = new StringBuffer(oldName).append('_').append(String.valueOf(++i)).toString();
            if (this.componentsCollectionContainsName(col, name)) continue;
            ok = true;
        }
        return name;
    }

    public abstract DesignPartView getMainView();

    public abstract boolean isEmpty();

    public void clearDesignPart() {
        this.clearAll();
        this.fullExport = false;
        this.getExportedSubViews().clear();
        if (this.getMainView() != null) {
            this.getMainView().clearDPV();
            this.getMainView().actualSize();
            this.setMainViewVisible(false);
            this.removeDesignPartListener(this.getMainView());
        }
        Object[] svarr = this.subViews.toArray();
        for (int i = 0; i < svarr.length; ++i) {
            DesignPartViewPlaceHolder dpvPH = (DesignPartViewPlaceHolder)svarr[i];
            DesignPartView dpv = dpvPH.getDesignPartView();
            dpvPH.setVisible(false);
            dpv.clearDPV();
            this.removeDesignPartListener(dpv);
            this.getDesign().removeDesignPartView(dpv);
            this.deleteSubview(dpv);
        }
        this.subViews.clear();
        this.filesMap.clear();
        this.mainView = null;
        this.dpvPlaceHolder = null;
        this.undoManager.discardAllEdits();
        this.listOfObjectsChanged = false;
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
        this.setDirty(false);
        this.setCheckedOut(false);
        this.setCheckedOutByMe(false);
        this.setCheckedOutBy("");
        this.setNewModel(true);
    }

    public void deleteSubview(DesignPartView dpv) {
        if (this.subViews.containsObject(dpv)) {
            dpv.clearDPV();
            dpv.closeEditor();
            dpv.clearCellRefsToObjects();
            this.subViews.removePlaceHolderFor(dpv);
            this.setDirty(true);
            DesignPartViewPlaceHolder dph = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
            this.fireRemoved(dph);
        }
    }

    public DesignPartViewPlaceHolder getMainDPVPlaceHolder() {
        if (this.dpvPlaceHolder == null) {
            this.dpvPlaceHolder = new DesignPartViewPlaceHolder(this, this.getMainView());
            this.dpvPlaceHolder.setParent(this);
        }
        return this.dpvPlaceHolder;
    }

    private void doSetMainViewVisible(boolean visible) {
        DesignPartView dpv = this.getMainView();
        if (visible) {
            dpv.setName(this.getName());
            if (!this.isMainViewVisible()) {
                if (dpv.canCreateDisplays()) {
                    int ind = dpv.getTabbedPane().indexOfComponent(dpv);
                    if (ind < 0) {
                        dpv.getTabbedPane().setName(dpv.getName());
                        dpv.getTabbedPane().add((Component)dpv, 0);
                        dpv.getTabbedPane().setSelectedComponent(dpv);
                    }
                    Editor editor = DMDiagramEditor.openNewDiagram(dpv.getTabbedPane());
                    dpv.setContext(editor.getContext());
                    dpv.getTabbedPane().addChangeListener(this.getAppView());
                } else {
                    Editor editor = DMDiagramEditor.openNewDiagram(dpv);
                    dpv.setContext(editor.getContext());
                }
            } else {
                dpv.activateEditor();
            }
        } else {
            if (dpv != null && dpv.canCreateDisplays()) {
                dpv.getTabbedPane().removeChangeListener(this.getAppView());
            }
            if (dpv != null) {
                dpv.closeEditor();
            }
        }
        this.setVisible(visible);
        if (dpv != null) {
            if (visible) {
                if (!this.getDesign().isLoading()) {
                    dpv.setVisible(visible);
                }
            } else {
                dpv.setVisible(visible);
            }
        }
    }

    public void setMainViewVisible(boolean visible, boolean clearDirty) {
        this.doSetMainViewVisible(visible);
        if (clearDirty) {
            this.getMainView().setDirty(false);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (EditorManager.getEditorManager().getCurrentEditor() != null) {
                EditorManager.getEditorManager().getCurrentEditor().getGUI().requestFocusInWindow();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
                        if (currentEditor != null) {
                            currentEditor.getGUI().requestFocusInWindow();
                        }
                    }
                });
            }
        }
    }

    public void setMainViewVisible(boolean visible) {
        this.setMainViewVisible(visible, false);
    }

    private void doSetMainViewVisible(boolean visible, ProgressDialog monitor) {
        DesignPartView dpv = this.getMainView();
        dpv.setVisible(visible, monitor);
        if (visible) {
            dpv.setName(this.getName());
            if (!this.isMainViewVisible()) {
                if (dpv.canCreateDisplays()) {
                    int ind = dpv.getTabbedPane().indexOfComponent(dpv);
                    if (ind < 0) {
                        dpv.getTabbedPane().setName(dpv.getName());
                        dpv.getTabbedPane().add(dpv);
                        for (DesignPartView subordinateView : dpv.getSubordinateViews()) {
                            if (!subordinateView.isDisplay()) continue;
                            dpv.getTabbedPane().add(subordinateView);
                        }
                        dpv.getTabbedPane().setSelectedComponent(dpv);
                    }
                    Editor editor = DMDiagramEditor.openNewDiagram(dpv.getTabbedPane());
                    dpv.setContext(editor.getContext());
                    this.getAppView().updateIdeToolbar(dpv.getToolbarName());
                    dpv.getTabbedPane().addChangeListener(this.getAppView());
                } else {
                    Editor editor = DMDiagramEditor.openNewDiagram(dpv);
                    dpv.setContext(editor.getContext());
                    this.getAppView().updateIdeToolbar(dpv.getToolbarName());
                }
            } else {
                dpv.activateEditor();
            }
        } else {
            if (dpv.canCreateDisplays()) {
                dpv.getTabbedPane().removeChangeListener(this.getAppView());
            }
            dpv.closeEditor();
        }
        this.setVisible(visible);
        if (SwingUtilities.isEventDispatchThread()) {
            EditorManager.getEditorManager().getCurrentEditor().getGUI().requestFocusInWindow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorManager.getEditorManager().getCurrentEditor().getGUI().requestFocusInWindow();
                }
            });
        }
    }

    public void setMainViewVisible(final boolean visible, final ProgressDialog monitor) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetMainViewVisible(visible, monitor);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesignPart.this.doSetMainViewVisible(visible, monitor);
                }
            });
        }
    }

    public boolean isMainViewVisible() {
        DesignPartView dpv = this.getMainView();
        if (dpv == null) {
            return false;
        }
        return dpv.isEditorVisible();
    }

    @Override
    public boolean setName(String name) {
        if (super.setName(name)) {
            ApplicationView appView;
            if (this.getMainView() != null) {
                this.getMainView().setName(name);
            }
            if ((appView = this.getAppView()) != null) {
                // empty if block
            }
            this.fireDesignPartNameChanged(new DesignEvent(DesignEvent.DESIGNPART_NAME_CHANGED));
            this.getDesign().setModelListChanged(true);
            return true;
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void doBeforeLoad() {
    }

    public void doAfterLoad() {
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    public void load() {
        System.out.println("Load start " + this.getName() + "   " + System.currentTimeMillis());
        XMLPersistenceManager pm = this.getAppView().getPersistenceManager();
        AbstractXMLReader reader = pm.getDesignPartReader(this);
        if (reader != null) {
            reader.recreateDesign("Logical", this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
        System.out.println("Load end " + this.getName() + "   " + System.currentTimeMillis());
    }

    public void checkAndSetIDGenerator() {
    }

    public static long getCounter(String id) {
        int ind = 9;
        int length = id.length();
        long counter = 0L;
        if (ind > length) {
            ind = length - 1;
        }
        while (true) {
            try {
                counter = Integer.parseInt(id.substring(length - ind));
                return counter;
            }
            catch (NumberFormatException e) {
                if (--ind >= 1) continue;
                return 0L;
            }
            break;
        }
    }

    public void doAfterSave() {
        int oper = this.getDesign().getCurrentOperation();
        if (oper != 4 && oper != 5) {
            this.removeDeletedObjects(true);
        }
        if (oper != 5) {
            this.createFilesMap();
        }
        if (this.getMainDPVPlaceHolder() != null) {
            this.getMainDPVPlaceHolder().setDirty(false);
        }
        if (this.getMainView() != null) {
            this.getMainView().setDirty(false);
        }
        this.setNewModel(false);
        this.setDirty(false);
    }

    public void save() {
        if (this.getDesign().isOldRepositoryType()) {
            MessageDialogs.showWarningMessage("This design is saved in an old format and can't be overwritten!\nPlease use \"Save As..\" option to save it as new design.");
        } else {
            this.getAppView().setCurrentDesign(this.getDesign());
            this.getAppView().getXMLTransformationManager().saveDesignPart(this);
        }
    }

    public void synchronizeFilesMap(boolean removeFromVCS) {
        this.removeDeletedObjects(removeFromVCS);
        this.createFilesMap();
    }

    protected void createFilesMap() {
        this.filesMap.clear();
        Collection col = this.getStorableDesignObjects();
        col.addAll(this.getAllDPVPlaceHolders());
        for (DesignObject dobj : col) {
            if (dobj.getStorageName() == null) continue;
            this.filesMap.put(dobj.getObjectID(), dobj.getSegmentedStorageName());
        }
    }

    public void createRepositoryMap() {
        this.repositoryMap.clear();
        Collection col = this.getStorableDesignObjects();
        col.addAll(this.getAllDPVPlaceHolders());
        for (DesignObject dobj : col) {
            if (dobj.getRepositoryOID() == null) continue;
            RepDeleteDescr descr = new RepDeleteDescr();
            descr.objectType = dobj.getObjectTypeName();
            descr.repOID = dobj.getRepositoryOID();
            descr.repOVID = dobj.getRepositoryOVID();
            descr.objectID = dobj.getObjectID();
            this.repositoryMap.put(dobj.getObjectID(), descr);
        }
    }

    public List getObjectsToDeleteFromRepository() {
        Collection col = this.getStorableDesignObjects();
        col.addAll(this.getAllDPVPlaceHolders());
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (DesignObject dobj : col) {
            if (dobj.getRepositoryOID() == null) continue;
            map.put(dobj.getObjectID(), dobj.getObjectID());
        }
        ArrayList deleted = new ArrayList();
        for (Map.Entry entry : this.repositoryMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null) continue;
            deleted.add(entry.getValue());
        }
        return deleted;
    }

    private void removeDeletedObjects(boolean removeFromVCS) {
        Collection col = this.getStorableDesignObjects();
        col.addAll(this.getAllDPVPlaceHolders());
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (DesignObject dobj : col) {
            map.put(dobj.getObjectID(), dobj.getObjectID());
        }
        ArrayList<String> deleted = new ArrayList<String>();
        for (Map.Entry entry : this.filesMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null) continue;
            deleted.add((String)entry.getValue());
        }
        if (deleted.size() > 0) {
            this.getDesign().getAppView().setCurrentDesign(this.getDesign());
            if (removeFromVCS && this.getDesign().isVersioned()) {
                if (Extension.isSVNExtensionLoaded()) {
                    SVNClientHelper.getInstance().doRemove(deleted);
                }
            } else {
                this.getAppView().getXMLTransformationManager().deleteFiles(deleted);
            }
        }
    }

    public boolean isShouldBeOpen() {
        return this.shouldBeOpen;
    }

    public void setShouldBeOpen(boolean shouldBeOpen) {
        this.shouldBeOpen = shouldBeOpen;
    }

    public DesignPartView getSubViewGeneratedByDPV(String designPVId) {
        return this.subViews.getSubViewGeneratedByDPV(designPVId);
    }

    public DesignPartView getSubViewByID(String designPVId) {
        return this.subViews.getSubViewByID(designPVId);
    }

    public DesignPartView getSubViewByName(String name) {
        return this.subViews.getSubViewByName(name);
    }

    public DesignPartView[] getMainViewAndSubViews() {
        return this.subViews.getMainViewAndSubViews();
    }

    public SubViewObjectSet getDesignSubviews() {
        return this.subViews;
    }

    public List<DesignPartView> getAllDiagrams() {
        ArrayList<DesignPartView> allDiagrams = new ArrayList<DesignPartView>();
        DesignPartView mainView = this.getMainView();
        if (mainView != null) {
            allDiagrams.add(mainView);
        }
        Iterator iterator = this.subViews.iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceholder = (DesignPartViewPlaceHolder)iterator.next();
            allDiagrams.add(designPartViewPlaceholder.getDesignPartView());
        }
        return allDiagrams;
    }

    public List<DesignPartView> getAllSubviews() {
        ArrayList<DesignPartView> allDiagrams = new ArrayList<DesignPartView>();
        Iterator iterator = this.subViews.iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceholder = (DesignPartViewPlaceHolder)iterator.next();
            allDiagrams.add(designPartViewPlaceholder.getDesignPartView());
        }
        return allDiagrams;
    }

    public List getListOfSubviews() {
        if (this.subViews.size() > 0) {
            ArrayList<DesignPartView> list = new ArrayList<DesignPartView>();
            ArrayList temp = new ArrayList();
            this.subViews.addAllElementsTo(temp);
            Collections.sort(temp, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
            for (DesignPartViewPlaceHolder dph : temp) {
                DesignPartView dpv = dph.getDesignPartView();
                if (dpv == null) continue;
                list.add(dpv);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getStorableDesignObjects() {
        ArrayList collection = new ArrayList();
        for (DesignObjectSet set : this.getStorableSets()) {
            set.addAllElementsTo(collection);
        }
        return collection;
    }

    public abstract List getStorableSets();

    public void sortCollections() {
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ModelPropertiesDialogEx dialog = new ModelPropertiesDialogEx(this.getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void addDesignListener(DesignListener listener) {
        this.designListeners.add(listener);
    }

    public void removeDesignListener(DesignListener listener) {
        this.designListeners.remove(listener);
    }

    protected void fireDesignPartNameChanged(DesignEvent event) {
        event.setDesignPart(this);
        DesignListener[] listeners = this.designListeners.toArray(new DesignListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            try {
                if (listeners[i] == null) continue;
                listeners[i].designChanged(event);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public List getDocuments() {
        if (this.documents == null) {
            this.documents = new ArrayList();
        }
        return this.documents;
    }

    public void addDocument(BIDocument document) {
        if (!this.getDocuments().contains(document)) {
            this.getDocuments().add(document);
        }
    }

    public void clearDocuments() {
        this.getDocuments().clear();
    }

    public List getResponsibleParties() {
        return this.responsibleParties;
    }

    public void addResponsibleParty(BIResponsibleParty party) {
        if (!this.getResponsibleParties().contains(party)) {
            this.getResponsibleParties().add(party);
        }
    }

    public void clearResponsibleParties() {
        this.getResponsibleParties().clear();
    }

    public boolean canCreateDPSubview() {
        return false;
    }

    public String getSubViewTypeName() {
        return "SubView";
    }

    public DiagramViewSet getDiagramViewSet() {
        if (this.dvSet == null) {
            this.dvSet = new DiagramViewSet(this);
            this.dvSet.setDesign(this.getDesign());
            this.dvSet.setName(Messages.getString("DesignPart.DiagramViews"));
            this.dvSet.setParent(this);
            this.dvSet.addSetListener(this);
        }
        return this.dvSet;
    }

    public DiagramView createDiagramView() {
        return this.getDiagramViewSet().createDiagramView(null);
    }

    public DiagramView recreateDiagramView(String id) {
        DiagramView dv = (DiagramView)this.getDiagramViewSet().getObjectByID(id);
        if (dv != null) {
            return dv;
        }
        return this.getDiagramViewSet().createDiagramView(id);
    }

    public abstract Note createNote();

    @Override
    public void setDirty(boolean dirty) {
        DesignPartViewPlaceHolder dpvPH;
        super.setDirty(dirty);
        if (dirty && (dpvPH = this.getMainDPVPlaceHolder()) != null) {
            dpvPH.setDirty(dirty);
        }
    }

    public List getNamingOptionsHolderList() {
        return this.namingOptionsHolderList;
    }

    public NamingOptionsHolder getNamingOptionsHolderFor(String className) {
        for (NamingOptionsHolder holder : this.getNamingOptionsHolderList()) {
            if (!holder.getClassName().getName().equals(className)) continue;
            return holder;
        }
        return new NamingOptionsHolder(className.getClass());
    }

    public NamingOptionsHolder getNamingOptionsHolderFor(Class className) {
        for (NamingOptionsHolder holder : this.getNamingOptionsHolderList()) {
            if (!holder.getClassName().equals(className)) continue;
            return holder.copy();
        }
        return null;
    }

    public void setMaxLength(int tableMaxNameLength, int columnMaxNameLength, int viewMaxNameLength) {
        this.getNamingOptionsHolderFor(Table.class).setMaxNameLength(tableMaxNameLength);
        this.getNamingOptionsHolderFor(Column.class).setMaxNameLength(columnMaxNameLength);
        this.getNamingOptionsHolderFor(TableView.class).setMaxNameLength(viewMaxNameLength);
    }

    public LabelSet getLabelSet() {
        if (this.labelSet == null) {
            this.labelSet = new LabelSet(this);
            this.labelSet.setDesign(this.getDesign());
            this.labelSet.setName(Messages.getString("DesignPart.Labels"));
            this.labelSet.setParent(this);
            this.labelSet.addSetListener(this);
        }
        return this.labelSet;
    }

    public Label createLabel() {
        Label label = this.getLabelSet().createLabel(null);
        return label;
    }

    public boolean isFullExport() {
        return this.fullExport;
    }

    public void setFullExport(boolean fullExport) {
        this.fullExport = fullExport;
    }

    public List getExportedSubViews() {
        return this.exportedSubViews;
    }

    public boolean isIncludedInExport() {
        return this.isFullExport() || this.getExportedSubViews().size() > 0;
    }

    public NoteSet getNoteSet() {
        return null;
    }

    public boolean isDeleting() {
        return this.isDeleting;
    }

    public void setIsDeleting(boolean isDeleting) {
        this.isDeleting = isDeleting;
    }

    public DP_UndoManager getUndoManager() {
        return this.getDesign().getUndoManager();
    }

    public synchronized void addUndoableEditListener(UndoableEditListener l) {
        this.undoListeners.add(l);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener l) {
        this.undoListeners.remove(l);
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        UndoableEditEvent event = new UndoableEditEvent(this, edit);
        Object[] undoList = this.undoListeners.toArray();
        for (int i = 0; i < undoList.length; ++i) {
            UndoableEditListener listener = (UndoableEditListener)undoList[i];
            listener.undoableEditHappened(event);
        }
    }

    public void postUndoableEdit(UndoableEdit edit) {
        if (edit instanceof CompoundEdit) {
            ((CompoundEdit)edit).end();
        }
        this.fireUndoableEditHappened(edit);
    }

    public void postNoteCreateEdit(Note note) {
        NoteCreateEdit edit = new NoteCreateEdit(note);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void postNoteRemoveEdit(Note note) {
        NoteRemoveEdit edit = new NoteRemoveEdit(note);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void postUndoableRemoveEditForObject(DesignObject object) {
        if (object instanceof Note) {
            this.postNoteRemoveEdit((Note)object);
        }
    }

    public List getTypeOrder() {
        if (this.typeOrder == null) {
            this.typeOrder = this.createTypeOrder();
        }
        return this.typeOrder;
    }

    public List getOrderedTypes(List types) {
        ArrayList temp = new ArrayList(types);
        List order = this.getTypeOrder();
        if (order.size() == 0) {
            return types;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String type : order) {
            String inp_type = null;
            for (int i = 0; i < types.size(); ++i) {
                String str = (String)types.get(i);
                if (!str.equalsIgnoreCase(type)) continue;
                inp_type = str;
                temp.remove(str);
                break;
            }
            if (inp_type == null) continue;
            result.add(inp_type);
        }
        result.addAll(temp);
        return result;
    }

    protected List createTypeOrder() {
        return new ArrayList();
    }

    public Note recreateNote(String id) {
        NoteSet set = this.getNoteSet();
        if (set != null) {
            return set.createNote(id);
        }
        return null;
    }

    @Override
    public void setCheckedOutByMe(boolean checkedOutByMe) {
        super.setCheckedOutByMe(checkedOutByMe);
        this.updateActions();
    }

    public void updateActions() {
        this.getAppView().updateActionsFor(this);
    }

    public boolean hasDirtyStorableObjects() {
        DesignPartView dpv = this.getMainView();
        if (dpv != null && dpv.isDirty()) {
            return true;
        }
        Iterator it = this.getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            if (!ph.getDesignPartView().isDirty()) continue;
            return true;
        }
        for (DesignObject dobj : this.getStorableDesignObjects()) {
            if (!dobj.isDirty()) continue;
            return true;
        }
        return this.hasDeletedObjects();
    }

    public List getAllDPVPlaceHolders() {
        ArrayList<DesignPartViewPlaceHolder> list = new ArrayList<DesignPartViewPlaceHolder>();
        DesignPartView dpv = this.getMainView();
        if (dpv != null && this.getMainDPVPlaceHolder() != null) {
            list.add(this.getMainDPVPlaceHolder());
        }
        this.subViews.addAllElementsTo(list);
        return list;
    }

    public boolean isListOfObjectsChanged() {
        return this.listOfObjectsChanged;
    }

    public boolean hasDeletedObjects() {
        Collection col = this.getStorableDesignObjects();
        col.addAll(this.getAllDPVPlaceHolders());
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (DesignObject designObject : col) {
            map.put(designObject.getObjectID(), designObject.getObjectID());
        }
        for (Map.Entry entry : this.filesMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null) continue;
            return true;
        }
        return false;
    }

    public boolean isNewModel() {
        return this.newModel;
    }

    public void setNewModel(boolean newModel) {
        this.newModel = newModel;
    }

    public void setObjectListChanged(boolean objectListChanged) {
        this.objectListChanged = objectListChanged;
    }

    public boolean isObjectListChanged() {
        return this.objectListChanged;
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public boolean hasWaitingTasks() {
        return this.tasks.size() > 0;
    }

    public void executeTasks() {
        Iterator it = this.tasks.iterator();
        while (it.hasNext()) {
            boolean succeeded = false;
            Task task = (Task)it.next();
            try {
                succeeded = task.execute();
            }
            catch (Exception e) {
                LOGGER.error("DesignPart: can not execute task: " + task.toString(), e);
            }
            if (!succeeded) continue;
            it.remove();
        }
    }

    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
        }
        return this.f2tMap;
    }

    public Map getDiagramFolderMap() {
        if (this.dfMap == null) {
            this.dfMap = new LinkedHashMap();
            this.dfMap.put("subviews", "");
        }
        return this.dfMap;
    }

    public String getMainViewID() {
        if (this.getMainView() != null) {
            return this.getMainView().getDPVId();
        }
        return this.mainViewID;
    }

    public void setMainViewID(String mainViewID) {
        this.mainViewID = mainViewID;
        if (this.getMainView() != null) {
            this.getMainView().setDPVId(mainViewID);
        }
    }

    public abstract void doAfterExternalLoad();

    public abstract List getObjectsWithMeasurements();

    @Override
    public RDBMSSite getSelectedRDBMSSite() {
        return this.getDesign().getSelectedRDBMSSite();
    }

    @Override
    public String getShortObjectID() {
        int pos;
        if (this.id != null && !"".equalsIgnoreCase(this.id) && (pos = this.id.indexOf(45)) > -1) {
            String s1 = this.id.substring(0, pos);
            pos = this.id.lastIndexOf(45);
            String s2 = this.id.substring(pos + 1);
            return s1 + '-' + s2;
        }
        return this.id;
    }

    public List getLastSearchResult() {
        if (this.lastSearchResult == null) {
            this.lastSearchResult = new ArrayList();
        }
        return this.lastSearchResult;
    }

    public List getUsedClassificationTypes() {
        DesignLevelSettings dls = this.getDesign().getDesignLevelSettings();
        HashMap<String, ClassificationType> map = new HashMap<String, ClassificationType>();
        ArrayList<ClassificationType> list = null;
        for (ContainerWithKeyObject co : this.getObjectWichAllowClassificationTypes()) {
            String id = co.getTypeID();
            if ("".equals(id)) continue;
            boolean inmap = true;
            ClassificationType clt = (ClassificationType)map.get(id);
            if (clt == null) {
                inmap = false;
                clt = dls.getClassificationTypeByID(id);
            }
            if (clt == null) continue;
            if (list == null) {
                list = new ArrayList<ClassificationType>();
            }
            list.add(clt);
            if (inmap) continue;
            map.put(id, clt);
        }
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    protected List getObjectWichAllowClassificationTypes() {
        return Collections.EMPTY_LIST;
    }
}

