/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.ide.Ide;

public class DesignUtilities {
    public static boolean checkUsedInAttributes(Design design, DesignObject datatypeObject, short use) {
        Iterator it = design.getLogicalDesign().getEntitySet().iterator();
        while (it.hasNext()) {
            Entity attrEntity = (Entity)it.next();
            ContainedObject[] attributes = attrEntity.getElements();
            for (int i = 0; i < attributes.length; ++i) {
                Attribute attr = (Attribute)attributes[i];
                if (!DesignUtilities.isUsedIn(datatypeObject, attr, use)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<AttributeRef> extractUsedInAttributes(Design design, DesignObject datatypeObject, short use) {
        ArrayList<AttributeRef> result = new ArrayList<AttributeRef>();
        Iterator it = design.getLogicalDesign().getEntitySet().iterator();
        while (it.hasNext()) {
            Entity attrEntity = (Entity)it.next();
            ContainedObject[] attributes = attrEntity.getElements();
            for (int i = 0; i < attributes.length; ++i) {
                Attribute attr = (Attribute)attributes[i];
                if (!DesignUtilities.isUsedIn(datatypeObject, attr, use)) continue;
                result.add(new AttributeRef(attrEntity, attr));
            }
        }
        return result;
    }

    public static boolean checkUsedInColumns(Design design, DesignObject datatypeObject, short use) {
        Iterator it = design.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)it.next();
            Iterator iter = relationalDesign.getTableSet().iterator();
            while (iter.hasNext()) {
                Table colTable = (Table)iter.next();
                ContainedObject[] columns = colTable.getElements();
                for (int i = 0; i < columns.length; ++i) {
                    Column col = (Column)columns[i];
                    if (!DesignUtilities.isUsedIn(datatypeObject, col, use)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<ColumnRef> extractUsedInColumns(Design design, DesignObject datatypeObject, short use) {
        ArrayList<ColumnRef> result = new ArrayList<ColumnRef>();
        Iterator it = design.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)it.next();
            Iterator iter = relationalDesign.getTableSet().iterator();
            while (iter.hasNext()) {
                Table colTable = (Table)iter.next();
                ContainedObject[] columns = colTable.getElements();
                for (int i = 0; i < columns.length; ++i) {
                    Column col = (Column)columns[i];
                    if (!DesignUtilities.isUsedIn(datatypeObject, col, use)) continue;
                    result.add(new ColumnRef(relationalDesign, colTable, col));
                }
            }
        }
        return result;
    }

    public static boolean checkUsedInTables(Design design, DesignObject datatypeObject) {
        Iterator it = design.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)it.next();
            Iterator iter = relationalDesign.getTableSet().iterator();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!DesignUtilities.isUsedIn(datatypeObject, table, null)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Table> extractUsedInTables(Design design, DesignObject datatypeObject, short use) {
        ArrayList<Table> result = new ArrayList<Table>();
        Iterator it = design.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)it.next();
            Iterator iter = relationalDesign.getTableSet().iterator();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!DesignUtilities.isUsedIn(datatypeObject, table, use)) continue;
                result.add(table);
            }
        }
        return result;
    }

    public static boolean checkUsedInEntities(Design design, DesignObject datatypeObject) {
        Iterator it = design.getLogicalDesign().getEntitySet().iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            if (!DesignUtilities.isUsedIn(datatypeObject, entity, null)) continue;
            return true;
        }
        return false;
    }

    public static List<Entity> extractUsedInEntities(Design design, DesignObject datatypeObject, short use) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        Iterator it = design.getLogicalDesign().getEntitySet().iterator();
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            if (!DesignUtilities.isUsedIn(datatypeObject, entity, use)) continue;
            result.add(entity);
        }
        return result;
    }

    public static boolean checkUsedInStructuredTypes(Design design, DesignObject datatypeObject) {
        Iterator it = design.getDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType structuredType = (StructuredType)it.next();
            if (!DesignUtilities.isUsedIn(datatypeObject, structuredType, null)) continue;
            return true;
        }
        return false;
    }

    public static List<StructuredType> extractUsedInStructuredTypes(Design design, DesignObject datatypeObject) {
        ArrayList<StructuredType> result = new ArrayList<StructuredType>();
        Iterator it = design.getDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType structuredType = (StructuredType)it.next();
            if (!DesignUtilities.isUsedIn(datatypeObject, structuredType, null)) continue;
            result.add(structuredType);
        }
        return result;
    }

    public static boolean checkUsedInStructuredTypeAttributes(Design design, DesignObject datatypeObject) {
        Iterator it = design.getDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType structuredType = (StructuredType)it.next();
            for (TypeElement typeElement : structuredType.getElements()) {
                if (!DesignUtilities.isUsedIn(datatypeObject, typeElement, null)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<TypeElement> extractUsedInStructuredTypeAttributes(Design design, DesignObject datatypeObject) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        Iterator it = design.getDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType structuredType = (StructuredType)it.next();
            for (TypeElement typeElement : structuredType.getElements()) {
                if (!DesignUtilities.isUsedIn(datatypeObject, typeElement, null)) continue;
                result.add(typeElement);
            }
        }
        return result;
    }

    public static boolean checkUsedInCollectionTypes(Design design, DesignObject datatypeObject) {
        Iterator it = design.getDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType collectionType = (CollectionType)it.next();
            if (!DesignUtilities.isUsedIn(datatypeObject, collectionType.getElementType(), null)) continue;
            return true;
        }
        return false;
    }

    public static List<CollectionType> extractUsedInCollectionTypes(Design design, DesignObject datatypeObject) {
        ArrayList<CollectionType> result = new ArrayList<CollectionType>();
        Iterator it = design.getDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType collectionType = (CollectionType)it.next();
            if (!DesignUtilities.isUsedIn(datatypeObject, collectionType.getElementType(), null)) continue;
            result.add(collectionType);
        }
        return result;
    }

    public static boolean checkUsedInViews(Design design, DesignObject datatypeObject) {
        Iterator it = design.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)it.next();
            Iterator iter = relationalDesign.getTableViewSet().iterator();
            while (iter.hasNext()) {
                TableView tableView = (TableView)iter.next();
                if (!DesignUtilities.isUsedIn(datatypeObject, tableView, null)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<TableView> extractUsedInViews(Design design, DesignObject datatypeObject) {
        ArrayList<TableView> result = new ArrayList<TableView>();
        Iterator it = design.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)it.next();
            Iterator iter = relationalDesign.getTableViewSet().iterator();
            while (iter.hasNext()) {
                TableView tableView = (TableView)iter.next();
                if (!DesignUtilities.isUsedIn(datatypeObject, tableView, null)) continue;
                result.add(tableView);
            }
        }
        return result;
    }

    public static int checkNotUsedIn(Design design, DesignObject datatypeObject) {
        boolean usedIn;
        boolean bl = usedIn = DesignUtilities.checkUsedInAttributes(design, datatypeObject, (short)3) || DesignUtilities.checkUsedInColumns(design, datatypeObject, (short)3) || DesignUtilities.checkUsedInTables(design, datatypeObject) || DesignUtilities.checkUsedInEntities(design, datatypeObject) || DesignUtilities.checkUsedInStructuredTypes(design, datatypeObject) || DesignUtilities.checkUsedInStructuredTypeAttributes(design, datatypeObject) || DesignUtilities.checkUsedInCollectionTypes(design, datatypeObject) || DesignUtilities.checkUsedInViews(design, datatypeObject);
        if (usedIn) {
            return JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DesignUtilities.StructuredTypeIsUsed"), datatypeObject.getName()), Messages.getString("DesignUtilities.DeletingStructuredType"), 0);
        }
        return -1;
    }

    public static boolean isUsedIn(DesignObject datatypeObject, DesignObject designObject, Short use) {
        if (designObject instanceof ContainedObjectWithDomain) {
            ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)designObject;
            if (containedObjectWithDomain.getUse() == use.shortValue()) {
                switch (use) {
                    case 0: {
                        return containedObjectWithDomain.getDomain() == datatypeObject;
                    }
                    case 3: {
                        return containedObjectWithDomain.getStructuredType() == datatypeObject;
                    }
                    case 2: {
                        return containedObjectWithDomain.getDistinctType() == datatypeObject;
                    }
                    case 4: {
                        return containedObjectWithDomain.getCollectionType() == datatypeObject;
                    }
                }
                return false;
            }
        } else if (datatypeObject instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)datatypeObject;
            if (designObject instanceof ContainerObject) {
                return ((ContainerObject)designObject).getBasedOnStructuredType() == structuredType;
            }
            if (designObject instanceof StructuredType) {
                return structuredType.getAllSubTypes().contains(designObject);
            }
            if (designObject instanceof TypeElement) {
                return ((TypeElement)designObject).getType() == structuredType;
            }
        } else if (datatypeObject instanceof Domain && designObject instanceof TypeElement && ((TypeElement)designObject).getDomain() != null) {
            return ((TypeElement)designObject).getDomain() == datatypeObject;
        }
        return false;
    }

    public static class ColumnRef {
        Column column;
        RelationalDesign design;
        Table table;

        public ColumnRef(RelationalDesign design, Table table, Column column) {
            this.design = design;
            this.table = table;
            this.column = column;
        }

        public RelationalDesign getModel() {
            return this.design;
        }

        public void setModel(RelationalDesign design) {
            this.design = design;
        }

        public Table getTable() {
            return this.table;
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public Column getColumn() {
            return this.column;
        }

        public void setColumn(Column column) {
            this.column = column;
        }
    }

    public static class AttributeRef {
        Entity entity;
        Attribute attribute;

        public AttributeRef(Entity entity, Attribute attribute) {
            this.entity = entity;
            this.attribute = attribute;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public void setEntity(Entity entity) {
            this.entity = entity;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public void setAttribute(Attribute newAttribute) {
            this.attribute = newAttribute;
        }
    }
}

