/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;

public class DomainSet
extends DesignObjectSet {
    private static final Object[] PROTO_DOMAIN = new Domain[0];
    public static final String DEFAULT_DOMAIN = "Unknown";
    private Domain defDomain;

    public DomainSet(DesignPart designPart) {
        super(designPart);
        this.requireSort = true;
    }

    public Domain createUnknownDomain() {
        Domain dmUnknown = this.createDomain("DOM3000004");
        dmUnknown.setName(DEFAULT_DOMAIN);
        dmUnknown.setReadOnly(true);
        dmUnknown.setLogicalDatatype(this.getDesign().getLogicalDatatypeSet().getDefaultType());
        return dmUnknown;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_DOMAIN;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default domain name");
    }

    public Domain createDomain() {
        return this.createDomain(null);
    }

    public Domain createDomain(String objectID) {
        Domain domain = new Domain(this.getDesignPart());
        if (objectID != null) {
            domain.setObjectID(objectID);
        }
        this.getDesign().addDesignObject(domain);
        this.add(domain);
        return domain;
    }

    @Override
    public Object getParent() {
        return this.getDesign();
    }

    public Set getUsedDomainFiles() {
        HashSet<String> result = new HashSet<String>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            if (result.contains(domain.getFileName())) continue;
            result.add(domain.getFileName());
        }
        return result;
    }

    public void loadDomainFile(String fileName) {
        if (!this.getUsedDomainFiles().contains(fileName)) {
            this.getAppView().getPersistenceManager().read(fileName, this.getDesign());
        }
    }

    public Domain getDefaultDomain() {
        if (this.defDomain != null && DEFAULT_DOMAIN.equalsIgnoreCase(this.defDomain.getName())) {
            return this.defDomain;
        }
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Domain domain = (Domain)it.next();
            if (!DEFAULT_DOMAIN.equalsIgnoreCase(domain.getName())) continue;
            this.defDomain = domain;
            return domain;
        }
        this.defDomain = this.createUnknownDomain();
        return this.defDomain;
    }

    @Override
    public void remove(DesignObject object) {
        if (this.defDomain != null && object == this.defDomain) {
            this.defDomain = null;
        }
        super.remove(object);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.createUnknownDomain();
    }

    public String getStoragePath() {
        try {
            return new File(this.getDesign().getStoragePath(), "domains").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getStorageName(String fileName) {
        try {
            if (fileName != null) {
                return new File(this.getStoragePath(), fileName + ".xml").getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

