/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public class LogicalDatatypeSet
extends DesignObjectSet
implements RepositoryObject {
    private static final Object[] PROTOTYPE = new LogicalDatatype[0];
    private LogicalDatatype defaultType;
    public static String UNKNOWN = "UNKNOWN";
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private boolean checkedOut = false;
    private boolean checkedOutByMe = false;
    private String checkedOutBy = "";
    private boolean dirty = false;
    private RepositoryObject pac_Element;

    public LogicalDatatypeSet(DesignPart designPart) {
        super(designPart);
    }

    public void createUnknownType() {
        LogicalDatatype ldtUnknown = this.createLogicalDatatype("LOGDT017");
        ldtUnknown.setName("unknown");
        Iterator it = this.getDesign().getDefaultRDBMSTypeSet().iterator();
        while (it.hasNext()) {
            RDBMSType type = (RDBMSType)it.next();
            ldtUnknown.put(type.getName(), UNKNOWN);
        }
        ldtUnknown.setReadOnly(true);
        this.setDefaultType(ldtUnknown);
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTOTYPE;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default log datatype name");
    }

    public void setDefaultType(LogicalDatatype type) {
        this.defaultType = type;
    }

    public LogicalDatatype getDefaultType() {
        return this.defaultType;
    }

    public LogicalDatatype createLogicalDatatype(String oldID) {
        LogicalDatatype type = new LogicalDatatype(this.getDesignPart());
        type.setObjectID(oldID);
        this.getDesign().addDesignObject(type);
        this.add(type);
        return type;
    }

    public LogicalDatatype getLogTypeByName(String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            LogicalDatatype tpo = (LogicalDatatype)it.next();
            if (!name.equalsIgnoreCase(tpo.getName())) continue;
            return tpo;
        }
        return null;
    }

    public LogicalDatatype getLogTypeByObjectID(String id) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            LogicalDatatype tpo = (LogicalDatatype)it.next();
            if (!id.equalsIgnoreCase(tpo.getObjectID())) continue;
            return tpo;
        }
        return null;
    }

    public List getLogicalDataTypes() {
        ArrayList list = new ArrayList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public LogicalDatatype getLogTypeByNativeType(String nativeDataType, String rdbmsSite) {
        int pos;
        String datatype;
        Map map;
        LogicalDatatype tpo;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            tpo = (LogicalDatatype)it.next();
            if (!nativeDataType.equalsIgnoreCase(tpo.getName())) continue;
            map = tpo.getToPhysical();
            datatype = (String)map.get(rdbmsSite);
            pos = datatype.indexOf(44);
            if (pos > -1) {
                datatype = datatype.substring(0, pos);
            }
            if (!nativeDataType.equalsIgnoreCase(datatype.trim())) continue;
            return tpo;
        }
        it = this.iterator();
        while (it.hasNext()) {
            tpo = (LogicalDatatype)it.next();
            map = tpo.getToPhysical();
            datatype = (String)map.get(rdbmsSite);
            pos = datatype.indexOf(44);
            if (pos > -1) {
                datatype = datatype.substring(0, pos);
            }
            if (!nativeDataType.equalsIgnoreCase(datatype.trim())) continue;
            return tpo;
        }
        return null;
    }

    public LogicalDatatype getLogTypeForVarcharMax(String nativeDataType, String rdbmsSite) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Map defaults;
            Map defs;
            String sdf;
            LogicalDatatype tpo = (LogicalDatatype)it.next();
            Map map = tpo.getToPhysical();
            String datatype = (String)map.get(rdbmsSite);
            int pos = datatype.indexOf(44);
            if (pos > -1) {
                datatype = datatype.substring(0, pos);
            }
            if (!nativeDataType.equalsIgnoreCase(datatype.trim()) || !"max".equalsIgnoreCase(sdf = (String)(defs = (Map)(defaults = tpo.getDefaultValues()).get(rdbmsSite)).get("size_default_value"))) continue;
            return tpo;
        }
        return null;
    }

    public LogicalDatatype getFirstNumberDataType() {
        return this.getLogTypeByNativeType("NUMBER", StorageDesignOraclev11g.RDBMS_TYPE.getName());
    }

    @Override
    public boolean canBedeleted() {
        return false;
    }

    @Override
    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return this.checkedOutByMe;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setCheckedOut(boolean checkedOut) {
        this.checkedOut = checkedOut;
    }

    @Override
    public void setCheckedOutBy(String checkedOutBy) {
        this.checkedOutBy = checkedOutBy;
    }

    @Override
    public void setCheckedOutByMe(boolean checkedOutByMe) {
        this.checkedOutByMe = checkedOutByMe;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void setRepositoryOID(String repositoryOID) {
        this.repositoryOID = repositoryOID;
    }

    @Override
    public void setRepositoryOVID(String repositoryOVID) {
        this.repositoryOVID = repositoryOVID;
    }

    @Override
    public String getName() {
        return "LogicalDatatypeSet";
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject object) {
        this.pac_Element = object;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.createUnknownType();
    }
}

