/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.swingui.editor.NoteEditor;
import oracle.ide.Ide;

public class Note
extends MultiShapedDesignObject
implements EditableFonts {
    private static final String DEFAULT_TEXT = Messages.getString("Note.DoubleClickToedit");
    private List editableFonts = new ArrayList();
    public static final String TYPE_NAME = "Note";

    public Note(DesignPart designPart) {
        super(designPart);
        this.setComment(DEFAULT_TEXT);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public String getText() {
        return this.getComment();
    }

    public void setText(String text) {
        this.setComment(text);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            NoteEditor dialog = new NoteEditor(this.getDesign().getAppView(), this);
            dialog.showDialog();
        }
    }

    @Override
    public String getFCObjectType() {
        return TYPE_NAME;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    @Override
    public void remove() {
        this.remove(true);
    }

    public void remove(boolean ask) {
        if (ask) {
            int res = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("Note.SureYouWantToDelete"), this.getName()), Messages.getString("Note.ConfirmObjectDelete"), 0);
            if (res == 0) {
                super.remove();
            }
        } else {
            super.remove();
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "note/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

