/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.compare.COPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;

public class ColumnComparator
extends COPropertiesComparator {
    private Column targetColumn;
    private Column sourceColumn;
    private ColumnProxy sourceColumnProxy;
    private ColumnProxy targetColumnProxy;
    private boolean tableShouldBeRecreated = false;
    protected static List propertiesFilterList = new ArrayList();
    private Map objectsMap;

    public ColumnComparator(Column column, Column attribute, Map objectsMap) {
        super(column, attribute);
        EngPropertyHolder ph;
        this.targetColumn = attribute;
        this.sourceColumn = column;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initPropertiesFilterList();
        if (this.sourceColumn != null && !this.sourceColumn.getAppView().getSettings().isUseDataTypeKindInCompare() && (ph = this.getPropertyHolderByName(DATA_TYPE_KIND)) != null) {
            ph.setFiltered(true);
            ph.setEditable(false);
        }
    }

    public ColumnComparator(Column sourceColumn, Column targetColumn, ColumnProxy sourceColumnProxy, ColumnProxy targetColumnProxy, Map objectsMap) {
        super(sourceColumn, targetColumn);
        EngPropertyHolder ph;
        this.targetColumn = targetColumn;
        this.sourceColumn = sourceColumn;
        this.sourceColumnProxy = sourceColumnProxy;
        this.targetColumnProxy = targetColumnProxy;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initPropertiesFilterList();
        if (sourceColumn != null && !sourceColumn.getAppView().getSettings().isUseDataTypeKindInCompare() && (ph = this.getPropertyHolderByName(DATA_TYPE_KIND)) != null) {
            ph.setFiltered(true);
            ph.setEditable(false);
        }
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyScopeFromColumnToColumn();
    }

    public Column getTargetColumn() {
        return this.targetColumn;
    }

    public Column getSourceColumn() {
        return this.sourceColumn;
    }

    @Override
    protected void initPropertiesList() {
        super.initPropertiesList();
        PropertyHolder ph = new PropertyHolder(SCOPE);
        if (this.targetColumn != null && this.targetColumn.getScope() != null) {
            ph.setRightValue(this.targetColumn.getScope().getName());
        } else {
            ph.setRightValue("");
        }
        if (this.sourceColumn != null && this.sourceColumn.getScope() != null) {
            ph.setLeftValue(this.sourceColumn.getScope().getName());
        } else {
            ph.setLeftValue("");
        }
        if (this.isExcludedFromComparison(SCOPE)) {
            ph.setExcluded(true);
        } else if (this.sourceColumn != null && this.targetColumn != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(DEPEND_ON_FK);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.sourceColumn != null ? String.valueOf(this.sourceColumn.getDependOnForeignKey()) : "");
            ph.setRightValue(this.targetColumn != null ? String.valueOf(this.targetColumn.getDependOnForeignKey()) : "");
            if (this.isExcludedFromComparison(DEPEND_ON_FK)) {
                ph.setExcluded(true);
            } else if (this.targetColumn != null && this.sourceColumn != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(DEPEND_ON_FK_AS_MANDATORY);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.sourceColumn != null ? String.valueOf(this.sourceColumn.isDependOnFK_AsMandatory()) : "");
            ph.setRightValue(this.targetColumn != null ? String.valueOf(this.targetColumn.isDependOnFK_AsMandatory()) : "");
            if (this.isExcludedFromComparison(DEPEND_ON_FK_AS_MANDATORY)) {
                ph.setExcluded(true);
            } else if (this.targetColumn != null && this.sourceColumn != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
        }
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    private void copyScopeFromColumnToColumn() {
        if (this.sourceColumn != null && this.targetColumn != null) {
            this.targetColumn.setTemporaryWriteable(true);
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(SCOPE)) {
                    if (this.sourceColumn.getScope() != null) {
                        Table tTable;
                        Table sTable = (Table)this.sourceColumn.getScope();
                        if (sTable == null || (tTable = (Table)this.objectsMap.get(sTable.getObjectID())) == null) continue;
                        this.targetColumn.setScopeId(tTable.getObjectID());
                        continue;
                    }
                    this.targetColumn.setScopeId(null);
                    continue;
                }
                if (ph.getName().equals(DEPEND_ON_FK)) {
                    FKIndexAssociation fk = this.sourceColumn.getDependOnForeignKey();
                    if (fk != null) {
                        FKIndexAssociation tfk = (FKIndexAssociation)this.objectsMap.get(fk.getObjectID());
                        if (tfk == null) continue;
                        this.targetColumn.setDependOnForeignKey(tfk);
                        continue;
                    }
                    this.targetColumn.setDependOnForeignKey(null);
                    this.targetColumn.setDependOnForeignKeyID("");
                    continue;
                }
                if (!ph.getName().equals(DEPEND_ON_FK_AS_MANDATORY)) continue;
                this.targetColumn.setDependOnFK_AsMandatory(this.sourceColumn.isDependOnFK_AsMandatory());
            }
            this.targetColumn.setTemporaryWriteable(false);
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceColumn != null ? this.sourceColumn.getContainerWithKeyObject().getName() + "." + this.sourceColumn.getName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetColumn != null ? this.targetColumn.getContainerWithKeyObject().getName() + "." + this.targetColumn.getName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceColumn != null && this.targetColumn != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.getName().equals(PropertiesComparator.DATA_TYPE) || !ph.isSelected()) continue;
                return true;
            }
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceColumn == null && this.targetColumn != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public ColumnProxy getSourceColumnProxy() {
        return this.sourceColumnProxy;
    }

    public ColumnProxy getTargetColumnProxy() {
        return this.targetColumnProxy;
    }

    public boolean isDataTypeChanged() {
        if (this.sourceColumn != null && this.targetColumn != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.getName().equals(PropertiesComparator.DATA_TYPE) || !ph.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTableShouldBeRecreated() {
        return this.tableShouldBeRecreated;
    }

    public void setTableShouldBeRecreated(boolean tableShouldBeRecreated) {
        this.tableShouldBeRecreated = tableShouldBeRecreated;
    }

    public boolean isRecreateTable() {
        return this.isTableShouldBeRecreated() && this.hasToBeRename();
    }
}

