/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.AbstractMerging;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.ColumnSelection;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.EmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.FKArcComparator;
import oracle.dbtools.crest.model.design.compare.FKComparator;
import oracle.dbtools.crest.model.design.compare.FilteredSelection;
import oracle.dbtools.crest.model.design.compare.IndexComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableConstraintComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.TableViewComparator;
import oracle.dbtools.crest.model.design.compare.ValidTimeDimensionComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CollectionTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.compare.cwddesign.DistinctTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.MethodComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.StructuredTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.TypeElementComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterTableConstraint;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterColumnOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterIndexOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBFKIndexOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBSequenceOracle10vg;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBSnapshotOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBTableViewOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBAddValidTimeOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBAlterColumnOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBAlterIndexOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBCreateTableOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBRenameTableOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBSnapshotOraclev11g;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SequenceComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SnapshotComparator;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.util.compare.CompareMapping;
import oracle.dbtools.crest.util.compare.CompareMappingObject;

public class CompareModelToModel
extends CompareObjectSelection {
    private static String NEW_VIEW = Messages.getString("CompareModelToModel.NewView");
    private CompareObjectSelection rightRelationalRoot;
    private Map comparatorsMap = new TreeMap();
    private Map leftSelectionMap = new TreeMap();
    private List deletedMappings = new ArrayList();
    private List newMappings = new ArrayList();
    private RelationalDesign sourcedes;
    private RelationalDesign targetdes;
    private List pkInd = new ArrayList();
    private List fkInd = new ArrayList();
    private List indexes = new ArrayList();
    private static String NEW_SNAPSHOT = Messages.getString("CompareModelToModel.NewSnapshot");
    private static String NEW_SEQUENCE = Messages.getString("CompareModelToModel.NewSequence");
    private Map objectsMap;
    private List tablesToRecreate = new ArrayList();
    private List columnsWithChangedDataType = new ArrayList();
    private DataTypesDesign sourceDTD;
    private DataTypesDesign targetDTD;
    private boolean buildDataTypes = false;
    private static boolean caseSensitive = false;
    private static boolean useSchema = true;
    private static boolean swapTarget = false;
    private boolean useGenerateInDDL = false;
    private Map selectedIDs;
    private boolean syncMode;
    private boolean syncConnFlag;

    public CompareModelToModel(RelationalDesign sourceRel, RelationalDesign targetRel, boolean swapTarget, boolean useGenerateInDDL, Map selectedIDs, boolean synchronize) {
        super(sourceRel);
        this.useGenerateInDDL = useGenerateInDDL;
        this.selectedIDs = selectedIDs;
        this.syncMode = swapTarget;
        CompareModelToModel.swapTarget = swapTarget;
        this.syncConnFlag = synchronize;
        sourceRel.getDesign().getDataTypesDesign().getPredefinedStCollection();
        targetRel.getDesign().getDataTypesDesign().getPredefinedStCollection();
        this.tablesToRecreate.clear();
        caseSensitive = sourceRel.getAppView().getSettings().isCaseSensitiveNamesInCompare();
        useSchema = sourceRel.getAppView().getSettings().isUseSchemaPropertyInCompare();
        this.sourceDTD = sourceRel.getDesign().getDataTypesDesign();
        this.targetDTD = targetRel.getDesign().getDataTypesDesign();
        this.buildDataTypes = this.sourceDTD != null && this.targetDTD != null && this.sourceDTD != this.targetDTD;
        this.objectsMap = new TreeMap();
        AbstractMerging.objectsMap = this.objectsMap;
        this.sourcedes = sourceRel;
        String leftRootName = sourceRel.getName() + "(" + sourceRel.getDesign().getName() + ")";
        this.setName(leftRootName);
        this.targetdes = targetRel;
        this.rightRelationalRoot = new CompareObjectSelection(this.targetdes.getName());
        String rightRootName = targetRel.getName() + "(" + targetRel.getDesign().getName() + ")";
        this.rightRelationalRoot.setName(rightRootName);
        this.setCorrespondentNode(this.rightRelationalRoot);
        this.rightRelationalRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.rightRelationalRoot);
        this.addFromSourceModel();
    }

    private void setEmptyComparator(CompareObjectSelection node) {
        node.setPropertiesComparator(new EmptyPropertiesComparator(null, null));
    }

    private void addTable(Table sourceTable, ModelIdObjectSelection allsTabsel, ModelIdObjectSelection alltTablesel) {
        TableProxy sTableProxy = (TableProxy)this.getSourceStorageDesign().getTableProxySet().getProxy(sourceTable.getObjectID());
        Table targetTable = (Table)this.getCorrespondingObject(this.targetdes.getTableSet(), sourceTable, useSchema);
        TableProxy tTableProxy = null;
        if (targetTable == null && this.getTargetStorageDesign().isOpen()) {
            ModelIDObject sch_impl = sTableProxy.getSchemaImplementingObject();
            if (sch_impl != null && (tTableProxy = this.getTargetStorageDesign().getTableProxySet().getBySchemaImplAndName(sch_impl.getName(), sTableProxy.getName())) != null) {
                targetTable = (Table)tTableProxy.getObject();
            }
        } else if (targetTable != null) {
            tTableProxy = (TableProxy)this.getTargetStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
        }
        if (this.useGenerateInDDL && (!sTableProxy.isMarkedGenerate() || tTableProxy != null && !tTableProxy.isMarkedGenerate() || !sourceTable.isMarkedGenerate() || targetTable != null && !targetTable.isMarkedGenerate())) {
            if (sourceTable != null && targetTable != null) {
                this.objectsMap.put(sourceTable.getObjectID(), targetTable);
            }
            return;
        }
        TableSelection sourceTabsel = new TableSelection(sourceTable);
        sourceTabsel.setProxy(sTableProxy);
        TableSelection targetTabsel = null;
        if (targetTable != null) {
            targetTabsel = new TableSelection(targetTable);
            targetTabsel.setProxy(tTableProxy);
            TableComparator comp = new TableComparator(sourceTable, targetTable, sTableProxy, tTableProxy, swapTarget);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceTabsel.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sourceTabsel);
            this.objectsMap.put(sourceTable.getObjectID(), targetTable);
        } else {
            targetTabsel = new TableSelection(NEW_TABLE);
            sourceTabsel.setStatus(STATE_NEW);
            targetTabsel.setStatus(STATE_NEW);
            targetTabsel.setElementDescriptor(Table.class);
            this.objectsMap.put(sourceTable.getObjectID(), null);
            TableComparator comp = new TableComparator(sourceTable, targetTable, sTableProxy, null);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceTabsel.setSelected(true);
            this.newMappings.add(sourceTabsel);
        }
        targetTabsel.setCorrespondentNode(sourceTabsel);
        sourceTabsel.setCorrespondentNode(targetTabsel);
        this.addTableDetails(sourceTable, sourceTabsel, targetTable, targetTabsel);
        allsTabsel.addChild(sourceTabsel);
        alltTablesel.addChild(targetTabsel);
        if (targetTabsel.isRecreateTable()) {
            this.tablesToRecreate.add(targetTabsel);
        }
        if (sourceTabsel.isModified() || sourceTabsel.hasChildsWithChangeStatus()) {
            sourceTabsel.setSelectedNoPropagateSelection(true);
        }
    }

    public static DesignObject getCorrespondingObject(DesignObjectSet set, DesignObject object) {
        if (object == null) {
            return null;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            DesignObject obj = (DesignObject)it.next();
            if (!(obj.getImportedId() != null && obj.getImportedId().equals(object.getObjectID()) || object.getImportedId() != null && object.getImportedId().equals(obj.getObjectID()) || object.getObjectID().equals(obj.getObjectID())) && (object.getImportedId() == null || obj.getImportedId() == null || !object.getImportedId().equals(obj.getImportedId()))) continue;
            return obj;
        }
        boolean useSyncName = object.getAppView().getSettings().isUseDBSyncSourceObject();
        DesignObject impObj = null;
        if (useSyncName) {
            impObj = (DesignObject)CompareModelToModel.getCorrespondingImportedObject(set.iterator(), object, false);
        }
        if (impObj != null) {
            return impObj;
        }
        return set.getByName(object.getName(), caseSensitive);
    }

    public DesignObject getCorrespondingObject(DesignObjectSet set, DesignObject object, boolean getByLongName) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            DesignObject obj = (DesignObject)it.next();
            if (!(obj.getImportedId() != null && obj.getImportedId().equals(object.getObjectID()) || object.getImportedId() != null && object.getImportedId().equals(obj.getObjectID()) || object.getObjectID().equals(obj.getObjectID())) && (obj.getImportedId() == null || object.getImportedId() == null || !object.getImportedId().equals(obj.getImportedId()))) continue;
            return obj;
        }
        DesignObject impObj = null;
        boolean useSyncSchema = object.getAppView().getSettings().isUseDBSyncSourceSchema();
        boolean useSyncName = object.getAppView().getSettings().isUseDBSyncSourceObject();
        if (useSyncName && (useSyncSchema && getByLongName || !getByLongName)) {
            impObj = (DesignObject)CompareModelToModel.getCorrespondingImportedObject(set.iterator(), object, useSyncSchema);
        }
        if (impObj != null) {
            return impObj;
        }
        if (getByLongName) {
            if (object instanceof Index || object instanceof FKIndexAssociation) {
                return set.getByVeryLongdName(object.getVeryLongName());
            }
            return set.getByLongName(object.getLongName());
        }
        if (!getByLongName && (object instanceof Index || object instanceof FKIndexAssociation)) {
            return set.getByLongName(object.getLongName());
        }
        return set.getByName(object.getName(), caseSensitive);
    }

    private DesignObject getCorrespondingObject(List list, DesignObject object) {
        for (DesignObject obj : list) {
            if (!(obj.getImportedId() != null && obj.getImportedId().equals(object.getObjectID()) || object.getImportedId() != null && object.getImportedId().equals(obj.getObjectID()) || object.getObjectID().equals(obj.getObjectID())) && (object.getImportedId() == null || obj.getImportedId() == null || !object.getImportedId().equals(obj.getImportedId()))) continue;
            return obj;
        }
        boolean useSyncName = object.getAppView().getSettings().isUseDBSyncSourceObject();
        DesignObject impObj = null;
        if (useSyncName) {
            impObj = (DesignObject)CompareModelToModel.getCorrespondingImportedObject(list.iterator(), object, false);
        }
        if (impObj != null) {
            return impObj;
        }
        String name = object.getName();
        for (DesignObject obj : list) {
            boolean nameMatch = caseSensitive ? obj.getName().equals(name) : obj.getName().equalsIgnoreCase(name);
            if (!nameMatch) continue;
            if (obj instanceof Method) {
                if (this.objectsMap.containsValue(obj)) continue;
                return obj;
            }
            return obj;
        }
        return null;
    }

    private static ModelObject getCorrespondingImportedObject(Iterator iter, ModelObject object, boolean useSyncSchema) {
        String syncConn = object.getSourceConnName();
        if (!"".equals(syncConn)) {
            String syncName = object.getSourceObjName();
            String syncSchema = object.getSourceObjSchema();
            RelationalDesign rel = object.getDesign().getRelationalDesign();
            while (iter.hasNext()) {
                ModelObject obj = (ModelObject)iter.next();
                if (!swapTarget) {
                    rel = obj.getDesign().getRelationalDesign();
                }
                if (!"".equals(obj.getSourceConnName())) {
                    if (!(caseSensitive ? syncName.equals(obj.getSourceObjName()) && (!useSyncSchema || syncSchema.equals(obj.getSourceObjSchema())) : syncName.equalsIgnoreCase(obj.getSourceObjName()) && (!useSyncSchema || syncSchema.equalsIgnoreCase(obj.getSourceObjSchema())))) continue;
                    return obj;
                }
                String objSchema = "";
                if (obj instanceof DesignObject) {
                    objSchema = ((DesignObject)obj).getSchema();
                }
                if (!(caseSensitive ? syncName.equals(obj.getName()) && (!useSyncSchema || syncSchema.equals(objSchema)) : syncName.equalsIgnoreCase(obj.getName()) && (!useSyncSchema || syncSchema.equalsIgnoreCase(objSchema)))) continue;
                return obj;
            }
        } else {
            String objectName = object.getName();
            String objectSchema = "";
            if (object instanceof DesignObject) {
                objectSchema = ((DesignObject)object).getSchema();
            }
            while (iter.hasNext()) {
                ModelObject obj = (ModelObject)iter.next();
                if (!(caseSensitive ? objectName.equals(obj.getSourceObjName()) && (!useSyncSchema || objectSchema.equals(obj.getSourceObjSchema())) : objectName.equalsIgnoreCase(obj.getSourceObjName()) && (!useSyncSchema || objectSchema.equalsIgnoreCase(obj.getSourceObjSchema())))) continue;
                return obj;
            }
        }
        return null;
    }

    private static ModelObject getCorrespondingImportedColumn(ContainedObject[] elems, ModelObject object) {
        if (!"".equals(object.getSourceConnName())) {
            String syncName = object.getSourceObjName();
            String syncTable = object.getSourceObjSchema();
            for (int i = 0; i < elems.length; ++i) {
                ContainedObject obj = elems[i];
                if (!(!"".equals(obj.getSourceConnName()) ? (caseSensitive ? syncName.equals(obj.getSourceObjName()) && syncTable.equals(obj.getSourceObjSchema()) : syncName.equalsIgnoreCase(obj.getSourceObjName()) && syncTable.equalsIgnoreCase(obj.getSourceObjSchema())) : (caseSensitive ? syncName.equals(obj.getName()) && syncTable.equals(obj.getContainer().getName()) : syncName.equalsIgnoreCase(obj.getName()) && syncTable.equalsIgnoreCase(obj.getContainer().getName())))) continue;
                return obj;
            }
        }
        return null;
    }

    private void addTableView(TableView sourceTableView, ModelIdObjectSelection allsTabViewSel, ModelIdObjectSelection alltTabViewSel) {
        TableView targetTableView = (TableView)this.getCorrespondingObject(this.targetdes.getTableViewSet(), sourceTableView, useSchema);
        TableViewProxy sViewProxy = (TableViewProxy)this.getSourceStorageDesign().getTableViewProxySet().getProxy(sourceTableView.getObjectID());
        TableViewProxy tViewProxy = null;
        if (targetTableView == null && this.getTargetStorageDesign().isOpen()) {
            ModelIDObject sch_impl = sViewProxy.getSchemaImplementingObject();
            if (sch_impl != null && (tViewProxy = this.getTargetStorageDesign().getTableViewProxySet().getBySchemaImplAndName(sch_impl.getName(), sViewProxy.getName())) != null) {
                targetTableView = (TableView)tViewProxy.getObject();
            }
        } else if (targetTableView != null) {
            tViewProxy = (TableViewProxy)this.getTargetStorageDesign().getTableViewProxySet().getProxy(targetTableView.getObjectID());
        }
        if (this.useGenerateInDDL && (sViewProxy != null && !sViewProxy.isMarkedGenerate() || tViewProxy != null && !tViewProxy.isMarkedGenerate())) {
            if (sourceTableView != null && targetTableView != null) {
                this.objectsMap.put(sourceTableView.getObjectID(), targetTableView);
            }
            return;
        }
        CompareObjectSelection sourceTabViewSel = new CompareObjectSelection(sourceTableView);
        CompareObjectSelection targetTabViewSel = null;
        if (targetTableView != null) {
            targetTabViewSel = new CompareObjectSelection(targetTableView);
            TableViewComparator comp = new TableViewComparator(sourceTableView, targetTableView, sViewProxy, tViewProxy);
            sourceTabViewSel.setPropertiesComparator(comp);
            targetTabViewSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceTabViewSel.setSelected(comp.isModified());
            this.objectsMap.put(sourceTableView.getObjectID(), targetTableView);
        } else {
            sourceTabViewSel.setSelected(true);
            targetTabViewSel = new CompareObjectSelection(NEW_VIEW);
            TableViewComparator comp = new TableViewComparator(sourceTableView, targetTableView, sViewProxy, null);
            sourceTabViewSel.setPropertiesComparator(comp);
            targetTabViewSel.setPropertiesComparator(comp);
            targetTabViewSel.setElementDescriptor(TableView.class);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceTableView.getObjectID(), null);
            sourceTabViewSel.setStatus(STATE_NEW);
            targetTabViewSel.setStatus(STATE_NEW);
            this.newMappings.add(sourceTabViewSel);
        }
        targetTabViewSel.setCorrespondentNode(sourceTabViewSel);
        sourceTabViewSel.setCorrespondentNode(targetTabViewSel);
        allsTabViewSel.addChild(sourceTabViewSel);
        alltTabViewSel.addChild(targetTabViewSel);
    }

    private void addFK(FKIndexAssociation sourcefk, CompareObjectSelection allsFKsel, CompareObjectSelection alltFKSel) {
        FKIndexAssociation targetfk = (FKIndexAssociation)this.getCorrespondingObject(this.targetdes.getFKIndexAssociationSet(), sourcefk, useSchema);
        ModelIDObject sproxy = this.getSourceStorageDesign().getStorageObject(sourcefk.getLocalFKIndex().getObjectID());
        if (sproxy == null) {
            sproxy = sourcefk;
        }
        ModelIDObject tproxy = null;
        if (targetfk != null) {
            tproxy = this.getTargetStorageDesign().getStorageObject(targetfk.getLocalFKIndex().getObjectID());
        }
        if (tproxy == null) {
            tproxy = targetfk;
        }
        if (this.useGenerateInDDL && (sproxy != null && !sproxy.isMarkedGenerate() || tproxy != null && !tproxy.isMarkedGenerate())) {
            if (sourcefk != null && targetfk != null) {
                this.objectsMap.put(sourcefk.getObjectID(), targetfk);
            }
            return;
        }
        CompareObjectSelection sfksel = new CompareObjectSelection(sourcefk);
        String sfkname = sourcefk.getName() + " (" + sourcefk.getContainerWithKeyObject().getName() + " : " + sourcefk.getRemoteTable().getName() + " )";
        sfksel.setName(sfkname);
        sfksel.setSelected(true);
        CompareObjectSelection tfksel = null;
        if (targetfk != null) {
            tfksel = new CompareObjectSelection(targetfk);
            Table tTable = targetfk.getRemoteTable();
            if (tTable != null) {
                KeyObject pk = (KeyObject)this.getCorrespondingObject(tTable.getPK_UKList(), sourcefk.getKeyObject());
                if (pk == null) {
                    sfksel.setSelected(true);
                    tfksel = new CompareObjectSelection(NEW_RELATION);
                    sfksel.setStatus(STATE_NEW);
                    tfksel.setStatus(STATE_NEW);
                    this.newMappings.add(sfksel);
                    tfksel.setElementDescriptor(FKIndexAssociation.class);
                    FKComparator comp = new FKComparator(sourcefk, null, false, false, this.objectsMap);
                    sfksel.setPropertiesComparator(comp);
                    tfksel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                    this.objectsMap.put(sourcefk.getObjectID(), null);
                } else {
                    Column[] targetColumns;
                    Column[] sourceColumns;
                    boolean matchingColumns;
                    boolean matchingRemoteKey = false;
                    KeyObject targetPK = targetfk.getKeyObject();
                    if (targetPK != null) {
                        if (targetPK.getDesignPart() != targetfk.getDesignPart()) {
                            matchingRemoteKey = true;
                        } else if (targetPK.getObjectID().equals(pk.getObjectID())) {
                            matchingRemoteKey = true;
                        }
                    }
                    boolean bl = matchingColumns = (sourceColumns = sourcefk.getColumns()).length == (targetColumns = targetfk.getColumns()).length;
                    if (matchingColumns) {
                        for (int i = 0; i < sourceColumns.length; ++i) {
                            Column mappedTargetCol = (Column)this.objectsMap.get(sourceColumns[i].getObjectID());
                            if (mappedTargetCol != null && mappedTargetCol.getObjectID().equals(targetColumns[i].getObjectID())) continue;
                            matchingColumns = false;
                            break;
                        }
                    }
                    FKComparator comp = new FKComparator(sourcefk, targetfk, matchingRemoteKey, matchingColumns, this.objectsMap);
                    sfksel.setPropertiesComparator(comp);
                    tfksel.setPropertiesComparator(comp);
                    tfksel.setSelected(comp.isModified());
                    sfksel.setSelected(comp.isModified());
                    Table tab1 = (Table)targetfk.getContainerWithKeyObject();
                    Table tab2 = targetfk.getRemoteTable();
                    if (tab1 != null && tab2 != null) {
                        String rname = targetfk.getName() + " (" + tab1.getName() + " : " + tab2.getName() + ")";
                        tfksel.setName(rname);
                    }
                    this.comparatorsMap.put(comp.getID(), comp);
                    this.objectsMap.put(sourcefk.getObjectID(), targetfk);
                    this.objectsMap.put(sourcefk.getLocalFKIndex().getObjectID(), targetfk.getLocalFKIndex());
                }
            }
        } else {
            sfksel.setSelected(true);
            tfksel = new CompareObjectSelection(NEW_RELATION);
            sfksel.setStatus(STATE_NEW);
            tfksel.setStatus(STATE_NEW);
            this.newMappings.add(sfksel);
            tfksel.setElementDescriptor(FKIndexAssociation.class);
            FKComparator comp = new FKComparator(sourcefk, null, false, false, this.objectsMap);
            sfksel.setPropertiesComparator(comp);
            tfksel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourcefk.getObjectID(), null);
        }
        tfksel.setCorrespondentNode(sfksel);
        sfksel.setCorrespondentNode(tfksel);
        allsFKsel.addChild(sfksel);
        alltFKSel.addChild(tfksel);
    }

    private void addFromSourceModel() {
        List list;
        boolean addStorageObjects = false;
        FilteredSelection allsTabsel = new FilteredSelection(Messages.getString("CompareModelToModel.Tables"));
        FilteredSelection alltTabsel = new FilteredSelection(Messages.getString("CompareModelToModel.Tables"));
        allsTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        alltTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        FilteredSelection allsTabViewSel = new FilteredSelection(Messages.getString("CompareModelToModel.Views"));
        FilteredSelection alltTabViewSel = new FilteredSelection(Messages.getString("CompareModelToModel.Views"));
        allsTabViewSel.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        alltTabViewSel.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        FilteredSelection allsSnapshotsSel = new FilteredSelection(Messages.getString("CompareModelToModel.Snapshots"));
        FilteredSelection alltSnapshotsSel = new FilteredSelection(Messages.getString("CompareModelToModel.Snapshots"));
        allsSnapshotsSel.setIcon(GUIConfiguration.getInstance().getIcon("MATERIALIZED_VIEW_FOLDER_ICON"));
        alltSnapshotsSel.setIcon(GUIConfiguration.getInstance().getIcon("MATERIALIZED_VIEW_FOLDER_ICON"));
        FilteredSelection allsSequencesSel = new FilteredSelection(Messages.getString("CompareModelToModel.Sequences"));
        FilteredSelection alltSequencesSel = new FilteredSelection(Messages.getString("CompareModelToModel.Sequences"));
        allsSequencesSel.setIcon(GUIConfiguration.getInstance().getIcon("SEQUENCE_FOLDER_ICON"));
        alltSequencesSel.setIcon(GUIConfiguration.getInstance().getIcon("SEQUENCE_FOLDER_ICON"));
        allsTabsel.setCorrespondentNode(alltTabsel);
        alltTabsel.setCorrespondentNode(allsTabsel);
        allsTabViewSel.setCorrespondentNode(alltTabViewSel);
        alltTabViewSel.setCorrespondentNode(allsTabViewSel);
        this.setEmptyComparator(alltTabsel);
        this.setEmptyComparator(alltTabViewSel);
        alltTabsel.setSelected(false);
        alltTabViewSel.setSelected(false);
        this.setEmptyComparator(allsTabsel);
        this.setEmptyComparator(allsTabViewSel);
        if (this.buildDataTypes) {
            this.addDataTypes();
        }
        boolean checkSelectedIDs = this.syncMode;
        if (this.getSourceStorageDesign() instanceof StorageDesignOracle) {
            list = this.getTables((StorageDesignOracle)this.getSourceStorageDesign());
        } else {
            list = new ArrayList();
            this.sourcedes.getTableSet().addAllElementsTo(list);
        }
        list = this.excludeModelObjects(list);
        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
        for (Table sourceTable : list) {
            if (checkSelectedIDs && this.selectedIDs != null) {
                if (!this.selectedIDs.containsKey(sourceTable.getObjectID())) continue;
                this.addTable(sourceTable, allsTabsel, alltTabsel);
                continue;
            }
            this.addTable(sourceTable, allsTabsel, alltTabsel);
        }
        list.clear();
        this.sourcedes.getTableViewSet().addAllElementsTo(list);
        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
        for (TableView sourceTableView : list) {
            if (checkSelectedIDs && this.selectedIDs != null) {
                if (!this.selectedIDs.containsKey(sourceTableView.getObjectID())) continue;
                this.addTableView(sourceTableView, allsTabViewSel, alltTabViewSel);
                continue;
            }
            this.addTableView(sourceTableView, allsTabViewSel, alltTabViewSel);
        }
        if (ModelChooserDialog.isSelectedDatabase && this.sourcedes.getStorageDesign() instanceof StorageDesignOracle) {
            addStorageObjects = true;
            allsSnapshotsSel.setCorrespondentNode(alltSnapshotsSel);
            alltSnapshotsSel.setCorrespondentNode(allsSnapshotsSel);
            allsSequencesSel.setCorrespondentNode(alltSequencesSel);
            alltSequencesSel.setCorrespondentNode(allsSequencesSel);
            this.setEmptyComparator(alltSnapshotsSel);
            this.setEmptyComparator(alltSequencesSel);
            alltSnapshotsSel.setSelected(false);
            alltSequencesSel.setSelected(false);
            this.setEmptyComparator(allsSnapshotsSel);
            this.setEmptyComparator(allsSequencesSel);
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getSourceStorageDesign();
            list.clear();
            storageDesign.getSnapshotSet().addAllElementsTo(list);
            Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
            for (SnapshotOracle sourceSnapshot : list) {
                TableProxyOracle tp = sourceSnapshot.getImplementedTable();
                if (tp == null) {
                    tp = sourceSnapshot.getOnPrebuildTable();
                }
                if (checkSelectedIDs && this.selectedIDs != null) {
                    if (tp == null || !this.selectedIDs.containsKey(tp.getObjectID())) continue;
                    this.addSnapshot(sourceSnapshot, allsSnapshotsSel, alltSnapshotsSel);
                    continue;
                }
                this.addSnapshot(sourceSnapshot, allsSnapshotsSel, alltSnapshotsSel);
            }
            if (this.selectedIDs == null) {
                list.clear();
                storageDesign.getSequenceSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                for (SequenceOracle sourceSequence : list) {
                    this.addSequence(sourceSequence, allsSequencesSel, alltSequencesSel);
                }
            }
        }
        this.addDeletedTables(allsTabsel, alltTabsel);
        this.addDeletedTableViews(allsTabViewSel, alltTabViewSel);
        if (addStorageObjects) {
            this.addDeletedSnapshots(allsSnapshotsSel, alltSnapshotsSel);
            if (this.selectedIDs == null) {
                this.addDeletedSequences(allsSequencesSel, alltSequencesSel);
            }
        }
        this.addChild(allsTabsel);
        this.rightRelationalRoot.addChild(alltTabsel);
        this.addChild(allsTabViewSel);
        this.rightRelationalRoot.addChild(alltTabViewSel);
        if (addStorageObjects) {
            this.addChild(allsSnapshotsSel);
            this.rightRelationalRoot.addChild(alltSnapshotsSel);
            this.addChild(allsSequencesSel);
            this.rightRelationalRoot.addChild(alltSequencesSel);
        }
    }

    private List excludeModelObjects(List list) {
        boolean use = ApplicationView.getInstance().getSettings().isUseDBSyncSourceConnection();
        if (!this.syncConnFlag || !use) {
            return list;
        }
        List<String> syncConnNames = this.getSyncConnNames();
        ArrayList<ModelObject> newList = new ArrayList<ModelObject>();
        for (int i = 0; i < list.size(); ++i) {
            ModelObject obj = (ModelObject)list.get(i);
            String objName = obj.getSourceConnName();
            if (!"".equals(objName) && !syncConnNames.contains(objName)) continue;
            newList.add(obj);
        }
        return newList;
    }

    private boolean excludeModelObject(ModelObject obj) {
        if (!this.syncConnFlag) {
            return false;
        }
        List<String> syncConnNames = this.getSyncConnNames();
        boolean use = obj.getAppView().getSettings().isUseDBSyncSourceConnection();
        String objName = obj.getSourceConnName();
        return use && !"".equals(objName) && !syncConnNames.contains(objName);
    }

    private List<String> getSyncConnNames() {
        ArrayList<String> syncConnNames = new ArrayList<String>();
        if (this.syncMode) {
            for (int i = 0; i < this.sourcedes.getImportConnectionStamps().size(); ++i) {
                if (this.sourcedes.getImportConnectionStamp(i).getSyncSelected() != 1) continue;
                syncConnNames.add(this.sourcedes.getImportConnectionStamp(i).getConnName());
            }
        } else {
            for (int i = 0; i < this.targetdes.getImportConnectionStamps().size(); ++i) {
                if (this.targetdes.getImportConnectionStamp(i).getSyncSelected() != 1) continue;
                syncConnNames.add(this.targetdes.getImportConnectionStamp(i).getConnName());
            }
        }
        return syncConnNames;
    }

    private List getTables(StorageDesignOracle storageDesign) {
        ArrayList<DesignObject> list = new ArrayList<DesignObject>();
        Iterator it = storageDesign.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyOracle proxy = (TableProxyOracle)it.next();
            list.add(proxy.getObject());
        }
        return list;
    }

    private void addSequence(SequenceOracle sourceSequence, ModelIdObjectSelection allsSequencesSel, ModelIdObjectSelection alltSequencesSel) {
        SequenceComparator comp;
        CompareObjectSelection sourceSequenceSel = new CompareObjectSelection(sourceSequence);
        StorageDesignOracle tStorageDesign = (StorageDesignOracle)this.getTargetStorageDesign();
        boolean useSyncSchema = this.object.getAppView().getSettings().isUseDBSyncSourceSchema();
        SequenceOracle targetSequence = (SequenceOracle)CompareModelToModel.getCorrespondingImportedObject(tStorageDesign.getSequenceSet().iterator(), sourceSequence, useSyncSchema);
        if (this.useGenerateInDDL && (!sourceSequence.isMarkedGenerate() || targetSequence != null && !targetSequence.isMarkedGenerate())) {
            if (sourceSequence != null && targetSequence != null) {
                this.objectsMap.put(sourceSequence.getObjectID(), targetSequence);
            }
            return;
        }
        if (targetSequence == null) {
            String sourceSequenceName = sourceSequence.getName();
            String sourceUserName = sourceSequence.getUser() == null ? "" : sourceSequence.getUser().getName();
            targetSequence = (SequenceOracle)tStorageDesign.getSequenceSet().getByUserSchemaAndName(sourceUserName, sourceSequenceName);
            if (targetSequence == null && !useSchema) {
                targetSequence = (SequenceOracle)tStorageDesign.getSequenceSet().getByName(sourceSequenceName);
            }
        }
        CompareObjectSelection targetSequenceSel = null;
        if (targetSequence != null) {
            targetSequenceSel = new CompareObjectSelection(targetSequence);
            comp = new SequenceComparator(sourceSequence, targetSequence);
            sourceSequenceSel.setPropertiesComparator(comp);
            targetSequenceSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSequenceSel.setSelected(comp.isModified());
            this.objectsMap.put(sourceSequence.getObjectID(), targetSequence);
        } else {
            sourceSequenceSel.setSelected(true);
            targetSequenceSel = new CompareObjectSelection(NEW_SEQUENCE);
            comp = new SequenceComparator(sourceSequence, targetSequence);
            sourceSequenceSel.setPropertiesComparator(comp);
            targetSequenceSel.setPropertiesComparator(comp);
            targetSequenceSel.setElementDescriptor(SequenceOracle.class);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceSequence.getObjectID(), null);
            sourceSequenceSel.setStatus(STATE_NEW);
            targetSequenceSel.setStatus(STATE_NEW);
            this.newMappings.add(sourceSequenceSel);
        }
        targetSequenceSel.setCorrespondentNode(sourceSequenceSel);
        sourceSequenceSel.setCorrespondentNode(targetSequenceSel);
        allsSequencesSel.addChild(sourceSequenceSel);
        alltSequencesSel.addChild(targetSequenceSel);
    }

    private void addDeletedSnapshots(ModelIdObjectSelection allsSnapshotsSel, ModelIdObjectSelection alltSnapshotsSel) {
        StorageDesign stoDesign = this.targetdes.getStorageDesign();
        if (stoDesign instanceof StorageDesignOracle) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)stoDesign;
            Iterator it = storageDesign.getSnapshotSet().iterator();
            while (it.hasNext()) {
                SnapshotOracle targetSnapshot = (SnapshotOracle)it.next();
                TableProxyOracle tp = targetSnapshot.getImplementedTable();
                if (tp == null) {
                    tp = targetSnapshot.getOnPrebuildTable();
                }
                if (this.selectedIDs != null && tp != null && !this.selectedIDs.containsKey(tp.getObjectID()) || this.objectsMap.containsValue(targetSnapshot)) continue;
                CompareObjectSelection tSnapshopSel = new CompareObjectSelection(TO_DROP);
                this.deletedMappings.add(tSnapshopSel);
                tSnapshopSel.setSelected(false);
                CompareObjectSelection sSnapshopSel = new CompareObjectSelection(targetSnapshot);
                tSnapshopSel.setElementDescriptor(SnapshotOracle.class);
                SnapshotComparator comp = new SnapshotComparator(null, targetSnapshot, this.objectsMap);
                this.comparatorsMap.put(comp.getID(), comp);
                tSnapshopSel.setPropertiesComparator(comp);
                sSnapshopSel.setPropertiesComparator(comp);
                tSnapshopSel.setStatus(STATE_DELETED);
                sSnapshopSel.setStatus(STATE_DELETED);
                sSnapshopSel.setCorrespondentNode(tSnapshopSel);
                tSnapshopSel.setCorrespondentNode(sSnapshopSel);
                allsSnapshotsSel.addChild(tSnapshopSel);
                alltSnapshotsSel.addChild(sSnapshopSel);
            }
        }
    }

    private void addDeletedSequences(ModelIdObjectSelection allsSequenceSel, ModelIdObjectSelection alltSequenceSel) {
        StorageDesign stoDesign = this.targetdes.getStorageDesign();
        if (stoDesign instanceof StorageDesignOracle) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)stoDesign;
            Iterator it = storageDesign.getSequenceSet().iterator();
            while (it.hasNext()) {
                SequenceOracle targetSequence = (SequenceOracle)it.next();
                if (this.objectsMap.containsValue(targetSequence)) continue;
                CompareObjectSelection tSequenceSel = new CompareObjectSelection(TO_DROP);
                this.deletedMappings.add(tSequenceSel);
                tSequenceSel.setSelected(false);
                CompareObjectSelection sSequenceSel = new CompareObjectSelection(targetSequence);
                tSequenceSel.setElementDescriptor(SequenceOracle.class);
                SequenceComparator comp = new SequenceComparator(null, targetSequence);
                this.comparatorsMap.put(comp.getID(), comp);
                tSequenceSel.setPropertiesComparator(comp);
                sSequenceSel.setPropertiesComparator(comp);
                tSequenceSel.setStatus(STATE_DELETED);
                sSequenceSel.setStatus(STATE_DELETED);
                sSequenceSel.setCorrespondentNode(tSequenceSel);
                tSequenceSel.setCorrespondentNode(sSequenceSel);
                allsSequenceSel.addChild(tSequenceSel);
                alltSequenceSel.addChild(sSequenceSel);
            }
        }
    }

    private void addSnapshot(SnapshotOracle sourceSnapshot, ModelIdObjectSelection allsSnapshotsSel, ModelIdObjectSelection alltSnapshotsSel) {
        StorageDesignOracle tStorageDesign = (StorageDesignOracle)this.getTargetStorageDesign();
        boolean useSyncSchema = this.object.getAppView().getSettings().isUseDBSyncSourceSchema();
        SnapshotOracle targetSnapshot = (SnapshotOracle)CompareModelToModel.getCorrespondingImportedObject(tStorageDesign.getSnapshotSet().iterator(), sourceSnapshot, useSyncSchema);
        if (targetSnapshot == null) {
            targetSnapshot = (SnapshotOracle)tStorageDesign.getSnapshotSet().getByName(sourceSnapshot.getName());
        }
        if (this.useGenerateInDDL && (!sourceSnapshot.isMarkedGenerate() || targetSnapshot != null && !targetSnapshot.isMarkedGenerate())) {
            if (sourceSnapshot != null && targetSnapshot != null) {
                this.objectsMap.put(sourceSnapshot.getObjectID(), targetSnapshot);
            }
            return;
        }
        CompareObjectSelection sourceSnapshotSel = new CompareObjectSelection(sourceSnapshot);
        CompareObjectSelection targetSnapshotSel = null;
        if (targetSnapshot != null) {
            targetSnapshotSel = new CompareObjectSelection(targetSnapshot);
            SnapshotComparator comp = new SnapshotComparator(sourceSnapshot, targetSnapshot, this.objectsMap);
            sourceSnapshotSel.setPropertiesComparator(comp);
            targetSnapshotSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSnapshotSel.setSelected(comp.isModified());
            this.objectsMap.put(sourceSnapshot.getObjectID(), targetSnapshot);
        } else {
            sourceSnapshotSel.setSelected(true);
            targetSnapshotSel = new CompareObjectSelection(NEW_SNAPSHOT);
            SnapshotComparator comp = new SnapshotComparator(sourceSnapshot, targetSnapshot, this.objectsMap);
            sourceSnapshotSel.setPropertiesComparator(comp);
            targetSnapshotSel.setPropertiesComparator(comp);
            targetSnapshotSel.setElementDescriptor(TableView.class);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceSnapshot.getObjectID(), null);
            sourceSnapshotSel.setStatus(STATE_NEW);
            targetSnapshotSel.setStatus(STATE_NEW);
            this.newMappings.add(sourceSnapshotSel);
        }
        targetSnapshotSel.setCorrespondentNode(sourceSnapshotSel);
        sourceSnapshotSel.setCorrespondentNode(targetSnapshotSel);
        allsSnapshotsSel.addChild(sourceSnapshotSel);
        alltSnapshotsSel.addChild(targetSnapshotSel);
    }

    private void addColumn(Column sourceColumn, Table targetTable, FilteredSelection sourceColumnSel, FilteredSelection targetColumnSel, int columnPos) {
        ColumnSelection sColsel = new ColumnSelection(sourceColumn);
        ModelIdObjectSelection tColsel = null;
        ColumnProxy sourceColumnProxy = (ColumnProxy)this.getSourceStorageDesign().getColumnProxySet().getProxy(sourceColumn.getObjectID());
        Column targetColumn = null;
        if (targetTable != null && (targetColumn = (Column)this.getCorrespondingColumn(targetTable.getElements(), sourceColumn, columnPos)) != null) {
            tColsel = new FilteredSelection(targetColumn);
            ColumnProxy targetColumnProxy = (ColumnProxy)this.getTargetStorageDesign().getColumnProxySet().getProxy(targetColumn.getObjectID());
            ColumnComparator comp = new ColumnComparator(sourceColumn, targetColumn, sourceColumnProxy, targetColumnProxy, this.objectsMap);
            sColsel.setPropertiesComparator(comp);
            ((CompareObjectSelection)tColsel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            ((CompareObjectSelection)sColsel).setSelected(comp.isModified());
            sColsel.setEditable(comp.isModified());
            this.objectsMap.put(sourceColumn.getObjectID(), targetColumn);
        }
        if (targetColumn == null) {
            ((CompareObjectSelection)sColsel).setSelected(true);
            tColsel = new FilteredSelection(NEW_COLUMN);
            ((CompareObjectSelection)tColsel).setStatus(STATE_NEW);
            sColsel.setStatus(STATE_NEW);
            this.newMappings.add(sColsel);
            ColumnComparator comp = new ColumnComparator(sourceColumn, targetColumn, sourceColumnProxy, null, this.objectsMap);
            sColsel.setPropertiesComparator(comp);
            ((CompareObjectSelection)tColsel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceColumn.getObjectID(), null);
        }
        tColsel.setElementDescriptor(Column.class);
        sColsel.setCorrespondentNode((CompareObjectSelection)tColsel);
        ((CompareObjectSelection)tColsel).setCorrespondentNode(sColsel);
        sourceColumnSel.addChild(sColsel);
        targetColumnSel.addChild(tColsel);
        if (((ColumnComparator)((CompareObjectSelection)tColsel).getPropertiesComparator()).isDataTypeChanged()) {
            this.columnsWithChangedDataType.add(tColsel);
        }
    }

    private ContainedObject getCorrespondingNestedColumn(List targetNestedElements, ContainedObject sourceColumn) {
        TypeElement targetStructAtt;
        ContainedObject targetParentColumn;
        ContainedObject sourceParentColumn = sourceColumn.getParentObject();
        if (sourceParentColumn != null && (targetParentColumn = (ContainedObject)this.objectsMap.get(sourceParentColumn.getObjectID())) != null && (targetStructAtt = (TypeElement)this.objectsMap.get(sourceColumn.getStructAttributeID())) != null) {
            String targetStructAttID = targetStructAtt.getObjectID();
            String targetParentColumnID = targetParentColumn.getObjectID();
            for (ContainedObject targetCol : targetNestedElements) {
                ContainedObject parentCol;
                if (!targetCol.getStructAttributeID().equals(targetStructAttID) || (parentCol = targetCol.getParentObject()) == null || !parentCol.getObjectID().equals(targetParentColumnID)) continue;
                return targetCol;
            }
        }
        return null;
    }

    private DesignObject getCorrespondingColumn(ContainedObject[] elements, Column object, int columnPos) {
        ContainedObject obj;
        CompareMapping compareMapping = this.sourcedes.getDesign().getDesignLevelSettings().getCompareMapping();
        for (int i = 0; i < elements.length; ++i) {
            ContainedObject obj2 = elements[i];
            if (!(obj2.getImportedId() != null && obj2.getImportedId().equals(object.getObjectID()) || object.getImportedId() != null && object.getImportedId().equals(obj2.getObjectID()) || object.getObjectID().equals(obj2.getObjectID())) && (obj2.getImportedId() == null || object.getImportedId() == null || !obj2.getImportedId().equals(object.getImportedId()))) continue;
            return obj2;
        }
        boolean useName = object.getAppView().getSettings().isUseDBSyncSourceObject();
        DesignObject impCol = null;
        if (useName) {
            impCol = (DesignObject)CompareModelToModel.getCorrespondingImportedColumn(elements, object);
        }
        if (impCol != null) {
            return impCol;
        }
        for (int i = 0; i < elements.length; ++i) {
            ContainedObject obj3 = elements[i];
            if (!(caseSensitive ? ((DesignObject)obj3).getName().equals(object.getName()) : ((DesignObject)obj3).getName().equalsIgnoreCase(object.getName()))) continue;
            return obj3;
        }
        if (compareMapping.getCompareMap().containsKey(object.getName())) {
            Table targetTable;
            Column sourceCol = object;
            Table sourceTable = (Table)sourceCol.getContainer();
            CompareMappingObject compObject = compareMapping.getCompareMap().get(object.getName());
            if (compObject != null && compObject.isSelected() && sourceTable.getName().equals(compObject.getSourceParentName()) && (targetTable = (Table)this.targetdes.getTableSet().getByName(compObject.getTargetParentName())) != null) {
                Column targetColumn = (Column)targetTable.getElementByName(compObject.getTargetObjectName());
                return targetColumn;
            }
        }
        if (columnPos < elements.length && (obj = elements[columnPos]) instanceof Column) {
            Column targetCol = (Column)obj;
            Column sourceCol = object;
            if (targetCol.getIndex() == object.getIndex() && targetCol.getDataType().toString().equals(sourceCol.getDataType().toString()) && sourceCol.getContainer().getElementByName(targetCol.getName()) == null) {
                return targetCol;
            }
        }
        return null;
    }

    private void addTableDetails(Table sourceTable, CompareObjectSelection sourceTabsel, Table targetTable, CompareObjectSelection targetTabSel) {
        FilteredSelection sourceColumnSel = new FilteredSelection(Messages.getString("CompareModelToModel.Columns"));
        FilteredSelection targetColumnSel = new FilteredSelection(Messages.getString("CompareModelToModel.Columns"));
        sourceColumnSel.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
        targetColumnSel.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
        sourceColumnSel.setCorrespondentNode(targetColumnSel);
        targetColumnSel.setCorrespondentNode(sourceColumnSel);
        this.setEmptyComparator(sourceColumnSel);
        this.setEmptyComparator(targetColumnSel);
        targetColumnSel.setSelected(false);
        Iterator<Object> it = sourceTable.getElementsCollection().iterator();
        int pos = 0;
        while (it.hasNext()) {
            Column sourceColumn = (Column)it.next();
            this.addColumn(sourceColumn, targetTable, sourceColumnSel, targetColumnSel, pos);
            ++pos;
        }
        if (targetTable != null) {
            this.addDeletedColumns(sourceTable, sourceColumnSel, targetTable, targetColumnSel);
            List targetNestedElements = targetTable.getNestedElements();
            if (targetNestedElements.size() > 0) {
                for (ContainedObject sourceNestedColumn : sourceTable.getNestedElements()) {
                    ContainedObject targetNestedColumn = this.getCorrespondingNestedColumn(targetNestedElements, sourceNestedColumn);
                    if (targetNestedColumn == null) continue;
                    this.objectsMap.put(sourceNestedColumn.getObjectID(), targetNestedColumn);
                }
            }
        }
        sourceTabsel.addChild(sourceColumnSel);
        targetTabSel.addChild(targetColumnSel);
        ((TableComparator)sourceTabsel.getPropertiesComparator()).presetColumnsOrder();
        this.initIndexes(sourceTable);
        FilteredSelection allsPlainsel = new FilteredSelection(Messages.getString("CompareModelToModel.Indexes"));
        FilteredSelection alltPlainSel = new FilteredSelection(Messages.getString("CompareModelToModel.Indexes"));
        allsPlainsel.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
        alltPlainSel.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
        allsPlainsel.setCorrespondentNode(alltPlainSel);
        alltPlainSel.setCorrespondentNode(allsPlainsel);
        this.setEmptyComparator(allsPlainsel);
        this.setEmptyComparator(alltPlainSel);
        alltPlainSel.setSelected(false);
        for (Index sourceIndex : this.indexes) {
            this.addIndex(sourceIndex, targetTable, allsPlainsel, alltPlainSel, false);
        }
        if (targetTable != null) {
            this.addDeletedIndexes(targetTable, allsPlainsel, alltPlainSel, false);
        }
        sourceTabsel.addChild(allsPlainsel);
        targetTabSel.addChild(alltPlainSel);
        FilteredSelection allsIndsel = new FilteredSelection(Messages.getString("CompareModelToModel.PKUKConstraints"));
        FilteredSelection alltIndSel = new FilteredSelection(Messages.getString("CompareModelToModel.PKUKConstraints"));
        allsIndsel.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        alltIndSel.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        allsIndsel.setCorrespondentNode(alltIndSel);
        alltIndSel.setCorrespondentNode(allsIndsel);
        this.setEmptyComparator(allsIndsel);
        this.setEmptyComparator(alltIndSel);
        alltIndSel.setSelected(false);
        for (Index sourceIndex : this.pkInd) {
            this.addIndex(sourceIndex, targetTable, allsIndsel, alltIndSel, true);
        }
        if (targetTable != null) {
            this.addDeletedIndexes(targetTable, allsIndsel, alltIndSel, true);
        }
        sourceTabsel.addChild(allsIndsel);
        targetTabSel.addChild(alltIndSel);
        FilteredSelection allsFKsel = new FilteredSelection(Messages.getString("CompareModelToModel.ForeignKeys"));
        FilteredSelection alltFKSel = new FilteredSelection(Messages.getString("CompareModelToModel.ForeignKeys"));
        allsFKsel.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        alltFKSel.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        allsFKsel.setCorrespondentNode(alltFKSel);
        alltFKSel.setCorrespondentNode(allsFKsel);
        this.setEmptyComparator(allsFKsel);
        this.setEmptyComparator(alltFKSel);
        alltFKSel.setSelected(false);
        List<FKIndexAssociation> sourcefkIndexes = Arrays.asList(sourceTable.getFKAssociations());
        for (FKIndexAssociation sourcefk : sourcefkIndexes) {
            this.addFK(sourcefk, allsFKsel, alltFKSel);
        }
        if (targetTable != null) {
            this.addDeletedFKAssociation(targetTable, allsFKsel, alltFKSel);
        }
        sourceTabsel.addChild(allsFKsel);
        targetTabSel.addChild(alltFKSel);
        String tableCheckConstraintsText = Messages.getString("CompareModelToModel.TableCheckConstraints");
        FilteredSelection sourceCheckSel = new FilteredSelection(tableCheckConstraintsText);
        FilteredSelection targetCheckSel = new FilteredSelection(tableCheckConstraintsText);
        sourceCheckSel.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON"));
        targetCheckSel.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON"));
        sourceCheckSel.setCorrespondentNode(targetCheckSel);
        targetCheckSel.setCorrespondentNode(sourceCheckSel);
        this.setEmptyComparator(sourceCheckSel);
        this.setEmptyComparator(targetCheckSel);
        targetCheckSel.setSelected(false);
        for (TableLevelConstraint sourceConstraint : sourceTable.getCheckConstraints()) {
            this.addCheckConstraint(sourceConstraint, targetTable, sourceCheckSel, targetCheckSel);
        }
        if (targetTable != null) {
            this.addDeletedCheckConstraints(targetTable, sourceCheckSel, targetCheckSel);
        }
        sourceTabsel.addChild(sourceCheckSel);
        targetTabSel.addChild(targetCheckSel);
        String validTimeDimensionsText = Messages.getString("CompareModelToModel.ValidTimeDimensions");
        FilteredSelection sourceTimeDimSel = new FilteredSelection(validTimeDimensionsText);
        FilteredSelection targetTimeDimSel = new FilteredSelection(validTimeDimensionsText);
        Icon dimensionIcon = GUIConfiguration.getInstance().getIcon("DIMENSION_ICON");
        sourceTimeDimSel.setIcon(dimensionIcon);
        targetTimeDimSel.setIcon(dimensionIcon);
        sourceTimeDimSel.setCorrespondentNode(targetTimeDimSel);
        targetTimeDimSel.setCorrespondentNode(sourceTimeDimSel);
        this.setEmptyComparator(sourceTimeDimSel);
        this.setEmptyComparator(targetTimeDimSel);
        targetTimeDimSel.setSelected(false);
        for (ValidTimeDimension sourceTimeDim : sourceTable.getValidTimeDimensions()) {
            this.addTimeDimension(sourceTimeDim, targetTable, sourceTimeDimSel, targetTimeDimSel);
        }
        if (targetTable != null) {
            this.addDeletedTimeDimensions(targetTable, sourceTimeDimSel, targetTimeDimSel);
        }
        sourceTabsel.addChild(sourceTimeDimSel);
        targetTabSel.addChild(targetTimeDimSel);
        if (!PropertiesComparator.DDL_ONLY) {
            this.addArcs(sourceTable, sourceTabsel, targetTable, targetTabSel);
        }
    }

    private void addDeletedFKAssociation(Table targetTable, FilteredSelection allsFKsel, FilteredSelection alltFKeSel) {
        for (FKIndexAssociation targetfk : Arrays.asList(targetTable.getFKAssociations())) {
            if (this.objectsMap.containsValue(targetfk)) continue;
            ModelIDObject tproxy = null;
            if (targetfk != null) {
                tproxy = this.getTargetStorageDesign().getStorageObject(targetfk.getObjectID());
            }
            if (tproxy == null) {
                tproxy = targetfk;
            }
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, tproxy)) continue;
            String tfkname = targetfk.getName() + " (" + targetfk.getContainerWithKeyObject().getName() + " : " + targetfk.getRemoteTable().getName() + " )";
            FilteredSelection sfksel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sfksel);
            sfksel.setSelected(false);
            FilteredSelection tfksel = new FilteredSelection(targetfk);
            tfksel.setElementDescriptor(FKIndexAssociation.class);
            sfksel.setElementDescriptor(FKIndexAssociation.class);
            this.setEmptyComparator(sfksel);
            FKComparator comp = new FKComparator(null, targetfk, false, false, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            tfksel.setPropertiesComparator(comp);
            tfksel.setName(tfkname);
            sfksel.setStatus(STATE_DELETED);
            tfksel.setStatus(STATE_DELETED);
            tfksel.setCorrespondentNode(sfksel);
            sfksel.setCorrespondentNode(tfksel);
            allsFKsel.addChild(sfksel);
            alltFKeSel.addChild(tfksel);
        }
    }

    private void initIndexes(Table r_table) {
        this.clearIndexList();
        Iterator it = r_table.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (key.isPK() || key.isUnique()) {
                this.pkInd.add(key);
                continue;
            }
            if (key.isFK()) continue;
            this.indexes.add(key);
        }
    }

    private void clearIndexList() {
        this.pkInd.clear();
        this.fkInd.clear();
        this.indexes.clear();
    }

    private void addIndex(Index sourceIndex, Table targetTable, FilteredSelection allsIndsel, FilteredSelection alltIndSel, boolean pk_uk) {
        IndexComparator comp;
        Index targetIndex = null;
        ModelIDObject siproxy = this.getSourceStorageDesign().getStorageObject(sourceIndex.getObjectID());
        ModelIDObject tiproxy = null;
        if (targetTable != null) {
            List list = pk_uk ? targetTable.getPK_UKList() : targetTable.getIndexes_Plain_List();
            targetIndex = (Index)this.getCorrespondingObject(list, sourceIndex);
            if (siproxy == null) {
                siproxy = sourceIndex;
            }
            if (targetIndex != null) {
                tiproxy = this.getTargetStorageDesign().getStorageObject(targetIndex.getObjectID());
            }
            if (tiproxy == null) {
                tiproxy = targetIndex;
            }
        }
        if (this.useGenerateInDDL && (siproxy != null && !((ModelIDObject)siproxy).isMarkedGenerate() || tiproxy != null && !tiproxy.isMarkedGenerate())) {
            if (sourceIndex != null && targetIndex != null) {
                this.objectsMap.put(sourceIndex.getObjectID(), targetIndex);
            }
            return;
        }
        FilteredSelection sIndsel = new FilteredSelection(sourceIndex);
        sIndsel.setSelected(true);
        CompareObjectSelection tIndsel = null;
        if (targetTable != null) {
            if (targetIndex == null) {
                targetIndex = this.checkForEqualStructure(sourceIndex, targetTable, allsIndsel);
            }
            if (targetIndex != null) {
                tIndsel = new FilteredSelection(targetIndex);
                comp = new IndexComparator(sourceIndex, targetIndex, this.objectsMap, pk_uk, this.getSourceStorageDesign(), this.getTargetStorageDesign());
                sIndsel.setPropertiesComparator(comp);
                tIndsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sIndsel.setSelected(comp.isModified());
                sIndsel.setEditable(comp.isModified());
                comp.setLeftSelectionObject(sIndsel);
                this.objectsMap.put(sourceIndex.getObjectID(), targetIndex);
            }
        }
        if (targetIndex == null) {
            sIndsel.setSelected(true);
            tIndsel = new FilteredSelection(NEW_INDEX);
            tIndsel.setStatus(STATE_NEW);
            sIndsel.setStatus(STATE_NEW);
            this.newMappings.add(sIndsel);
            tIndsel.setElementDescriptor(Index.class);
            comp = new IndexComparator(sourceIndex, targetIndex, this.objectsMap, pk_uk, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            sIndsel.setPropertiesComparator(comp);
            tIndsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceIndex.getObjectID(), null);
        }
        sIndsel.setCorrespondentNode(tIndsel);
        tIndsel.setCorrespondentNode(sIndsel);
        alltIndSel.addChild(tIndsel);
        allsIndsel.addChild(sIndsel);
    }

    private Index checkForEqualStructure(Index sourceIndex, Table targetTable, FilteredSelection allsIndsel) {
        block4: {
            Table sourceTable;
            block5: {
                block3: {
                    sourceTable = (Table)sourceIndex.getContainerObject();
                    if (!sourceIndex.isPK()) break block3;
                    Index targetIndex = (Index)targetTable.getPK();
                    if (targetIndex != null && this.checkIndexes(sourceIndex, targetIndex)) {
                        return targetIndex;
                    }
                    break block4;
                }
                if (!sourceIndex.isUnique()) break block5;
                Iterator it = targetTable.getUKeys().iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    Index targetIndex = obj instanceof ContainerObjectPlaceHolder ? (Index)((ContainerObjectPlaceHolder)obj).getObject() : (Index)obj;
                    if (!this.checkIndexes(sourceIndex, targetIndex) || sourceTable.getUKeys().getByName(targetIndex.getName()) != null) continue;
                    return targetIndex;
                }
                break block4;
            }
            if (sourceIndex.isFK()) break block4;
            Iterator it = targetTable.getIndexes().iterator();
            while (it.hasNext()) {
                Index targetIndex = (Index)((ContainerObjectPlaceHolder)it.next()).getObject();
                if (!this.checkIndexes(sourceIndex, targetIndex) || sourceTable.getIndexes().getByName(targetIndex.getName()) != null) continue;
                return targetIndex;
            }
        }
        return null;
    }

    private boolean checkIndexes(Index sourceIndex, Index targetIndex) {
        ContainedObject[] targetColumns;
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        if (sourceColumns.length != (targetColumns = targetIndex.getElements()).length) {
            return false;
        }
        for (int i = 0; i < sourceColumns.length; ++i) {
            Column scol = (Column)sourceColumns[i];
            Column tcol = (Column)this.objectsMap.get(scol.getObjectID());
            if (tcol == null) {
                return false;
            }
            if (tcol.getName().equals(((Column)targetColumns[i]).getName())) continue;
            return false;
        }
        return true;
    }

    private void addCheckConstraint(TableLevelConstraint sourceConstraint, Table targetTable, FilteredSelection allsTlcSel, FilteredSelection alltTlcSel) {
        TableConstraintComparator comp;
        FilteredSelection sTlcSel = new FilteredSelection(sourceConstraint);
        sTlcSel.setSelected(true);
        CompareObjectSelection tTlcSel = null;
        TableLevelConstraint targetConstraint = null;
        if (targetTable != null) {
            targetConstraint = (TableLevelConstraint)this.getCorrespondingObject(targetTable.getCheckConstraints(), sourceConstraint);
            if (targetConstraint == null) {
                targetConstraint = this.checkForEqualRule(sourceConstraint, targetTable);
            }
            if (targetConstraint != null) {
                tTlcSel = new FilteredSelection(targetConstraint);
                comp = new TableConstraintComparator(sourceConstraint, targetConstraint);
                sTlcSel.setPropertiesComparator(comp);
                tTlcSel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sTlcSel.setSelected(comp.isModified());
                sTlcSel.setEditable(comp.isModified());
                comp.setLeftSelectionObject(sTlcSel);
                this.objectsMap.put(sourceConstraint.getObjectID(), targetConstraint);
            }
        }
        if (targetConstraint == null) {
            sTlcSel.setSelected(true);
            tTlcSel = new FilteredSelection(NEW_CONSTRAINT);
            tTlcSel.setStatus(STATE_NEW);
            sTlcSel.setStatus(STATE_NEW);
            this.newMappings.add(sTlcSel);
            tTlcSel.setElementDescriptor(TableLevelConstraint.class);
            comp = new TableConstraintComparator(sourceConstraint, targetConstraint);
            sTlcSel.setPropertiesComparator(comp);
            tTlcSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceConstraint.getObjectID(), null);
        }
        sTlcSel.setCorrespondentNode(tTlcSel);
        tTlcSel.setCorrespondentNode(sTlcSel);
        alltTlcSel.addChild(tTlcSel);
        allsTlcSel.addChild(sTlcSel);
    }

    private TableLevelConstraint checkForEqualRule(TableLevelConstraint sourceConstraint, Table targetTable) {
        for (TableLevelConstraint targetConstraint : targetTable.getCheckConstraints()) {
            if (!sourceConstraint.getRule().equals(targetConstraint.getRule())) continue;
            boolean nameMatch = false;
            for (TableLevelConstraint aSourceConstraint : sourceConstraint.getTable().getCheckConstraints()) {
                if (!aSourceConstraint.getName().equalsIgnoreCase(targetConstraint.getName())) continue;
                nameMatch = true;
            }
            if (nameMatch) continue;
            return targetConstraint;
        }
        return null;
    }

    private void addDeletedCheckConstraints(Table targetTable, FilteredSelection sourceCheckSel, FilteredSelection targetCheckSel) {
        for (TableLevelConstraint targetConstraint : targetTable.getCheckConstraints()) {
            if (this.objectsMap.containsValue(targetConstraint)) continue;
            FilteredSelection sTlcSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sTlcSel);
            sTlcSel.setSelected(false);
            sTlcSel.setElementDescriptor(TableLevelConstraint.class);
            FilteredSelection tTlcSel = new FilteredSelection(targetConstraint);
            tTlcSel.setElementDescriptor(TableLevelConstraint.class);
            TableConstraintComparator comp = new TableConstraintComparator(null, targetConstraint);
            this.comparatorsMap.put(comp.getID(), comp);
            tTlcSel.setPropertiesComparator(comp);
            sTlcSel.setPropertiesComparator(comp);
            sTlcSel.setStatus(STATE_DELETED);
            tTlcSel.setStatus(STATE_DELETED);
            tTlcSel.setCorrespondentNode(sTlcSel);
            sTlcSel.setCorrespondentNode(tTlcSel);
            sourceCheckSel.addChild(sTlcSel);
            targetCheckSel.addChild(tTlcSel);
        }
    }

    private void addTimeDimension(ValidTimeDimension sourceTimeDim, Table targetTable, FilteredSelection allsTimeDimSel, FilteredSelection alltTimeDimSel) {
        ValidTimeDimensionComparator comp;
        FilteredSelection sTimeDimSel = new FilteredSelection(sourceTimeDim);
        sTimeDimSel.setSelected(true);
        CompareObjectSelection tTimeDimSel = null;
        ValidTimeDimension targetTimeDim = null;
        if (targetTable != null && (targetTimeDim = (ValidTimeDimension)this.getCorrespondingObject(targetTable.getValidTimeDimensions(), sourceTimeDim)) != null) {
            tTimeDimSel = new FilteredSelection(targetTimeDim);
            comp = new ValidTimeDimensionComparator(sourceTimeDim, targetTimeDim);
            sTimeDimSel.setPropertiesComparator(comp);
            tTimeDimSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sTimeDimSel.setSelected(comp.isModified());
            sTimeDimSel.setEditable(comp.isModified());
            comp.setLeftSelectionObject(sTimeDimSel);
            this.objectsMap.put(sourceTimeDim.getObjectID(), targetTimeDim);
        }
        if (targetTimeDim == null) {
            sTimeDimSel.setSelected(true);
            tTimeDimSel = new FilteredSelection(NEW_VALID_TIME);
            tTimeDimSel.setStatus(STATE_NEW);
            sTimeDimSel.setStatus(STATE_NEW);
            this.newMappings.add(sTimeDimSel);
            tTimeDimSel.setElementDescriptor(ValidTimeDimension.class);
            comp = new ValidTimeDimensionComparator(sourceTimeDim, targetTimeDim);
            sTimeDimSel.setPropertiesComparator(comp);
            tTimeDimSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceTimeDim.getObjectID(), null);
        }
        sTimeDimSel.setCorrespondentNode(tTimeDimSel);
        tTimeDimSel.setCorrespondentNode(sTimeDimSel);
        alltTimeDimSel.addChild(tTimeDimSel);
        allsTimeDimSel.addChild(sTimeDimSel);
    }

    private void addDeletedTimeDimensions(Table targetTable, FilteredSelection sourceTimeDimSel, FilteredSelection targetTimeDimSel) {
        for (ValidTimeDimension targetTimeDim : targetTable.getValidTimeDimensions()) {
            if (this.objectsMap.containsValue(targetTimeDim)) continue;
            FilteredSelection sTlcSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sTlcSel);
            sTlcSel.setSelected(false);
            sTlcSel.setElementDescriptor(ValidTimeDimension.class);
            FilteredSelection tTlcSel = new FilteredSelection(targetTimeDim);
            tTlcSel.setElementDescriptor(ValidTimeDimension.class);
            ValidTimeDimensionComparator comp = new ValidTimeDimensionComparator(null, targetTimeDim);
            this.comparatorsMap.put(comp.getID(), comp);
            tTlcSel.setPropertiesComparator(comp);
            sTlcSel.setPropertiesComparator(comp);
            sTlcSel.setStatus(STATE_DELETED);
            tTlcSel.setStatus(STATE_DELETED);
            tTlcSel.setCorrespondentNode(sTlcSel);
            sTlcSel.setCorrespondentNode(tTlcSel);
            sourceTimeDimSel.addChild(sTlcSel);
            targetTimeDimSel.addChild(tTlcSel);
        }
    }

    public CompareObjectSelection getRelationalRoot() {
        return this;
    }

    public CompareObjectSelection getRightRelationalRoot() {
        return this.rightRelationalRoot;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    private void addDeletedColumns(Table sourceTable, FilteredSelection sourceColumnSel, Table targetTable, FilteredSelection targetColumnSel) {
        for (Column targetColumn : targetTable.getElementsCollection()) {
            if (this.objectsMap.containsValue(targetColumn)) continue;
            FilteredSelection sColsel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sColsel);
            sColsel.setSelected(false);
            sColsel.setElementDescriptor(Column.class);
            FilteredSelection tColSel = new FilteredSelection(targetColumn);
            tColSel.setElementDescriptor(Column.class);
            ColumnComparator comp = new ColumnComparator(null, targetColumn, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            tColSel.setPropertiesComparator(comp);
            sColsel.setPropertiesComparator(comp);
            sColsel.setStatus(STATE_DELETED);
            tColSel.setStatus(STATE_DELETED);
            tColSel.setCorrespondentNode(sColsel);
            sColsel.setCorrespondentNode(tColSel);
            sourceColumnSel.addChild(sColsel);
            targetColumnSel.addChild(tColSel);
        }
    }

    private void addDeletedIndexes(Table targetTable, FilteredSelection allsIndsel, FilteredSelection alltIndsel, boolean isPKorUK) {
        Iterator it = targetTable.getKeySet().iterator();
        while (it.hasNext()) {
            Index ind;
            boolean isdeleted;
            Index targetIndex = (Index)it.next();
            boolean bl = isdeleted = isPKorUK == (targetIndex.isPK() || targetIndex.isUnique());
            if (targetIndex.isFK() || !isdeleted || this.objectsMap.containsValue(targetIndex) || this.syncMode && !isPKorUK && (ind = targetTable.getPKorUKWithName(targetIndex.getName())) != null) continue;
            ModelIDObject tiproxy = null;
            if (targetIndex != null) {
                tiproxy = this.getTargetStorageDesign().getStorageObject(targetIndex.getObjectID());
            }
            if (tiproxy == null) {
                tiproxy = targetIndex;
            }
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, tiproxy)) continue;
            FilteredSelection sIndsel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sIndsel);
            sIndsel.setSelected(false);
            FilteredSelection tIndsel = new FilteredSelection(targetIndex);
            sIndsel.setElementDescriptor(Index.class);
            IndexComparator comp = new IndexComparator(null, targetIndex, this.objectsMap, isPKorUK, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            this.comparatorsMap.put(comp.getID(), comp);
            tIndsel.setPropertiesComparator(comp);
            sIndsel.setPropertiesComparator(comp);
            sIndsel.setStatus(STATE_DELETED);
            tIndsel.setStatus(STATE_DELETED);
            tIndsel.setCorrespondentNode(sIndsel);
            sIndsel.setCorrespondentNode(tIndsel);
            allsIndsel.addChild(sIndsel);
            alltIndsel.addChild(tIndsel);
        }
    }

    private void addDeletedTables(ModelIdObjectSelection allsTabsel, ModelIdObjectSelection alltTabsel) {
        Iterator it = this.getTargetStorageDesign() instanceof StorageDesignOracle ? this.getTables((StorageDesignOracle)this.getTargetStorageDesign()).iterator() : this.targetdes.getTableSet().iterator();
        while (it.hasNext()) {
            Table targetTable = (Table)it.next();
            if (this.selectedIDs != null && !this.selectedIDs.containsKey(targetTable.getObjectID()) || this.objectsMap.containsValue(targetTable) || this.excludeModelObject(targetTable)) continue;
            TableProxy tTableProxy = null;
            if (targetTable != null) {
                tTableProxy = (TableProxy)this.getTargetStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
            }
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, tTableProxy)) continue;
            FilteredSelection targetTabsel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(targetTabsel);
            targetTabsel.setSelected(false);
            FilteredSelection sourceTabsel = new FilteredSelection(targetTable);
            targetTabsel.setElementDescriptor(Table.class);
            tTableProxy = (TableProxy)this.getTargetStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
            TableComparator comp = new TableComparator(null, targetTable, null, tTableProxy);
            this.comparatorsMap.put(comp.getID(), comp);
            targetTabsel.setPropertiesComparator(comp);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setStatus(STATE_DELETED);
            sourceTabsel.setCorrespondentNode(targetTabsel);
            targetTabsel.setCorrespondentNode(sourceTabsel);
            allsTabsel.addChild(targetTabsel);
            alltTabsel.addChild(sourceTabsel);
        }
    }

    private void addDeletedTableViews(ModelIdObjectSelection allsTabViewSel, ModelIdObjectSelection alltTabViewSel) {
        Iterator it = this.targetdes.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView targetTableView = (TableView)it.next();
            if (this.selectedIDs != null && !this.selectedIDs.containsKey(targetTableView.getObjectID()) || this.objectsMap.containsValue(targetTableView)) continue;
            TableViewProxy tViewProxy = (TableViewProxy)this.getTargetStorageDesign().getProxy(targetTableView.getObjectID());
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, tViewProxy)) continue;
            FilteredSelection tTabViewSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(tTabViewSel);
            tTabViewSel.setSelected(false);
            FilteredSelection sTabViewSel = new FilteredSelection(targetTableView);
            tTabViewSel.setElementDescriptor(TableView.class);
            TableViewComparator comp = new TableViewComparator(null, targetTableView, null, tViewProxy);
            this.comparatorsMap.put(comp.getID(), comp);
            tTabViewSel.setPropertiesComparator(comp);
            sTabViewSel.setPropertiesComparator(comp);
            tTabViewSel.setStatus(STATE_DELETED);
            sTabViewSel.setStatus(STATE_DELETED);
            sTabViewSel.setCorrespondentNode(tTabViewSel);
            tTabViewSel.setCorrespondentNode(sTabViewSel);
            allsTabViewSel.addChild(tTabViewSel);
            alltTabViewSel.addChild(sTabViewSel);
        }
    }

    public List getDeletedMappings() {
        return this.deletedMappings;
    }

    public List getNewMappings() {
        return this.newMappings;
    }

    public Map getObjectsMap() {
        return this.objectsMap;
    }

    @Override
    protected DDLGenerator createDDLGenerator() {
        StorageDesign targetStorageDesign = this.targetdes.getStorageDesign();
        if (targetStorageDesign instanceof StorageDesignOraclev11g) {
            return this.createDDLGeneratorOraclev11g();
        }
        if (targetStorageDesign instanceof StorageDesignOraclev10g) {
            return this.createDDLGeneratorOraclev10g();
        }
        return super.createDDLGenerator();
    }

    private DDLGenerator createDDLGeneratorOraclev11g() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        CSSBCreateTableOraclev11g cssbCreateTableOraclev11g = new CSSBCreateTableOraclev11g();
        ddlGenerator.append(cssbCreateTableOraclev11g);
        ddlGenerator.append(new CSSBRenameTableOraclev11g(this.fkMap));
        ddlGenerator.append(new CSSBAlterTableOraclev10g());
        ddlGenerator.append(new CSSBAlterIndexOraclev11g(this.fkMap));
        ddlGenerator.append(new CSSBAlterColumnOraclev11g());
        ddlGenerator.append(new CSSBAddValidTimeOraclev11g());
        ddlGenerator.append(new CSSBAlterTableConstraint());
        ddlGenerator.append(new CSSBFKIndexOraclev10g(this.fkMap));
        ddlGenerator.append(new CSSBSnapshotOraclev11g(cssbCreateTableOraclev11g));
        ddlGenerator.append(new CSSBSequenceOracle10vg());
        ddlGenerator.append(new CSSBTableViewOraclev10g());
        return ddlGenerator;
    }

    private DDLGenerator createDDLGeneratorOraclev10g() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        CSSBCreateTableOraclev10g cssbCreateTableOraclev10g = new CSSBCreateTableOraclev10g();
        ddlGenerator.append(cssbCreateTableOraclev10g);
        ddlGenerator.append(new CSSBRenameTableOraclev10g(this.fkMap));
        ddlGenerator.append(new CSSBAlterTableOraclev10g());
        ddlGenerator.append(new CSSBAlterIndexOraclev10g(this.fkMap));
        ddlGenerator.append(new CSSBAlterColumnOraclev10g());
        ddlGenerator.append(new CSSBAlterTableConstraint());
        ddlGenerator.append(new CSSBFKIndexOraclev10g(this.fkMap));
        ddlGenerator.append(new CSSBSnapshotOraclev10g(cssbCreateTableOraclev10g));
        ddlGenerator.append(new CSSBSequenceOracle10vg());
        ddlGenerator.append(new CSSBTableViewOraclev10g());
        return ddlGenerator;
    }

    public StorageDesign getSourceStorageDesign() {
        return this.sourcedes.getStorageDesign();
    }

    public StorageDesign getTargetStorageDesign() {
        return this.targetdes.getStorageDesign();
    }

    public Map getLeftSelectionMap() {
        return this.leftSelectionMap;
    }

    public List getColumnsWithChangedDataType() {
        return this.columnsWithChangedDataType;
    }

    public List getTablesToRecreate() {
        return this.tablesToRecreate;
    }

    private void addDataTypes() {
        FilteredSelection sDTModel = new FilteredSelection(Messages.getString("CompareCWDDesigns.DataTypesModel"));
        FilteredSelection tDTModel = new FilteredSelection(Messages.getString("CompareCWDDesigns.DataTypesModel"));
        sDTModel.setCorrespondentNode(tDTModel);
        tDTModel.setCorrespondentNode(sDTModel);
        this.setEmptyComparator(sDTModel);
        this.setEmptyComparator(tDTModel);
        this.addChild(sDTModel);
        this.rightRelationalRoot.addChild(tDTModel);
        FilteredSelection sDistType = new FilteredSelection(Messages.getString("CompareCWDDesigns.DistinctTypes"));
        FilteredSelection tDistType = new FilteredSelection(Messages.getString("CompareCWDDesigns.DistinctTypes"));
        sDistType.setCorrespondentNode(tDistType);
        tDistType.setCorrespondentNode(sDistType);
        this.setEmptyComparator(sDistType);
        this.setEmptyComparator(tDistType);
        sDTModel.addChild(sDistType);
        tDTModel.addChild(tDistType);
        tDistType.setSelected(false);
        FilteredSelection sStrType = new FilteredSelection(Messages.getString("DataTypesDesign.StructuredTypes"));
        FilteredSelection tStrType = new FilteredSelection(Messages.getString("DataTypesDesign.StructuredTypes"));
        sStrType.setCorrespondentNode(tStrType);
        tStrType.setCorrespondentNode(sStrType);
        this.setEmptyComparator(sStrType);
        this.setEmptyComparator(tStrType);
        sDTModel.addChild(sStrType);
        tDTModel.addChild(tStrType);
        tStrType.setSelected(false);
        FilteredSelection sCollType = new FilteredSelection(Messages.getString("CompareCWDDesigns.CollectionTypes"));
        FilteredSelection tCollType = new FilteredSelection(Messages.getString("CompareCWDDesigns.CollectionTypes"));
        sCollType.setCorrespondentNode(tCollType);
        tCollType.setCorrespondentNode(sCollType);
        this.setEmptyComparator(sCollType);
        this.setEmptyComparator(tCollType);
        sDTModel.addChild(sCollType);
        tDTModel.addChild(tCollType);
        tCollType.setSelected(false);
        Iterator it = this.getSourceDataTypesDesign().getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType distType = (DistinctType)it.next();
            this.addDistinctType(distType, sDistType, tDistType);
        }
        this.addDeletedDistinctTypes(sDistType, tDistType);
        it = this.getSourceDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType strType = (StructuredType)it.next();
            this.addStructuredType(strType, sStrType, tStrType);
        }
        if (this.selectedIDs == null || this.selectedIDs.size() == 0) {
            this.addDeletedStructuredTypes(sStrType, tStrType);
        }
        it = this.getSourceDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType collType = (CollectionType)it.next();
            this.addCollectionType(collType, sCollType, tCollType);
        }
        if (this.selectedIDs == null || this.selectedIDs.size() == 0) {
            this.addDeletedCollectionTypes(sCollType, tCollType);
        }
    }

    private void addDistinctType(DistinctType sourceType, FilteredSelection allSDistTypes, FilteredSelection allTDistTypes) {
        FilteredSelection sDistType = new FilteredSelection(sourceType);
        FilteredSelection tDistType = null;
        DistinctType targetType = (DistinctType)CompareModelToModel.getCorrespondingObject(this.getTargetDataTypesDesign().getDistinctTypeSet(), sourceType);
        if (targetType != null) {
            tDistType = new FilteredSelection(targetType);
            DistinctTypeComparator comp = new DistinctTypeComparator(sourceType, targetType);
            sDistType.setPropertiesComparator(comp);
            tDistType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sDistType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sDistType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tDistType = new FilteredSelection(CompareCWDDesigns.NEW_DISTINCT_TYPE);
            sDistType.setStatus(STATE_NEW);
            tDistType.setStatus(STATE_NEW);
            tDistType.setElementDescriptor(DistinctType.class);
            this.objectsMap.put(sourceType.getObjectID(), null);
            DistinctTypeComparator comp = new DistinctTypeComparator(sourceType, targetType);
            sDistType.setPropertiesComparator(comp);
            tDistType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sDistType.setSelected(true);
            this.newMappings.add(sDistType);
        }
        tDistType.setCorrespondentNode(sDistType);
        sDistType.setCorrespondentNode(tDistType);
        allSDistTypes.addChild(sDistType);
        allTDistTypes.addChild(tDistType);
    }

    private void addDeletedDistinctTypes(FilteredSelection allSDistTypes, FilteredSelection allTDistTypes) {
        Iterator it = this.getTargetDataTypesDesign().getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType targetType = (DistinctType)it.next();
            if (this.objectsMap.containsValue(targetType)) continue;
            FilteredSelection selTargetType = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(selTargetType);
            selTargetType.setSelected(false);
            FilteredSelection selSourceType = new FilteredSelection(targetType);
            selTargetType.setElementDescriptor(DistinctType.class);
            DistinctTypeComparator comp = new DistinctTypeComparator(null, targetType);
            this.comparatorsMap.put(comp.getID(), comp);
            selTargetType.setPropertiesComparator(comp);
            selSourceType.setPropertiesComparator(comp);
            selTargetType.setStatus(STATE_DELETED);
            selSourceType.setStatus(STATE_DELETED);
            selSourceType.setCorrespondentNode(selTargetType);
            selTargetType.setCorrespondentNode(selSourceType);
            allSDistTypes.addChild(selTargetType);
            allTDistTypes.addChild(selSourceType);
        }
    }

    private void addStructuredType(StructuredType sourceType, FilteredSelection allSourceStrTypes, FilteredSelection allTargetStrTypes) {
        FilteredSelection sStrType = new FilteredSelection(sourceType);
        FilteredSelection tStrType = null;
        if (this.getSourceStorageDesign() == null) {
            return;
        }
        if (this.getSourceStorageDesign().getStructuredTypeProxySet() == null) {
            return;
        }
        StructuredTypeProxy sstp = (StructuredTypeProxy)this.getSourceStorageDesign().getStructuredTypeProxySet().getProxy(sourceType.getObjectID());
        StructuredType targetType = (StructuredType)CompareModelToModel.getCorrespondingObject(this.getTargetDataTypesDesign().getStructuredTypeSet(), sourceType);
        StructuredTypeProxy tstp = null;
        if (targetType != null) {
            tstp = (StructuredTypeProxy)this.getTargetStorageDesign().getStructuredTypeProxySet().getProxy(targetType.getObjectID());
        }
        if (this.useGenerateInDDL && (sstp != null && !sstp.isMarkedGenerate() || tstp != null && !tstp.isMarkedGenerate())) {
            if (sourceType != null && targetType != null) {
                this.objectsMap.put(sourceType.getObjectID(), targetType);
            }
            return;
        }
        if (targetType != null) {
            tStrType = new FilteredSelection(targetType);
            StructuredTypeComparator comp = new StructuredTypeComparator(sourceType, targetType);
            sStrType.setPropertiesComparator(comp);
            tStrType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sStrType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sStrType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tStrType = new FilteredSelection(CompareCWDDesigns.NEW_STRUCTURED_TYPE);
            sStrType.setStatus(STATE_NEW);
            tStrType.setStatus(STATE_NEW);
            tStrType.setElementDescriptor(StructuredType.class);
            this.objectsMap.put(sourceType.getObjectID(), null);
            StructuredTypeComparator comp = new StructuredTypeComparator(sourceType, targetType);
            sStrType.setPropertiesComparator(comp);
            tStrType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sStrType.setSelected(true);
            this.newMappings.add(sStrType);
        }
        tStrType.setCorrespondentNode(sStrType);
        sStrType.setCorrespondentNode(tStrType);
        this.addStructuredTypeDetails(sourceType, sStrType, targetType, tStrType);
        allSourceStrTypes.addChild(sStrType);
        allTargetStrTypes.addChild(tStrType);
    }

    private void addDeletedStructuredTypes(FilteredSelection allsStrTypes, FilteredSelection alltStrTypes) {
        Iterator it = this.getTargetDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType targetType = (StructuredType)it.next();
            if (targetType.getName().equalsIgnoreCase("SDO_GEOMETRY") || targetType.getName().equalsIgnoreCase("XMLTYPE")) continue;
            RelationalObjectProxy tstp = null;
            if (targetType != null) {
                tstp = (StructuredTypeProxy)this.getTargetStorageDesign().getStructuredTypeProxySet().getProxy(targetType.getObjectID());
            }
            if (this.useGenerateInDDL && tstp != null && !tstp.isMarkedGenerate() || this.objectsMap.containsValue(targetType)) continue;
            FilteredSelection tStrType = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(tStrType);
            tStrType.setSelected(false);
            FilteredSelection sStrType = new FilteredSelection(targetType);
            tStrType.setElementDescriptor(StructuredType.class);
            StructuredTypeComparator comp = new StructuredTypeComparator(null, targetType);
            this.comparatorsMap.put(comp.getID(), comp);
            tStrType.setPropertiesComparator(comp);
            sStrType.setPropertiesComparator(comp);
            tStrType.setStatus(STATE_DELETED);
            sStrType.setStatus(STATE_DELETED);
            sStrType.setCorrespondentNode(tStrType);
            tStrType.setCorrespondentNode(sStrType);
            allsStrTypes.addChild(tStrType);
            alltStrTypes.addChild(sStrType);
        }
    }

    private void addStructuredTypeDetails(StructuredType sourceType, FilteredSelection sTypeDesign, StructuredType targetType, FilteredSelection tTypeDesign) {
        FilteredSelection sTypeElems = new FilteredSelection(Messages.getString("CompareCWDDesigns.Attributes"));
        FilteredSelection tTypeElems = new FilteredSelection(Messages.getString("CompareCWDDesigns.Attributes"));
        sTypeElems.setCorrespondentNode(tTypeElems);
        tTypeElems.setCorrespondentNode(sTypeElems);
        this.setEmptyComparator(sTypeElems);
        this.setEmptyComparator(tTypeElems);
        tTypeElems.setSelected(false);
        TypeElement[] elems = sourceType.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElement sourceAttribute = elems[i];
            this.addTypeElement(sourceAttribute, targetType, sTypeElems, tTypeElems);
        }
        if (targetType != null) {
            this.addDeletedTypeElements(sTypeElems, targetType, tTypeElems);
        }
        sTypeDesign.addChild(sTypeElems);
        tTypeDesign.addChild(tTypeElems);
        ((StructuredTypeComparator)sTypeDesign.getPropertiesComparator()).presetTypeElemsOrder();
        FilteredSelection sourceMethods = new FilteredSelection(Messages.getString("CompareCWDDesigns.Methods"));
        FilteredSelection targetMethods = new FilteredSelection(Messages.getString("CompareCWDDesigns.Methods"));
        sourceMethods.setCorrespondentNode(targetMethods);
        targetMethods.setCorrespondentNode(sourceMethods);
        this.setEmptyComparator(sourceMethods);
        this.setEmptyComparator(targetMethods);
        targetMethods.setSelected(false);
        Method[] methods = sourceType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            this.addMethod(method, targetType, sourceMethods, targetMethods);
        }
        if (targetType != null) {
            this.addDeletedMethods(sourceMethods, targetType, targetMethods);
        }
        sTypeDesign.addChild(sourceMethods);
        tTypeDesign.addChild(targetMethods);
    }

    private void addTypeElement(TypeElement sourceElem, StructuredType targetType, FilteredSelection sTypeElement, FilteredSelection tTypeElement) {
        TypeElementComparator comp;
        FilteredSelection sElemType = new FilteredSelection(sourceElem);
        ModelIdObjectSelection tElemType = null;
        TypeElement targetElem = null;
        if (targetType != null && (targetElem = (TypeElement)this.getCorrespondingObject(targetType.getTypeElementSet(), sourceElem, true)) != null) {
            tElemType = new FilteredSelection(targetElem);
            comp = new TypeElementComparator(sourceElem, targetElem);
            sElemType.setPropertiesComparator(comp);
            ((CompareObjectSelection)tElemType).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sElemType.setSelected(comp.isModified());
            sElemType.setEditable(comp.isModified());
            this.objectsMap.put(sourceElem.getObjectID(), targetElem);
        }
        if (targetElem == null) {
            sElemType.setSelected(true);
            tElemType = new FilteredSelection(CompareCWDDesigns.NEW_ATTRIBUTE);
            ((CompareObjectSelection)tElemType).setStatus(STATE_NEW);
            sElemType.setStatus(STATE_NEW);
            this.newMappings.add(sElemType);
            comp = new TypeElementComparator(sourceElem, null);
            sElemType.setPropertiesComparator(comp);
            ((CompareObjectSelection)tElemType).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceElem.getObjectID(), null);
        }
        tElemType.setElementDescriptor(TypeElement.class);
        sTypeElement.addChild(sElemType);
        tTypeElement.addChild(tElemType);
    }

    private void addDeletedTypeElements(FilteredSelection sElemSelected, StructuredType targetType, FilteredSelection tElemSelected) {
        TypeElement[] elems = targetType.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElement targetElem = elems[i];
            if (this.objectsMap.containsValue(targetElem)) continue;
            FilteredSelection sElemSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sElemSel);
            sElemSel.setSelected(false);
            sElemSel.setElementDescriptor(TypeElement.class);
            FilteredSelection tElemSel = new FilteredSelection(targetElem);
            tElemSel.setElementDescriptor(TypeElement.class);
            TypeElementComparator comp = new TypeElementComparator(null, targetElem);
            this.comparatorsMap.put(comp.getID(), comp);
            tElemSel.setPropertiesComparator(comp);
            sElemSel.setPropertiesComparator(comp);
            sElemSel.setStatus(STATE_DELETED);
            tElemSel.setStatus(STATE_DELETED);
            tElemSel.setCorrespondentNode(sElemSel);
            sElemSel.setCorrespondentNode(tElemSel);
            sElemSelected.addChild(sElemSel);
            tElemSelected.addChild(tElemSel);
        }
    }

    private void addMethod(Method sourceMethod, StructuredType targetType, FilteredSelection sMethodType, FilteredSelection tMethodType) {
        MethodComparator comp;
        FilteredSelection sMethodTab = new FilteredSelection(sourceMethod);
        CompareObjectSelection tMethodTab = null;
        Method targetMethod = null;
        if (targetType != null && (targetMethod = (Method)this.getCorrespondingObject(targetType.getMethodsList(), sourceMethod)) != null) {
            tMethodTab = new FilteredSelection(targetMethod);
            comp = new MethodComparator(sourceMethod, targetMethod);
            sMethodTab.setPropertiesComparator(comp);
            tMethodTab.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sMethodTab.setSelected(comp.isModified());
            sMethodTab.setEditable(comp.isModified());
            comp.setLeftSelectionObject(sMethodTab);
            this.objectsMap.put(sourceMethod.getObjectID(), targetMethod);
        }
        if (targetMethod == null) {
            sMethodTab.setSelected(true);
            tMethodTab = new FilteredSelection(CompareCWDDesigns.NEW_METHOD);
            tMethodTab.setStatus(STATE_NEW);
            sMethodTab.setStatus(STATE_NEW);
            this.newMappings.add(sMethodTab);
            tMethodTab.setElementDescriptor(Method.class);
            comp = new MethodComparator(sourceMethod, targetMethod);
            sMethodTab.setPropertiesComparator(comp);
            tMethodTab.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            this.objectsMap.put(sourceMethod.getObjectID(), null);
        }
        sMethodTab.setCorrespondentNode(tMethodTab);
        tMethodTab.setCorrespondentNode(sMethodTab);
        sMethodType.addChild(sMethodTab);
        tMethodType.addChild(tMethodTab);
    }

    private void addDeletedMethods(FilteredSelection sMethodSelected, StructuredType targetType, FilteredSelection tMethodSelected) {
        Method[] methods = targetType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method targetMethod = methods[i];
            if (this.objectsMap.containsValue(targetMethod)) continue;
            FilteredSelection sMethodSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sMethodSel);
            sMethodSel.setSelected(false);
            sMethodSel.setElementDescriptor(Method.class);
            FilteredSelection tMethodSel = new FilteredSelection(targetMethod);
            tMethodSel.setElementDescriptor(Method.class);
            MethodComparator comp = new MethodComparator(null, targetMethod);
            this.comparatorsMap.put(comp.getID(), comp);
            tMethodSel.setPropertiesComparator(comp);
            sMethodSel.setPropertiesComparator(comp);
            sMethodSel.setStatus(STATE_DELETED);
            tMethodSel.setStatus(STATE_DELETED);
            tMethodSel.setCorrespondentNode(sMethodSel);
            sMethodSel.setCorrespondentNode(tMethodSel);
            sMethodSelected.addChild(sMethodSel);
            tMethodSelected.addChild(tMethodSel);
        }
    }

    private void addCollectionType(CollectionType sourceType, FilteredSelection selSourceCollType, FilteredSelection selTargetCollType) {
        FilteredSelection sCollType = new FilteredSelection(sourceType);
        FilteredSelection tCollType = null;
        CollectionType targetType = (CollectionType)CompareModelToModel.getCorrespondingObject(this.getTargetDataTypesDesign().getCollectionTypeSet(), sourceType);
        if (targetType != null) {
            tCollType = new FilteredSelection(targetType);
            CollectionTypeComparator comp = new CollectionTypeComparator(sourceType, targetType);
            sCollType.setPropertiesComparator(comp);
            tCollType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sCollType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sCollType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tCollType = new FilteredSelection(CompareCWDDesigns.NEW_COLLECTION_TYPE);
            sCollType.setStatus(STATE_NEW);
            tCollType.setStatus(STATE_NEW);
            tCollType.setElementDescriptor(CollectionType.class);
            this.objectsMap.put(sourceType.getObjectID(), null);
            CollectionTypeComparator comp = new CollectionTypeComparator(sourceType, targetType);
            sCollType.setPropertiesComparator(comp);
            tCollType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sCollType.setSelected(true);
            this.newMappings.add(sCollType);
        }
        tCollType.setCorrespondentNode(sCollType);
        sCollType.setCorrespondentNode(tCollType);
        selSourceCollType.addChild(sCollType);
        selTargetCollType.addChild(tCollType);
    }

    private void addDeletedCollectionTypes(FilteredSelection sCollTypes, FilteredSelection tCollTypes) {
        Iterator it = this.getTargetDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType targetType = (CollectionType)it.next();
            if (this.objectsMap.containsValue(targetType)) continue;
            FilteredSelection tCollType = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(tCollType);
            tCollType.setSelected(false);
            FilteredSelection sCollType = new FilteredSelection(targetType);
            tCollType.setElementDescriptor(CollectionType.class);
            CollectionTypeComparator comp = new CollectionTypeComparator(null, targetType);
            this.comparatorsMap.put(comp.getID(), comp);
            tCollType.setPropertiesComparator(comp);
            sCollType.setPropertiesComparator(comp);
            tCollType.setStatus(STATE_DELETED);
            sCollType.setStatus(STATE_DELETED);
            sCollType.setCorrespondentNode(tCollType);
            tCollType.setCorrespondentNode(sCollType);
            sCollTypes.addChild(tCollType);
            tCollTypes.addChild(sCollType);
        }
    }

    private DataTypesDesign getTargetDataTypesDesign() {
        return this.targetDTD;
    }

    private DataTypesDesign getSourceDataTypesDesign() {
        return this.sourceDTD;
    }

    private boolean isGenerateInDDL(ModelIDObject source, ModelIDObject target) {
        if (swapTarget) {
            if (source != null) {
                return source.isMarkedGenerate();
            }
        } else if (target != null) {
            return target.isMarkedGenerate();
        }
        return true;
    }

    private void addArcs(Table sTable, CompareObjectSelection sParentNode, Table tTable, CompareObjectSelection tParentNode) {
        List slist = sTable.getArcs();
        ArrayList tlist = tTable != null ? tTable.getArcs() : new ArrayList();
        if (slist.size() == 0) {
            return;
        }
        FilteredSelection sArcs = new FilteredSelection(Messages.getString("LogicalDesign.Arcs"));
        FilteredSelection tArcs = new FilteredSelection(Messages.getString("LogicalDesign.Arcs"));
        sArcs.setCorrespondentNode(tArcs);
        tArcs.setCorrespondentNode(sArcs);
        this.setEmptyComparator(sArcs);
        this.setEmptyComparator(tArcs);
        sParentNode.addChild(sArcs);
        tParentNode.addChild(tArcs);
        tArcs.setSelected(false);
        for (FKArc source : slist) {
            FKArcComparator comp;
            FilteredSelection sourceArcsel = new FilteredSelection(source);
            FilteredSelection targetArcsel = null;
            FKArc target = (FKArc)this.getCorrespondingObject(tlist, source);
            if (target != null) {
                targetArcsel = new FilteredSelection(target);
                comp = new FKArcComparator(source, target, this.objectsMap);
                sourceArcsel.setPropertiesComparator(comp);
                targetArcsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sourceArcsel.setSelected(comp.isModified());
                this.objectsMap.put(source.getObjectID(), target);
            } else {
                targetArcsel = new FilteredSelection(NEW_NOTE);
                sourceArcsel.setStatus(STATE_NEW);
                targetArcsel.setStatus(STATE_NEW);
                targetArcsel.setElementDescriptor(FKArc.class);
                comp = new FKArcComparator(source, target, this.objectsMap);
                sourceArcsel.setPropertiesComparator(comp);
                targetArcsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sourceArcsel.setSelected(true);
            }
            targetArcsel.setCorrespondentNode(sourceArcsel);
            sourceArcsel.setCorrespondentNode(targetArcsel);
            sArcs.addChild(sourceArcsel);
            tArcs.addChild(targetArcsel);
        }
    }
}

