/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.SSBErrorHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableViewComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterColumn;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterTableConstraint;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBCreateTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropColumn;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropSequence;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropSnapshot;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTableConstraint;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTableView;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropValidTime;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBFKIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBRenameTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBSequence;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBSnapshot;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBTableView;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;

public class CompareObjectSelection
extends ModelIdObjectSelection {
    private PropertiesComparator propertiesComparator;
    private CompareObjectSelection correspondentNode;
    private JComponent dependentComponent;
    private boolean editable = true;
    private String rname;
    private DDLGenerator dropGenerator;
    protected Map fkMap = new TreeMap();
    private DDLGenerator generator;
    public static final int TABLE_INDEX = 1;
    public static final int VIEW_INDEX = 2;
    public static final int SNAPSHOT_INDEX = 3;
    public static final int SEQUENCE_INDEX = 4;
    public static final int TABLE_COLUMN = 0;
    public static final int TABLE_INDEX_KEY = 1;
    public static final int TABLE_PK_UK = 2;
    public static final int TABLE_FK = 3;
    public static final int TABLE_CONSTRAINT = 4;
    public static final int TABLE_TIME_DIM = 5;
    private RelationalObjectProxy proxy;
    private String dataTypeConversion = "";
    private boolean updateDependent = true;

    public CompareObjectSelection(ModelIDObject object) {
        super(object);
    }

    public CompareObjectSelection(ModelIDObject object, boolean applySelectionImmediate) {
        super(object, applySelectionImmediate);
    }

    public CompareObjectSelection(String name) {
        super(name);
    }

    public PropertiesComparator getPropertiesComparator() {
        return this.propertiesComparator;
    }

    public void setPropertiesComparator(PropertiesComparator propertiesComparator) {
        this.propertiesComparator = propertiesComparator;
    }

    public CompareObjectSelection getCorrespondentNode() {
        return this.correspondentNode;
    }

    public void setCorrespondentNode(CompareObjectSelection correspondentNode) {
        this.correspondentNode = correspondentNode;
    }

    @Override
    public ModelIdObjectSelection getCorrespondentObjectSelection() {
        return this.getCorrespondentNode();
    }

    public void applySelectionToEngineering() {
        if (this.getObject() != null) {
            this.getObject().setShouldMerge(this.isSelected());
        }
        int count = this.getNumberOfChildren();
        for (int i = 0; i < count; ++i) {
            CompareObjectSelection child = (CompareObjectSelection)this.getChild(i);
            child.applySelectionToEngineering();
        }
    }

    public void setStatus(int status) {
        if (status == STATE_MODIFIED) {
            if (this.status != STATE_NEW && this.status != STATE_DELETED) {
                this.status = status;
            }
        } else {
            this.status = status;
        }
    }

    public void presetStatus(int status) {
        this.status = status;
    }

    @Override
    public boolean isModified() {
        if (this.propertiesComparator != null) {
            return this.propertiesComparator.isModified();
        }
        return false;
    }

    public boolean hasChildsWithChangeStatus() {
        for (CompareObjectSelection selob : this.childs) {
            if (!selob.isModified() && this.status == STATE_UNCHANGED) continue;
            return true;
        }
        for (CompareObjectSelection selob : this.childs) {
            if (!selob.hasChildsWithChangeStatus()) continue;
            return true;
        }
        return false;
    }

    public void resetModifiedStatus() {
        for (CompareObjectSelection selob : this.childs) {
            selob.resetModifiedStatus();
            if (selob.getStatus() == STATE_UNCHANGED) continue;
            this.setStatus(STATE_MODIFIED);
        }
        if (this.isModified() || this.hasChildsWithChangeStatus()) {
            this.setStatus(STATE_MODIFIED);
        }
    }

    @Override
    public String getName() {
        ModelIDObject object = this.getObject();
        RelationalObjectProxy pr = this.getProxy();
        if (pr != null) {
            return pr.getName();
        }
        if (object != null) {
            if (this.rname != null) {
                return this.rname;
            }
            if (object instanceof KeyObject && ((KeyObject)object).isPK()) {
                return "(PK) " + object.getName();
            }
            if (object instanceof Column) {
                return "(" + ((Column)object).getIndex() + ")" + object.getName();
            }
            return object.getName();
        }
        if (this.rname != null) {
            return this.rname;
        }
        return super.getName();
    }

    @Override
    public boolean setName(String name) {
        this.rname = name;
        super.setName(name);
        return true;
    }

    public JComponent getDependentComponent() {
        return this.dependentComponent;
    }

    public void setDependentComponent(JComponent dependentComponent) {
        this.dependentComponent = dependentComponent;
    }

    @Override
    public void setSelected(boolean selected) {
        boolean old = this.selected;
        super.setSelected(selected);
        if (old != selected && this.updateDependent && this.dependentComponent != null) {
            this.dependentComponent.updateUI();
        }
    }

    public void setSelected(boolean selected, boolean updateDependent) {
        boolean old = this.updateDependent;
        this.updateDependent = updateDependent;
        this.setSelected(selected);
        this.updateDependent = old;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean canBeRename() {
        if (this.getPropertiesComparator() instanceof TableComparator) {
            if (!this.getPropertiesComparator().hasToBeRename() && !this.isLeaf()) {
                if (this.childs.size() > 0) {
                    return this.isChangeColumnsType((CompareObjectSelection)this.childs.get(0));
                }
                return false;
            }
            return true;
        }
        if (this.getPropertiesComparator() instanceof TableViewComparator) {
            return this.getPropertiesComparator().hasToBeRename();
        }
        return false;
    }

    public boolean canBeRenameOnly() {
        if (this.getPropertiesComparator() instanceof TableComparator && !this.canBeRename()) {
            return this.getPropertiesComparator().hasToBeRenameOnly();
        }
        return false;
    }

    private boolean isChangeColumnsType(CompareObjectSelection parent) {
        for (CompareObjectSelection obj : parent.childs) {
            if (!(obj.getPropertiesComparator() instanceof ColumnComparator) || !((ColumnComparator)obj.getPropertiesComparator()).isRecreateTable()) continue;
            return true;
        }
        return false;
    }

    public Iterator ddlDropObjects() {
        ArrayList list = new ArrayList();
        list.addAll(this.getDropViewComparator((CompareObjectSelection)this.getChild(2)));
        if (ModelChooserDialog.isSelectedDatabase) {
            list.addAll(this.getDropSnapshotComparator((CompareObjectSelection)this.getChild(3)));
        }
        list.addAll(this.getDropTableComparator((CompareObjectSelection)this.getChild(1)));
        if (ModelChooserDialog.isSelectedDatabase) {
            list.addAll(this.getDropSequenceComparator((CompareObjectSelection)this.getChild(4)));
        }
        return list.iterator();
    }

    private List getDropSequenceComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!obj.isSelected() || !obj.canBeDrop()) continue;
                list.add(obj);
            }
        }
        return list;
    }

    private List getDropSnapshotComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!obj.isSelected() || !obj.canBeDrop()) continue;
                list.add(obj);
            }
        }
        return list;
    }

    private List getDropViewComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        for (CompareObjectSelection obj : parent.childs) {
            if (!obj.isSelected() || !obj.canBeDrop() && !obj.canBeRename()) continue;
            list.add(obj);
        }
        return list;
    }

    private List getDropTableComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!(obj.getPropertiesComparator() instanceof TableComparator)) continue;
                if (obj.isSelected() && obj.canBeDrop()) {
                    list.add(obj);
                    continue;
                }
                if (obj.canBeRename()) continue;
                this.getChildsToBeDrop(list, obj);
            }
        }
        return list;
    }

    private void getChildsToBeDrop(List list, CompareObjectSelection obj) {
        for (CompareObjectSelection object : obj.childs) {
            if (object.isSelected() && object.canBeDrop()) {
                list.add(object);
            }
            this.getChildsToBeDrop(list, object);
        }
    }

    public Iterator ddlCreateObjects() {
        return this.ddlObjects();
    }

    public Iterator ddlObjects() {
        ArrayList list = new ArrayList();
        if (ModelChooserDialog.isSelectedDatabase) {
            list.addAll(this.getSequenceComparator((CompareObjectSelection)this.getChild(4)));
        }
        list.addAll(this.getTableComparator((CompareObjectSelection)this.getChild(1)));
        list.addAll(this.getSelectedObjectsFor((CompareObjectSelection)this.getChild(1), 0));
        list.addAll(this.getSelectedObjectsFor((CompareObjectSelection)this.getChild(1), 5));
        list.addAll(this.getSelectedObjectsFor((CompareObjectSelection)this.getChild(1), 1));
        list.addAll(this.getSelectedObjectsFor((CompareObjectSelection)this.getChild(1), 2));
        list.addAll(this.getSelectedObjectsFor((CompareObjectSelection)this.getChild(1), 4));
        list.addAll(this.getFKComparator((CompareObjectSelection)this.getChild(1)));
        if (ModelChooserDialog.isSelectedDatabase) {
            list.addAll(this.getSnapshotComparator((CompareObjectSelection)this.getChild(3)));
        }
        list.addAll(this.getTableViewComparator((CompareObjectSelection)this.getChild(2)));
        return list.iterator();
    }

    private List getSequenceComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!obj.isSelected() || obj.canBeDrop()) continue;
                list.add(obj);
            }
        }
        return list;
    }

    private List getSnapshotComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!obj.isSelected() || obj.canBeDrop() && !obj.canBeCreate()) continue;
                list.add(obj);
            }
        }
        return list;
    }

    private List getTableViewComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!obj.isSelected() || obj.canBeDrop() && !obj.canBeRename()) continue;
                list.add(obj);
            }
        }
        return list;
    }

    private List getFKComparator(CompareObjectSelection parent) {
        ArrayList list = new ArrayList();
        if (parent != null) {
            for (CompareObjectSelection table : parent.childs) {
                if (table.getNumberOfChildren() < 3) continue;
                CompareObjectSelection fkchild = (CompareObjectSelection)table.getChild(3);
                Iterator fkIt = fkchild.childs.iterator();
                while (fkIt.hasNext()) {
                    list.add(fkIt.next());
                }
            }
        }
        return list;
    }

    private List getTableComparator(CompareObjectSelection parent) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection obj : parent.childs) {
                if (!(obj.getPropertiesComparator() instanceof TableComparator) || !obj.isSelected() || obj.canBeDrop()) continue;
                list.add(obj);
            }
        }
        return list;
    }

    private List getSelectedObjectsFor(CompareObjectSelection parent, int index) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (parent != null) {
            for (CompareObjectSelection table : parent.childs) {
                if (table.canBeCreate() || !table.isSelected() || table.canBeRename() || table.getNumberOfChildren() <= index) continue;
                CompareObjectSelection colchild = (CompareObjectSelection)table.getChild(index);
                for (CompareObjectSelection chobj : colchild.childs) {
                    if (!chobj.isSelected() || chobj.canBeDrop() || !chobj.isDDLModified()) continue;
                    list.add(chobj);
                }
            }
        }
        return list;
    }

    public boolean canBeDrop() {
        return this.getPropertiesComparator().hasToBeDrop();
    }

    public boolean canBeCreate() {
        return this.getStatus() == STATE_NEW;
    }

    public void removeDDLObjects() {
        this.fkMap.clear();
    }

    public DDLGenerator getDDLDropGenerator() {
        if (this.dropGenerator == null) {
            this.dropGenerator = this.createDDLDropGenerator();
            this.dropGenerator.setLabel("DropGen");
            this.dropGenerator.append(SSBErrorHandler.getInstance());
        }
        return this.dropGenerator;
    }

    protected DDLGenerator createDDLDropGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        ddlGenerator.append(new CSSBDropTable());
        ddlGenerator.append(new CSSBDropTableView());
        ddlGenerator.append(new CSSBDropTableConstraint());
        ddlGenerator.append(new CSSBDropIndex(this.fkMap));
        ddlGenerator.append(new CSSBDropColumn());
        ddlGenerator.append(new CSSBDropValidTime());
        ddlGenerator.append(new CSSBDropSnapshot());
        ddlGenerator.append(new CSSBDropSequence());
        return ddlGenerator;
    }

    public DDLGenerator getDDLGenerator() {
        if (this.generator == null) {
            this.generator = this.createDDLGenerator();
            this.generator.append(SSBErrorHandler.getInstance());
        }
        return this.generator;
    }

    protected DDLGenerator createDDLGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        CSSBCreateTable cssbCreateTable = new CSSBCreateTable();
        ddlGenerator.append(cssbCreateTable);
        ddlGenerator.append(new CSSBRenameTable(this.fkMap));
        ddlGenerator.append(new CSSBAlterTable());
        ddlGenerator.append(new CSSBAlterIndex(this.fkMap));
        ddlGenerator.append(new CSSBAlterColumn());
        ddlGenerator.append(new CSSBAlterTableConstraint());
        ddlGenerator.append(new CSSBFKIndex(this.fkMap));
        ddlGenerator.append(new CSSBSnapshot(cssbCreateTable));
        ddlGenerator.append(new CSSBSequence());
        ddlGenerator.append(new CSSBTableView());
        return ddlGenerator;
    }

    public List getObjectsForRestore(int index) {
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        if (this.getNumberOfChildren() > index) {
            CompareObjectSelection object = (CompareObjectSelection)this.childs.get(index);
            for (CompareObjectSelection childObj : object.childs) {
                if (!childObj.canBeDrop() || childObj.isSelected()) continue;
                list.add(childObj.getCorrespondentNode());
            }
        }
        return list;
    }

    public List getChildObjects(int index) {
        ArrayList list = new ArrayList();
        if (this.getNumberOfChildren() > index) {
            CompareObjectSelection object = (CompareObjectSelection)this.childs.get(index);
            list.addAll(object.childs);
        }
        return list;
    }

    public void setObject(ModelIDObject object) {
        this.object = object;
        this.elDescriptor = object.getClass();
    }

    public CompareObjectSelection getChild(Object object) {
        for (CompareObjectSelection obj : this.childs) {
            if (obj.getObject() != object) continue;
            return obj;
        }
        return null;
    }

    public CompareObjectSelection getChildNested(Object object, int level) {
        int nlevel = level - 1;
        if (nlevel >= 0) {
            if (this.getObject() == object) {
                return this;
            }
            for (CompareObjectSelection obj : this.childs) {
                CompareObjectSelection nobj;
                if (obj.getObject() == object) {
                    return obj;
                }
                if (nlevel <= 0 || (nobj = obj.getChildNested(object, nlevel)) == null || nobj.getObject() != object) continue;
                return nobj;
            }
        }
        return null;
    }

    public String getChoosedPropertyValue(String propertyName) {
        return this.getPropertiesComparator().getChoosedPropertyValue(propertyName);
    }

    public boolean isTargetSelected(String propertyName) {
        return this.getPropertiesComparator().isTargetSelected(propertyName);
    }

    public String getChoosedPropertyValue(String propertyName, boolean selected) {
        return this.getPropertiesComparator().getChoosedPropertyValue(propertyName, selected);
    }

    public String getMergedProperty(String propName) {
        EngPropertyHolder ph = this.getPropertiesComparator().getPropertyHolderByName(propName);
        String prop = ph.isSelected() ? ph.getLeftValue() : ph.getRightValue();
        return prop;
    }

    public CompareObjectSelection getTableNode() {
        if (this.getParent() != null) {
            return (CompareObjectSelection)((ModelObject)this.getParent()).getParent();
        }
        return null;
    }

    public boolean isDDLModified() {
        return this.getPropertiesComparator().isDDLModified();
    }

    public String getDataTypeConversion() {
        return this.dataTypeConversion;
    }

    public void setDataTypeConversion(String dataTypeConversion) {
        this.dataTypeConversion = dataTypeConversion;
    }

    @Override
    public String getLongName() {
        if (this.getObject() != null) {
            return this.getObject().getLongName();
        }
        return this.getName();
    }

    @Override
    public boolean isFiltered(List filters) {
        for (Integer filter : filters) {
            if (filter.intValue() != this.getStatus() || this.getObject() == null && EngFilter.STATE_MODIFIED_FILTER.intValue() == filter.intValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFilteredChilds(List filters) {
        for (CompareObjectSelection object : this.getChilds()) {
            if (!object.isFiltered(filters) && !object.hasFilteredChilds(filters)) continue;
            return true;
        }
        return false;
    }

    public RelationalObjectProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(RelationalObjectProxy proxy) {
        this.proxy = proxy;
    }
}

