/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.Index;

public class FKArcComparator
extends PropertiesComparator {
    private FKArc sourceArc;
    private FKArc targetArc;
    private Map objectsMap;
    protected static List propertiesFilterList = new ArrayList();

    public FKArcComparator(FKArc sourced, FKArc target, Map objectsMap) {
        super(sourced, target);
        this.sourceArc = sourced;
        this.targetArc = target;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        if (!DDL_ONLY) {
            PropertyHolder ph = new PropertyHolder(MANDATORY);
            ph.setLeftValue(this.sourceArc != null ? String.valueOf(this.sourceArc.isMandatory()) : "");
            ph.setRightValue(this.targetArc != null ? String.valueOf(this.targetArc.isMandatory()) : "");
            if (this.isExcludedFromComparison(MANDATORY)) {
                ph.setExcluded(true);
            } else if (this.targetArc != null && this.sourceArc != null && this.targetArc.isMandatory() != this.sourceArc.isMandatory()) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(FOREIGN_KEYS);
            ph.setLeftValue(this.sourceArc != null ? String.valueOf(this.sourceArc.getFkeys().size()) : "");
            ph.setRightValue(this.targetArc != null ? String.valueOf(this.targetArc.getFkeys().size()) : "");
            if (this.isExcludedFromComparison(FOREIGN_KEYS)) {
                ph.setExcluded(true);
            } else if (this.targetArc != null && this.sourceArc != null && !FKArc.isMatchingForeignKeys(this.sourceArc, this.targetArc, this.objectsMap)) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setRightValue(CHANGED);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(DISCRIMINATOR_COLUMN);
            ph.setLeftValue(this.sourceArc != null && this.sourceArc.getDiscriminatorColumn() != null ? this.sourceArc.getDiscriminatorColumn().getName() : "");
            ph.setRightValue(this.targetArc != null && this.targetArc.getDiscriminatorColumn() != null ? this.targetArc.getDiscriminatorColumn().getName() : "");
            if (this.isExcludedFromComparison(DISCRIMINATOR_COLUMN)) {
                ph.setExcluded(true);
            } else if (this.targetArc != null && this.sourceArc != null && !FKArc.isMatchingDiscriminatorColumn(this.sourceArc, this.targetArc, this.objectsMap)) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromArc();
        this.copyPropertiesFromLeftToRight();
    }

    private void copyPropertiesFromArc() {
        if (this.targetArc != null && this.sourceArc != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(MANDATORY)) {
                    this.targetArc.setMandatory(this.sourceArc.isMandatory());
                    continue;
                }
                if (ph.getName().equals(FOREIGN_KEYS)) {
                    FKArc.synchronizeForeignKeys(this.sourceArc, this.targetArc, this.objectsMap, false);
                    continue;
                }
                if (!ph.getName().equals(DISCRIMINATOR_COLUMN)) continue;
                FKArc.synchronizeDiscriminatorColumn(this.sourceArc, this.targetArc, this.objectsMap);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceArc != null ? this.sourceArc.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetArc != null ? this.targetArc.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceArc == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceArc == null && this.targetArc != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    @Override
    public String getChoosedPropertyValue(String propertyName) {
        return super.getChoosedPropertyValue(propertyName);
    }

    private CompareObjectSelection[] getColumnNodes(Index index, CompareObjectSelection tableNode) {
        ArrayList<CompareObjectSelection> templist = new ArrayList<CompareObjectSelection>();
        CompareObjectSelection columns = (CompareObjectSelection)tableNode.getChild(0);
        int nod_number = columns.getNumberOfChildren();
        for (int i = 0; i < nod_number; ++i) {
            CompareObjectSelection cnode = (CompareObjectSelection)columns.getChild(i);
            if (cnode.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!cnode.isSelected() || cnode.getStatus() != ModelIdObjectSelection.STATE_NEW) && cnode.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            templist.add(cnode);
        }
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        ContainedObject[] cos = index.getElements();
        for (int i = 0; i < cos.length; ++i) {
            CompareObjectSelection node = this.getNode(templist, cos[i]);
            if (node == null) continue;
            list.add(node);
        }
        return list.toArray(new CompareObjectSelection[0]);
    }

    private CompareObjectSelection getNode(List list, ModelIDObject tofind) {
        for (CompareObjectSelection node : list) {
            if (node.getObject() != tofind) continue;
            return node;
        }
        return null;
    }

    private String getElementsToString(Index keyObject, CompareObjectSelection[] nodes) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < nodes.length; ++i) {
            ContainedObject co = (ContainedObject)nodes[i].getObject();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append("; ").append(co.getName());
                continue;
            }
            if (first) {
                sb.append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
        }
        return sb.toString();
    }

    private CompareObjectSelection getTableNode() {
        if (this.getLeftSelectionObject() != null) {
            return (CompareObjectSelection)((CompareObjectSelection)this.getLeftSelectionObject().getParent()).getParent();
        }
        return null;
    }
}

