/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;

public class FKComparator
extends PropertiesComparator {
    private FKIndexAssociation lfk;
    private FKIndexAssociation rfk;
    private KeyObject right_key;
    private KeyObject left_key;
    private boolean matchingRemoteKey;
    private boolean matchingColumns;
    protected static List propertiesFilterList = new ArrayList();
    private Map objectsMap;

    public FKComparator(FKIndexAssociation left_fk, FKIndexAssociation right_fk, boolean matchingRemoteKey, boolean matchingColumns, Map objectsMap) {
        super(left_fk, right_fk);
        this.lfk = left_fk;
        this.rfk = right_fk;
        this.left_key = left_fk != null ? left_fk.getKeyObject() : null;
        this.right_key = right_fk != null ? right_fk.getKeyObject() : null;
        this.matchingRemoteKey = matchingRemoteKey;
        this.matchingColumns = matchingColumns;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        PropertyHolder ph;
        this.initNameProperty();
        this.initCommentsAndNotes();
        if (!DDL_ONLY) {
            ph = new PropertyHolder(MANDATORY);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.left_key != null ? String.valueOf(this.lfk.isMandatory()) : "");
            ph.setRightValue(this.right_key != null ? String.valueOf(this.rfk.isMandatory()) : "");
            if (this.isExcludedFromComparison(MANDATORY)) {
                ph.setExcluded(true);
            } else if (this.rfk != null && this.lfk != null && this.rfk.isMandatory() != this.lfk.isMandatory()) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(TRANSFERABLE);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.left_key != null ? String.valueOf(this.lfk.isTransferable()) : "");
            ph.setRightValue(this.right_key != null ? String.valueOf(this.rfk.isTransferable()) : "");
            if (this.isExcludedFromComparison(TRANSFERABLE)) {
                ph.setExcluded(true);
            } else if (this.rfk != null && this.lfk != null && this.rfk.isTransferable() != this.lfk.isTransferable()) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(DELETE_RULE);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.left_key != null ? this.lfk.getValidDeleteRule() : "");
        ph.setRightValue(this.right_key != null ? this.rfk.getValidDeleteRule() : "");
        if (this.isExcludedFromComparison(DELETE_RULE)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && !this.lfk.getDeleteRule().equals(this.rfk.getDeleteRule())) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(true);
            if (this.isDeleteRuleCompatible()) {
                ph.setSelected(false);
                ph.setEditable(false);
                ph.setModified(false);
            }
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(IN_ARC);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.left_key != null ? String.valueOf(this.lfk.isInArc()) : "");
        ph.setRightValue(this.right_key != null ? String.valueOf(this.rfk.isInArc()) : "");
        if (this.isExcludedFromComparison(IN_ARC)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && this.rfk.isInArc() != this.lfk.isInArc()) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(PRIMARY_KEY);
        ph.setLeftValue(this.left_key != null ? this.left_key.getLongName() : "");
        ph.setRightValue(this.right_key != null ? this.right_key.getLongName() : "");
        if (this.isExcludedFromComparison(PRIMARY_KEY)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && !this.matchingRemoteKey) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(false);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COLUMN_ASSOCIATION);
        ph.setLeftValue(this.lfk != null ? this.getElementsToString(this.lfk) : "");
        ph.setRightValue(this.rfk != null ? this.getElementsToString(this.rfk) : "");
        if (this.isExcludedFromComparison(COLUMN_ASSOCIATION)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && !this.matchingColumns) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(false);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(DISCRIMINATOR_COLUMN);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.left_key != null ? String.valueOf(this.lfk.getDiscriminatorColumn()) : "");
            ph.setRightValue(this.right_key != null ? String.valueOf(this.rfk.getDiscriminatorColumn()) : "");
            if (this.isExcludedFromComparison(DISCRIMINATOR_COLUMN)) {
                ph.setExcluded(true);
            } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(DISCRIMINATOR_VALUE);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.left_key != null ? String.valueOf(this.lfk.getDiscriminatorValue()) : "");
            ph.setRightValue(this.right_key != null ? String.valueOf(this.rfk.getDiscriminatorValue()) : "");
            if (this.isExcludedFromComparison(DISCRIMINATOR_VALUE)) {
                ph.setExcluded(true);
            } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
        }
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    private boolean isDeleteRuleCompatible() {
        String leftRule = this.lfk.getDeleteRule();
        String rightRule = this.rfk.getDeleteRule();
        return leftRule.equalsIgnoreCase("NO ACTION") && rightRule.equalsIgnoreCase("RESTRICT") || leftRule.equalsIgnoreCase("RESTRICT") && rightRule.equalsIgnoreCase("NO ACTION");
    }

    private String getElementsToString(FKIndexAssociation fk) {
        StringBuffer sb = new StringBuffer();
        Iterator<Column> it = Arrays.asList(fk.getColumns()).iterator();
        boolean first = true;
        while (it.hasNext()) {
            ContainedObject co = it.next();
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName());
        }
        return sb.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromLeftFK();
    }

    private void copyPropertiesFromLeftFK() {
        if (this.right_key != null && this.left_key != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || !ph.getName().equals(COLUMNS)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey((Index)this.left_key, (Index)this.right_key);
                break;
            }
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(MANDATORY)) {
                    this.rfk.setMandatory(this.lfk.isMandatory());
                    continue;
                }
                if (ph.getName().equals(TRANSFERABLE)) {
                    this.rfk.setTransferable(this.lfk.isTransferable());
                    continue;
                }
                if (ph.getName().equals(DELETE_RULE)) {
                    this.rfk.setDeleteRule(this.lfk.getDeleteRule());
                    continue;
                }
                if (ph.getName().equals(IN_ARC)) {
                    if (this.lfk.isInArc()) continue;
                    this.rfk.setArc(null);
                    continue;
                }
                if (ph.getName().equals(PRIMARY_KEY)) {
                    this.right_key.setPK(this.left_key.isPK());
                    continue;
                }
                if (ph.getName().equals(DISCRIMINATOR_COLUMN)) {
                    Column col = this.lfk.getDiscriminatorColumn();
                    if (col != null) {
                        Column tcol = (Column)this.objectsMap.get(col.getObjectID());
                        if (tcol == null) continue;
                        this.rfk.setDiscriminatorColumn(tcol);
                        continue;
                    }
                    this.rfk.setDiscriminatorColumn(null);
                    continue;
                }
                if (!ph.getName().equals(DISCRIMINATOR_VALUE)) continue;
                this.rfk.setDiscriminatorValue(this.lfk.getDiscriminatorValue());
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.lfk != null ? this.lfk.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.rfk != null ? this.rfk.getLongName() : "";
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.lfk == null && this.rfk != null) {
            return true;
        }
        return super.hasToBeDrop();
    }
}

