/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyFilter;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StorageTemplateComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;

public class IndexComparator
extends PropertiesComparator {
    private Index sourceIndex;
    private Index targetIndex;
    private Map objectsMap;
    private boolean isPKorUK;
    protected static List propertiesFilterList = new ArrayList();
    protected static List storagePropertiesFilterList = new ArrayList();
    private StorageDesign sourceSD;
    private StorageDesign targetSD;

    public IndexComparator(Index index, Index key, Map objectsMap, boolean isPKorUK, StorageDesign sourceSD, StorageDesign targetSD) {
        super(index, key);
        this.sourceIndex = index;
        this.targetIndex = key;
        this.objectsMap = objectsMap;
        this.isPKorUK = isPKorUK;
        this.sourceSD = sourceSD;
        this.targetSD = targetSD;
        this.initPropertiesList();
        this.initStoragePropertiesList();
        this.initPropertiesFilterList();
        this.initStoragePropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initSchemaProperty();
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(INDEX_STATUS);
        ph.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexState() : "");
        ph.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexState() : "");
        if (this.isExcludedFromComparison(INDEX_STATUS)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !this.targetIndex.getIndexState().equals(this.sourceIndex.getIndexState())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(INDEX_FUNCTION_EXPRESSION);
        ph.setLeftValue(this.sourceIndex != null ? this.sourceIndex.getIndexExpression() : "");
        ph.setRightValue(this.targetIndex != null ? this.targetIndex.getIndexExpression() : "");
        if (this.isExcludedFromComparison(INDEX_FUNCTION_EXPRESSION)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !this.targetIndex.getIndexExpression().equals(this.sourceIndex.getIndexExpression())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COLUMNS);
        ph.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
        ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
        if (this.isExcludedFromComparison(COLUMNS)) {
            ph.setExcluded(true);
        } else if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(false);
        }
        this.propertiesList.add(ph);
    }

    protected void initSchemaProperty() {
        String name;
        String lname;
        int ind;
        IndexProxy ip;
        RelationalDesign rd;
        StorageDesign sd;
        PropertyHolder ph = new PropertyHolder(SCHEMA);
        String sSchema = "";
        String tSchema = "";
        if (this.sourceIndex != null) {
            sd = this.sourceSD;
            if (sd == null) {
                rd = (RelationalDesign)this.sourceIndex.getDesignPart();
                sd = rd.getStorageDesign();
            }
            if (!this.sourceIndex.isPK() && !this.sourceIndex.isUnique()) {
                if (sd.isOpen()) {
                    ip = (IndexProxy)sd.getStorageObject(this.sourceIndex.getObjectID());
                    if (ip != null && (ind = (lname = ip.getLongName()).indexOf(name = ip.getName())) > 0) {
                        sSchema = lname.substring(0, ind - 1);
                    }
                } else {
                    sSchema = this.sourceIndex.getSchema();
                }
            }
        }
        if (this.targetIndex != null) {
            sd = this.targetSD;
            if (sd == null) {
                rd = (RelationalDesign)this.targetIndex.getDesignPart();
                sd = rd.getStorageDesign();
            }
            if (!this.targetIndex.isPK() && !this.targetIndex.isUnique()) {
                if (sd.isOpen()) {
                    ip = (IndexProxy)sd.getStorageObject(this.targetIndex.getObjectID());
                    if (ip != null && (ind = (lname = ip.getLongName()).indexOf(name = ip.getName())) > 0) {
                        tSchema = lname.substring(0, ind - 1);
                    }
                } else {
                    tSchema = this.targetIndex.getSchema();
                }
            }
        }
        ph.setLeftValue(sSchema);
        ph.setRightValue(tSchema);
        if (this.isExcludedFromComparison(SCHEMA)) {
            ph.setExcluded(true);
        } else if (this.caseSensitive) {
            if (!ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                if (this.useSchema) {
                    ph.setSelected(true);
                } else {
                    ph.setFiltered(true);
                }
            }
        } else if (!ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            if (this.useSchema) {
                ph.setSelected(true);
            } else {
                ph.setFiltered(true);
            }
        }
        this.propertiesList.add(ph);
    }

    @Override
    protected void initStoragePropertiesList() {
        if (!this.isPKorUK) {
            RDBMSSite targetSite;
            Design targetDesign;
            StorageDesign targetStorageDesign;
            IndexProxy targetIndexProxy;
            RDBMSSite sourceSite;
            Design sourceDesign;
            StorageDesign sourceStorageDesign;
            IndexProxy sourceIndexProxy;
            SegmentOracle sourceSegment = null;
            SegmentOracle targetSegment = null;
            TableSpaceOracle sourceTableSpace = null;
            TableSpaceOracle targetTableSpace = null;
            if (this.sourceIndex != null && (sourceIndexProxy = (IndexProxy)(sourceStorageDesign = (sourceDesign = this.sourceIndex.getDesign()).getStorageDesign(sourceSite = this.sourceIndex.getSelectedRDBMSSite())).getIndexProxySet().getProxy(this.sourceIndex.getObjectID())) != null && sourceIndexProxy instanceof IndexProxyOracle) {
                sourceSegment = ((IndexProxyOracle)sourceIndexProxy).getSegment();
                sourceTableSpace = ((IndexProxyOracle)sourceIndexProxy).getTableSpace();
            }
            if (this.targetIndex != null && (targetIndexProxy = (IndexProxy)(targetStorageDesign = (targetDesign = this.targetIndex.getDesign()).getStorageDesign(targetSite = this.targetIndex.getSelectedRDBMSSite())).getIndexProxySet().getProxy(this.targetIndex.getObjectID())) != null && targetIndexProxy instanceof IndexProxyOracle) {
                targetSegment = ((IndexProxyOracle)targetIndexProxy).getSegment();
                targetTableSpace = ((IndexProxyOracle)targetIndexProxy).getTableSpace();
            }
            StorageTemplateComparator st_comp = new StorageTemplateComparator(sourceSegment, targetSegment, sourceTableSpace, targetTableSpace);
            st_comp.loadStoragePropertiesList(this.storagePropertiesList, storagePropertiesFilterList);
            this.storagePropertiesListActive = true;
        }
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    public static List getStaticStoragePropertiesFilterList() {
        return storagePropertiesFilterList;
    }

    public List getStoragePropertiesFilterList() {
        return storagePropertiesFilterList;
    }

    protected void initStoragePropertiesFilterList() {
        if (!this.isPKorUK && this.getStoragePropertiesFilterList().size() != this.storagePropertiesList.size()) {
            TreeMap<String, Boolean> fm = new TreeMap<String, Boolean>();
            for (int i = 0; i < this.getStoragePropertiesFilterList().size(); ++i) {
                PropertyFilter fe = (PropertyFilter)this.getStoragePropertiesFilterList().get(i);
                fm.put(fe.getName(), fe.isSelected());
            }
            this.getStoragePropertiesFilterList().clear();
            for (int j = 0; j < this.storagePropertiesList.size(); ++j) {
                EngPropertyHolder ph = (EngPropertyHolder)this.storagePropertiesList.get(j);
                PropertyFilter pf = new PropertyFilter(ph.getName());
                if (fm.containsKey(pf.getName())) {
                    pf.setSelected((Boolean)fm.get(pf.getName()));
                }
                this.getStoragePropertiesFilterList().add(pf);
            }
        }
    }

    private String getElementsToString(Index keyObject) {
        StringBuffer sb = new StringBuffer();
        Iterator it = keyObject.getElementsCollection().iterator();
        boolean first = true;
        while (it.hasNext()) {
            String sort;
            Column co = (Column)it.next();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append("; ").append(co.getName());
                continue;
            }
            if (first) {
                sort = keyObject.getColumnSortOrder(co).trim();
                if ("ASC".equalsIgnoreCase(sort)) {
                    sort = "";
                }
                sb.append(co.getName()).append(" ").append(sort);
                first = false;
                continue;
            }
            sort = keyObject.getColumnSortOrder(co).trim();
            if ("ASC".equalsIgnoreCase(sort)) {
                sort = "";
            }
            sb.append("; ").append(co.getName()).append(" ").append(sort);
        }
        return sb.toString();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromIndexToKey();
    }

    private void copyPropertiesFromIndexToKey() {
        if (this.targetIndex != null && this.sourceIndex != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(SCHEMA)) {
                    if (this.sourceIndex == null || this.targetIndex == null) continue;
                    this.setSchemaObject(this.sourceIndex, this.targetIndex);
                    continue;
                }
                if (ph.getName().equals(INDEX_STATUS)) {
                    this.targetIndex.setIndexState(this.sourceIndex.getIndexState());
                    continue;
                }
                if (!ph.getName().equals(COLUMNS)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey(this.sourceIndex, this.targetIndex);
            }
        }
    }

    private void setSchemaObject(Index source, Index target) {
        SchemaObject s_sch = source.getSchemaObject();
        if (s_sch == null) {
            target.setSchemaObject(null);
        } else {
            SchemaObject t_sch = (SchemaObject)((RelationalDesign)target.getDesignPart()).getSchemaObjectSet().getObjectByID(s_sch.getObjectID());
            if (t_sch == null) {
                t_sch = (SchemaObject)((RelationalDesign)target.getDesignPart()).getSchemaObjectSet().getByName(s_sch.getName());
            }
            if (t_sch != null) {
                target.setSchemaObject(t_sch);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceIndex != null ? this.sourceIndex.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetIndex != null ? this.targetIndex.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceIndex == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceIndex == null && this.targetIndex != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public void presetColumnsOrder() {
        EngPropertyHolder ph = this.getPropertyHolderByName(COLUMNS);
        if (ph != null) {
            if (this.getLeftSelectionObject() != null) {
                ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.sourceIndex != null) {
                    CompareObjectSelection[] nodes = this.getColumnNodes(this.sourceIndex, this.getTableNode());
                    ph.setLeftValue(this.getElementsToString(this.sourceIndex, nodes));
                } else {
                    ph.setLeftValue("");
                }
                if (this.targetIndex != null && this.sourceIndex != null) {
                    if (!MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
                        ph.setModified(true);
                        ph.setSelected(true);
                    } else {
                        ph.setModified(false);
                        ph.setSelected(false);
                    }
                    ph.setEditable(false);
                }
            } else {
                ph.setLeftValue(this.sourceIndex != null ? this.getElementsToString(this.sourceIndex) : "");
                ph.setRightValue(this.targetIndex != null ? this.getElementsToString(this.targetIndex) : "");
                if (this.targetIndex != null && this.sourceIndex != null && !MergingModels.haveIdenticalColumnsAndSortType(this.sourceIndex, this.targetIndex, this.objectsMap)) {
                    ph.setModified(true);
                    ph.setSelected(true);
                    ph.setEditable(false);
                }
            }
        }
    }

    private CompareObjectSelection[] getColumnNodes(Index index, CompareObjectSelection tableNode) {
        ArrayList<CompareObjectSelection> templist = new ArrayList<CompareObjectSelection>();
        CompareObjectSelection columns = (CompareObjectSelection)tableNode.getChild(0);
        int nod_number = columns.getNumberOfChildren();
        for (int i = 0; i < nod_number; ++i) {
            CompareObjectSelection cnode = (CompareObjectSelection)columns.getChild(i);
            if (cnode.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!cnode.isSelected() || cnode.getStatus() != ModelIdObjectSelection.STATE_NEW) && cnode.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            templist.add(cnode);
        }
        ArrayList<CompareObjectSelection> list = new ArrayList<CompareObjectSelection>();
        ContainedObject[] cos = index.getElements();
        for (int i = 0; i < cos.length; ++i) {
            CompareObjectSelection node = this.getNode(templist, cos[i]);
            if (node == null) continue;
            list.add(node);
        }
        return list.toArray(new CompareObjectSelection[0]);
    }

    private CompareObjectSelection getNode(List list, ModelIDObject tofind) {
        for (CompareObjectSelection node : list) {
            if (node.getObject() != tofind) continue;
            return node;
        }
        return null;
    }

    private String getElementsToString(Index keyObject, CompareObjectSelection[] nodes) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < nodes.length; ++i) {
            ContainedObject co = (ContainedObject)nodes[i].getObject();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append("; ").append(co.getName());
                continue;
            }
            if (first) {
                sb.append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
                first = false;
                continue;
            }
            sb.append("; ").append(co.getName()).append(" ").append(keyObject.getColumnSortOrder(co));
        }
        return sb.toString();
    }

    private CompareObjectSelection getTableNode() {
        if (this.getLeftSelectionObject() != null) {
            return (CompareObjectSelection)((CompareObjectSelection)this.getLeftSelectionObject().getParent()).getParent();
        }
        return null;
    }
}

