/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertyFilter;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.util.options.Settings;

public abstract class PropertiesComparator
extends PropertyNames {
    private DesignObject left_do;
    private DesignObject right_do;
    protected List propertiesList = new ArrayList();
    protected List storagePropertiesList = new ArrayList();
    protected boolean storagePropertiesListActive = false;
    protected boolean isDroped = false;
    protected Settings settings = null;
    protected boolean caseSensitive = false;
    protected boolean useSchema = true;
    protected boolean useColumnsOrder = true;
    protected boolean useDataTypeKind = false;
    protected boolean includeSystemNames = true;
    protected boolean useGenInDDL = true;
    private CompareObjectSelection selectionObject;
    public static boolean DDL_ONLY = false;
    protected static String SYSTEM_NAME_PREFIX = "SYS_";

    public PropertiesComparator(DesignObject left_do, DesignObject right_do) {
        this.left_do = left_do;
        this.right_do = right_do;
        this.settings = null;
        if (left_do != null) {
            this.settings = left_do.getDesignPart().getAppView().getSettings();
        } else if (right_do != null) {
            this.settings = right_do.getDesignPart().getAppView().getSettings();
        }
        if (this.settings != null) {
            this.caseSensitive = this.settings.isCaseSensitiveNamesInCompare();
            if (left_do != null) {
                boolean bl = this.caseSensitive = this.caseSensitive || left_do.getNameHasQuotes();
            }
            if (right_do != null) {
                this.caseSensitive = this.caseSensitive || right_do.getNameHasQuotes();
            }
            this.useSchema = this.settings.isUseSchemaPropertyInCompare();
            this.useColumnsOrder = this.settings.isUseColumnsOrderPropertyInCompare();
            this.useDataTypeKind = this.settings.isUseDataTypeKindInCompare();
            this.includeSystemNames = this.settings.isIncludeSystemNamesInCompare();
            if (DDL_ONLY) {
                this.useGenInDDL = this.settings.isUseGenInDDLInCompare();
            }
        }
    }

    public List getPropertiesList() {
        return this.propertiesList;
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        this.initDynamicProperties();
    }

    public List getStoragePropertiesList() {
        return this.storagePropertiesList;
    }

    public boolean isStoragePropertiesListActive() {
        return this.storagePropertiesListActive;
    }

    protected void initStoragePropertiesList() {
        this.storagePropertiesListActive = false;
    }

    public abstract List getPropertiesFilterList();

    protected void initPropertiesFilterList() {
        EngPropertyHolder ph;
        int j;
        TreeMap<String, Boolean> fm = new TreeMap<String, Boolean>();
        for (int i = 0; i < this.getPropertiesFilterList().size(); ++i) {
            PropertyFilter fe = (PropertyFilter)this.getPropertiesFilterList().get(i);
            fm.put(fe.getName(), fe.isSelected());
        }
        if (this.getPropertiesFilterList().size() != this.propertiesList.size()) {
            this.getPropertiesFilterList().clear();
            for (j = 0; j < this.propertiesList.size(); ++j) {
                ph = (EngPropertyHolder)this.propertiesList.get(j);
                PropertyFilter pf = new PropertyFilter(ph.getName());
                if (fm.containsKey(pf.getName())) {
                    pf.setSelected((Boolean)fm.get(pf.getName()));
                    if (!pf.isSelected()) {
                        ph.setFiltered(true);
                        ph.setEditable(false);
                        ph.setExcluded(true);
                        ph.setModified(false);
                        ph.setSelected(false);
                    }
                }
                this.getPropertiesFilterList().add(pf);
            }
        } else {
            for (j = 0; j < this.propertiesList.size(); ++j) {
                ph = (EngPropertyHolder)this.propertiesList.get(j);
                Boolean sel = (Boolean)fm.get(ph.getName());
                if (sel == null || sel.booleanValue()) continue;
                ph.setFiltered(true);
                ph.setEditable(false);
                ph.setExcluded(true);
                ph.setModified(false);
                ph.setSelected(false);
            }
        }
    }

    protected boolean isExcludedFromComparison(String propertyName) {
        for (int i = 0; i < this.getPropertiesFilterList().size(); ++i) {
            PropertyFilter pf = (PropertyFilter)this.getPropertiesFilterList().get(i);
            if (!propertyName.equalsIgnoreCase(pf.getName())) continue;
            return !pf.isSelected();
        }
        return false;
    }

    public abstract void copySelectedProperties();

    public DesignObject getLeftObject() {
        return this.left_do;
    }

    public DesignObject getRightObject() {
        return this.right_do;
    }

    public String getLeftName() {
        if (this.left_do != null) {
            return this.left_do.getName();
        }
        return "";
    }

    public String getRightName() {
        if (this.right_do != null) {
            return this.right_do.getName();
        }
        return "";
    }

    protected void initNameProperty() {
        PropertyHolder ph = new PropertyHolder(NAME);
        ph.setLeftValue(this.left_do != null ? this.left_do.getName() : "");
        ph.setRightValue(this.right_do != null ? this.right_do.getName() : "");
        if (this.isExcludedFromComparison(NAME) || this.isExcludeNamesFromComparison(ph)) {
            ph.setExcluded(true);
        } else if (this.caseSensitive) {
            if (!ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        } else if (!ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    protected boolean isExcludeNamesFromComparison(EngPropertyHolder ph) {
        return (ph.getLeftValue().toUpperCase().startsWith(SYSTEM_NAME_PREFIX) || ph.getRightValue().toUpperCase().startsWith(SYSTEM_NAME_PREFIX)) && !this.includeSystemNames;
    }

    protected void initCommentsAndNotes() {
        this.initCommentsAndNotes(true);
    }

    protected void initCommentsAndNotes(boolean initRDBMS) {
        PropertyHolder ph;
        if (!DDL_ONLY) {
            ph = new PropertyHolder(COMMENT);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.left_do != null ? this.left_do.getComment() : "");
            ph.setRightValue(this.right_do != null ? this.right_do.getComment() : "");
            if (this.isExcludedFromComparison(COMMENT)) {
                ph.setExcluded(true);
            } else if (this.left_do != null && this.right_do != null && !this.left_do.getComment().equals(this.right_do.getComment())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        if (initRDBMS) {
            ph = new PropertyHolder(COMMENT_IN_RDBMS);
            ph.setDDLHolder(true);
            ph.setLeftValue(this.left_do != null ? this.left_do.getCommentInRDBMS() : "");
            ph.setRightValue(this.right_do != null ? this.right_do.getCommentInRDBMS() : "");
            if (this.isExcludedFromComparison(COMMENT_IN_RDBMS)) {
                ph.setExcluded(true);
            } else if (this.left_do != null && this.right_do != null && !this.left_do.getCommentInRDBMS().equals(this.right_do.getCommentInRDBMS())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        if (!DDL_ONLY) {
            ph = new PropertyHolder(NOTES);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.left_do != null ? this.left_do.getNotes() : "");
            ph.setRightValue(this.right_do != null ? this.right_do.getNotes() : "");
            if (this.isExcludedFromComparison(NOTES)) {
                ph.setExcluded(true);
            } else if (this.left_do != null && this.right_do != null && !this.left_do.getNotes().equals(this.right_do.getNotes())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
    }

    protected void copyPropertiesFromLeftToRight() {
        if (this.left_do != null && this.right_do != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(NAME)) {
                    this.right_do.setName(this.left_do.getName());
                    continue;
                }
                if (ph.getName().equals(COMMENT)) {
                    this.right_do.setComment(this.left_do.getComment());
                    continue;
                }
                if (ph.getName().equals(COMMENT_IN_RDBMS)) {
                    this.right_do.setCommentInRDBMS(this.left_do.getCommentInRDBMS());
                    continue;
                }
                if (ph.getName().equals(NOTES)) {
                    this.right_do.setNotes(this.left_do.getNotes());
                    continue;
                }
                if (ph.getName().equals(INDEX_FUNCTION_EXPRESSION)) {
                    ((Index)this.right_do).setIndexExpression(((Index)this.left_do).getIndexExpression());
                    continue;
                }
                if (!ph.getName().equals(DYNAMIC_PROPERTIES)) continue;
                this.left_do.copyDynamicProperties(this.right_do);
            }
            if (this.isDirty()) {
                this.right_do.setDirty(true);
            }
        }
    }

    public boolean isModified() {
        if (this.left_do != null && this.right_do == null) {
            return true;
        }
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.isModified() || ph.isFiltered()) continue;
            return true;
        }
        for (EngPropertyHolder st_ph : this.getStoragePropertiesList()) {
            if (!st_ph.isModified() || st_ph.isFiltered()) continue;
            return true;
        }
        return false;
    }

    public String getID() {
        if (this.left_do != null && this.right_do != null) {
            return this.left_do.getObjectID() + this.right_do.getObjectID();
        }
        if (this.left_do != null) {
            return this.left_do.getObjectID();
        }
        if (this.right_do != null) {
            return this.right_do.getObjectID();
        }
        return "null";
    }

    protected boolean hasToBeRename() {
        return false;
    }

    protected boolean hasToBeRenameOnly() {
        return false;
    }

    protected boolean hasToBeDrop() {
        return false;
    }

    protected boolean isDirty() {
        for (EngPropertyHolder ph : this.propertiesList) {
            if (!ph.isModified() || !ph.isSelected()) continue;
            return true;
        }
        for (EngPropertyHolder st_ph : this.storagePropertiesList) {
            if (!st_ph.isModified() || !st_ph.isSelected()) continue;
            return true;
        }
        return false;
    }

    public CompareObjectSelection getLeftSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareObjectSelection selectionObject) {
        this.selectionObject = selectionObject;
    }

    public String getChoosedPropertyValue(String propertyName) {
        return this.getChoosedPropertyValue(propertyName, true);
    }

    public boolean isTargetSelected(String propertyName) {
        return this.isTargetSelected(propertyName, true);
    }

    public boolean isTargetSelected(String propertyName, boolean leftSelected) {
        for (EngPropertyHolder ph : this.propertiesList) {
            if (!ph.getName().equals(propertyName)) continue;
            if (!leftSelected) {
                return true;
            }
            if (this.left_do == null) {
                return true;
            }
            if (this.right_do == null) {
                return false;
            }
            return !ph.isSelected();
        }
        for (EngPropertyHolder st_ph : this.storagePropertiesList) {
            if (!st_ph.getName().equals(propertyName)) continue;
            if (!leftSelected) {
                return true;
            }
            if (this.left_do == null) {
                return true;
            }
            if (this.right_do == null) {
                return false;
            }
            return !st_ph.isSelected();
        }
        return true;
    }

    public String getChoosedPropertyValue(String propertyName, boolean selected) {
        for (EngPropertyHolder ph : this.propertiesList) {
            if (!ph.getName().equals(propertyName)) continue;
            if (!selected) {
                return ph.getRightValue();
            }
            if (this.left_do == null) {
                return ph.getRightValue();
            }
            if (this.right_do == null) {
                return ph.getLeftValue();
            }
            if (ph.isSelected()) {
                return ph.getLeftValue();
            }
            return ph.getRightValue();
        }
        for (EngPropertyHolder st_ph : this.storagePropertiesList) {
            if (!st_ph.getName().equals(propertyName)) continue;
            if (!selected) {
                return st_ph.getRightValue();
            }
            if (this.left_do == null) {
                return st_ph.getRightValue();
            }
            if (this.right_do == null) {
                return st_ph.getLeftValue();
            }
            if (st_ph.isSelected()) {
                return st_ph.getLeftValue();
            }
            return st_ph.getRightValue();
        }
        return "";
    }

    public EngPropertyHolder getPropertyHolderByName(String name) {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.getName().equals(name)) continue;
            return ph;
        }
        for (EngPropertyHolder st_ph : this.getStoragePropertiesList()) {
            if (!st_ph.getName().equals(name)) continue;
            return st_ph;
        }
        return null;
    }

    public boolean isDDLModified() {
        for (EngPropertyHolder ph : this.getPropertiesList()) {
            if (!ph.isSelected() || !ph.isDDLHolder() || ph.isFiltered()) continue;
            return true;
        }
        for (EngPropertyHolder st_ph : this.getStoragePropertiesList()) {
            if (!st_ph.isSelected() || !st_ph.isDDLHolder() || st_ph.isFiltered()) continue;
            return true;
        }
        return false;
    }

    public List getAllSelectedPH() {
        ArrayList<PropertyHolder> list = new ArrayList<PropertyHolder>();
        for (PropertyHolder ph : this.propertiesList) {
            if (!ph.isSelected()) continue;
            list.add(ph);
        }
        for (PropertyHolder st_ph : this.storagePropertiesList) {
            if (!st_ph.isSelected()) continue;
            list.add(st_ph);
        }
        return list;
    }

    protected void initDynamicProperties() {
        if (!DDL_ONLY) {
            String left = this.getDynamicPropertiesAsString(this.left_do);
            String right = this.getDynamicPropertiesAsString(this.right_do);
            PropertyHolder ph = new PropertyHolder(DYNAMIC_PROPERTIES);
            ph.setDDLHolder(false);
            ph.setLeftValue(left);
            ph.setRightValue(right);
            if (this.isExcludedFromComparison(DYNAMIC_PROPERTIES)) {
                ph.setExcluded(true);
            } else if (this.left_do != null && this.right_do != null && !this.left_do.getComment().equals(this.right_do.getComment())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
    }

    public List getDynamicPropskeys(ModelIDObject obj) {
        ArrayList<String> list = new ArrayList<String>();
        if (obj != null) {
            Iterator it = obj.getPropertyNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                list.add(key);
            }
        }
        return list;
    }

    public String getDynamicPropertiesAsString(ModelIDObject obj) {
        String res = "";
        if (obj != null) {
            Iterator it = obj.getPropertyNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = obj.getProperty(key);
                if (value == null) continue;
                if ("".equals(res)) {
                    res = key + "/" + value;
                    continue;
                }
                res = res + "\n" + key + "/" + value;
            }
        }
        return res;
    }

    protected boolean hasCreateProperties() {
        for (EngPropertyHolder ph : this.getStoragePropertiesList()) {
            if (!ph.isSelected() || this.settings == null) continue;
            String propName = ph.getName();
            if (this.settings.isIncludeStorageInDDL() && (propName.equalsIgnoreCase(PropertyNames.SC_INITIAL_EXTENT) && this.settings.isIncludeInitialExtentInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_NEXT_EXTENT) && this.settings.isIncludeNextExtentInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_MIN_EXTENTS) && this.settings.isIncludeMinExtentsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_MAX_EXTENTS) && this.settings.isIncludeMaxExtentsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_PCT_INCREASE) && this.settings.isIncludePctIncreaseInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_FREE_LISTS) && this.settings.isIncludeFreeListsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_FREE_LISTS_GRPS) && this.settings.isIncludeFreeListGroupsInDDL())) {
                return true;
            }
            if (!propName.equalsIgnoreCase(PropertyNames.TABLESPACE) || !this.settings.isIncludeTablespaceInDDL()) continue;
            return true;
        }
        return false;
    }
}

