/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class TableConstraintComparator
extends PropertiesComparator {
    private TableLevelConstraint sourceConstraint;
    private TableLevelConstraint targetConstraint;
    protected static List propertiesFilterList = new ArrayList();

    public TableConstraintComparator(TableLevelConstraint sourceConstraint, TableLevelConstraint targetConstraint) {
        super(sourceConstraint, targetConstraint);
        this.sourceConstraint = sourceConstraint;
        this.targetConstraint = targetConstraint;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(RULE);
        if (this.sourceConstraint != null) {
            ph.setLeftValue(this.sourceConstraint.getRule());
        }
        if (this.targetConstraint != null) {
            ph.setRightValue(this.targetConstraint.getRule());
        }
        if (this.isExcludedFromComparison(RULE)) {
            ph.setExcluded(true);
        } else if (this.sourceConstraint != null && this.targetConstraint != null && !this.sourceConstraint.getRule().equals(this.targetConstraint.getRule())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(GEN_CONSTRAINT_IN_DDL);
        if (this.sourceConstraint != null) {
            ph.setLeftValue(this.sourceConstraint.getGenerateInDDL());
        }
        if (this.targetConstraint != null) {
            ph.setRightValue(this.targetConstraint.getGenerateInDDL());
        }
        if (this.isExcludedFromComparison(GEN_CONSTRAINT_IN_DDL)) {
            ph.setExcluded(true);
        } else if (this.sourceConstraint != null && this.targetConstraint != null) {
            ph.setModified(false);
            ph.setSelected(false);
        }
        this.propertiesList.add(ph);
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        if (this.sourceConstraint != null && this.targetConstraint != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || !ph.getName().equals(RULE)) continue;
                this.targetConstraint.setRule(this.sourceConstraint.getRule());
            }
        }
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceConstraint == null && this.targetConstraint != null) {
            return true;
        }
        return super.hasToBeDrop();
    }
}

