/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Arc;

public class ArcComparator
extends PropertiesComparator {
    private Arc sourceArc;
    private Arc targetArc;
    private Map objectsMap;
    protected static List propertiesFilterList = new ArrayList();

    public ArcComparator(Arc sourced, Arc target, Map objectsMap) {
        super(sourced, target);
        this.sourceArc = sourced;
        this.targetArc = target;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(RELATIONSHIPS);
        ph.setLeftValue(this.sourceArc != null ? String.valueOf(this.sourceArc.getRelations().size()) : "");
        ph.setRightValue(this.targetArc != null ? String.valueOf(this.targetArc.getRelations().size()) : "");
        if (this.isExcludedFromComparison(RELATIONSHIPS)) {
            ph.setExcluded(true);
        } else if (this.targetArc != null && this.sourceArc != null && !Arc.isMatchingRelationships(this.sourceArc, this.targetArc, this.objectsMap)) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setRightValue(CHANGED);
        }
        this.propertiesList.add(ph);
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromArc();
        this.copyPropertiesFromLeftToRight();
    }

    private void copyPropertiesFromArc() {
        if (this.targetArc != null && this.sourceArc != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || !ph.getName().equals(RELATIONSHIPS)) continue;
                Arc.synchronizeReationships(this.sourceArc, this.targetArc, this.objectsMap, false);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceArc != null ? this.sourceArc.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetArc != null ? this.targetArc.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceArc == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceArc == null && this.targetArc != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    @Override
    public String getChoosedPropertyValue(String propertyName) {
        return super.getChoosedPropertyValue(propertyName);
    }
}

