/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class CWDModelComparator
extends PropertiesComparator {
    private DesignPart sourceDes;
    private DesignPart targetDes;
    protected static List propertiesFilterList = new ArrayList();

    public CWDModelComparator(DesignPart sourceDes, DesignPart targetDes) {
        super(null, null);
        this.sourceDes = sourceDes;
        this.targetDes = targetDes;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
    }

    public static List getStaticPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public List getPropertiesFilterList() {
        return propertiesFilterList;
    }

    @Override
    public String getLeftName() {
        return this.sourceDes != null ? MessageFormat.format(Messages.getString("CWDModelComparator.SourceModel"), this.sourceDes.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.targetDes != null ? MessageFormat.format(Messages.getString("CWDModelComparator.TargetModel"), this.targetDes.getName()) : "";
    }

    @Override
    protected void initNameProperty() {
        PropertyHolder ph = new PropertyHolder(NAME);
        ph.setLeftValue(this.sourceDes != null ? this.sourceDes.getName() : "");
        ph.setRightValue(this.targetDes != null ? this.targetDes.getName() : "");
        if (this.isExcludedFromComparison(NAME)) {
            ph.setExcluded(true);
        } else if (this.sourceDes != null && this.targetDes != null) {
            if (this.caseSensitive) {
                if (!this.sourceDes.getName().equals(this.targetDes.getName())) {
                    ph.setModified(true);
                    ph.setSelected(false);
                }
            } else if (!this.sourceDes.getName().equalsIgnoreCase(this.targetDes.getName())) {
                ph.setModified(true);
                ph.setSelected(false);
            }
        }
        this.propertiesList.add(ph);
    }

    @Override
    protected void initCommentsAndNotes() {
        PropertyHolder ph = new PropertyHolder(COMMENT);
        ph.setLeftValue(this.sourceDes != null ? this.sourceDes.getComment() : "");
        ph.setRightValue(this.targetDes != null ? this.targetDes.getComment() : "");
        if (this.isExcludedFromComparison(COMMENT)) {
            ph.setExcluded(true);
        } else if (this.sourceDes != null && this.targetDes != null && !this.sourceDes.getComment().equals(this.targetDes.getComment())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(NOTES);
        ph.setLeftValue(this.sourceDes != null ? this.sourceDes.getNotes() : "");
        ph.setRightValue(this.targetDes != null ? this.targetDes.getNotes() : "");
        if (this.isExcludedFromComparison(NOTES)) {
            ph.setExcluded(true);
        } else if (this.sourceDes != null && this.targetDes != null && !this.sourceDes.getNotes().equals(this.targetDes.getNotes())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.sourceDes != null && this.targetDes != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(NAME)) {
                    this.targetDes.setName(this.sourceDes.getName());
                    continue;
                }
                if (ph.getName().equals(COMMENT)) {
                    this.targetDes.setComment(this.sourceDes.getComment());
                    continue;
                }
                if (!ph.getName().equals(NOTES)) continue;
                this.targetDes.setNotes(this.sourceDes.getNotes());
            }
            this.targetDes.setDirty(this.isDirty());
        }
    }

    @Override
    public String getID() {
        if (this.sourceDes != null && this.targetDes != null) {
            return this.sourceDes.getObjectID() + this.targetDes.getObjectID();
        }
        if (this.sourceDes != null) {
            return this.sourceDes.getObjectID();
        }
        if (this.targetDes != null) {
            return this.targetDes.getObjectID();
        }
        return "null";
    }

    public DesignPart getSourceModel() {
        return this.sourceDes;
    }

    public DesignPart getTargetModel() {
        return this.targetDes;
    }
}

